

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvGetEventMsgIDs.sp] ---------- 

--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Michael Klose, Pratima Kudale
--	Date:   12/21/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvGetEventMsgIDs.sp,v $ $Id: EvGetEventMsgIDs.sp,v 1.1.2.1 2017/12/31 06:17:33 pkudale Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EvGetEventMsgIDs <<<'

IF EXISTS (select * from sysobjects where name='EvGetEventMsgIDs')
	drop procedure EvGetEventMsgIDs
IF EXISTS (select * from GxQscripts where name='EvGetEventMsgIDs')
	delete from GxQscripts where name = 'EvGetEventMsgIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGetEventMsgIDs')
	delete from GXDBVersions where aliasname = 'EvGetEventMsgIDs'
GO
print '... Creating Procedure: EvGetEventMsgIDs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure EvGetEventMsgIDs
  @i_EventId bigint,
  @i_LocaleId integer,
  @i_CCId integer
AS
  DECLARE @o_evMsgId INTEGER;
  DECLARE @o_evFormatString NVARCHAR(MAX);
DECLARE @MsgIds TABLE (msgId Integer, position Integer)
DECLARE @outerMessageId int = (select messageId from evmsg where id = @i_EventId AND commCellID = @i_CCId)
DECLARE @paramOffset int = 0
DECLARE @iteration int = 0
    SET NOCOUNT ON
    INSERT INTO @MsgIds
    SELECT EP.data, position
    FROM evParam EP INNER JOIN EvLocaleMsgArgInfo ON position= argpos AND localeId = @i_LocaleId and FmtSpecifier = 'a'
    WHERE evMsgId = @i_EventId AND EP.commcellId = @i_CCId AND EvLocaleMsgArgInfo.MessageID = @outerMessageId
    while (@iteration < 20)
    BEGIN
	    INSERT INTO @MsgIds
	    SELECT data, EP.position
	    FROM @MsgIds M INNER JOIN EvLocaleMsgArgInfo ON EvLocaleMsgArgInfo.MessageID = M.msgId AND localeId = @i_LocaleId and FmtSpecifier = 'a'
					    INNER JOIN evParam EP  ON EP.evMsgId = @i_EventId AND EP.position = M.position*16 + EvLocaleMsgArgInfo.ArgPos AND EP.commcellId = @i_CCId
	    WHERE EP.position NOT IN (SELECT position FROM @MsgIds)
	    IF (@@ROWCOUNT = 0) SET @iteration = 100
	    SET @iteration = @iteration  + 1
    END
    INSERT INTO @MsgIds VALUES (@outerMessageId, 0)
    SELECT msgId, EvLocaleMsgs.Message
    FROM @MsgIds M INNER JOIN EvLocaleMsgs ON M.msgId = EvLocaleMsgs.MessageID AND localeid = @i_LocaleId
    SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'EvGetEventMsgIDs')
	delete from GxQscripts where name = 'EvGetEventMsgIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGetEventMsgIDs')
	delete from GXDBVersions where aliasname = 'EvGetEventMsgIDs'
GO

insert into GXDBVersions values(2, 'EvGetEventMsgIDs',  '00010001000200010000', 'EvGetEventMsgIDs', '00010001000200010000')
GO

