

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvGetAnomalousEvents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName:EvGetAnomalousEvents
--		  gets the anomalous events fro the past x hours
--        input: '<App_GetAnomalousEventsRequest hours="1">
--					<processinginstructioninfo>
--						<user _type_="13" userId="1" userName="admin"/>
--						<locale _type_="66" localeId="0"/>
--						<formatFlags continueOnError="0" elementBased="0" filterUnInitializedFields="0" formatted="0" ignoreUnknownTags="1" skipIdToNameConversion="1" skipNameToIdConversion="0"/>
--					</processinginstructioninfo>
--				 </App_GetAnomalousEventsRequest>'
--
--       output:'<App_GetAnomalousEventsResponse>
--                    <anomalousEvents eventId="157105" severity="0" jobID="0" time="1527742984" program="EvMgrS" computer="vm14" eventCode="19:2143" description="Data Aging operation has been enabled on the client [clie]."/>
--                    <anomalousEvents eventId="157138" severity="0" jobID="0" time="1527743078" program="EvMgrS" computer="vm14" eventCode="19:289" description="Restores on the client [clie] have been disabled."/>
--			    </App_GetAnomalousEventsResponse>
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EvGetAnomalousEvents')
BEGIN
	print '>>> Drop Stored Procedure: EvGetAnomalousEvents <<<'
	drop procedure EvGetAnomalousEvents
END
IF EXISTS (select * from GxQscripts where name='EvGetAnomalousEvents')
	delete from GxQscripts where name = 'EvGetAnomalousEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGetAnomalousEvents')
	delete from GXDBVersions where aliasname = 'EvGetAnomalousEvents'
GO
print '... Creating Procedure: EvGetAnomalousEvents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EvGetAnomalousEvents
  @i_xml XML
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @hrs int= ISNULL((select ref.value('@hours','INT') FROM @i_xml.nodes('/App_GetAnomalousEventsRequest') R(ref)),1)
	DECLARE @userId int = ISNULL((select ref.value('@userId','INT') FROM @i_xml.nodes('/App_GetAnomalousEventsRequest/processinginstructioninfo/user')  R(ref)),0)
	DECLARE @localeId int = ISNULL((select ref.value('@localeId','INT') FROM @i_xml.nodes('/App_GetAnomalousEventsRequest/processinginstructioninfo/locale')  R(ref)),0)
	DECLARE @currTime int = dbo.getunixtime(getutcdate())
	DECLARE @eventsFrom int	= @currTime - (@hrs*60*60)
	DECLARE @POWER_2_32 BIGINT = POWER(CONVERT(BIGINT, 2), 32)
	DECLARE @POWER_2_17 INTEGER = POWER(2, 17)
	DECLARE @POWER_2_18 INTEGER = POWER(2, 18)
	DECLARE @POWER_2_24 INTEGER = POWER(2, 24)
	SELECT ISNULL(
		   (SELECT Ev.id as '@eventId',
		   Ev.severity as '@severity',
		   (@POWER_2_32 * Ev.jobId_h + Ev.jobId_l) as '@jobID',
		   Ev.timeSource as '@time',
		   Ev.subsystem as '@program',
		   Ev.client as '@computer',
		   CONVERT(NVARCHAR(128),(CASE  WHEN (Ev.messageId & @POWER_2_17) <> 0
										THEN    (Ev.messageId / @POWER_2_18 & 0xFFFF)
										ELSE (Ev.messageId / @POWER_2_24 & 0xFF) END)) + ':' + CONVERT(NVARCHAR(MAX),(Ev.messageId & 0x7FFF)) as '@eventCode',
			dbo.fn_EvFormatEventMsgText(Ev.id, @localeId, Ev.messageId, 1, Ev.commCellId) as '@description'
			FROM EvMsg Ev INNER JOIN
			(
				SELECT MAX(id) AS eventId
				FROM evMsg 	WHERE
				anomalous > 0 AND type<>2 AND timeSource >= @eventsFrom
				GROUP BY messageId,clientId
			)Anom ON Anom.eventId=Ev.id
			WHERE (dbo.isClientVisibleEvents(@userId , jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0)
			ORDER BY Ev.timeSource DESC
			FOR  XML PATH ('anomalousEvents'),ROOT('App_GetAnomalousEventsResponse')),'<App_GetAnomalousEventsResponse/>')
GO

IF EXISTS (select * from GxQscripts where name = 'EvGetAnomalousEvents')
	delete from GxQscripts where name = 'EvGetAnomalousEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvGetAnomalousEvents')
	delete from GXDBVersions where aliasname = 'EvGetAnomalousEvents'
GO

insert into GXDBVersions values(2, 'EvGetAnomalousEvents',  '00000000000000000000', 'EvGetAnomalousEvents', '00000000000000000000')
GO

