

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvFetchLastOccurrence.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvFetchLastOccurrence.sp,v $ $Id: EvFetchLastOccurrence.sp,v 1.9.208.1 2018/03/20 00:44:40 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: EvFetchLastOccurrence()
--  |
--  | Description:
--  |		(1)	Update the Event row if it is repeated or signal to insert a new row
--  |
--  |	    Input:	 msgid, lastOccurence, MsgEnglish, JobID_h, JobID_l, ignoreJobId
--  |
--  |     Return:   return one row or no rows
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Andre and Mary
--  |   1.1        Prakash
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EvFetchLastOccurrence <<<'

IF EXISTS (select * from sysobjects where name='EvFetchLastOccurrence')
	drop procedure EvFetchLastOccurrence
IF EXISTS (select * from GxQscripts where name='EvFetchLastOccurrence')
	delete from GxQscripts where name = 'EvFetchLastOccurrence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvFetchLastOccurrence')
	delete from GXDBVersions where aliasname = 'EvFetchLastOccurrence'
GO
print '... Creating Procedure: EvFetchLastOccurrence'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure EvFetchLastOccurrence
  @i_messageId INTEGER,
  @i_now INTEGER,
  @i_msgEnglish char(1024),
  @i_JobId_h INTEGER,
  @i_JobId_l INTEGER,
  @i_ignoreJobId INTEGER
AS
  DECLARE @r_nextPost integer;
  DECLARE @r_needInsert integer;
DECLARE @r_id	 			integer
DECLARE @r_timeSource		integer
DECLARE @r_repeatCount 		integer
DECLARE @r_lastOccurrence	integer
DECLARE @r_acked			integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @r_nextPost   =0;
SET @r_needInsert =0;
SET @r_id         =0;
-- -- Fetch last occurrence for MsgEnglish
IF (@i_ignoreJobId > 0)
BEGIN
	SELECT TOP 1  @r_id = id,
				@r_nextPost = nextPost,
				@r_timeSource = timeSource,
				@r_repeatCount = repeatCount,
				@r_lastOccurrence = lastOccurrence,
				@r_acked = acked
	FROM		EvMsg
	WHERE		messageid = @i_messageId and lastOccurrence>= ( @i_now - (90*60) ) and msgEnglish = @i_msgEnglish
	ORDER BY	id DESC ;
END
ELSE
BEGIN
	SELECT TOP 1  @r_id = id,
				@r_nextPost = nextPost,
				@r_timeSource = timeSource,
				@r_repeatCount = repeatCount,
				@r_lastOccurrence = lastOccurrence,
				@r_acked = acked
	FROM		EvMsg
	WHERE		messageid = @i_messageId and lastOccurrence>= ( @i_now - (90*60) ) and msgEnglish = @i_msgEnglish
	AND			jobID_h = @i_JobId_h
	AND			jobID_l = @i_JobId_l
	ORDER BY    id DESC ;
END
IF ( @r_id = 0 ) OR ( @i_now >= ( @r_timeSource + ( @r_nextPost * 60)) )
BEGIN
	SET @r_needInsert=1;
END
ELSE
BEGIN
	UPDATE EvMsg
	SET repeatCount = repeatCount + 1, lastOccurrence = @i_now
	WHERE id = @r_id
END
SELECT @r_nextPost, @r_needInsert
--  	:INTO @r_nextPost, @r_needInsert;	--skip for mssql7--
--  return @r_nextPost, @r_needInsert;	--skip for mssql7--
GO


IF EXISTS (select * from GxQscripts where name = 'EvFetchLastOccurrence')
	delete from GxQscripts where name = 'EvFetchLastOccurrence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvFetchLastOccurrence')
	delete from GXDBVersions where aliasname = 'EvFetchLastOccurrence'
GO

insert into GXDBVersions values(2, 'EvFetchLastOccurrence',  '00010009020800010000', 'EvFetchLastOccurrence', '00010009020800010000')
GO

