

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvEventPrune.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvEventPrune.sp,v $ $Id: EvEventPrune.sp,v 1.7.66.5 2018/08/23 23:43:15 snandhini Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EvEventPrune <<<'

IF EXISTS (select * from sysobjects where name='EvEventPrune')
	drop procedure EvEventPrune
IF EXISTS (select * from GxQscripts where name='EvEventPrune')
	delete from GxQscripts where name = 'EvEventPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvEventPrune')
	delete from GXDBVersions where aliasname = 'EvEventPrune'
GO
print '... Creating Procedure: EvEventPrune'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure EvEventPrune
  @i_WaterMark integer,
  @i_MaxEvRetDays integer
AS
  DECLARE @r_numRowPruned integer
  DECLARE @r_errorCode integer
SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF object_id('tempdb.dbo.#tblEventToPrune') is not null
		DROP TABLE #tblEventToPrune
	Create TABLE #tblEventToPrune (evMsgId integer, commcellId integer, primary key (evMsgId,commcellId))
	DECLARE @commcellIdList TABLE (commcellId integer primary key (commcellId))
	DECLARE @retVal integer
	DECLARE @numRow integer
	SET		@retVal = 0
	SET		@numRow = 0
	DECLARE @minId integer
	DECLARE @highId integer
	DECLARE @lowId integer
	DECLARE @numEventToKeep integer
	DECLARE @commcellId integer
	DECLARE @curTime	integer
	DECLARE @maxEvRetTime FLOAT
	DECLARE @eventsPerCommcell integer
	IF NOT EXISTS(SELECT 1 FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'MoveEventsToHistoryDB' AND modified=0 AND value='false')
	 EXEC EvMoveEventsToHistoryDB
	INSERT INTO @commcellIdList
	SELECT DISTINCT commcellId
	FROM EvMsg
	DECLARE FetchCommcellId_Cursor CURSOR LOCAL
		FOR SELECT commcellId FROM @commcellIdList
	OPEN FetchCommcellId_Cursor
	FETCH NEXT FROM FetchCommcellId_Cursor
			INTO @commcellId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		set @highId	= (select max(id) from evMsg with (nolock) where commCellID = @commcellId)
	set @numEventToKeep	= @i_WaterMark
	set @lowId	= @highId - @numEventToKeep
		set @eventsPerCommcell	= @numEventToKeep
	set @curTime = dbo.GetUnixTime(getUtcDate())
	set @maxEvRetTime = @i_MaxEvRetDays*24.0*60.0*60.0
	-- There are might be lots of old audit trail record in evmsg table.
	-- We don't want to process them if there is no event among them.
		set @minId	= (select min(id) from evMsg with (nolock) where type <> 2 and commCellID = @commcellId)
		-- Recursive loop to get the right number of events to keep per commcellId
		while @lowId >= @minId and @numEventToKeep > 0
		begin
				-- Get number of other commcell events between highId and lowId limits.
				-- Get the same number of events from current commcellId to replace these events. Also replace audit trail records.
				set @eventsPerCommcell	=
					(select count(id)
					from evMsg with (nolock)
					where commCellID = @commcellId
					and id <= @highId
					and id > @lowId
					and type <> 2)
				if @eventsPerCommcell < @numEventToKeep
				begin
					set @highId = @lowId
					set @lowId = @highId - (@numEventToKeep - @eventsPerCommcell)
				end
				set @numEventToKeep = @numEventToKeep - @eventsPerCommcell
		end
		/*set @numEventToKeep	= @i_WaterMark
	-- Recursive loop to get the right number of events to keep
	while @lowId >= @minId and @numEventToKeep > 0
	begin
			-- Get number of audit trail records among events.
			-- Get the same number of events to replace these audit trail records.
			set @numEventToKeep	=
				(select count(id)
				from evMsg with (nolock)
				where type = 2
				and id <= @highId
				and id > @lowId)
			if @numEventToKeep > 0
			begin
				set @highId = @lowId
				set @lowId = @highId - @numEventToKeep
			end
		end*/
	INSERT	INTO #tblEventToPrune
		SELECT	id,@commcellId
	FROM	EvMsg with (nolock)
	WHERE	id <= @lowId
			AND Type <> 2
			AND (@curTime - timeServer) > @maxEvRetTime
			AND commCellID = @commcellId
	SELECT @retVal = @@Error, @numRow = @@ROWCOUNT
	IF @retVal <> 0 GOTO CX_EXIT
		FETCH NEXT FROM FetchCommcellId_Cursor
			INTO @commcellId
	END
	CLOSE FetchCommcellId_Cursor
	DEALLOCATE FetchCommcellId_Cursor
BEGIN	TRANSACTION PruneEventTran
	-- Exit if there is not enough events
	--if @lowId < @minId
		--goto CX_EXIT
	-- Start to prune events
	DELETE	EvMsgCache
	FROM	EvMsgCache a inner join #tblEventToPrune b
	on a.evMsgId = b.evMsgId
	AND	a.commcellId = b.commcellId
	SELECT @retVal = @@Error
	IF @retVal <> 0 GOTO CX_EXIT
	DELETE	EvParam
	FROM	EvParam a inner join #tblEventToPrune b
	on a.evMsgId = b.evMsgId
	AND a.commcellId = b.commcellId
	SELECT @retVal = @@Error
	IF @retVal <> 0 GOTO CX_EXIT
	DELETE	EvMsg
	FROM	EvMsg a inner join #tblEventToPrune b
	on a.id = b.evMsgId
	AND a.commcellId = b.commcellId
	SELECT @retVal = @@Error
	IF @retVal <> 0 GOTO CX_EXIT
COMMIT TRANSACTION PruneEventTran
SELECT	@numRow, @retVal
RETURN
CX_EXIT:
		ROLLBACK TRANSACTION PruneEventTran
		SELECT @numRow, @retVal
		RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'EvEventPrune')
	delete from GxQscripts where name = 'EvEventPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvEventPrune')
	delete from GXDBVersions where aliasname = 'EvEventPrune'
GO

insert into GXDBVersions values(2, 'EvEventPrune',  '00010007006600050000', 'EvEventPrune', '00010007006600050000')
GO

