

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EvAddEventNew.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Prakash Varadharajan
--	Date:   01/20/2004
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EvAddEventNew.sp,v $ $Id: EvAddEventNew.sp,v 1.1.2.1 2020/06/21 01:04:47 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EvAddEventNew')
BEGIN
	print '>>> Drop Stored Procedure: EvAddEventNew <<<'
	drop procedure EvAddEventNew
END
IF EXISTS (select * from GxQscripts where name='EvAddEventNew')
	delete from GxQscripts where name = 'EvAddEventNew'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvAddEventNew')
	delete from GXDBVersions where aliasname = 'EvAddEventNew'
GO
print '... Creating Procedure: EvAddEventNew'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EvAddEventNew
  @i_ForceInsert integer,
  @i_IgnoreJobId integer,
  @i_eventDataXML XML
AS
  DECLARE @r_MsgId integer
  DECLARE @r_ErrorStr varchar(255)
	DECLARE @MsgId			INTEGER
	DECLARE @NeedInsert		INTEGER
	DECLARE @NextPost		INTEGER
	DECLARE @TimeSource		INTEGER
	DECLARE @Now			INTEGER
	DECLARE @EventId		INTEGER
	DECLARE @LocaleId		INTEGER
	DECLARE @Index			INTEGER
	DECLARE @UniqPosition	INTEGER
	DECLARE @Position		INTEGER
	DECLARE @NumParam		INTEGER
	DECLARE @NumParamTmp	INTEGER
	DECLARE @JobId_h		INTEGER
	DECLARE @JobId_l		INTEGER
	DECLARE @eventMsgID		INTEGER
	SET NOCOUNT ON
	SET @NeedInsert = 1
	SET @MsgId 		= 0
	SET @NextPost	= 0
	SET @r_ErrorStr	= 'NO ERROR'
	-- Max Position count is 16
	-- The nested events has its history of parents position represented in 4 bits
	-- Eg We have in pos 3 %a which inturn has %a in pos 5 which has %s in pos 2
	--    The %s will have position column as 0x352 and the previous %a will have %35
	--    This is to make sure we are having unique position id for each position still
	--    be able to extract the actual position of the inner most event string. All we have
	--    to do is do a & 0xf to get the actual position for that event string.
	-- Because of this logic we have have only 16 positions in one event and we have nest up to
	-- 7 levels of nesting as an integer is 4 bytes and is signed number.
	---------------------------------------------------------------------------------------------
	SELECT @EventId = ref.value('@nMessageID', 'int')
	FROM @i_eventDataXML.nodes('App_EvMessageContainerXML')	R(ref)
	SET @eventMsgID = @EventId
	SELECT @NumParam = ArgCount
	FROM 	EvLocaleMsgs (NOLOCK)
	WHERE 	MessageId 	= @EventId
	AND		LocaleId	= 0		-- Assuming all language will have same number of args as English
	IF object_id('tempdb.dbo.#evParamTmp') is not null
		DROP TABLE #evParamTmp
	CREATE TABLE #evParamTmp
	(
		Position	integer,
		Type		integer,
		Size		integer,
		Data		nvarchar(1024)
	)
	IF object_id('tempdb.dbo.#evParamTmp1') is not null
		DROP TABLE #evParamTmp1
	CREATE TABLE #evParamTmp1
	(
		EventId		integer,
		Position	integer,
		Type		integer,
		Size		integer,
		Data		nvarchar(1024)
	)
	INSERT INTO #evParamTmp(Position, Type, Size, Data)
	SELECT ref.value('@position', 'int') , ref.value('@type', 'int'), ref.value('@size', 'int'), ref.value('@arg', 'nvarchar(1024)')
	FROM @i_eventDataXML.nodes('App_EvMessageContainerXML/arguments/arguments')	R(ref)
	IF @NumParam is null
	BEGIN
		SET @MsgId = -1
		SET @r_ErrorStr = 'Event Id Not Found In Database'
		GOTO EXIT_PROC
	END
	SET @Index 			= 1		-- Index of the position column from EvParamTmp
	SET @UniqPosition	= 1		-- This holds the position that goes into the 'position' col of EvParam
	SET @Position		= 1		-- This the position of the current nested event
	WHILE 1 = 1
	BEGIN
		-- Check to see if we are done with the param count
		WHILE @Position > @NumParam
		BEGIN
			-- Now rollback one level of nesting
			SET @UniqPosition = @UniqPosition/16
			SET @Position = (@UniqPosition & 0xF)+1
			IF @UniqPosition = 0
				BREAK;		-- At the top most level
			SELECT @EventId = EventId
				FROM #EvParamTmp1
				WHERE Position	= @UniqPosition
			SELECT @NumParam = ArgCount
				FROM EvLocaleMsgs (NOLOCK)
				WHERE MessageId = @EventId
				AND	LocaleId	= 0
			SET @UniqPosition = @UniqPosition+1
		END
		IF @UniqPosition = 0
			BREAK;
		IF NOT EXISTS (SELECT * FROM #EvParamTmp WHERE Position = @Index)
			BREAK				-- Not enough Parameters
		INSERT INTO #EvParamTmp1 (EventId, Position, Type, Size, Data)
		SELECT @EventId, @UniqPosition, Type, Size, Data
		FROM #EvParamTmp
		WHERE Position	= @Index
		-- Check to see if the parameter is an event id
		IF (13 = (SELECT DataType FROM EvLocaleMsgArgInfo (NOLOCK) WHERE LocaleID = 0 AND MessageId = @EventId AND ArgPos = @Position))
		BEGIN
			SET @UniqPosition = (@UniqPosition*16) + 1
			SET @Position = 1
			SELECT @EventId = Data
			FROM #EvParamTmp
			WHERE Position = @Index
			SELECT @NumParam = ArgCount
			FROM EvLocaleMsgs (NOLOCK)
			WHERE MessageId = @EventId
			AND	LocaleId	= 0
		END
		ELSE
		BEGIN
			SET @UniqPosition = @UniqPosition + 1
			SET @Position = @Position + 1
		END
		SET @Index = @Index + 1
	END
	-- Check for the number of parameters
	SET @NumParamTmp = (SELECT COUNT(*) FROM #EvParamTmp1)
	SET @NumParam = (SELECT COUNT(*) FROM #EvParamTmp)
	IF(@NumParam > @NumParamTmp)
	BEGIN
		SET @MsgId = -2
		SET @r_ErrorStr = 'Too Many parameters'
		GOTO EXIT_PROC
	END
	ELSE IF (@UniqPosition <> 0)
	BEGIN
		SET @MsgId = -3
		SET @r_ErrorStr = 'Not enough Parameters'
		GOTO EXIT_PROC
	END
	IF @i_ForceInsert = 0
	BEGIN
		-- Now look for repeated events
		SELECT	@Now	= ref.value('@timeServer', 'int'),
			@EventId	= ref.value('@nMessageID', 'int'),
			@JobId_l	= ref.value('@jobId_l', 'int'),
			@JobId_h	= ref.value('@jobId_h', 'int')
		FROM @i_eventDataXML.nodes('App_EvMessageContainerXML')	R(ref)
		IF @NumParamTmp >0
		BEGIN
			IF object_id('tempdb.dbo.#lt_EventsToLookAt') is not null
				DROP TABLE #lt_EventsToLookAt
			CREATE TABLE #lt_EventsToLookAt (EvMsgId Integer)
			CREATE CLUSTERED INDEX lt_EventsToLookAt_EvMsgId_Idx ON #lt_EventsToLookAt(evMsgId)
			INSERT INTO #lt_EventsToLookAt
			SELECT Id
			FROM EvMsg
			WHERE MessageId = @EventId
			AND LastOccurrence > (@Now -(90*60))
			AND (@i_IgnoreJobId = 1 OR JobId_l = @JobId_l)
			SELECT TOP 1 @MsgId=E.Id, @TimeSource=E.TimeServer, @NextPost=E.NextPost
			FROM
			(
			 SELECT EP1.EvMsgId
			 FROM
			 (
				SELECT EvP.EvMsgId, EvP.EventId, EvP.Position, EvP.Type, EvP.Size, EvP.Data , EvP.commcellId
				 FROM #lt_EventsToLookAt EM INNER JOIN EvParam (NOLOCK) EvP ON EvP.EvMsgId = EM.EvMsgId
			 ) AS EP1, #EvParamTmp1 EPT1
			 WHERE	EP1.EventId	= EPT1.EventId
			 AND	EP1.Position= EPT1.Position
			 AND	EP1.Type	= EPT1.Type
			 AND	EP1.Size	= EPT1.Size
			 AND	EP1.Data	= EPT1.Data
			 GROUP BY EP1.EvMsgId
			 HAVING COUNT(*) = @NumParam
			) AS A INNER JOIN EvMsg E ON E.Id = A.EvMsgId
			ORDER BY E.Id DESC
		END
		ELSE
		BEGIN
				--new code for case when event has zero params
				SELECT TOP 1 @MsgId=E.Id, @TimeSource=E.TimeServer, @NextPost=E.NextPost
				FROM EvMsg E
				WHERE MessageId = @EventId
				AND LastOccurrence > (@Now -(90*60))
				AND (@i_IgnoreJobId = 1 OR JobId_l = @JobId_l)
				ORDER BY E.Id DESC
		END
-- end of new code
		IF (@MsgId>0) AND (@Now <= (@TimeSource+(@NextPost*60)))
		BEGIN
			-- Found one so just update the repeat count and end.
			UPDATE	EvMsg
			SET	RepeatCount = RepeatCount + 1,
				LastOccurrence = @Now
			WHERE	Id = @MsgId
			SET @NeedInsert = 0
			SET @MsgId = 0			-- Don't want the GUI Server to send this message to all GUIs
		END
	END
	IF @NeedInsert = 1
	BEGIN
		DECLARE @NextEvIDTable TABLE (id int)
		INSERT INTO @NextEvIDTable
		  EXECUTE GetNextEventId
		SELECT @MsgId  = id FROM  @NextEvIDTable
		--execute @MsgId = GetNextEventId
		INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
				ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
				UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
				MsgEnglish, RepeatCount, LastOccurrence, NextPost,
				mediaId, driveId, libraryId, maClientId, entityId, entityType)
		SELECT TOP 1 @MsgId, ref.value('@timeSource','int'), ref.value('@timeServer','int'), ref.value('@severity','int'), 0, 0, ref.value('@msgType','int'),
			@NumParam, @eventMsgID, ref.value('@jobId_h','int'), ref.value('@jobId_l','int'),
			ref.value('(msgEntities/client/@clientId)[1]','int'), 2, ref.value('(user/@userId)[1]','int'), 0,
			ref.value('(msgEntities/client/@clientName)[1]','nvarchar(512)'), '', '', ref.value('@subsystem','varchar(128)'),
			'', 1, ref.value('@timeServer','int'), CASE @NextPost
								WHEN 0		then 1			-- First Entry
								WHEN 5 		then 60			-- 5 mins to 1hr
								WHEN 60		then 480		-- 1 hr to 8 hrs
								WHEN 480	then 480		-- 8Hrs is the max
								ELSE 5						-- Anything else 5mins
								END,
			ref.value('(msgEntities/@mediaId)[1]','int'), ref.value('(msgEntities/@driveId)[1]','int'), ref.value('(msgEntities/@libraryId)[1]','int'), ref.value('(msgEntities/@maClientId)[1]','int'),
			ref.value('(msgEntities/entity/@entityId)[1]','int'), ref.value('(msgEntities/entity/@entityType)[1]','int')
		FROM @i_eventDataXML.nodes('App_EvMessageContainerXML')	R(ref)
		--SELECT @MsgId = @@IDENTITY		-- Get the New Message Id
		INSERT INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
		SELECT @MsgId, EventId, Position, Type, Size, Data
		FROM #EvParamTmp1
	END
EXIT_PROC:
	-- Return the Message ID inserted/changed
	IF @MsgId is null
		SET @MsgId = 0
	SELECT @MsgId, @r_ErrorStr
	SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'EvAddEventNew')
	delete from GxQscripts where name = 'EvAddEventNew'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EvAddEventNew')
	delete from GXDBVersions where aliasname = 'EvAddEventNew'
GO

insert into GXDBVersions values(2, 'EvAddEventNew',  '00010001000200010000', 'EvAddEventNew', '00010001000200010000')
GO

