

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityTimeToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntityTimeToId.sp,v $ $Id: EntityTimeToId.sp,v 1.4.80.2 2018/03/22 01:36:25 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntityTimeToId()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Ravneet Singh Arora	 EntityNameToIdConverter is broken into small procedures
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntityTimeToId <<<'

IF EXISTS (select * from sysobjects where name='EntityTimeToId')
	drop procedure EntityTimeToId
IF EXISTS (select * from GxQscripts where name='EntityTimeToId')
	delete from GxQscripts where name = 'EntityTimeToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityTimeToId')
	delete from GXDBVersions where aliasname = 'EntityTimeToId'
GO
print '... Creating Procedure: EntityTimeToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityTimeToId
  @i int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @globalTimeZoneId int ,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast int 
AS
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
DECLARE	@time					int
DECLARE @timeStr				nvarchar(255)
DECLARE	@toTime					int
DECLARE @toTimeStr				nvarchar(255)
DECLARE	@fromTime				int
DECLARE @fromTimeStr			nvarchar(255)
DECLARE @timeZoneStdName		nvarchar(255)
declare @type int
DECLARE @utcDateTime			datetime
DECLARE @tempId					int
 SET  @toTimeStr = @temp.value('(//./@toTimeValue)[1]','nvarchar(255)')
 SET  @fromTimeStr = @temp.value('(//./@fromTimeValue)[1]','nvarchar(255)')
 SET  @timeStr = @temp.value('(//./@timeValue)[1]','nvarchar(255)')
set @time=@temp.value('(//./@time)[1]','int')
set @toTime=@temp.value('(//./@toTime)[1]','int')
set @fromTime=@temp.value('(//./@fromTime)[1]','int')
IF (@timeStr IS NOT null  AND @globalTimeZoneId IS NOT NULL)
	BEGIN
				SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @globalTimeZoneId)
				IF @timeZoneStdName IS NOT null
				BEGIN
					SET @type=@temp.value('(//./@type)[1]','int')
					IF @type is null
					 SET @type = 0
					IF(@type <11 OR @type > 14)
					BEGIN
				 		SET @utcDateTime = dbo.LocalToUTCTime(@timeStr,@timeZoneStdName)
						SET @tempId = dbo.GetUnixTime(@utcDateTime)
					END
					ELSE
					BEGIN
						SET @tempId = CONVERT(INTEGER, @timeStr)
						SET @tempId = (CASE @type
											WHEN 11 THEN (@tempId * 24 * 60 * 60)				--RELATIVE_DAYS
											WHEN 12 THEN (@tempId * 7 * 24 * 60 * 60)			--RELATIVE_WEEKS
											WHEN 13 THEN (@tempId * 60 * 60)					--RELATIVE_HOURS
											WHEN 14 THEN (@tempId)								--RELATIVE
										END)
					END
					BEGIN
						IF @time IS null
							 SET @var.modify('insert (attribute time {sql:variable("@tempId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						ELSE
						   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@time)[1] with sql:variable("@tempId")')
					END
				END
	END
	IF (@toTimeStr IS NOT null  AND @globalTimeZoneId IS NOT NULL)
	BEGIN
				SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @globalTimeZoneId)
				IF @timeZoneStdName IS NOT null
				BEGIN
					SET @type=@temp.value('(//./@type)[1]','int')
					IF @type is null
					 SET @type = 0
					IF(@type <11 OR @type > 14)
					BEGIN
				 		SET @utcDateTime = dbo.LocalToUTCTime(@toTimeStr,@timeZoneStdName)
						SET @tempId = dbo.GetUnixTime(@utcDateTime)
					END
					ELSE
					BEGIN
						SET @tempId = CONVERT(INTEGER, @toTimeStr)
						SET @tempId = (CASE @type
											WHEN 11 THEN (@tempId * 24 * 60 * 60)				--RELATIVE_DAYS
											WHEN 12 THEN (@tempId * 7 * 24 * 60 * 60)			--RELATIVE_WEEKS
											WHEN 13 THEN (@tempId * 60 * 60)					--RELATIVE_HOURS
											WHEN 14 THEN (@tempId)								--RELATIVE
										END)
					END
					BEGIN
						IF @toTime IS null
							 SET @var.modify('insert (attribute toTime {sql:variable("@tempId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						ELSE
						   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@toTime)[1] with sql:variable("@tempId")')
					END
				END
	END
	set @fromTime=@var.value('(//./@fromTime)[1]','int')
	IF (@fromTimeStr IS NOT null  AND @globalTimeZoneId IS NOT NULL)
	BEGIN
				SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @globalTimeZoneId)
				IF @timeZoneStdName IS NOT null
				BEGIN
					SET @type=@temp.value('(//./@type)[1]','int')
					IF @type is null
					 SET @type = 0
					IF(@type <11 OR @type > 14)
					BEGIN
				 		SET @utcDateTime = dbo.LocalToUTCTime(@fromTimeStr,@timeZoneStdName)
						SET @tempId = dbo.GetUnixTime(@utcDateTime)
					END
					ELSE
					BEGIN
						SET @tempId = CONVERT(INTEGER, @fromTimeStr)
						SET @tempId = (CASE @type
											WHEN 11 THEN (@tempId * 24 * 60 * 60)				--RELATIVE_DAYS
											WHEN 12 THEN (@tempId * 7 * 24 * 60 * 60)			--RELATIVE_WEEKS
											WHEN 13 THEN (@tempId * 60 * 60)					--RELATIVE_HOURS
											WHEN 14 THEN (@tempId)								--RELATIVE
										END)
					END
					BEGIN
						IF @fromTime IS null
							 SET @var.modify('insert (attribute fromTime {sql:variable("@tempId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						ELSE
						   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@fromTime)[1] with sql:variable("@tempId")')
					END
				END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'EntityTimeToId')
	delete from GxQscripts where name = 'EntityTimeToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityTimeToId')
	delete from GXDBVersions where aliasname = 'EntityTimeToId'
GO

insert into GXDBVersions values(2, 'EntityTimeToId',  '00010004008000020000', 'EntityTimeToId', '00010004008000020000')
GO

