

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntitySubclientNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntitySubclientNameToId.sp,v $ $Id: EntitySubclientNameToId.sp,v 1.11.12.7 2019/03/19 23:16:14 snagendra Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntitySubclientNameToId()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Ravneet Singh Arora	 EntityNameToIdConverter is broken into small procedures
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EntitySubclientNameToId')
BEGIN
	print '>>> Drop Stored Procedure: EntitySubclientNameToId <<<'
	drop procedure EntitySubclientNameToId
END
IF EXISTS (select * from GxQscripts where name='EntitySubclientNameToId')
	delete from GxQscripts where name = 'EntitySubclientNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntitySubclientNameToId')
	delete from GXDBVersions where aliasname = 'EntitySubclientNameToId'
GO
print '... Creating Procedure: EntitySubclientNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntitySubclientNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @entityType int OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replaceVarLast int
AS
declare @clientNameVal nvarchar(255)
declare @displayNameVal nvarchar(510)
declare @clientId1 int
declare @tempClnt int
declare @appNameVal nvarchar(255)
declare @applicationIdVal int
declare @appId int
declare @instanceNameVal nvarchar(255)
declare @instanceIdVal nvarchar(255)
declare @instId int
declare @backupSetNameVal nvarchar(255)
declare @backupsetIdVal int
declare @subclientNameVal nvarchar(255)
declare @tempbkpSetId int
declare @subclientIdVal int
declare @tempsubclntId int
declare @appTypeNameVal nvarchar(255)
declare @appTypeIdVal int
declare @tempSCPolicyId int
declare @appGroupNameVal nvarchar(255)
declare @appGroupIdVal int
declare @scPolicyNameVal nvarchar(255)
declare @scPolicyIdVal int
declare @appTypeId int
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @appGroupId int
SET @entityType = 0
SET @temp=@var.query('(//.[@_type_])[sql:variable("@i")]')
 SET @clientNameVal=@temp.value('(//./@clientName)[1]','nvarchar(255)')
 IF SUBSTRING(@clientNameVal,1,1) = '|'
	SET @clientNameVal = ( select dbo.DecodeInvalidXMLChar(@clientNameVal) )
 SET @displayNameVal=@temp.value('(//./@displayName)[1]','nvarchar(510)')
 IF SUBSTRING(@displayNameVal,1,1) = '|'
	SET @displayNameVal = ( select dbo.DecodeInvalidXMLChar(@displayNameVal) )
 SET @tempClnt=@temp.value('(//./@clientId)[1]','int')
 SET @clientId1 = @tempClnt
 SET @appNameVal=@temp.value('(//./@appName)[1]','nvarchar(255)')
 IF SUBSTRING(@appNameVal,1,1) = '|'
	SET @appNameVal = ( select dbo.DecodeInvalidXMLChar(@appNameVal) )
 SET @appId=@temp.value('(//./@applicationId)[1]','int')
 SET @applicationIdVal=@appId
 SET @appGroupNameVal=@temp.value('(//./@appGroupName)[1]','nvarchar(255)')
 IF SUBSTRING(@appGroupNameVal,1,1) = '|'
	SET @appGroupNameVal = ( select dbo.DecodeInvalidXMLChar(@appGroupNameVal) )
 SET @appGroupId=@temp.value('(//./@appGroupId)[1]','int')
 SET @appGroupIdVal=@appGroupId
 SET @appTypeNameVal=@temp.value('(//./@appTypeName)[1]','nvarchar(255)')
 IF SUBSTRING(@appTypeNameVal,1,1) = '|'
	SET @appTypeNameVal = ( select dbo.DecodeInvalidXMLChar(@appTypeNameVal) )
 SET @appTypeId=@temp.value('(//./@appTypeId)[1]','int')
 SET @appTypeIdVal=@appTypeId
 SET @instanceNameVal=@temp.value('(//./@instanceName)[1]','nvarchar(255)')
  IF SUBSTRING(@instanceNameVal,1,1) = '|'
	SET @instanceNameVal = ( select dbo.DecodeInvalidXMLChar(@instanceNameVal) )
 SET @instId=@temp.value('(//./@instanceId)[1]','int')
 SET @instanceIdVal=@instId
 SET @backupSetNameVal=@temp.value('(//./@backupsetName)[1]','nvarchar(255)')
 IF SUBSTRING(@backupSetNameVal,1,1) = '|'
	SET @backupSetNameVal = ( select dbo.DecodeInvalidXMLChar(@backupSetNameVal) )
 SET @tempbkpSetId=@temp.value('(//./@backupsetId)[1]','int')
 SET @backupsetIdVal=@tempbkpSetId
 SET @subclientNameVal=@temp.value('(//./@subclientName)[1]','nvarchar(255)')
 IF SUBSTRING(@subclientNameVal,1,1) = '|'
	SET @subclientNameVal = ( select dbo.DecodeInvalidXMLChar(@subclientNameVal) )
 SET @tempsubclntId =@temp.value('(//./@subclientId)[1]','int')
 SET @subclientIdVal=@tempsubclntId
 SET @tempSCPolicyId =@temp.value('(//./@subclientPolicyId)[1]','int')
 SET @scPolicyIdVal = @tempSCPolicyId
 SET @scPolicyNameVal=@temp.value('(//./@subclientPolicyName)[1]','nvarchar(255)')
 IF SUBSTRING(@scPolicyNameVal,1,1) = '|'
	SET @scPolicyNameVal = ( select dbo.DecodeInvalidXMLChar(@scPolicyNameVal) )
IF @appNameVal = 'DB2 DPF'
	-- Ganesh - Ideally 'DB2 MultiNode' should come from the macro CV_APPTYPE_DB2_DPF_NAME in AppTypeDefs.h
	-- This macro is defined as a double quoted string literal.
	-- QUOTED_IDENTIFIER will have to be set to OFF for double quoted literals to work in SQL.
	-- But, this proc also does some xQuery for which QUOTED_IDENTIFIER has to be set to ON.
	-- The best fix for this is to modify SQL generation to automatically change double quoted string literals to
	-- single quoted literals. But, this can't happen in current build (11.0 B02).
	-- So, for now we perform the replacement manually.
	SET @appNameVal = 'DB2 MultiNode'
-- backward compatibility (11.0 to 9.0) for merged NAS licence types
IF @appNameVal = 'Hitachi NAS' OR @appNameVal like '%NAS NDMP'
	SET @appNameVal	= 'NAS'
-- Its assumed that whenever displayName is used, it means the entity is CLIENT_ENTITY.
-- If a new entity is using displayName then the corresponding type should also be passed to this SP.
if(@displayNameVal IS NOT null OR @clientNameVal IS NOT null)
begin
	    SELECT @clientId1 = id FROM App_Client WITH(NOLOCK) WHERE displayName = @displayNameVal AND @displayNameVal IS NOT null
		IF @@ROWCOUNT <> 1
		BEGIN
			SET @clientId1 = (SELECT id FROM App_Client WITH(NOLOCK) WHERE name = @clientNameVal)
		END
	    SET @entityType = 3
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
		IF @clientId1 IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Client Id for client name [' + @clientNameVal + '].'
			IF (@put_invalid_id < 0)
				set @clientId1= @put_invalid_id
		END
		IF (@clientId1 is not NULL)
		BEGIN
			BEGIN
				IF @tempClnt IS null
				BEGIN
					IF @clientId1 IS not null
						SET @var.modify('insert (attribute clientId {sql:variable("@clientId1")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				END
				ELSE
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@clientId)[1] with sql:variable("@clientId1")')
			END
		END
end
	IF @clientId1 IS NOT null
	BEGIN
		IF @appNameVal IS NOT null
		BEGIN
			--set @applicationIdVal=(select type from app_IDAType where name=@appNameVal)
			set @applicationIdVal=(select MAX(type) from app_IDAType where name=@appNameVal AND type IN (select appTypeId from APP_Application where clientId = @clientId1))	--USE LAST VALUE ADDED WHICH SHOULD BE THE MAX
			IF  @applicationIdVal IS null
			BEGIN
				SET @applicationIdVal = (select appTypeId from app_idaname
										 where clientid = @clientId1
										 and appTypeId in (select distinct type from app_idaType
														   where displayName = @appNameVal))
			END
			IF  @applicationIdVal IS null
			BEGIN
				SET @applicationIdVal = (select distinct TOP 1 type from app_idaType
								where displayName = @appNameVal)
			END
			IF @applicationIdVal IS NULL
			BEGIN
				SET @ErrorSeverity = @ERROR_SEVERITY
				SET @ErrorState	   = @ERROR_STATE
				SET @ErrorMessage  = @ErrorMessage + 'Invalid Application Id for App name [' + @appNameVal + '].'
				IF (@put_invalid_id < 0)
					set @applicationIdVal= @put_invalid_id
			END
			IF (@applicationIdVal is not null)
			BEGIN
				SET @entityType = 4
				BEGIN
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
					IF @appId IS null
					BEGIN
						SET @var.modify('insert (attribute applicationId {sql:variable("@applicationIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
					END
					ELSE
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@applicationId)[1] with sql:variable("@applicationIdVal")')
				END
			END
		END
		IF @applicationIdVal IS NOT null
		BEGIN
			IF  @instanceNameVal IS NOT null
			BEGIN
				SET @instanceNameVal = REPLACE(@instanceNameVal,'[','^[')
				SET @instanceNameVal = REPLACE(@instanceNameVal,']','^]')
				SET @instanceNameVal = REPLACE(@instanceNameVal,'_','^_')
				SET @instanceNameVal = REPLACE(@instanceNameVal,'%','^%')
				SET  @instanceIdVal=
				(
					select  TOP 1 app_instancename.id from app_application ,app_instancename
					where app_application.clientid=@clientId1 and app_application.appTypeId=@applicationIdVal and
					(
						((app_instancename.name like @instanceNameVal ESCAPE N'^')
						or
						(app_instancename.name like @instanceNameVal + CAST(0X12 as nvarchar) + '%' ESCAPE N'^'))
						and
						app_application.instance=app_instancename.id
					)
				)
				SET @entityType = 5
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
				IF @instanceIdVal IS NULL
				BEGIN
					SET @ErrorSeverity = @ERROR_SEVERITY
					SET @ErrorState	   = @ERROR_STATE
					SET @ErrorMessage  = @ErrorMessage + 'Invalid Instance Id for Instance name [' + @instanceNameVal + '].'
					IF (@put_invalid_id < 0)
						set @instanceIdVal= @put_invalid_id
				END
				IF (@instanceIdVal is not null)
				BEGIN
					BEGIN
						IF @instId IS null
						BEGIN
							SET @var.modify('insert (attribute instanceId {sql:variable("@instanceIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						END
						ELSE
							SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@instanceId)[1] with sql:variable("@instanceIdVal")')
					END
				END
			END
			ELSE IF @instanceIdVal IS null OR @instanceIdVal = 0
			BEGIN
				IF (( @backupSetNameVal IS NOT NULL and LEN(@backupSetNameVal)>0) OR	( @backupsetIdVal IS NOT null AND @backupsetIdVal>0) OR
					( @subclientNameVal IS NOT NULL and LEN(@subclientNameVal)>0) OR ( @subclientIdVal IS NOT null AND @subclientIdVal>0 ) )
				BEGIN
					SET  @instanceIdVal = (
                        select  TOP 1 app_instancename.id
                        from app_application ,app_instancename
                        where
						(app_application.clientid=@clientId1 and app_application.appTypeId=@applicationIdVal and app_application.instance=app_instancename.id)
                        OR
						(app_application.instance=app_instancename.id AND APP_Application.id = @subclientIdVal )	--SELECTION AT SUBCLIENT LEVEL
                    )
					IF @instanceIdVal IS NULL
					BEGIN
						SET @ErrorSeverity = @ERROR_SEVERITY
						SET @ErrorState	   = @ERROR_STATE
						SET @ErrorMessage  = @ErrorMessage + 'Invalid Instance Id for Instance name [' + @instanceNameVal + '].'
						IF (@put_invalid_id < 0)
							set @instanceIdVal= @put_invalid_id
					END
					IF (@instanceIdVal is not null)
					BEGIN
						SET @entityType = 5
						BEGIN
							SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
							IF @instId IS null
								SET @var.modify('insert (attribute instanceId {sql:variable("@instanceIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
							ELSE
								SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@instanceId)[1] with sql:variable("@instanceIdVal")')
						END
					END
				END
				-- No need to print error here since @instanceNameVal IS null OR is empty AND instanceIdVal is 0. Backupset/subclient id/name not provided also.
			END
			IF @backupSetNameVal IS NOT null
			BEGIN
				SET @backupsetIdVal=(select  TOP 1 app_backupsetname.id from app_application ,app_backupsetname
				where app_application.clientid=@clientId1 and app_application.instance=@instanceIdVal and app_application.appTypeId=@applicationIdVal and app_backupsetname.name=@backupSetNameVal and app_application.backupset=app_backupsetname.id)
				IF @backupsetIdVal IS NULL
				BEGIN
					SET @ErrorSeverity = @ERROR_SEVERITY
					SET @ErrorState	   = @ERROR_STATE
					SET @ErrorMessage  = @ErrorMessage + 'Invalid backupset Id for backupSet name [' + @backupSetNameVal + '].'
					IF (@put_invalid_id < 0)
						set @backupsetIdVal= @put_invalid_id
				END
				IF (@backupsetIdVal is not null)
				BEGIN
					SET @entityType = 6
					BEGIN
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
						IF @tempbkpSetId IS null
						BEGIN
							SET @var.modify('insert (attribute backupsetId {sql:variable("@backupsetIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						END
						ELSE
							SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@backupsetId)[1] with sql:variable("@backupsetIdVal")')
					END
				END
			END
			ELSE
			BEGIN
				IF ( (@instanceIdVal IS NOT  NULL) AND ((@subclientNameVal IS NOT null)))
				BEGIN
					SET @backupsetIdVal=(select  TOP 1 app_backupsetname.id from app_application ,app_backupsetname
					where app_application.clientid=@clientId1 and app_application.instance=@instanceIdVal and app_application.appTypeId=@applicationIdVal and app_application.backupset=app_backupsetname.id)
					IF @backupsetIdVal IS NULL
					BEGIN
						SET @ErrorSeverity = @ERROR_SEVERITY
						SET @ErrorState	   = @ERROR_STATE
						SET @ErrorMessage  = @ErrorMessage + 'Invalid backupset Id for backupSet name.'
						IF (@put_invalid_id < 0)
							set @backupsetIdVal= @put_invalid_id
					END
					IF (@backupsetIdVal is not null)
					BEGIN
						SET @entityType = 6
						BEGIN
							SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
							IF @backupsetIdVal IS NOT null
							BEGIN
								IF @tempbkpSetId IS null
									SET @var.modify('insert (attribute backupsetId {sql:variable("@backupsetIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
								ELSE
									SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@backupsetId)[1] with sql:variable("@backupsetIdVal")')
							END
						END
					END
				END
			END
			IF (@subclientNameVal IS NOT NULL)
			BEGIN
			 IF(@instanceIdVal IS NOT NULL) AND ((@applicationIdVal IS NOT NULL) OR (@applicationIdVal != 0)) AND ( @clientId1 IS NOT NULL) AND (@backupsetIdVal IS NOT NULL)
			 BEGIN
				SET @subclientIdVal=(select app_application.id from app_application where clientid=@clientId1 and appTypeId=@applicationIdVal and app_application.instance=@instanceIdVal and backupSet=@backupsetIdVal and app_application.subclientName=@subclientNameVal)
				IF @subclientIdVal IS NULL
				BEGIN
					SET @ErrorSeverity = @ERROR_SEVERITY
					SET @ErrorState	   = @ERROR_STATE
					SET @ErrorMessage  = @ErrorMessage + 'Invalid Subclient Id for Subclient Name [' + @subclientNameVal + '].'
					IF (@put_invalid_id < 0)
						SET @subclientIdVal= @put_invalid_id
				END
				IF (@subclientIdVal is not null)
				BEGIN
					SET @entityType = 7
					BEGIN
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
						IF @tempsubclntId IS null
						BEGIN
							SET @var.modify('insert (attribute subclientId {sql:variable("@subclientIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						END
						ELSE
							SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@subclientId)[1] with sql:variable("@subclientIdVal")')
					END
				END
			END
			ELSE
				BEGIN
					SET @ErrorSeverity = @ERROR_SEVERITY
					SET @ErrorState	   = @ERROR_STATE
					SET @ErrorMessage  = @ErrorMessage + 'Invalid Subclient Id for Subclient Name [' + @subclientNameVal + '].'
					IF (@put_invalid_id < 0)
						SET @subclientIdVal= @put_invalid_id
				END
			END
		END
	END
	ELSE
	BEGIN
		IF @appTypeNameVal IS NOT null
		BEGIN
			set @appTypeIdVal=(select MAX(type) from app_IDAType where name=@appTypeNameVal and type <> 2) -- problem only for oracle
			IF  @appTypeIdVal IS null
			BEGIN
				SET @appTypeIdVal = (select distinct TOP 1 Type from app_idaType
								where displayName = @appTypeNameVal)
			END
			IF @appTypeIdVal IS null
			BEGIN
				SET @ErrorSeverity = @ERROR_SEVERITY
				SET @ErrorState	   = @ERROR_STATE
				SET @ErrorMessage  = @ErrorMessage + 'Invalid Application Id for App name [' + @appTypeNameVal + '].'
				IF (@put_invalid_id < 0)
					SET @appTypeIdVal= @put_invalid_id
			END
			IF (@appTypeIdVal is not null)
			BEGIN
				SET @entityType = 79
				BEGIN
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
					IF @appTypeId IS null
					BEGIN
						SET @var.modify('insert (attribute appTypeId {sql:variable("@appTypeIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
					END
					ELSE
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@appTypeId)[1] with sql:variable("@appTypeIdVal")')
				END
			END
		END
		IF @appGroupNameVal IS NOT null
		BEGIN
			set @appGroupIdVal=(select appTypeGroupId from APP_appTypeGroup where groupName=@appGroupNameVal)
			--select @appGroupIdVal
			IF @appGroupIdVal IS null
			BEGIN
				SET @ErrorSeverity = @ERROR_SEVERITY
				SET @ErrorState	   = @ERROR_STATE
				SET @ErrorMessage  = @ErrorMessage + 'Invalid AppGroup Id for App group name [' + @appNameVal + '].'
				IF (@put_invalid_id < 0)
					SET @appGroupIdVal= @put_invalid_id
			END
			IF (@appGroupIdVal is not null)
			BEGIN
				SET @entityType = 78
				BEGIN
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
					IF (@appId IS NULL) AND (@appGroupIdVal IS NULL)
					BEGIN
						SET @var.modify('insert (attribute appGroupId {sql:variable("@appGroupIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
					END
					ELSE
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@appGroupId)[1] with sql:variable("@appGroupIdVal")')
				END
			END
		END
		IF @scPolicyNameVal IS NOT null
		BEGIN
			SET @scPolicyIdVal=(select  TOP 1 app_backupsetname.id from app_application ,app_backupsetname
			where app_application.appTypeId=1030 and app_backupsetname.name=@scPolicyNameVal and app_application.backupset=app_backupsetname.id)
			IF @scPolicyIdVal IS null
			BEGIN
				SET @ErrorSeverity = @ERROR_SEVERITY
				SET @ErrorState	   = @ERROR_STATE
				SET @ErrorMessage  = @ErrorMessage + 'Invalid backupset Id for backupSet name [' + @scPolicyNameVal + '].'
				IF (@put_invalid_id < 0)
					SET @scPolicyIdVal= @put_invalid_id
			END
			IF (@scPolicyIdVal is not null)
			BEGIN
				SET @entityType = 65
				BEGIN
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
					IF @tempSCPolicyId IS null
					BEGIN
						SET @var.modify('insert (attribute subclientPolicyId {sql:variable("@scPolicyIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
					END
					ELSE
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@subclientPolicyId)[1] with sql:variable("@scPolicyIdVal")')
				END
			END
		END
		IF @appNameVal IS NOT NULL AND @appNameVal <> ''
		BEGIN
			exec EntityApplicationNameToId @i, @put_invalid_id, @temp,@var output,@appNameVal,@appId,@entityType,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'EntitySubclientNameToId')
	delete from GxQscripts where name = 'EntitySubclientNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntitySubclientNameToId')
	delete from GXDBVersions where aliasname = 'EntitySubclientNameToId'
GO

insert into GXDBVersions values(2, 'EntitySubclientNameToId',  '00010011001200070000', 'EntitySubclientNameToId', '00010011001200070000')
GO

