

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntitySIDBStoreNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntitySIDBStoreNameToId.sp,v $ $Id: EntitySIDBStoreNameToId.sp,v 1.1.52.2 2018/03/22 01:40:54 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntitySIDBStoreNameToId()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0			Gokul		Name to Id conversion for SIDB Store Name
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntitySIDBStoreNameToId <<<'

IF EXISTS (select * from sysobjects where name='EntitySIDBStoreNameToId')
	drop procedure EntitySIDBStoreNameToId
IF EXISTS (select * from GxQscripts where name='EntitySIDBStoreNameToId')
	delete from GxQscripts where name = 'EntitySIDBStoreNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntitySIDBStoreNameToId')
	delete from GXDBVersions where aliasname = 'EntitySIDBStoreNameToId'
GO
print '... Creating Procedure: EntitySIDBStoreNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntitySIDBStoreNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast int 
AS
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @tempIdVal int
declare @sidbStoreName nvarchar(max)
declare @sidbStoreId int
declare @entityType int
SET @sidbStoreName=@temp.value('(//./@sidbStoreName)[1]','nvarchar(max)')
 IF SUBSTRING(@sidbStoreName,1,1) = '|'
	SET @sidbStoreName= ( select dbo.DecodeInvalidXMLChar(@sidbStoreName))
IF @sidbStoreName IS NOT null AND @sidbStoreName <> ''
BEGIN
	SET @tempIdVal=@temp.value('(//./@sidbStoreId)[1]','nvarchar(1024)')
	SET @sidbStoreId=(select SIDBStoreId from IdxSIDBStore  where SIDBStoreName=@sidbStoreName )
	IF @sidbStoreId IS NULL
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
		SET @ErrorState	   = @ERROR_STATE
		SET @ErrorMessage  = @ErrorMessage + 'Invalid SIDB Store Id for Store name['+ @sidbStoreName +'].'
		IF (@put_invalid_id = 1)
			set @sidbStoreId = -1
	END
	IF (@sidbStoreId is not null)
	BEGIN
		SET @entityType = 115
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempIdVal IS null
			BEGIN
			 SET @var.modify('insert (attribute sidbStoreId {sql:variable("@sidbStoreId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@sidbStoreId)[1] with sql:variable("@sidbStoreId")')
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'EntitySIDBStoreNameToId')
	delete from GxQscripts where name = 'EntitySIDBStoreNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntitySIDBStoreNameToId')
	delete from GXDBVersions where aliasname = 'EntitySIDBStoreNameToId'
GO

insert into GXDBVersions values(2, 'EntitySIDBStoreNameToId',  '00010001005200020000', 'EntitySIDBStoreNameToId', '00010001005200020000')
GO

