

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityRoleNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +======================================================================================================+
--  | Stored Precedure: EntityRoleNameToId()
--  |
--  |   Revisions  	Author 							Description
--  |   ---------  	----------    				----------------------------------------
--  |   1.0			jswaminathan & saggarwal	EntityNameToIdConverter is broken into small procedures
--  +======================================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntityRoleNameToId <<<'

IF EXISTS (select * from sysobjects where name='EntityRoleNameToId')
	drop procedure EntityRoleNameToId
IF EXISTS (select * from GxQscripts where name='EntityRoleNameToId')
	delete from GxQscripts where name = 'EntityRoleNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityRoleNameToId')
	delete from GXDBVersions where aliasname = 'EntityRoleNameToId'
GO
print '... Creating Procedure: EntityRoleNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityRoleNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast INT
AS
declare @roleName nvarchar(255)
declare @entityType int
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @tempRoleId int
declare @roleId int
SET @roleName = @temp.value('(//./@roleName)[1]','nvarchar(255)')
 IF SUBSTRING(@roleName,1,1) = '|'
	SET @roleName = ( select dbo.DecodeInvalidXMLChar(@roleName) )
 SET @tempRoleId = @temp.value('(//./@roleId)[1]','int')
IF @roleName IS NOT null
BEGIN
		SET @roleId = (select TOP 1 id FROM UMRoles WHERE name = @roleName)
		IF @roleId IS null
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid role Id for Role Name [' + @roleName + '].'
			IF (@put_invalid_id < 0)
				set @roleId = @put_invalid_id
		END
	if (@roleId is not null)
	BEGIN
		SET @entityType = 120				--CvEntities::EntityType_ROLE_ENTITY
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempRoleId IS null
			BEGIN
			 SET @var.modify('insert (attribute roleId {sql:variable("@roleId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@roleId)[1] with sql:variable("@roleId")')
		END
	END
end
GO

IF EXISTS (select * from GxQscripts where name = 'EntityRoleNameToId')
	delete from GxQscripts where name = 'EntityRoleNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityRoleNameToId')
	delete from GXDBVersions where aliasname = 'EntityRoleNameToId'
GO

insert into GXDBVersions values(2, 'EntityRoleNameToId',  '00000000000000000000', 'EntityRoleNameToId', '00000000000000000000')
GO

