

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityProviderNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntityProviderNameToId.sp,v $ $Id: EntityProviderNameToId.sp,v 1.7.2.3 2018/03/27 08:04:23 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntityProviderNameToId()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Ravneet Singh Arora	 EntityNameToIdConverter is broken into small procedures
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntityProviderNameToId <<<'

IF EXISTS (select * from sysobjects where name='EntityProviderNameToId')
	drop procedure EntityProviderNameToId
IF EXISTS (select * from GxQscripts where name='EntityProviderNameToId')
	delete from GxQscripts where name = 'EntityProviderNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityProviderNameToId')
	delete from GXDBVersions where aliasname = 'EntityProviderNameToId'
GO
print '... Creating Procedure: EntityProviderNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityProviderNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @providerNameVal nvarchar(255),
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast int
AS
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @tempIdVal int
declare @providerIdVal int
declare @groupIdVal int
declare @externalGroupNameVal nvarchar(255)
--declare @storagePolicyNameVal nvarchar(255)
declare @entityType int
SET @tempIdVal=@temp.value('(//./@providerId)[1]','nvarchar(255)')
	SET @providerIdVal=(select P.id from UMDSProviders P where P.domainName=@providerNameVal)
	IF @providerIdVal IS NULL
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
		SET @ErrorState	   = @ERROR_STATE
		SET @ErrorMessage  = @ErrorMessage + 'Invalid Provider Id for Provider Name ['+ @providerNameVal+'].'
		IF (@put_invalid_id < 0)
			set @providerIdVal= @put_invalid_id
	END
	IF (@providerIdVal is not null)
	BEGIN
		SET @entityType = 61
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempIdVal IS null
			BEGIN
			 SET @var.modify('insert (attribute providerId {sql:variable("@providerIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@providerId)[1] with sql:variable("@providerIdVal")')
		END
	END
	SET @externalGroupNameVal=@temp.value('(//./@externalGroupName)[1]','nvarchar(255)')
 IF SUBSTRING(@externalGroupNameVal,1,1) = '|'
	SET @externalGroupNameVal = ( select dbo.DecodeInvalidXMLChar(@externalGroupNameVal) )
	IF @providerIdVal IS NOT null and @externalGroupNameVal <> ''
BEGIN
	SET @tempIdVal=@temp.value('(//./@groupId)[1]','nvarchar(255)')
SET @groupIdVal=(select G.id from UMgroups G where G.name = @externalGroupNameVal and G.umdsProviderId = @providerIdVal and (groupFlags<>0 AND groupFlags&0x0002=0))
	IF @groupIdVal IS NULL
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
		SET @ErrorState	   = @ERROR_STATE
		SET @ErrorMessage  = @ErrorMessage + 'Invalid Group Id'
		IF (@put_invalid_id < 0)
			set @groupIdVal= @put_invalid_id
	END
	IF (@groupIdVal is not null)
	BEGIN
		SET @entityType = 62
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempIdVal IS null
			BEGIN
			 SET @var.modify('insert (attribute groupId {sql:variable("@groupIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@groupId)[1] with sql:variable("@groupIdVal")')
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'EntityProviderNameToId')
	delete from GxQscripts where name = 'EntityProviderNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityProviderNameToId')
	delete from GXDBVersions where aliasname = 'EntityProviderNameToId'
GO

insert into GXDBVersions values(2, 'EntityProviderNameToId',  '00010007000200030000', 'EntityProviderNameToId', '00010007000200030000')
GO

