

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityNameToIdConverterNew.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================================================================================================+
--  |
--	| Stored Procedure: EntityNameToIdConverterNew
--  |
--  | Author: jswaminathan
--  |
--  | Description: Converts the entity names to ids for given XML. Depends on App_Entity to find out the look up table for each entity type.
--	| Creates a #tempTable and updates all entities of same type in one query. For new entities if they have a one-to-one straight name - id mapping that
--	| can be identified from a look up table, then add the entry in APP_Entity. If they need some extra processing, then add entity specific code here.
--	|
--  +========================================================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EntityNameToIdConverterNew')
BEGIN
	print '>>> Drop Stored Procedure: EntityNameToIdConverterNew <<<'
	drop procedure EntityNameToIdConverterNew
END
IF EXISTS (select * from GxQscripts where name='EntityNameToIdConverterNew')
	delete from GxQscripts where name = 'EntityNameToIdConverterNew'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityNameToIdConverterNew')
	delete from GXDBVersions where aliasname = 'EntityNameToIdConverterNew'
GO
print '... Creating Procedure: EntityNameToIdConverterNew'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityNameToIdConverterNew
  @xmlInput XML OUTPUT,
  @selectOutput INT = 0
AS
  DECLARE @xmlOutput XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#entityTable') IS NOT NULL
	DROP TABLE #entityTable
CREATE TABLE #entityTable
(
	_type_ INT,								--_type_ as defined in CvEntities.x and App_Entity
	typeIndex INT,							--position of _type_ in the given XML
	originalXML XML,						--XML blob that contains _type_
	parentTag VARCHAR(128),					--parentTag of the XML blob
	entityName NVARCHAR(200),				--entity name in XML
	entityId VARCHAR(100),					--entity ID in XML (It is in varchar because there are some entities that fill GUID as id)
	idFound INT DEFAULT 0,					--flag to tell whether we have got the ID or not (Reason we have a separate flag is for those entities that come with wrong name and some ID, we need to populate error message. So cannot just rely on entityId alone)
	fieldName VARCHAR(64),					--field name of the entity id in .x (like clientId, applicationId, mediaAgentId, roleId, etc.)
	isCustomEntity INT DEFAULT 0			--how the entity comes in input XML. If it is custom entity, then we need to populate it back in the same way.
)
-- This is taken out of the EntityNameToIdConverterNew stored procedure
-- By doing this, the core of the logic is retained as is except for the output part
-- Out of this core stored procedure, the users pick the type of output they need
-- EntityNameToIdConverterNew -- returns XML just as before
-- EntityNameToIdConverterNewTableOutput -- returns the #entityTable as such
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @invalidEntities NVARCHAR(MAX) = N''
--For Create Task and Modify Task requests if they are creating subTasks, then we should not error out if subtask name is not found. (Ref: EntityTaskSubtaskNameToId)
DECLARE @isTaskReq INT = 0
IF @xmlInput.exist('/TMMsg_ModifyTaskReq') = 1 OR @xmlInput.exist('/TMMsg_CreateTaskReq') = 1
	SET @isTaskReq = 1
--For Create Storage Policy Request we get drive pool name different.
DECLARE @createStoragePolicyCopyReqMA NVARCHAR(200) = N''
SET @createStoragePolicyCopyReqMA = ISNULL((@xmlInput.value('(/App_CreateStoragePolicyCopyReq/storagePolicyCopyInfo/mediaAgent/@mediaAgentName)[1]','nvarchar(255)')), N'')
CREATE CLUSTERED INDEX IX_entityTable_NameToId ON #entityTable (_type_, entityName)
--Entities present in APP_Entity are read here. (Both that come with proper _type_ and as generic entity _type_ = 0). If there is no record found, then the record comes with _type_ = 0.
--If there are multiple records found (like in generic entity or iDA entities), then it will populate multiple rows. Handles generic entities that takes more than one entity in one blob.
--<node _type_="0" clientName="C1" appName="File System"/> will populate 2 rows. Both with same parentTag and originalXML.
INSERT INTO #entityTable (_type_, typeIndex, originalXML, parentTag, isCustomEntity, entityName)
SELECT CASE	WHEN Entities._type_ IS NOT NULL THEN Entities._type_
WHEN EntityOriginalXML._type_ = 150 THEN ISNULL((SELECT E.entityTYpe FROM APP_Entity E (NOLOCK) WHERE E.entityTypeName = originalXML.value('(/*/@entityTypeName)[1]', 'VARCHAR(200)')), -32000)
			WHEN EntityOriginalXML._type_ IS NOT NULL THEN EntityOriginalXML._type_
	   ELSE 0 END,
	   EntityOriginalXML.typeIndex,
	   EntityOriginalXML.originalXML,
	   EntityOriginalXML.parentTag,
CASE WHEN (EntityOriginalXML._type_ = 150) THEN 1 ELSE 0 END,
CASE WHEN (EntityOriginalXML._type_ = 150) THEN (SELECT originalXML.value('(/*/@entityName)[1]', 'NVARCHAR(MAX)')) END
FROM
(
	SELECT ref.value('(@_type_)[1]', 'INT') AS _type_,
		   ROW_NUMBER() OVER (ORDER BY R.ref) AS typeIndex,
		   ref.query('.') AS originalXML,
		   ref.value('local-name(.)', 'VARCHAR(1024)' ) AS parentTag
	FROM @xmlInput.nodes('(//.[@_type_])') R (ref)
) EntityOriginalXML
OUTER APPLY
(
	SELECT DISTINCT E.entityType AS _type_
	FROM EntityOriginalXML.originalXML.nodes('//@*') T (tef) INNER JOIN APP_Entity E (NOLOCK)
	ON ((tef.value('local-name(.)', 'VARCHAR(1024)') = E.entityNameInXML)
		OR (tef.value('local-name(.)', 'VARCHAR(1024)') = E.entityIdInXML)
OR (tef.value('local-name(.)', 'VARCHAR(1024)') = 'displayName') AND E.entityType = 3)	-- **Note: refer down.
) Entities
-- Note**: We need to check for Id matching also. Because Aniket tries a special XML with client as Id, appType and backupset as names - <clientId="4" appName="File System" backupsetName="defaultBkpSet"/>
-- For this case, we need a client row, apptype row and backupset row to be inserted. If we do only name match, it will miss client row and this will go unprocessed.
--Fills appropriate _type_ for custom entities and time entities
UPDATE A
SET isCustomEntity = CASE WHEN E1._type_ = 150 THEN 1 ELSE 0 END,
entityName = CASE WHEN E1._type_ = 150 THEN originalXML.value('(/*/@entityName)[1]', 'NVARCHAR(MAX)') ELSE '' END,
_type_ = CASE WHEN E1._type_ = 150 THEN ISNULL((SELECT E.entityTYpe FROM APP_Entity E (NOLOCK) WHERE E.entityTypeName = originalXML.value('(/*/@entityTypeName)[1]', 'VARCHAR(200)')), -32000) ELSE E1._type_ END
FROM #entityTable A
CROSS APPLY (SELECT dbo.getEntityTypeFromGenericEntityXMLBlob(originalXML) AS _type_) E1
WHERE A._type_ = 0
DECLARE @_type_ INT
DECLARE @_type_Table TABLE (id INT IDENTITY(1,1), _type_ INT)		--Temp table to hold distinct entity types in the input request.
INSERT INTO @_type_Table (_type_)
SELECT DISTINCT _type_ FROM #entityTable WHERE _type_ > 0 AND _type_ NOT IN (4, 5, 6, 7, 47, 51, 67, 48, 18, 62, 68, 54) ORDER BY _type_			--All excluded _type_ are children entities like appType, instance, backupset, subclient, subTask, drivePool, masterPool, scratchPool, etc.
																																					--They will be handled when their parent is processed.
DECLARE @i INT = 1			--Let us not use a cursor since they are costly. Using a While loop with an index variable and a temp Table is also going to do the trick.
WHILE @i <= (SELECT MAX(id) FROM @_type_Table)
BEGIN
	SET @_type_ = (SELECT _type_ FROM @_type_Table WHERE id = @i)
	DECLARE @dynamicSQLStmt NVARCHAR(MAX) = N''
	DECLARE @idCOlName NVARCHAR(512)
    DECLARE @entityNameColName NVARCHAR(512)
    DECLARE @entityNameInXML NVARCHAR(512)
    DECLARE @entityIdINXML NVARCHAR(512)
    DECLARE @tableName NVARCHAR(512)
    DECLARE @isCustomEntity INT = 0
    DECLARE @entityTypeName NVARCHAR(512)
	DECLARE @doesExistInAPP_Entity INT = 0
	SELECT @doesExistInAPP_Entity = 1, @tableName = tableName, @idCOlName = idColName, @entityNameColName = entityNameColName, @entityNameInXML = entityNameInXML, @entityIdINXML = entityIdInXML, @isCustomEntity = (flags & 1), @entityTYpeName = entityTypeName
	FROM App_entity (NOLOCK)
	WHERE entityType = @_type_
	IF (@doesExistInAPP_Entity <> 1)
	BEGIN
		--If _type_ is filled in input and there is no entry for it in APP_Entity this code will be hit. Should we probably not throw error in this case?
		SET @invalidEntities += 'No record found for entity type [' + CAST(@_type_ AS VARCHAR(10)) + '] in App_Entity.'
		SET @i = @i + 1
		CONTINUE
	END
IF @_type_ <> 3
	BEGIN
		SET @dynamicSQLStmt = 'UPDATE #entityTable ' + CHAR(10) +
							' SET entityId = (SELECT originalXML.value('' (/*/@' + @entityIdINXML + ')[1]'', ''VARCHAR(100)'')),' + CHAR(10) +
							' entityName = (SELECT originalXML.value('' (/*/@' + @entityNameInXML + ')[1]'', ''NVARCHAR(1024)''))' + CHAR(10) +
							' WHERE #entityTable._type_ = ' + CAST(@_type_ AS VARCHAR(10)) + ' AND isCustomEntity = 0' 				--For custom entities we already know entity name and _type_
		EXEC (@dynamicSQLStmt)
	END
	ELSE
	BEGIN
		UPDATE #entityTable
			SET entityId = originalXML.value('(/*/@clientId)[1]','nvarchar(100)'),
			entityName = originalXML.value('(/*/@displayName)[1]','nvarchar(1024)')
WHERE _type_ = 3 AND isCustomEntity = 0
	END
	--Entities that do not depend directly on name need to be handled here. Like commcell, component, etc.
IF @_type_ = 1				--Commcell entity (Ref: EntityCommcellNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityID = CC.id,
			fieldName = 'commCellId'
		FROM APP_Commcell CC (NOLOCK) INNER JOIN APP_Client C (NOLOCK)
		ON C.id = 2 AND CC.clientId = C.id
WHERE #entityTable._type_ = 1 AND C.csHostName = #entityTable.entityName AND #entityTable.originalXML.value('(/*/@csGUID)[1]', 'NVARCHAR(255)') IS NULL
		UPDATE #entityTable
		SET idFound = 1,
			entityID = APP_Commcell.id,
			fieldName = 'commCellId'
		FROM APP_Commcell (NOLOCK)
WHERE #entityTable._type_ = 1 AND aliasName = #entityTable.entityName AND #entityTable.originalXML.value('(/*/@csGUID)[1]', 'NVARCHAR(255)') IS NULL AND #entityTable.idFound = 0
		UPDATE #entityTable
		SET idFound = 1,
			entityID = APP_Commcell.id,
			fieldName = 'commCellId'
		FROM APP_Commcell (NOLOCK)
WHERE #entityTable._type_ = 1 AND aliasName = #entityTable.entityName AND #entityTable.originalXML.value('(/*/@csGUID)[1]', 'NVARCHAR(255)') IS NOT NULL AND #entityTable.originalXML.value('(/*/@csGUID)[1]', 'NVARCHAR(255)') = APP_Commcell.csGUID AND #entityTable.idFound = 0
	END
ELSE IF @_type_ = 88 			--VM entity (Ref: EntityVMNameToId)
	BEGIN
		--Get client ID first.
		UPDATE #entityTable
		SET entityID = C.id,				--Do not set idFound here. We need to get GUID ultimately.
			fieldName = 'clientId'
		FROM APP_Client C (NOLOCK) INNER JOIN APP_VM V (NOLOCK)
		ON C.id = V.clientID
WHERE #entityTable._type_ = 88  AND (C.name = entityName OR C.name = #entityTable.originalXML.value('(/*/@clientName)[1]', 'NVARCHAR(1024)')) AND V.removalTimeStamp IS NULL
		AND #entityTable.originalXML.value('(/*/@vmGUID)[1]', 'VARCHAR(100)') IS NULL			--In old code, we fill GUID only if it is not there in input XML
		--Then get GUID from APP_VM. If it is null, then from APP_ClientProp
		UPDATE #entityTable
		SET idFound = 1,
			entityID = CASE WHEN V.GUID IS NOT NULL THEN V.GUID ELSE entityID END,		--If GUID is not found, we need to query APP_ClientProp again. So retain clientID.
			fieldName = 'vmGUID'
		FROM APP_VM V (NOLOCK)
WHERE #entityTable._type_ = 88  AND CAST(V.clientID AS VARCHAR(100)) = #entityTable.entityID
		AND #entityTable.originalXML.value('(/*/@vmGUID)[1]', 'VARCHAR(100)') IS NULL			--In old code, we fill GUID only if it is not there in input XML
		UPDATE #entityTable
		SET idFound = 1,
			entityID = attrVal,
			fieldName = 'vmGUID'
		FROM APP_CLientProp P (NOLOCK)
WHERE #entityTable._type_ = 88  AND CAST(P.componentNameId AS VARCHAR(100)) = #entityTable.entityID AND (P.attrName = 'Virtual Machine Instance UUID' OR P.attrName = 'Virtual Machine GUID') AND modified = 0 AND #entityTable.idFound = 0
		AND #entityTable.originalXML.value('(/*/@vmGUID)[1]', 'VARCHAR(100)') IS NULL			--In old code, we fill GUID only if it is not there in input XML
	END
ELSE IF @_type_ = 60			--Component entity (Ref:EntityComponentNameToId)
	BEGIN
		UPDATE #entityTable
		SET entityName = 'File System'
WHERE _type_ = 60 AND entityName = 'Windows File System'
		UPDATE #entityTable
		SET idFound = 1,
			entityId = id,
			fieldName = 'ComponentId'
		FROM simPackage (NOLOCK)
WHERE #entityTable._type_ = 60 AND #entityTable.entityName = Name
		AND ((originalXML.value('(/*/@osType)[1]', 'char(100)') IS NULL) OR (originalXML.value('(/*/@osType)[1]', 'char(100)') NOT IN ('Windows', 'Unix', 'Netware')))
		--If multiple entries are there it will throw SQL error.
		UPDATE #entityTable
		SET idFound = 1,
			entityId = id,
			fieldName = 'ComponentId'
		FROM simPackage (NOLOCK)
WHERE #entityTable._type_ = 60 AND #entityTable.entityName = Name AND idFound = 0
		AND ((originalXML.value('(/*/@osType)[1]', 'char(100)') IS NOT NULL)
		AND (((originalXML.value('(/*/@osType)[1]', 'char(100)') IN ('Windows')) AND id BETWEEN 0 AND 1000)
			OR ((originalXML.value('(/*/@osType)[1]', 'char(100)') IN ('Unix')) AND id BETWEEN 1001 AND 1999)
			OR ((originalXML.value('(/*/@osType)[1]', 'char(100)') IN ('Netware')) AND id BETWEEN 2000 AND 2999)))
	END
ELSE IF @_type_ = 3
	BEGIN
	--Match the input name on display name.
     -- (If unique match)  proceed;
     -- (If duplicate ) error;
     -- (if not found)  match on client name and proceed;  -- backward compatibility
		UPDATE #entityTable
			SET entityName = originalXML.value('(/*/@clientName)[1]','nvarchar(1024)')
WHERE _type_ = 3 AND isCustomEntity = 0 AND idFound = 0  AND entityName is null --entityName can be populated from displayName.
		CREATE TABLE #tempDispTable (clientId INT, displayName nvarchar(510))
		SELECT id as clientId, displayName into #tempDispTableDup FROM #entityTable JOIN APP_Client WITH(NOLOCK)
ON entityName = displayName AND _type_ = 3 AND idFound = 0 GROUP BY displayName,id
		IF (@@ROWCOUNT <> 0)
		BEGIN
			INSERT INTO #tempDispTable -- unique display name found
					SELECT max(clientId), displayName FROM #tempDispTableDup
						GROUP BY displayName HAVING COUNT(displayName) = 1
			UPDATE #entityTable		--so update the id for the display name
			SET idFound = 1,
				entityId = C.clientId,
				fieldName = 'clientId'
			FROM #tempDispTable C(NOLOCK)
			WHERE
_type_ = 3 AND entityName = C.displayName AND idFound = 0
			--for duplicate display names found, set the entityID here
			UPDATE et
SET entityId = -32001, fieldName=@entityIdINXML
			from  #entityTable et
			inner join
			(SELECT max(clientId) as cid, displayName as dn FROM #tempDispTableDup
						GROUP BY displayName HAVING COUNT(displayName) > 1) dup	on dup.dn=et.entityName
WHERE _type_ = 3 and idFound = 0
		END
		UPDATE #entityTable													-- should not break.
		SET idFound = 1,
			entityId = C.id,
			fieldName = 'clientId'
		FROM APP_Client C(NOLOCK)
		WHERE
_type_ = 3 AND entityName = C.name AND idFound = 0
	END
	ELSE
	BEGIN
		--Normal entities like client group, user, alert, etc. that require no special processing.
		SET @dynamicSQLStmt = 'UPDATE #entityTable '+ CHAR(10) +
								' SET idFound = 1,' + CHAR(10) +
								' entityId = ' + @tableName + '.' + @idCOlName + ',' + CHAR(10) +
								' fieldName = ''' + @entityIdINXML + '''' + CHAR(10) +
								'FROM ' + @tableName + ' (NOLOCK)' + CHAR(10) +
								'WHERE #entityTable._type_ = ' + CAST(@_type_ AS VARCHAR(10)) + ' AND #entityTable.entityName = ' + @tableName + '.' + @entityNameColName
		EXEC (@dynamicSQLStmt)
	END
	--Entities that need extra processing other than names defined in App_Entity need to be handled here.
IF @_type_ = 9 						--Library (Ref: EntityLibraryNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityId = ISNULL(MMLibrary.libraryId,0),
			fieldName = 'libraryId'
		FROM MMLibrary (NOLOCK)
WHERE #entityTable._type_ = 9  AND (#entityTable.entityName = MMLibrary.libraryName OR #entityTable.entityName='Libraries') AND #entityTable.idFound = 0
	END
ELSE IF @_type_ = 121				--Category (Ref: EntityCategoryPermissionNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityId = 0,
			fieldName = 'categoryId',
			_type_ = 123
WHERE _type_ = 121 AND entityName = 'All Permissions'
	END
ELSE IF @_type_ = 79				--AppType (Ref: EntityApplicationNameToId)
	BEGIN
		-- NAS agent renamed to NDMP, must handle both names for backward compatibility. APP_iDAType table has NDMP for the name an displayname
		UPDATE #entityTable
SET entityName = 'NDMP' -- Should match the APP_iDAType.script
WHERE _type_ = 79 AND entityName = 'NAS'
		UPDATE #entityTable
		SET idFound = 1,
			entityID = type,
			fieldName  = 'appTypeId'
		FROM APP_iDAType (NOLOCK)
WHERE _type_ = 79 AND displayName = entityName AND idFound = 0
	END
ELSE IF @_type_ = 57 				--Shelf (Ref: EntityShelfNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityID = 0,
			fieldName  = 'shelfId'
WHERE _type_ = 57 AND entityName = 'Media Repository' AND idFound = 0
	END
ELSE IF @_type_ = 11 				--Media agent (Ref: EntityMediaAgentNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityID = 0,
			fieldName  = 'mediaAgentId'
WHERE _type_ = 11  AND entityName = '<ANY MEDIAAGENT>' AND idFound = 0
	END
ELSE IF @_type_ = 15				--User group (Ref: EntityUserGroupNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityID = G.id,
			fieldName  = 'userGroupId'
		FROM UMGroups G (NOLOCK) INNER JOIN UMDsProviders P (NOLOCK)
		ON G.umdsProviderId = P.id
WHERE _type_ = 15 AND idFound = 0 AND CHARINDEX('\', entityName) > 0 AND G.name = SUBSTRING(entityName, CHARINDEX('\', entityName)+1, LEN(entityName)) AND P.domainName = SUBSTRING(entityName, 1, CHARINDEX('\', entityName)-1)
	END
ELSE IF @_type_ = 53				--typeIndex (Ref: EntityMMexporttypeIndexNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityID = -1,
			fieldName  = 'locationId'
WHERE _type_ = 53 AND  ( entityName = 'Export typeIndex' OR entityName='Export Location') AND idFound = 0
	END
ELSE IF @_type_ = 55				--Timezone (Ref: EntityTimeZoneNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityID = TimeZoneID,
			fieldName  = 'TimeZoneID'
		FROM SchedTimeZone (NOLOCK)
WHERE _type_ = 55 AND entityName = TimeZoneStdName AND idFound = 0
		UPDATE #entityTable
		SET idFound = 1,
			entityID = 1001,
			fieldName  = 'TimeZoneID'
WHERE _type_ = 55 AND entityName = 'Client Time Zone' AND idFound = 0
		UPDATE #entityTable
		SET idFound = 1,
			entityID = 0,
			fieldName  = 'TimeZoneID'
WHERE _type_ = 55 AND idFound = 0		--Copied from EntityTimeZoneNameToId
	END
ELSE IF @_type_ = 66				--Locale (Ref: EntityLocaleNameToId)
	BEGIN
		UPDATE #entityTable
		SET idFound = 1,
			entityID = cvLocaleId,
			fieldName  = 'localeId'
		FROM evLocales  (NOLOCK)
WHERE _type_ = 66 AND locale LIKE (SUBSTRING(entityName,1,2) + '-%') AND idFound = 0
		UPDATE #entityTable
		SET idFound = 1,
			entityID = cvLocaleId,
			fieldName  = 'localeId'
		FROM evLocales  (NOLOCK)
WHERE _type_ = 66 AND displayString = (originalXML.value('(/*/@country)[1]', 'NVARCHAR(32)') + '-' + originalXML.value('(/*/@language)[1]', 'NVARCHAR(32)')) AND idFound = 0
		UPDATE #entityTable
		SET idFound = 1,
			entityID = cvLocaleId,
			fieldName  = 'localeId'
		FROM evLocales  (NOLOCK)
WHERE _type_ = 66 AND displayString LIKE ('%' + originalXML.value('(/*/@language)[1]', 'NVARCHAR(32)')) AND idFound = 0
		UPDATE #entityTable
		SET idFound = 1,
			entityID = cvLocaleId,
			fieldName  = 'localeId'
		FROM evLocales  (NOLOCK)
WHERE _type_ = 66 AND displayString LIKE (originalXML.value('(/*/@country)[1]', 'NVARCHAR(32)') + '%') AND idFound = 0
	END
	--After all these processing still if IdFound = 0, then it is a wrong entity. So fill -32000 for id.
IF @_type_ <> 88
	BEGIN
		SET @dynamicSQLStmt = 'UPDATE #entityTable '+ CHAR(10) +
' SET entityId = ' + '-32000' + ',' + CHAR(10) +
								' fieldName = ''' + @entityIdINXML + '''' + CHAR(10) +
								'WHERE #entityTable._type_ = ' + CAST(@_type_ AS VARCHAR(10)) + ' AND idFound = 0 AND entityId IS NULL AND entityName IS NOT NULL AND entityName <> '''''
		EXEC (@dynamicSQLStmt)
		--Populate error message correspondingly.
		SELECT @invalidEntities += 'Invalid ' + @entityIdINXML + ' for ' + @entityNameInXML + '[' + ISNULL(entityName, '') + '].'
		FROM #entityTable
WHERE _type_ = @_type_ AND entityId in (-32000, -32001)
	END
	--Special handling for hierarchical entities. Convert the vertical format #entityTable to a horizontal #hierarchicalEntities.
	IF OBJECT_ID('tempdb.dbo.#hierarchicalEntities') IS NOT NULL
			DROP TABLE #hierarchicalEntities
	CREATE TABLE #hierarchicalEntities (_type_ INT, typeIndex INT, originalXML XML, parentTag VARCHAR(1024), parentName1 NVARCHAR(1024), parentName2 NVARCHAR(1024), parentName3 NVARCHAR(1024), parentName4 NVARCHAR(1024), parentName5 NVARCHAR(1024), parentName6 NVARCHAR(1024), parentId1 INT, parentId2 INT, parentId3 INT, parentId4 INT, parentId5 INT, parentId6 INT)
IF (@_type_ = 3) AND EXISTS (SELECT 1 FROM #entityTable WHERE _type_ = 4)			--iDA entities (Ref: EntityApplicationNameToId, EntitySubclientNameToId)
	BEGIN
		--Parent1 = Client, parent2 = AppType, parent3 = Instance, parent4 = Backupset, parent5 = Subclient
		--Insert all the ids whatever you get from XML. We need it for processing other entities.
		INSERT INTO #hierarchicalEntities (_type_,  typeIndex, originalXML, parentTag, parentName1, parentName2, parentName3, parentName4, parentName5, parentID1, parentId2, parentId3, parentId4, parentID5)
			SELECT Tbl1._type_, OuterTbl.typeIndex, OuterTbl.originalXML, OuterTbl.parentTag, OuterTbl.entityName, ISNULL((originalXML.value('(/*/@appName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@instanceName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@backupsetName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@subclientName)[1]', 'NVARCHAR(1024)')), N''), entityId, originalXML.value('(/*/@applicationId)[1]', 'INT'), originalXML.value('(/*/@instanceId)[1]', 'INT'), originalXML.value('(/*/@backupsetId)[1]', 'INT'), originalXML.value('(/*/@subclientId)[1]', 'INT')
FROM #entityTable OuterTbl INNER JOIN (SELECT typeIndex, MAX(_type_) AS _type_ FROM #entityTable WHERE _type_ IN (4, 5, 6, 7) GROUP BY typeIndex) Tbl1
ON OuterTbl.typeIndex = Tbl1.typeIndex AND OuterTbl._type_ = 3
AND EXISTS (SELECT 1 FROM #entityTable WHERE typeIndex = OuterTbl.typeIndex AND _type_ = 4)			--There are some XMLs that have only CLIENT_ENTITY, BACKUPSET_ENTITY without APPTYPE_ENTITY
		UPDATE #hierarchicalEntities
		SET parentName2 = 'DB2 MultiNode'
		WHERE
			parentName2 = 'DB2 DPF'
		UPDATE #hierarchicalEntities
		SET parentName2 = 'NAS'
		WHERE
			(parentName2 = 'Hitachi NAS')
			OR(parentName2 like '%NAS NDMP')
		-- NAS agent renamed to NDMP, must handle both names for backward compatibility. APP_iDAType table has NDMP for the name
		-- The value put into parentName2 should match the value populated in APP_iDAType.script
		-- APPTYPE(4):   When getting agent properties for a client. Parent1 is the client, parent2 is the agent
		-- BACKUPSET(6): When kicking off a restore. Parent1 is the client, parent2 is the agent, parent3 is the instance, parent4 is the backupset
		-- SUBCLIENT(7): When operating on a subclient. Parent1 is the client, parent2 is the agent, parent5 is the subclient
UPDATE #hierarchicalEntities SET parentName2 = 'NDMP' WHERE _type_ in (4, 6, 7) AND parentName2 = 'NAS'
		UPDATE #hierarchicalEntities
		SET parentId2 = ISNULL(ISNULL(ISNULL((SELECT TOP 1 I.type FROM APP_Application A (NOLOCK) INNER JOIN APP_idaType I (NOLOCK) ON A.appTypeID = I.type AND A.clientID = #hierarchicalEntities.parentID1 AND I.name = #hierarchicalEntities.parentName2),
										(SELECT TOP 1 T.type FROM App_IdaName A (NOLOCK) INNER JOIN App_IdaType T (NOLOCK) ON A.appTypeId = T.type AND A.clientID = #hierarchicalEntities.parentID1 AND T.displayName = #hierarchicalEntities.parentName2)),
(SELECT TOP 1 type FROM APP_idaType (NOLOCK) WHERE displayName = #hierarchicalEntities.parentName2)), -32000)
		WHERE parentName2 <> N''
		UPDATE #hierarchicalEntities
		SET parentName3 = dbo.DecodeInvalidXMLChar(parentName3)
		WHERE parentName3 <> N''
		UPDATE #hierarchicalEntities
		SET parentName4 = dbo.DecodeInvalidXMLChar(parentName4)
		WHERE parentName4 <> N''
		UPDATE #hierarchicalEntities
		SET parentName5 = dbo.DecodeInvalidXMLChar(parentName5)
		WHERE parentName5 <> N''
		UPDATE #hierarchicalEntities
		SET parentName3 = REPLACE(REPLACE(REPLACE(REPLACE(parentName3, '%', '^%'), '_', '^_'), ']', '^]'), '[', '^[')
		WHERE parentName3 <> N''
		UPDATE #hierarchicalEntities
SET parentID3 = ISNULL((SELECT TOP 1 I.id FROM APP_Application A (NOLOCK) INNER JOIN APP_InstanceName I (NOLOCK) ON A.instance = I.id AND A.clientID = #hierarchicalEntities.parentID1 AND A.appTypeId = #hierarchicalEntities.parentID2 AND (I.name = #hierarchicalEntities.parentName3 OR I.name LIKE #hierarchicalEntities.parentName3 ESCAPE N'^' OR I.name LIKE #hierarchicalEntities.parentName3 + CAST(0x12 AS NVARCHAR) + '%' ESCAPE N'^')), -32000)
		WHERE parentName3 <> N''
		UPDATE #hierarchicalEntities
SET parentID3 = ISNULL((SELECT TOP 1 instance FROM APP_Application WHERE ((clientId = parentId1 AND appTypeId = parentId2) OR (parentId5 > 0 AND id = parentId5))), -32000)
		WHERE (
				(parentId3 IS NULL OR parentId3 = 0)
				AND
				(
					(parentName4 IS NOT NULL AND parentName4 <> '') OR (parentId4 IS NOT NULL AND parentId4 > 0) OR
					(parentName5 IS NOT NULL AND parentName5 <> '') OR (parentId5 IS NOT NULL AND parentId5 > 0)
				)
			)										--#252-255 of EntitySubclientNameToId.sp. Check specifically for a valid id / name of backupset / subclient instead of just checking if type is greater than instance.
		UPDATE #hierarchicalEntities
SET parentId4 = ISNULL((SELECT TOP 1 B.id FROM APP_Application A (NOLOCK) INNER JOIN APP_BackupsetName B (NOLOCK) ON A.backupSet = B.id AND A.clientId = #hierarchicalEntities.parentId1 AND A.appTypeId = #hierarchicalEntities.parentId2 AND A.instance = #hierarchicalEntities.parentId3 AND B.name = #hierarchicalEntities.parentName4), -32000)
		WHERE parentName4 <> N''
		--If subclient is given and backupset is not given, then get the first backupset of that instance.
		UPDATE #hierarchicalEntities
SET parentID4 = ISNULL((SELECT TOP 1 A.backupset FROM APP_Application A (NOLOCK) INNER JOIN APP_BackupsetName B (NOLOCK) ON A.backupSet = B.id AND (B.status& 0x00008<>0) WHERE A.clientID = #hierarchicalEntities.parentID1 AND A.appTypeID = #hierarchicalEntities.parentID2 AND A.instance = #hierarchicalEntities.parentId3), -32000)
		WHERE parentName4 = '' AND parentId3 IS NOT NULL AND parentName5 <> N''		-- #317 of EntitySubclientNameToId.sp
		-- If above query fail for some reason, try it old way to get just top 1
		UPDATE #hierarchicalEntities
SET parentID4 = ISNULL((SELECT TOP 1 A.backupset FROM APP_Application A (NOLOCK) WHERE A.clientID = #hierarchicalEntities.parentID1 AND A.appTypeID = #hierarchicalEntities.parentID2 AND A.instance = #hierarchicalEntities.parentId3), -32000)
WHERE parentName4 = '' AND parentId3 IS NOT NULL AND parentName5 <> N''	AND parentID4=-32000	-- #317 of EntitySubclientNameToId.sp
		UPDATE #hierarchicalEntities
SET parentID5 = ISNULL((SELECT TOP 1 A.id FROM APP_Application A (NOLOCK) WHERE A.clientID = #hierarchicalEntities.parentID1 AND A.appTypeId = #hierarchicalEntities.parentId2 AND A.instance = #hierarchicalEntities.parentId3 AND A.backupSet = #hierarchicalEntities.parentId4 AND A.subclientName = #hierarchicalEntities.parentName5), -32000)
		WHERE parentName5 <> N''
		--Populate #entityTable with values obtained from #hierarchicalEntities.
		UPDATE #entityTable
SET idFound = CASE WHEN Temp.parentID2 <> -32000 THEN 1 ELSE 0 END,
			entityId = Temp.parentID2,
			entityName = Temp.parentName2,
			fieldName = 'applicationId'
		FROM #hierarchicalEntities Temp
WHERE #entityTable._type_ = 4 AND #entityTable.typeIndex = Temp.typeIndex 			--AppType will be there for sure in that typeIndex. So just fill id or -32000.
		--If instance is present in that typeIndex, then update the id. Else insert instance row there.
		MERGE #entityTable AS Target
USING (SELECT typeIndex, originalXML, parentTag, parentId3, parentName3 FROM #hierarchicalEntities WHERE _type_ >= 5) AS Source
ON Target._type_ = 5  AND Source.typeIndex = Target.typeIndex
		WHEN MATCHED THEN
			UPDATE SET idFound = CASE WHEN Source.parentId3 <> - 32000 THEN 1 ELSE 0 END,
					   entityId = Source.parentId3,
					   entityName = Source.parentName3,
					   fieldname = 'instanceId'
		WHEN NOT MATCHED THEN
			INSERT
VALUES(5, Source.typeIndex, Source.originalXML, Source.parentTag, N'', Source.parentID3, CASE WHEN Source.parentID3 IS NOT NULL THEN 1 ELSE 0 END, 'instanceId', 0);
		--If backupset is present in that typeIndex, then update the id. Else insert backupset row there.
		MERGE #entityTable AS Target
USING (SELECT typeIndex, originalXML, parentTag, parentId4, parentName4 FROM #hierarchicalEntities WHERE _type_ >= 6) AS Source
ON Target._type_ = 6 AND Source.typeIndex = Target.typeIndex
		WHEN MATCHED THEN
UPDATE SET idFound = CASE WHEN Source.parentId4 <> -32000 THEN 1 ELSE 0 END,
					   entityId = Source.parentId4,
					   entityName = Source.parentName4,
					   fieldname = 'backupsetId'
		WHEN NOT MATCHED THEN
			INSERT
VALUES(6, Source.typeIndex, Source.originalXML, Source.parentTag, N'', Source.parentID4, CASE WHEN Source.parentID4 IS NOT NULL THEN 1 ELSE 0 END, 'backupsetId', 0);
		UPDATE #entityTable
SET idFound = CASE WHEN Temp.parentId5 <> -32000 THEN 1 ELSE 0 END,
			entityId = Temp.parentId5,
			entityName = Temp.parentName5,
			fieldName = 'subclientId'
		FROM #hierarchicalEntities Temp
WHERE #entityTable._type_ = 7 AND #entityTable.typeIndex = Temp.typeIndex
SELECT @invalidEntities += 'Invalid ' + fieldName + ' for ' + CASE WHEN _type_ = 4 THEN 'appName' WHEN _type_ = 5 THEN 'instanceName' WHEN _type_ = 6 THEN 'backupsetName' ELSE 'subclientName' END + '[' + ISNULL(entityName, '') + '].'
		FROM #entityTable
WHERE _type_ IN (4, 5, 6, 7) AND entityID = -32000
	END
ELSE IF (@_type_ = 9) AND EXISTS (SELECT 1 FROM #entityTable WHERE _type_ IN (47, 51, 67, 48))			--library entities (Ref: EntityLibraryNameToId)
	BEGIN
		--parent1 = library, parent2 = drivePool, parent3 = drive, parent4 = spareMediaGroup, parent5 = scratchPool, parent6 = masterPool
		INSERT INTO #hierarchicalEntities (typeIndex, originalXML, parentTag, parentName1, parentName2, parentName3, parentName4, parentName5, parentName6, parentID1)
			SELECT OuterTbl.typeIndex, originalXML, parentTag, ISNULL((originalXML.value('(/*/@libraryName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@drivePoolName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@driveName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@spareMediaGroupName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@scratchPoolName)[1]', 'NVARCHAR(1024)')), N''), ISNULL((originalXML.value('(/*/@masterPoolName)[1]', 'NVARCHAR(1024)')), N''), outerTbl.entityId
FROM #entityTable OuterTbl INNER JOIN (SELECT DISTINCT typeIndex FROM #entityTable WHERE _type_ IN (47, 51, 67, 48)) Tbl1
ON OuterTbl.typeIndex = Tbl1.typeIndex AND OuterTbl._type_ = 9
		IF @createStoragePolicyCopyReqMA = N''
			UPDATE #hierarchicalEntities
SET parentId2 = ISNULL((SELECT drivepoolid FROM MMDrivePool(NOLOCK) WHERE drivePoolName = parentName2 AND MasterPoolId IN (SELECT MasterPoolID FROM MMMasterPool WHERE libraryId = #hierarchicalEntities.parentId1)), -32000)
			WHERE parentName2 <> N''
		ELSE
			UPDATE #hierarchicalEntities
SET parentId2 = ISNULL((SELECT drivepoolid FROM MMDrivePool(NOLOCK) DP INNER JOIN APP_Client C (NOLOCK) ON DP.clientId = C.id WHERE C.name = @createStoragePolicyCopyReqMA AND DP.drivePoolName = parentName2 AND MasterPoolId IN (SELECT MasterPoolID FROM MMMasterPool WHERE libraryId = #hierarchicalEntities.parentId1)), -32000)
			WHERE parentName2 <> N''
		UPDATE #hierarchicalEntities
		SET parentId3 = ISNULL((SELECT A.driveID FROM MMDriveController A (NOLOCK) WHERE A.driveID = (SELECT driveID FROM MMDrive (NOLOCK) WHERE aliasName = #hierarchicalEntities.parentName3 AND MasterPoolId IN (SELECT masterPoolId FROM MMMasterPool(NOLOCK) WHERE libraryId = #hierarchicalEntities.parentID1))
AND A.DrivePoolId = #hierarchicalEntities.parentID2), -32000)
		WHERE parentName3 <> N'' AND parentId2 IS NOT NULL
		UPDATE #hierarchicalEntities
		SET parentId3 = ISNULL((SELECT MMDrive.driveID FROM MMDrive(NOLOCK) WHERE AliasName = #hierarchicalEntities.parentName3
AND MasterPoolId IN (SELECT masterPoolId FROM MMMasterPool(NOLOCK) WHERE LibraryId = #hierarchicalEntities.parentID1)), -32000)
		WHERE parentName3 <> N'' AND parentId3 IS NULL
		UPDATE #hierarchicalEntities
SET parentId4 = ISNULL((SELECT spareGroupID FROM MMSpareGroup (NOLOCK) WHERE spareGroupName = parentName4 AND libraryId = #hierarchicalEntities.parentId1), -32000)
		WHERE parentName4 <> N''
		UPDATE #hierarchicalEntities
SET parentId5 = ISNULL((SELECT spareGroupID FROM MMSpareGroup (NOLOCK) WHERE spareGroupName = parentName5 AND libraryId = #hierarchicalEntities.parentId1), -32000)
		WHERE parentName5 <> N''
		UPDATE #hierarchicalEntities
SET parentID6 = ISNULL((SELECT masterPoolId FROM MMMasterPool(NOLOCK) WHERE masterPoolName = parentName6 AND libraryId = #hierarchicalEntities.parentId1), -32000)
		WHERE parentName6 <> N''
		--Populate #entityTable with values obtained from #hierarchicalEntities.
		UPDATE #entityTable
SET idFound = CASE WHEN parentId2 <> -32000 THEN 1 ELSE 0 END,
			entityId = parentId2,
			entityName = parentName2,
			fieldName = 'drivePoolId'
		FROM #hierarchicalEntities
WHERE #entityTable._type_ = 47 AND #entityTable.typeIndex = #hierarchicalEntities.typeIndex
		UPDATE #entityTable
SET idFound = CASE WHEN parentId3 <> -32000 THEN 1 ELSE 0 END,
			entityId = parentId3,
			entityName = parentName3,
			fieldName = 'driveId'
		FROM #hierarchicalEntities
WHERE #entityTable._type_ = 51  AND #entityTable.typeIndex = #hierarchicalEntities.typeIndex
		UPDATE #entityTable
SET idFound = CASE WHEN parentId4 <> -32000 THEN 1 ELSE 0 END,
			entityId = parentId4,
			entityName = parentName4,
			fieldName = 'spareMediaGroupId'
		FROM #hierarchicalEntities
WHERE #entityTable._type_ = 67 AND #entityTable.typeIndex = #hierarchicalEntities.typeIndex
		UPDATE #entityTable
SET idFound = CASE WHEN parentId5 <> -32000 THEN 1 ELSE 0 END,
			entityId = parentId5,
			entityName = parentName5,
			fieldName = 'scratchPoolId'
		FROM #hierarchicalEntities
WHERE #entityTable._type_ = 48 AND #entityTable.typeIndex = #hierarchicalEntities.typeIndex
		--Master pool is not an entity. But we need to populate the id if there is some level under library came. So just keeping a dummy _type_ here anyhow the correct _type_ will be filled in that row.
		INSERT INTO #entityTable (_type_, typeIndex, originalXML, parentTag, entityName, entityId, idFound, fieldName, isCustomEntity)
SELECT 47/*masterpool has no type. But it comes in conjunction with drivePool or drive hopefully*/, typeIndex, originalXML, parentTag, parentName6, parentId6, CASE WHEN parentId6 <> -32000 THEN 1 ELSE 0 END, 'masterPoolId', 0
			FROM #hierarchicalEntities
			WHERE parentName6 <> N''
SELECT @invalidEntities += 'Invalid ' + fieldName + ' for ' + CASE WHEN _type_ = 47 THEN 'drivePool' WHEN _type_ = 51 THEN 'drive' WHEN _type_ = 67 THEN 'spareMediaGroup' ELSE 'scratchPool' END + '[' + ISNULL(entityName, '') + '].'
		FROM #entityTable
WHERE _type_ IN (47, 51, 67, 48) AND entityId = -32000
	END
ELSE IF (@_type_ = 17) AND EXISTS (SELECT 1 FROM #entityTable WHERE _type_ = 18)			--storage policy (Ref: EntityStoragePolicyNameToId)
	BEGIN
		--parent1 = storage policy, parent2 = storage policy copy
		INSERT INTO #hierarchicalEntities (typeIndex, originalXML, parentName1, parentName2, parentId1)
			SELECT Tbl1.typeIndex, OuterTbl.originalXML, ISNULL(originalXML.value('(/*/@storagePolicyName)[1]', 'NVARCHAR(1024)'), N''), ISNULL(originalXML.value('(/*/@copyName)[1]', 'NVARCHAR(1024)'), N''), entityId
FROM #entityTable OuterTbl INNER JOIN (SELECT DISTINCT typeIndex FROM #entityTable WHERE _type_ = 18) Tbl1
ON OuterTbl.typeIndex = Tbl1.typeIndex AND OuterTbl._type_ = 17
		UPDATE #hierarchicalEntities
SET parentId2 = ISNULL((SELECT id FROM archGroupCopy (NOLOCK) WHERE name = #hierarchicalEntities.parentName2 AND archGroupID = #hierarchicalEntities.parentID1), -32000)
		WHERE parentName2 <> N''
		UPDATE #entityTable
SET idFound = CASE WHEN temp.parentID2 <> -32000 THEN 1 ELSE 0 END,
			entityId = temp.parentID2,
			entityName = temp.parentName2,
			fieldName = 'copyId'
		FROM #hierarchicalEntities temp
WHERE #entityTable._type_ = 18	AND	#entityTable.typeIndex = temp.typeIndex
		SELECT @invalidEntities += 'Invalid ' + fieldName + ' for ' + 'copyName' + '[' + ISNULL(entityName, '') + '].'
		FROM #entityTable
WHERE _type_ IN (18) AND entityId = -32000
	END
ELSE IF (@_type_ = 61) AND EXISTS (SELECT 1 FROM #entityTable WHERE _type_ = 62)			--external group (Ref: EntityProviderNameToId)
	BEGIN
		--parent1 = provider, parent2 = external group
		INSERT INTO #hierarchicalEntities (typeIndex, originalXML, parentName1, parentName2, parentId1)
			SELECT OuterTbl.typeIndex, originalXML, ISNULL(originalXML.value('(/*/@providerDomainName)[1]', 'NVARCHAR(1024)'), N''), ISNULL(originalXML.value('(/*/@externalGroupName)[1]', 'NVARCHAR(1024)'), N''), entityId
FROM #entityTable OuterTbl INNER JOIN (SELECT DISTINCT typeIndex FROM #entityTable WHERE _type_ = 62) Tbl1
ON OuterTbl.typeIndex = Tbl1.typeIndex AND OuterTbl._type_ = 61
		UPDATE #hierarchicalEntities
SET parentId2 = ISNULL((SELECT id FROM UMGroups (NOLOCK) WHERE umdsProviderId = #hierarchicalEntities.parentId1 AND name = #hierarchicalEntities.parentName2), -32000)
		WHERE parentName2 <> N''
		UPDATE #entityTable
SET idFound = CASE WHEN temp.parentID2 <> -32000 THEN 1 ELSE 0 END,
			entityId = temp.parentID2,
			entityName = temp.parentName2,
			fieldName = 'groupId'
		FROM #hierarchicalEntities temp
WHERE #entityTable._type_ = 62 AND #entityTable.typeIndex = temp.typeIndex
		SELECT @invalidEntities += 'Invalid ' + fieldName + ' for ' + 'groupName' + '[' + ISNULL(entityName, '') + '].'
		FROM #entityTable
WHERE _type_ IN (62) AND entityId = -32000
	END
ELSE IF (@_type_ = 69) AND EXISTS (SELECT 1 FROM #entityTable WHERE _type_ = 68)			--task (Ref: EntityTaskSubTaskNameToId)
	BEGIN
		--parent1 = task, parent2 = subtask
		--If subtask comes alone, we need to handle it separately. It is done outside this loop.
		INSERT INTO #hierarchicalEntities (typeIndex, originalXML, parentName1, parentName2, parentId1)
			SELECT OuterTbl.typeIndex, originalXML, ISNULL(originalXML.value('(/*/@taskName)[1]', 'NVARCHAR(1024)'), N''), ISNULL(originalXML.value('(/*/@subtaskName)[1]', 'NVARCHAR(1024)'), N''), entityId
FROM #entityTable OuterTbl INNER JOIN (SELECT DISTINCT typeIndex FROM #entityTable WHERE _type_ = 68) Tbl1
ON OuterTbl.typeIndex = Tbl1.typeIndex AND OuterTbl._type_ = 69
		UPDATE #hierarchicalEntities
SET parentId2 = ISNULL((SELECT subTaskid FROM TM_SubTask (NOLOCK) WHERE taskId = #hierarchicalEntities.parentId1 AND subTaskName = #hierarchicalEntities.parentName2), -32000)
		WHERE parentName2 <> N''
		UPDATE #entityTable
SET idFound = CASE WHEN temp.parentId2 <> -32000 THEN 1 ELSE 0 END,
			entityId = temp.parentID2,
			entityName = temp.parentName2,
			fieldName = 'subtaskId'
		FROM #hierarchicalEntities temp
WHERE #entityTable._type_ = 68 AND #entityTable.typeIndex = temp.typeIndex
		IF @isTaskReq = 1			--DO not fill error in this case.
UPDATE #entityTable SET entityID = NULL WHERE _type_ = 68 AND entityID = -32000
		ELSE
			SELECT @invalidEntities += 'Invalid ' + fieldName + ' for ' + 'subTaskName' + '[' + ISNULL(entityName, '') + '].'
			FROM #entityTable
WHERE _type_ IN (68) AND entityID = -32000			--Not checking idFound = 0 because there may be few subtasks that are coming alone without task info. They are handled separately.
	END
ELSE IF (@_type_ = 122)			--permission entity (Ref: EntityCategoryPermissionNameToId)
	BEGIN
		--For those permissions that do not have categories we need to insert category Ids also.
		MERGE #entityTable AS Target
USING (SELECT typeIndex, originalXML, parentTag, entityId FROM #entityTable WHERE _type_ = 122) AS Source
ON Target._type_ = 121 AND Target.typeIndex = Source.typeIndex
		WHEN NOT MATCHED THEN
			INSERT (_type_, typeIndex, originalXML, parentTag, entityName, entityId, idFound, fieldName, isCustomEntity)
VALUES(121, Source.typeIndex, Source.originalXML, Source.parentTag, N'', (SELECT categoryID FROM UMPermissions (NOLOCK) WHERE id = Source.entityId), 1, 'categoryId', 0);
	END
ELSE IF (@_type_ = 55)
	BEGIN
		--For time zones, there may be fromTime, toTime, etc. existing. We need to fill them also. So let us insert another row with same details and _type_ as 54
		INSERT INTO #entityTable (_type_, typeIndex, originalXML, parentTag)
SELECT 54 , typeIndex, originalXML, parentTag
		FROM #entityTable
WHERE _type_ = 55 AND ((originalXML.value('(/*/@timeValue)[1]', 'VARCHAR(255)') IS NOT NULL) OR (originalXML.value('(/*/@fromTimeValue)[1]', 'VARCHAR(255)') IS NOT NULL) OR (originalXML.value('(/*/@toTimeValue)[1]', 'VARCHAR(255)') IS NOT NULL))
	END
	IF OBJECT_ID('tempdb.dbo.#hierarchicalEntities') IS NOT NULL
			DROP TABLE #hierarchicalEntities
	SET @i = @i + 1
END
--subtask entity special handling. When only subtask entity is there (without task entity), we need to get taskID and subtaskID from it. It is like getting parent from child. So cannot be handled in the main cursor.
IF EXISTS (SELECT 1 FROM #entityTable WHERE _type_ = 68) --(Ref: EntityTaskSubTaskNameToId)
BEGIN
	UPDATE #entityTable
	SET entityName = originalXML.value('(/*/@subtaskName)[1]', 'NVARCHAR(1024)')
WHERE _type_ = 68 AND entityID IS NULL
	UPDATE #entityTable
	SET idFound = 1,
		entityID = TM_SubTask.subtaskid,
		fieldName = 'subtaskId'
	FROM TM_SubTask (NOLOCK)
WHERE #entityTable.entityID IS NULL /*All subtasks coming with task entities will have ids filled, worst case at least -32000*/ AND #entityTable._type_ = 68 AND #entityTable.entityName = TM_SubTask.subTaskName
	AND TM_SubTask.taskId IN (SELECT taskID FROM TM_Task WHERE taskType <> 4)
	UPDATE #entityTable
SET entityID = -32000,
		fieldName = 'subtaskId'
WHERE _type_ = 68 AND idFound = 0 AND entityId IS NULL
	MERGE #entityTable AS Target
USING (SELECT typeIndex, originalXML, parentTag, entityId FROM #entityTable WHERE _type_ = 68) AS Source
ON Target.typeIndex = Source.typeIndex AND Target._type_ = 69
	WHEN NOT MATCHED THEN
		INSERT (_type_, typeIndex, originalXML, parentTag, entityName, entityId, idFound, fieldName, isCustomEntity)
VALUES (69, Source.typeIndex, Source.originalXML, Source.parentTag, N'', (SELECT taskId FROM TM_SubTask (NOLOCK) WHERE subTaskId = Source.entityID), 1, 'taskId', 0);
	IF @isTaskReq = 1
UPDATE #entityTable SET entityID = NULL WHERE _type_ = 68 AND entityID = -32000
	ELSE
		SELECT @invalidEntities += 'Invalid ' + fieldName + ' for ' + 'subTaskName' + '[' + ISNULL(entityName, '') + '].'
		FROM #entityTable
WHERE _type_ IN (68) AND entityID = -32000
END
--The reason we took it outside the loop is because time entity does not belong to APP_Entity. Let the loop cater only to entities in App_Entity. Else we need to skip lots of places
--where we depend on App_Entity.
IF EXISTS (SELECT 1 FROM #entityTable WHERE _type_ = 54)			--Time (Ref: EntityTimeToId, EntityTimeToId1).
BEGIN
		DECLARE @globalTimeZoneID INT
		DECLARE @iCountTimeZoneID INT = @xmlInput.value('count(//@TimeZoneName)','nvarchar(MAX)')
		DECLARE @globalTimeZoneName NVARCHAR(MAX)				--Unicode time zone support
		IF @iCountTimeZoneID = 0 OR @iCountTimeZoneID IS NULL
			SET @globalTimeZoneID = (SELECT TimeZoneID FROM SchedTimeZone WHERE TimeZoneStdName = dbo.GetClientTimeZone(2))
		IF @iCountTimeZoneId = 1
		BEGIN
			SET @globalTimeZoneName = @xmlInput.value('(//*/@TimeZoneName)[1]','nvarchar(max)')
			SET @globalTimeZoneId = (SELECT TimeZoneID FROM SchedTimeZone WHERE (flags != 1) and ((TimeZoneName=@globalTimeZoneName) OR (TimeZoneStdName=@globalTimeZoneName)))
		END
		IF @globalTimeZoneID IS NOT NULL
			SET @globalTimeZoneName = (SELECT TimeZoneStdName FROM SchedTimeZone WHERE timezoneid = @globalTimeZoneID)
		IF OBJECT_ID('tempdb.dbo.#timeEntities_NameToIdConverter') IS NOT NULL
			DROP TABLE #timeEntities_NameToIdConverter
		CREATE TABLE #timeEntities_NameToIdConverter (_type_ INT, typeIndex INT, originalXML XML, parentTag VARCHAR(255), timeStr VARCHAR(255), fromTimeStr VARCHAR(255), toTimeStr VARCHAR(255), timeZoneName NVARCHAR(MAX), timeId INT, fromTimeId INT, toTimeId INT, timeZoneID INT)
		INSERT INTO #timeEntities_NameToIdConverter (_type_, typeIndex, originalXML, parentTag, timeStr, fromTimeStr, toTimeStr)
			SELECT ISNULL(originalXML.value('(/*/@type)[1]', 'INT'), 0), typeIndex, originalXML, parentTag, ISNULL(originalXML.value('(/*/@timeValue)[1]', 'VARCHAR(100)'), ''), ISNULL(originalXML.value('(/*/@fromTimeValue)[1]', 'VARCHAR(100)'), ''), ISNULL(originalXML.value('(/*/@toTimeValue)[1]', 'VARCHAR(100)'), '')
			FROM #entityTable
WHERE _type_ = 54
		IF @globalTimeZoneID IS NOT NULL
			UPDATE #timeEntities_NameToIdConverter
			SET timeZoneName = @globalTimeZoneName
		ELSE IF @iCountTimeZoneID > 1
		BEGIN
			--According to old name to id converter, we should go one level above fromTimeValue, timeValue, toTimeValue and read time zones.
			UPDATE #timeEntities_NameToIdConverter
			SET timeZoneName = (@xmlInput.query('((//.[@_type_])[sql:column("typeIndex")])//..//*')).value('(//@TimeZoneName)[1]', 'nvarchar(max)')
			--We read only input time zone name. Let us have only those that actually are valid. Set NULL to remaining time zones else they will create issues in the C# function LocalToUTCTime
			UPDATE #timeEntities_NameToIdConverter
			SET timeZoneId = SchedTimeZone.TimeZoneID, timeZoneName = SchedTimeZone.TimeZoneStdName
			FROM SchedTImeZone
			WHERE SchedTimeZone.TimeZoneName = #timeEntities_NameToIdConverter.timeZoneName OR SchedTimeZone.TimeZoneStdName = #timeEntities_NameToIdConverter.timeZoneName
			AND flags != 1
			UPDATE #timeEntities_NameToIdConverter
			SET timeZoneName = NULL
			WHERE timeZoneId IS NULL
		END
		UPDATE #timeEntities_NameToIdConverter
		SET timeId = dbo.GetUnixTime(dbo.LocalToUTCTime(CAST(timeStr AS DATETIME), timeZoneName))
		WHERE timeStr <> N'' AND _type_ NOT IN (11, 12, 13, 14)					--Convert only absolute times.
		AND timeZoneName IS NOT NULL
		UPDATE #timeEntities_NameToIdConverter
		SET fromTimeId = dbo.GetUnixTime(dbo.LocalToUTCTime(CAST(fromTimeStr AS DATETIME), timeZoneName))
		WHERE fromTimeStr <> N'' AND _type_ NOT IN (11, 12, 13, 14)				--Convert only absolute times.
		AND timeZoneName IS NOT NULL
		UPDATE #timeEntities_NameToIdConverter
		SET toTimeId = dbo.GetUnixTime(dbo.LocalToUTCTime(CAST(toTimeStr AS DATETIME), timeZoneName))
		WHERE toTimeStr <> N'' AND _type_ NOT IN (11, 12, 13, 14)				--Convert only absolute times.
		AND timeZoneName IS NOT NULL
		UPDATE #timeEntities_NameToIdConverter
		SET timeId = CASE WHEN _type_ = 11 THEN CAST(timeStr AS INT) * 24 * 60 * 60			--RELATIVE_DAYS
							 WHEN _type_ = 12 THEN CAST(timeStr AS INT) * 7 * 24 * 60 * 60		--RELATIVE_WEEKS
							 WHEN _type_ = 13 THEN CAST(timeStr AS INT) * 60 * 60				--RELATIVE_HOURS
							 ELSE CAST (timeStr AS INT)											--RELATIVE
						END
		WHERE timeStr <> N'' AND _type_ IN (11, 12, 13, 14)				--Convert only relative times.
		UPDATE #timeEntities_NameToIdConverter
		SET fromTimeId = CASE WHEN _type_ = 11 THEN CAST(fromTimeStr AS INT) * 24 * 60 * 60			--RELATIVE_DAYS
							 WHEN _type_ = 12 THEN CAST(fromTimeStr AS INT) * 7 * 24 * 60 * 60		--RELATIVE_WEEKS
							 WHEN _type_ = 13 THEN CAST(fromTimeStr AS INT) * 60 * 60				--RELATIVE_HOURS
							 ELSE CAST (fromTimeStr AS INT)											--RELATIVE
						END
		WHERE fromTimeStr <> N'' AND _type_ IN (11, 12, 13, 14)				--Convert only relative times.
		UPDATE #timeEntities_NameToIdConverter
		SET toTimeId = CASE WHEN _type_ = 11 THEN CAST(toTimeStr AS INT) * 24 * 60 * 60			--RELATIVE_DAYS
							 WHEN _type_ = 12 THEN CAST(toTimeStr AS INT) * 7 * 24 * 60 * 60		--RELATIVE_WEEKS
							 WHEN _type_ = 13 THEN CAST(toTimeStr AS INT) * 60 * 60				--RELATIVE_HOURS
							 ELSE CAST (toTimeStr AS INT)											--RELATIVE
						END
		WHERE toTimeStr <> N'' AND _type_ IN (11, 12, 13, 14)				--Convert only relative times.
		--Before updating check whether timeStr is present in that typeIndex. If so then take timeId as 'time'
		UPDATE #entityTable
		SET idFound = 1,
			entityId = timeId,
			fieldName = 'time'
		FROM #timeEntities_NameToIdConverter
WHERE #entityTable._type_ = 54 AND #entityTable.typeIndex = #timeEntities_NameToIdConverter.typeIndex AND #timeEntities_NameToIdConverter.timeStr <> N''
		--Before updating check whether fromTimeStr is present in that typeIndex. If so then take fromTimeId as 'fromTime'
		UPDATE #entityTable
		SET idFound = 1,
			entityId = fromTimeId,
			fieldName = 'fromTime'
		FROM #timeEntities_NameToIdConverter
WHERE #entityTable._type_ = 54 AND #entityTable.typeIndex = #timeEntities_NameToIdConverter.typeIndex AND #timeEntities_NameToIdConverter.fromTimeStr <> N''
		--toTimeStr is toTime. There can be a row already existing with fromTime. In that case, insert a new row else update the existing row.
		MERGE #entityTable Target
		USING (SELECT typeIndex, originalXML, parentTag, toTimeId FROM #timeEntities_NameToIdConverter WHERE toTimeStr <> N'') Source
ON Target._type_ = 54 AND Target.typeIndex = Source.typeIndex AND Target.idFound = 0 --No row exists. So just update the existing value.
		WHEN MATCHED THEN
			UPDATE SET idFound = 1, entityId = toTimeId, fieldName = 'toTime'
		WHEN NOT MATCHED THEN			--definitely there is something in typeIndex. IdFound = 1. It must be fromTime. So let us insert a new row.
			INSERT (_type_, typeIndex, originalXML, parentTag, entityName, entityId, idFound, fieldName, isCustomEntity)
VALUES(54, Source.typeIndex, Source.originalXML, Source.parentTag, N'', Source.toTimeId, 1, 'toTime', 0);
END
--There are some .x messages that have only appName and not client. We need to fill them without bothering about client.
--Ref: EntityApplicationNameToId
IF EXISTS (SELECT 1 FROM #entityTable OuterTbl WHERE _type_ = 4 AND NOT EXISTS (SELECT 1 FROM #entityTable InnerTbl WHERE InnerTbl.typeIndex = OuterTbl.typeIndex AND InnerTbl._type_ = 3))
BEGIN
	UPDATE OuterTbl
	SET entityName =
CASE WHEN 'NAS' = originalXML.value('(/*/@appName)[1]', 'VARCHAR(1024)') THEN 'NDMP'
		ELSE originalXML.value('(/*/@appName)[1]', 'VARCHAR(1024)')
		END
	FROM #entityTable OuterTbl
WHERE _type_ = 4 AND NOT EXISTS (SELECT 1 FROM #entityTable InnerTbl WHERE InnerTbl.typeIndex = OuterTbl.typeIndex AND InnerTbl._type_ = 3)
	UPDATE OuterTbl
	SET idFound = 1,
		entityId = Type.type,
		fieldName = 'applicationId'
	FROM #entityTable OuterTbl INNER JOIN APP_IdaType Type
	ON OuterTbl.entityName = Type.name
WHERE _type_ = 4 AND NOT EXISTS (SELECT 1 FROM #entityTable InnerTbl WHERE InnerTbl.typeIndex = OuterTbl.typeIndex AND InnerTbl._type_ = 3)
	UPDATE #entityTable
SET entityID = -32000,
		fieldName = 'applicationId'
WHERE _type_ = 4 AND idFound = 0 AND entityName <> ''
	SELECT @invalidEntities += 'Invalid ' + fieldName + ' for ' + 'appName' + '[' + ISNULL(entityName, '') + '].'
	FROM #entityTable
WHERE _type_ IN (4) AND entityId = -32000
END
--Custom entities that came with an invalid _type_.
SELECT @invalidEntities += 'Invalid entity type Id for [' + ISNULL((originalXML.value('(/*/@entityTypeName)[1]', 'NVARCHAR(MAX)')), '') + '].'
FROM #entityTable
WHERE _type_ = -32000
--All done. Call C# API with the correct replacement XML.
DECLARE @replaceXML XML = (SELECT
								(SELECT '(//./@_type_)[' + CAST(typeIndex AS VARCHAR(10)) + ']' as '@xPathElem',
										 entityId AS '@xPathVal',
										 CASE WHEN isCustomEntity = 0 THEN fieldName ELSE 'entityId' END AS '@attrName'
								FOR XML PATH ('entity'), TYPE
								),
								(SELECT '(//./@_type_)[' + CAST(typeIndex AS VARCHAR(10)) + ']' as '@xPathElem',
CASE WHEN isCustomEntity = 0 THEN _type_ ELSE 150 END AS '@xPathVal',
										 '_type_' AS '@attrName'
								FOR XML PATH ('entity'), TYPE
								),
								CASE WHEN isCustomEntity <> 0 THEN
									(SELECT '(//./@_type_)[' + CAST(typeIndex AS VARCHAR(10)) + ']' as '@xPathElem',
											 _type_ AS '@xPathVal',
											 'entityType' AS '@attrName'
									FOR XML PATH ('entity'), TYPE
									)
								END
							FROM #entityTable
							ORDER BY typeIndex, _type_
					  FOR XML PATH (''), TYPE, ROOT ('CustomReplacer'))
DECLARE @replaceString NVARCHAR(MAX) = CAST(@replaceXML AS NVARCHAR(MAX))
DECLARE @inputXMLString NVARCHAR(MAX) = CAST(@xmlInput AS NVARCHAR(MAX))
DECLARE @retainError INT = 1
EXEC ReplaceXmlAttributesNew @inputXMLString OUTPUT, @replaceString, 0, @retainError OUTPUT
SET @xmlInput = CAST(@inputXMLString AS XML)
--Error processing.
IF @invalidEntities <> N'' AND @retainError = 1
BEGIN
	DECLARE @isPinfoSet BIT
	SET @isPinfoSet = @xmlInput.exist('//processinginstructioninfo')
	IF (@isPinfoSet = 0)
	BEGIN
		DECLARE @piInfo XML
		SET @piInfo = (SELECT @invalidEntities AS 'value',
							 'ENTITY_ERROR_MESSAGE' AS 'name'
					   FOR XML PATH ('attributes'), ROOT('processinginstructioninfo'))
		SET @xmlInput.modify('insert sql:variable("@piInfo") as first into (//./*)[1]')
	END
	ELSE			-- Some requests have processinginstructioninfo blob already filled in the XML. Those that come from REST API have it.
	BEGIN
		DECLARE @attributes XML = (SELECT @invalidEntities AS 'value',
										  'ENTITY_ERROR_MESSAGE' as'name'
								   FOR XML PATH ('attributes'))
		SET @xmlInput.modify('insert sql:variable("@attributes") as first into (//./processinginstructioninfo)[1]')
	END
END
IF @selectOutput = 1
	SELECT @xmlInput AS xmlOutput
IF OBJECT_ID('tempdb.dbo.#entityTable') IS NOT NULL
	DROP TABLE #entityTable
GO

IF EXISTS (select * from GxQscripts where name = 'EntityNameToIdConverterNew')
	delete from GxQscripts where name = 'EntityNameToIdConverterNew'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityNameToIdConverterNew')
	delete from GXDBVersions where aliasname = 'EntityNameToIdConverterNew'
GO

insert into GXDBVersions values(2, 'EntityNameToIdConverterNew',  '00000000000000000000', 'EntityNameToIdConverterNew', '00000000000000000000')
GO

