

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityNameToIdConverter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntityNameToIdConverter.sp,v $ $Id: EntityNameToIdConverter.sp,v 1.95.12.11 2019/03/19 23:16:17 snagendra Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntityNameToIdConverter()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0        					Initial Edit
--	|	1.01		Prasad Nara		Added ScratchPool Entity
--	| 	1.02	Ravneet Singh Arora	 EntityNameToIdConverter is broken into small procedures
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EntityNameToIdConverter')
BEGIN
	print '>>> Drop Stored Procedure: EntityNameToIdConverter <<<'
	drop procedure EntityNameToIdConverter
END
IF EXISTS (select * from GxQscripts where name='EntityNameToIdConverter')
	delete from GxQscripts where name = 'EntityNameToIdConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityNameToIdConverter')
	delete from GXDBVersions where aliasname = 'EntityNameToIdConverter'
GO
print '... Creating Procedure: EntityNameToIdConverter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityNameToIdConverter
  @var XML OUTPUT
AS
  DECLARE @output XML
DECLARE @optimizeEntityNameToIdConverter BIT = 1
SELECT @optimizeEntityNameToIdConverter = 0
FROM GxGlobalParam (NOLOCK)
WHERE
	name = 'OptimizeEntityNameToIdConverter' AND value = '0'
IF @optimizeEntityNameToIdConverter = 1
BEGIN
	EXEC EntityNameToIdConverterNew @var OUTPUT, 1		-- This SP needs to select output always.
	RETURN
END
DECLARE @clientNameVal			nvarchar(255)
DECLARE @displayNameVal			nvarchar(510)
DECLARE @appNameVal				nvarchar(255)
DECLARE @appGroupNameVal		nvarchar(255)
DECLARE @appTypeNameVal			nvarchar(255)
DECLARE @instanceNameVal		nvarchar(255)
DECLARE @backupSetNameVal		nvarchar(255)
DECLARE @subclientNameVal		nvarchar(255)
DECLARE @libraryNameVal 		nvarchar(255)
DECLARE @shelfNameVal	 		nvarchar(255)
DECLARE @mediaAgentNameVal		nvarchar(255)
DECLARE @userGroupNameVal		nvarchar(255)
DECLARE @storagePolicyNameVal	nvarchar(255)
DECLARE @storagePolicyCopyNameVal	nvarchar(255)
DECLARE @clientGroupNameVal		nvarchar(255)
DECLARE @mediaNameVal			nvarchar(255)
DECLARE @mountPathNameVal		nvarchar(255)
DECLARE @localeNameVal			nvarchar(32)
DECLARE @localeCountry			nvarchar(32)
DECLARE @localeLanguage			nvarchar(32)
DECLARE @taskNameVal			nvarchar(1024)
DECLARE @schedulePolicyName		nvarchar(1024)
DECLARE @subTaskNameVal			nvarchar(1024)
DECLARE @scPolicyNameVal		nvarchar(1024)
DECLARE @vmNameVal				nvarchar(255)
DECLARE @vmPolicyNameVal		nvarchar(255)
DECLARE @calendarNameVal		nvarchar(255)
DECLARE @snapShotEngineNameVal	nvarchar(255)
DECLARE @MMexportLocationVal	nvarchar(255)
DECLARE @alertNameVal			nvarchar(255)
DECLARE @timeZoneNameVal		nvarchar(255)
DECLARE @masterPoolNameVal		nvarchar(255)
DECLARE @drivePoolNameVal		nvarchar(255)
DECLARE @driveNameVal			nvarchar(255)
DECLARE @userNameVal			nvarchar(255)
DECLARE @providerNameVal		nvarchar(255)
DECLARE @externalGroupNameVal	nvarchar(255)
DECLARE @releaseStringVal		nvarchar(255)
DECLARE @licenseNameVal			nvarchar(255)
DECLARE @commcellNameVal		nvarchar(255)
DECLARE @csGUIDVal				nvarchar(255)
DECLARE @tempNameVal			nvarchar(255)
DECLARE @tempIdVal				nvarchar(255)
DECLARE @componentNameVal		nvarchar(255)
DECLARE @osTypeVal				nvarchar(255)
DECLARE @activityNameVal		nvarchar(255)
DECLARE @workflowNameVal		nvarchar(255)
DECLARE @schemaNamespaceVal		nvarchar(255)
DECLARE @schemaLocationUrlVal	nvarchar(255)
DECLARE @spareMediaGroupNameVal	nvarchar(255)
DECLARE @scratchPoolNameVal		nvarchar(255)
DECLARE @trackingNameVal		nvarchar(255)
DECLARE @syncWebFolderNameVal			nvarchar(255)
DECLARE @containerName		nvarchar(255)
DECLARE @tempId					int
DECLARE @clientId1				int
DECLARE @tempClnt				int
DECLARE @appId					int
DECLARE @appGroupId				int
DECLARE @appTypeId				int
DECLARE @instId					int
DECLARE @tempbkpSetId			int
DECLARE @tempsubclntId 			int
DECLARE @tempmasterPlId			int
DECLARE @templibId				int
DECLARE @tempshelfId			int
DECLARE @tempMediaId			int
DECLARE @tempMountPathId		int
DECLARE @tempSCPolicyId			int
DECLARE @tempTrackingPolicyId	int
DECLARE @syncWebFolderId		int
DECLARE @backupsetIdVal			int
DECLARE @instanceIdVal			int
DECLARE @applicationIdVal		int
DECLARE @appGroupIdVal			int
DECLARE @appTypeIdVal			int
DECLARE @subclientIdVal			int
DECLARE @storagePolicyIdVal		int
DECLARE @storagePolicyCopyIdVal int
DECLARE @masterPoolIdVal		int
DECLARE @libraryIdVal			int
DECLARE @shelfIdVal				int
DECLARE @drivePoolIdVal			int
DECLARE @driveIdVal				int
DECLARE @mediaIdVal				int
DECLARE @releaseIdVal			int
DECLARE @licenseIdVal			int
DECLARE @commCellIdVal			int
DECLARE @temp					XML
DECLARE @providerIdVal			int
DECLARE @groupIdVal				int
DECLARE @localeIdVal			int
DECLARE @taskIdVal				int
DECLARE @taskId					int
DECLARE @schedulePolicyId		int
DECLARE @subTaskIdVal			int
DECLARE @mountPathIdVal			int
DECLARE @scPolicyIdVal			int
DECLARE @trackingPolicyIdVal	int
DECLARE @activityIdVal			int
DECLARE @workflowIdVal			int
DECLARE @schemaIdVal			int
DECLARE @schemaLocationIdVal	int
DECLARE @tmpCCId				int
DECLARE @spareMediaGroupIdVal	int
DECLARE @scratchPoolIdVal		int
DECLARE @entityType				int
DECLARE @containerIdVal			int
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
DECLARE @ErrorMessage		NVARCHAR(4000)
DECLARE @ErrorSeverity		INT
DECLARE @ErrorState			INT
SET @ErrorSeverity =		0
SET @ErrorState	   =		0
SET @ErrorMessage  =		''
--MR 46550
DECLARE @iCountTimeZoneId		INT
DECLARE @globalTimeZoneId		INT
DECLARE @globalTimeZoneName		nvarchar(255)
DECLARE	@timeZoneId				int
DECLARE @utcDateTime			datetime
DECLARE @timeZoneStdName		nvarchar(255)
DECLARE	@time					int
DECLARE @timeStr				nvarchar(255)
DECLARE	@toTime					int
DECLARE @toTimeStr				nvarchar(255)
DECLARE	@fromTime				int
DECLARE @fromTimeStr			nvarchar(255)
DECLARE @type					int
DECLARE @lmMPName				nvarchar(1024)
DECLARE @lmMPId					int
DECLARE @customQueryName		nvarchar(1024)
DECLARE @customQueryId			int
DECLARE @sidbStoreName			nvarchar(512)
DECLARE @sidbStoreId			int
DECLARE	@roleName				nvarchar(1024)
DECLARE @roleId					int
DECLARE @categoryId				int
DECLARE @categoryName			nvarchar(max)
DECLARE @permissionId			int
DECLARE @permissionName			nvarchar(max)
DECLARE @customEntityTypeName	nvarchar(max)
DECLARE @customEntityName		nvarchar(max)
DECLARE @adminUserId int
DECLARE @adminUserFlags int = 0
set @adminUserFlags = 0x040
SET @adminUserId = (SELECT TOP 1 UMUsers.id FROM UMUsers WHERE ((UMUsers.flags & @adminUserFlags) <> 0) and enabled =1)
DECLARE	@userId					Integer = 0
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                         FROM    @var.nodes('//processinginstructioninfo/user') R ( ref )),0)
--Optimization of entity name to id converter sp
--We wont be replacing var in every entity*nametoidconverter sps.
--Instead we will push a combination of xpath - which is _type_[i], value - which is entity id/ entity type, attrname - which is entity id's name/entity type
--Replacing this into original val will be done at last
--CREATE TABLE #tempTableForReplacement
--(
--	xpath NVARCHAR(MAX),
--	value NVARCHAR(MAX),
--	attrName NVARCHAR(MAX)
--)
DECLARE @replaceVarLast		AS INT = 0
BEGIN TRY
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--MR 46450
if( (@var.exist('(//@timeValue)') != 0) OR
    (@var.exist('(//@fromTimeValue)')!=0) OR
    (@var.exist('(//@toTimeValue)') != 0)
    )
BEGIN
	SET @iCountTimeZoneId = @var.value('count(//@TimeZoneName)','nvarchar(255)')
	if (@iCountTimeZoneId = 0) or (@iCountTimeZoneId is NULL)
	BEGIN
		SET @globalTimeZoneId = (select TimeZoneID from SchedTimeZone where TimeZoneStdName = dbo.GetClientTimeZone(2))
	END
	if @iCountTimeZoneId = 1
	BEGIN
		SET @globalTimeZoneName = @var.value('(//*/@TimeZoneName)[1]','nvarchar(255)')
		SET @globalTimeZoneId = (select TimeZoneID from SchedTimeZone  where (flags != 1) and ((TimeZoneName=@globalTimeZoneName) OR (TimeZoneStdName=@globalTimeZoneName)))
	END
END
---ve number max INT is -32768,
--Flag to indicate - Set the filed value to -ve in case of invalid entities.
--when -ve all sp insert the negative value supplied in put_invalid_id, To disable the feature change the flag to 0
declare @put_invalid_id INT = -32000
DECLARE @iCount int
SET @iCount = @var.value('count(//.[@_type_])','int')
IF @iCount IS NULL
	SET @iCount = 0
DECLARE @i int
SET @i = 0
WHILE (@i < @iCount)
 BEGIN
 SET @i = @i + 1
 SET @entityType = 0
SET @temp=@var.query('(//.[@_type_])[sql:variable("@i")]')
set @type = @temp.value('(//./_type_)[1]','int')
 SET @clientNameVal=@temp.value('(//./@clientName)[1]','nvarchar(255)')
 IF SUBSTRING(@clientNameVal,1,1) = '|'
	SET @clientNameVal = ( select dbo.DecodeInvalidXMLChar(@clientNameVal) )
 SET @displayNameVal=@temp.value('(//./@displayName)[1]','nvarchar(510)')
 IF SUBSTRING(@displayNameVal,1,1) = '|'
	SET @displayNameVal = ( select dbo.DecodeInvalidXMLChar(@displayNameVal) )
 SET @tempClnt=@temp.value('(//./@clientId)[1]','int')
 SET @clientId1 = @tempClnt
 SET @appNameVal=@temp.value('(//./@appName)[1]','nvarchar(255)')
 IF SUBSTRING(@appNameVal,1,1) = '|'
	SET @appNameVal = ( select dbo.DecodeInvalidXMLChar(@appNameVal) )
 SET @appId=@temp.value('(//./@applicationId)[1]','int')
 SET @applicationIdVal=@appId
 SET @appGroupNameVal=@temp.value('(//./@appGroupName)[1]','nvarchar(255)')
 IF SUBSTRING(@appGroupNameVal,1,1) = '|'
	SET @appGroupNameVal = ( select dbo.DecodeInvalidXMLChar(@appGroupNameVal) )
 SET @appGroupId=@temp.value('(//./@appGroupId)[1]','int')
 SET @appGroupIdVal=@appGroupId
 SET @appTypeNameVal=@temp.value('(//./@appTypeName)[1]','nvarchar(255)')
 IF SUBSTRING(@appTypeNameVal,1,1) = '|'
	SET @appTypeNameVal = ( select dbo.DecodeInvalidXMLChar(@appTypeNameVal) )
 SET @appTypeId=@temp.value('(//./@appTypeId)[1]','int')
 SET @appTypeIdVal=@appTypeId
 SET @instanceNameVal=@temp.value('(//./@instanceName)[1]','nvarchar(255)')
  IF SUBSTRING(@instanceNameVal,1,1) = '|'
	SET @instanceNameVal = ( select dbo.DecodeInvalidXMLChar(@instanceNameVal) )
 SET @instId=@temp.value('(//./@instanceId)[1]','int')
 SET @instanceIdVal=@instId
 SET @backupSetNameVal=@temp.value('(//./@backupsetName)[1]','nvarchar(255)')
 IF SUBSTRING(@backupSetNameVal,1,1) = '|'
	SET @backupSetNameVal = ( select dbo.DecodeInvalidXMLChar(@backupSetNameVal) )
 SET @tempbkpSetId=@temp.value('(//./@backupsetId)[1]','int')
 SET @backupsetIdVal=@tempbkpSetId
 SET @subclientNameVal=@temp.value('(//./@subclientName)[1]','nvarchar(255)')
 IF SUBSTRING(@subclientNameVal,1,1) = '|'
	SET @subclientNameVal = ( select dbo.DecodeInvalidXMLChar(@subclientNameVal) )
 SET @tempsubclntId =@temp.value('(//./@subclientId)[1]','int')
 SET @subclientIdVal=@tempsubclntId
  SET @mediaNameVal=@temp.value('(//./@mediaName)[1]','nvarchar(255)')
  IF SUBSTRING(@mediaNameVal,1,1) = '|'
	SET @mediaNameVal = ( select dbo.DecodeInvalidXMLChar(@mediaNameVal) )
  SET @tempMediaId = @temp.value('(//./@mediaId)[1]','nvarchar(255)')
  SET @mediaIdVal = @tempMediaId
  SET @mountPathNameVal=@temp.value('(//./@mountPathName)[1]','nvarchar(255)')
  IF SUBSTRING(@mountPathNameVal,1,1) = '|'
	SET @mountPathNameVal = ( select dbo.DecodeInvalidXMLChar(@mountPathNameVal) )
  SET @tempMountPathId = @temp.value('(//./@mountPathId)[1]','nvarchar(255)')
  SET @mountPathIdVal = @tempMountPathId
 SET @libraryNameVal=@temp.value('(//./@libraryName)[1]','nvarchar(255)')
 IF SUBSTRING(@libraryNameVal,1,1) = '|'
	SET @libraryNameVal = ( select dbo.DecodeInvalidXMLChar(@libraryNameVal) )
 SET @templibId=@temp.value('(//./@libraryId)[1]','int')
 SET @spareMediaGroupNameVal=@temp.value('(//./@spareMediaGroupName)[1]','nvarchar(255)')
 IF SUBSTRING(@spareMediaGroupNameVal,1,1) = '|'
	SET @spareMediaGroupNameVal = ( select dbo.DecodeInvalidXMLChar(@spareMediaGroupNameVal) )
 SET @scratchPoolNameVal=@temp.value('(//./@scratchPoolName)[1]','nvarchar(255)')
 IF SUBSTRING(@scratchPoolNameVal,1,1) = '|'
	SET @scratchPoolNameVal = ( select dbo.DecodeInvalidXMLChar(@scratchPoolNameVal) )
 SET @shelfNameVal=@temp.value('(//./@shelfName)[1]','nvarchar(255)')
 IF SUBSTRING(@shelfNameVal,1,1) = '|'
	SET @shelfNameVal = ( select dbo.DecodeInvalidXMLChar(@shelfNameVal) )
 SET @tempshelfId=@temp.value('(//./@shelfId)[1]','int')
 SET @mediaAgentNameVal=@temp.value('(//./@mediaAgentName)[1]','nvarchar(255)')
 IF SUBSTRING(@mediaAgentNameVal,1,1) = '|'
	SET @mediaAgentNameVal = ( select dbo.DecodeInvalidXMLChar(@mediaAgentNameVal) )
 SET @userNameVal=@temp.value('(//./@userName)[1]','nvarchar(255)')
 IF SUBSTRING(@userNameVal,1,1) = '|'
	SET @userNameVal = ( select dbo.DecodeInvalidXMLChar(@userNameVal) )
 SET @userGroupNameVal=@temp.value('(//./@userGroupName)[1]','nvarchar(255)')
 IF SUBSTRING(@userGroupNameVal,1,1) = '|'
	SET @userGroupNameVal = ( select dbo.DecodeInvalidXMLChar(@userGroupNameVal) )
 SET @storagePolicyNameVal=@temp.value('(//./@storagePolicyName)[1]','nvarchar(255)')
 IF SUBSTRING(@storagePolicyNameVal,1,1) = '|'
	SET @storagePolicyNameVal = ( select dbo.DecodeInvalidXMLChar(@storagePolicyNameVal) )
 SET @storagePolicyCopyNameVal=@temp.value('(//./@copyName)[1]','nvarchar(255)')
 IF SUBSTRING(@storagePolicyCopyNameVal,1,1) = '|'
	SET @storagePolicyCopyNameVal = ( select dbo.DecodeInvalidXMLChar(@storagePolicyCopyNameVal) )
 SET @providerNameVal=@temp.value('(//./@providerDomainName)[1]','nvarchar(255)')
 IF SUBSTRING(@providerNameVal,1,1) = '|'
	SET @providerNameVal = ( select dbo.DecodeInvalidXMLChar(@providerNameVal) )
 SET @externalGroupNameVal=@temp.value('(//./@externalGroupName)[1]','nvarchar(255)')
 IF SUBSTRING(@externalGroupNameVal,1,1) = '|'
	SET @externalGroupNameVal = ( select dbo.DecodeInvalidXMLChar(@externalGroupNameVal) )
 SET @clientGroupNameVal=@temp.value('(//./@clientGroupName)[1]','nvarchar(255)')
 IF SUBSTRING(@externalGroupNameVal,1,1) = '|'
	SET @clientGroupNameVal= ( select dbo.DecodeInvalidXMLChar(@clientGroupNameVal) )
 SET @calendarNameVal=@temp.value('(//./@calendarName)[1]','nvarchar(255)')
 IF SUBSTRING(@calendarNameVal,1,1) = '|'
	SET @calendarNameVal= ( select dbo.DecodeInvalidXMLChar(@calendarNameVal) )
 SET @snapShotEngineNameVal=@temp.value('(//./@snapShotEngineName)[1]','nvarchar(255)')
 IF SUBSTRING(@snapShotEngineNameVal,1,1) = '|'
	SET @snapShotEngineNameVal= ( select dbo.DecodeInvalidXMLChar(@snapShotEngineNameVal) )
 SET @MMexportLocationVal=@temp.value('(//./@locationName)[1]','nvarchar(255)')
 IF SUBSTRING(@MMexportLocationVal,1,1) = '|'
	SET @MMexportLocationVal= ( select dbo.DecodeInvalidXMLChar(@MMexportLocationVal) )
 SET @alertNameVal=@temp.value('(//./@alertName)[1]','nvarchar(255)')
 IF SUBSTRING(@alertNameVal,1,1) = '|'
	SET @alertNameVal= ( select dbo.DecodeInvalidXMLChar(@alertNameVal) )
 SET  @timeZoneNameVal=@temp.value('(//./@TimeZoneName)[1]','nvarchar(255)')
 IF SUBSTRING(@timeZoneNameVal,1,1) = '|'
	SET @timeZoneNameVal= ( select dbo.DecodeInvalidXMLChar(@timeZoneNameVal) )
 SET  @masterPoolNameVal=@temp.value('(//./@masterPoolName)[1]','nvarchar(255)')
 IF SUBSTRING(@masterPoolNameVal,1,1) = '|'
	SET @masterPoolNameVal= ( select dbo.DecodeInvalidXMLChar(@masterPoolNameVal) )
 SET @tempmasterPlId=@temp.value('(//./@masterPoolId)[1]','int')
 SET @drivePoolNameVal=@temp.value('(//./@drivePoolName)[1]','nvarchar(255)')
 IF SUBSTRING(@drivePoolNameVal,1,1) = '|'
	SET @drivePoolNameVal= ( select dbo.DecodeInvalidXMLChar(@drivePoolNameVal) )
SET @driveNameVal=@temp.value('(//./@driveName)[1]','nvarchar(255)')
 IF SUBSTRING(@driveNameVal,1,1) = '|'
	SET @driveNameVal= ( select dbo.DecodeInvalidXMLChar(@driveNameVal) )
 SET @releaseStringVal=@temp.value('(//./@ReleaseString)[1]','nvarchar(255)')
 IF SUBSTRING(@releaseStringVal,1,1) = '|'
	SET @releaseStringVal= ( select dbo.DecodeInvalidXMLChar(@releaseStringVal) )
 SET @licenseNameVal=@temp.value('(//./@LicenseName)[1]','nvarchar(255)')
 IF SUBSTRING(@licenseNameVal,1,1) = '|'
	SET @licenseNameVal= ( select dbo.DecodeInvalidXMLChar(@licenseNameVal) )
 SET @componentNameVal=@temp.value('(//./@ComponentName)[1]','nvarchar(255)')
 IF SUBSTRING(@componentNameVal,1,1) = '|'
	SET @componentNameVal= ( select dbo.DecodeInvalidXMLChar(@componentNameVal) )
 SET @commcellNameVal=@temp.value('(//./@commCellName)[1]','nvarchar(255)')
 IF SUBSTRING(@commcellNameVal,1,1) = '|'
	SET @commcellNameVal= ( select dbo.DecodeInvalidXMLChar(@commcellNameVal) )
 SET @localeNameVal=@temp.value('(//./@localeName)[1]','nvarchar(32)')
 IF SUBSTRING(@localeNameVal,1,1) = '|'
	SET @localeNameVal= ( select dbo.DecodeInvalidXMLChar(@localeNameVal) )
 SET @localeCountry =@temp.value('(//./@country)[1]','nvarchar(32)')
 IF SUBSTRING(@localeCountry,1,1) = '|'
	SET @localeNameVal= ( select dbo.DecodeInvalidXMLChar(@localeCountry) )
SET @localeLanguage=@temp.value('(//./@language)[1]','nvarchar(32)')
 IF SUBSTRING(@localeLanguage,1,1) = '|'
	SET @localeLanguage= ( select dbo.DecodeInvalidXMLChar(@localeLanguage) )
 SET @taskNameVal=@temp.value('(//./@taskName)[1]','nvarchar(1024)')
 IF SUBSTRING(@taskNameVal,1,1) = '|'
	SET @taskNameVal= ( select dbo.DecodeInvalidXMLChar(@taskNameVal) )
 SET @schedulePolicyName=@temp.value('(//./@schedulePolicyName)[1]','nvarchar(1024)')
 IF SUBSTRING(@schedulePolicyName,1,1) = '|'
	SET @schedulePolicyName= ( select dbo.DecodeInvalidXMLChar(@schedulePolicyName))
 SET @subTaskNameVal=@temp.value('(//./@subtaskName)[1]','nvarchar(1024)')
 IF SUBSTRING(@subTaskNameVal,1,1) = '|'
	SET @subTaskNameVal= ( select dbo.DecodeInvalidXMLChar(@subTaskNameVal))
 SET @scPolicyNameVal=@temp.value('(//./@subclientPolicyName)[1]','nvarchar(255)')
 IF SUBSTRING(@scPolicyNameVal,1,1) = '|'
	SET @scPolicyNameVal = ( select dbo.DecodeInvalidXMLChar(@scPolicyNameVal) )
 SET @activityNameVal=@temp.value('(//./@activityName)[1]','nvarchar(255)')
 IF SUBSTRING(@activityNameVal,1,1) = '|'
	SET @activityNameVal= ( select dbo.DecodeInvalidXMLChar(@activityNameVal) )
 SET @workflowNameVal=@temp.value('(//./@workflowName)[1]','nvarchar(255)')
 IF SUBSTRING(@workflowNameVal,1,1) = '|'
	SET @workflowNameVal= ( select dbo.DecodeInvalidXMLChar(@workflowNameVal) )
 SET @schemaNamespaceVal=@temp.value('(//./@schemaNamespace)[1]','nvarchar(255)')
 IF SUBSTRING(@schemaNamespaceVal,1,1) = '|'
	SET @schemaNamespaceVal= ( select dbo.DecodeInvalidXMLChar(@schemaNamespaceVal) )
 SET @schemaLocationUrlVal=@temp.value('(//./@schemaLocationUrl)[1]','nvarchar(255)')
 IF SUBSTRING(@schemaLocationUrlVal,1,1) = '|'
	SET @schemaLocationUrlVal= ( select dbo.DecodeInvalidXMLChar(@schemaLocationUrlVal) )
 SET @tempSCPolicyId=@temp.value('(//./@subclientPolicyId)[1]','int')
 SET @scPolicyIdVal=@tempSCPolicyId
 SET @taskId = @temp.value('(//./@taskId)[1]','int')
 SET @schedulePolicyId = @temp.value('(//./@schedulePolicyId)[1]','int')
 SET @csGUIDVal=@temp.value('(//./@csGUID)[1]','nvarchar(255)')
 SET @vmNameVal=@temp.value('(//./@vmName)[1]','nvarchar(255)')
 IF SUBSTRING(@vmNameVal,1,1) = '|'
	SET @vmNameVal= ( select dbo.DecodeInvalidXMLChar(@vmNameVal) )
 SET @vmPolicyNameVal=@temp.value('(//./@vmAllocPolicyName)[1]','nvarchar(255)')
 IF SUBSTRING(@vmPolicyNameVal,1,1) = '|'
	SET @vmPolicyNameVal= ( select dbo.DecodeInvalidXMLChar(@vmPolicyNameVal) )
 SET @trackingNameVal=@temp.value('(//./@trackingPolicyName)[1]','nvarchar(255)')
 IF SUBSTRING(@trackingNameVal,1,1) = '|'
	SET @trackingNameVal = ( select dbo.DecodeInvalidXMLChar(@trackingNameVal) )
 SET @tempTrackingPolicyId = @temp.value('(//./@trackingPolicyId)[1]','int')
 SET @trackingPolicyIdVal=@tempTrackingPolicyId
 SET @syncWebFolderNameVal=@temp.value('(//./@syncWebFolderName)[1]','nvarchar(255)')
 IF SUBSTRING(@syncWebFolderNameVal,1,1) = '|'
	SET @syncWebFolderNameVal = ( select dbo.DecodeInvalidXMLChar(@syncWebFolderNameVal) )
 --MR 46450
 SET  @toTimeStr = @temp.value('(//./@toTimeValue)[1]','nvarchar(255)')
 SET  @fromTimeStr = @temp.value('(//./@fromTimeValue)[1]','nvarchar(255)')
 SET  @timeStr = @temp.value('(//./@timeValue)[1]','nvarchar(255)')
set @appId=@temp.value('(//./@applicationId)[1]','int')
 SET @lmMPName=@temp.value('(//./@policyName)[1]','nvarchar(1024)')
 IF SUBSTRING(@lmMPName,1,1) = '|'
 SET @lmMPName = ( select dbo.DecodeInvalidXMLChar(@lmMPName) )
 SET @customQueryName=@temp.value('(//./@queryName)[1]','nvarchar(max)')
 IF SUBSTRING(@customQueryName,1,1) = '|'
 SET @customQueryName = ( select dbo.DecodeInvalidXMLChar(@customQueryName) )
 SET @containerName=@temp.value('(//./@containerName)[1]','nvarchar(max)')
 IF SUBSTRING(@containerName,1,1) = '|'
 SET @containerName = ( select dbo.DecodeInvalidXMLChar(@containerName) )
 SET @sidbStoreName=@temp.value('(//./@sidbStoreName)[1]','nvarchar(max)')
 IF SUBSTRING(@sidbStoreName,1,1) = '|'
 SET @sidbStoreName = ( select dbo.DecodeInvalidXMLChar(@sidbStoreName) )
 SET @roleName = @temp.value('(//./@roleName)[1]','nvarchar(max)')
 IF SUBSTRING(@roleName,1,1) = '|'
 SET @roleName = ( select dbo.DecodeInvalidXMLChar(@roleName) )
 SET @categoryName = @temp.value('(//./@categoryName)[1]','nvarchar(max)')
 IF SUBSTRING(@categoryName,1,1) = '|'
 SET @categoryName = ( select dbo.DecodeInvalidXMLChar(@categoryName) )
 SET @permissionName = @temp.value('(//./@permissionName)[1]','nvarchar(max)')
 IF SUBSTRING(@permissionName,1,1) = '|'
 SET @permissionName = ( select dbo.DecodeInvalidXMLChar(@permissionName) )
 SET @customEntityTypeName = @temp.value('(//./@entityTypeName)[1]','nvarchar(max)')
 IF SUBSTRING(@customEntityTypeName, 1, 1) = '|'
 SET @customEntityTypeName = (select dbo.DecodeInvalidXMLChar(@customEntityTypeName))
 SET @customEntityName = @temp.value('(//./@entityName)[1]','nvarchar(max)')
 IF SUBSTRING(@customEntityName, 1, 1) = '|'
 SET @customEntityName = (select dbo.DecodeInvalidXMLChar(@customEntityName))
	IF @commcellNameVal IS NOT null AND @commcellNameVal <> ''
	BEGIN
		exec EntityCommcellNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- CommcellEntity is a part of clientEntity and GenericEntity. Removing continue here since EntitySubclientNameToId or
		-- EntityApplicationNameToId will handle further conversion
	end
	IF (@vmNameVal IS NOT null AND @vmNameVal <> '')
	BEGIN
		EXEC entityVMNameToId @i, @put_invalid_id, @temp OUTPUT, @var OUTPUT, @ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
	END
	IF @vmPolicyNameVal IS NOT null AND @vmPolicyNameVal <> ''
	BEGIN
		EXEC entityVMPolicyNameToId @i, @put_invalid_id, @temp OUTPUT, @var OUTPUT, @ErrorSeverity output,@ErrorState output, @ErrorMessage output , @replaceVarLast
	END
	--clientName, Also Handles Application Name, Instance Name, Backupset Name,Subclient Name, appType Name, appGroup Name, subclientPolicy Name
	set @appId=@temp.value('(//./@applicationId)[1]','int')
	IF  ((@displayNameVal IS NOT null AND @displayNameVal <> '') OR (@clientNameVal IS NOT null AND @clientNameVal <> '')) or (@clientId1 IS NOT null) or (@appTypeNameVal IS NOT null AND @appTypeNameVal <> '') or (@appGroupNameVal IS NOT null AND @appGroupNameVal <> '') or (@scPolicyNameVal IS NOT null AND @scPolicyNameVal <> '') or (( @appNameVal IS NOT null AND @appNameVal <> '') AND ( @appId IS NULL))
	BEGIN
		exec EntitySubclientNameToId @i, @put_invalid_id, @temp,@var output,@entityType output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		--MR 46550
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @shelfNameVal IS NOT null AND @shelfNameVal <> ''
	BEGIN
		exec EntityShelfNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	--MR 46550
	--Library Name. Also handles masterPool Name, drivePool Name, drive Name, spareMediaGroup Name, scratchPool Name
	IF (@libraryNameVal IS NOT null AND @libraryNameVal <> '' ) or (@templibId IS NOT NULL)
	BEGIN
		exec EntityLibraryNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @spareMediaGroupNameVal IS NOT NULL AND @spareMediaGroupNameVal <> ''
	BEGIN
		exec EntitySpareGroupNameToId @i, @put_invalid_id, @temp, @var output, @ErrorSeverity output, @ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @mediaAgentNameVal IS NOT null AND @mediaAgentNameVal <> ''
	BEGIN
		exec EntityMediaAgentNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF (@userNameVal IS NOT null AND @userNameVal <> '')
	BEGIN
		exec EntityUsernameToId  @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF (@userGroupNameVal IS NOT null AND @userGroupNameVal <> '')
	BEGIN
		exec EntityUserGroupnameToId  @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	--storagePolicy Name, Also handles storagePolicyCopy Name
	IF @storagePolicyNameVal IS NOT null AND @storagePolicyNameVal <> ''
	BEGIN
		exec EntityStoragePolicyNameToId @i, @put_invalid_id, @temp,@var output,@storagePolicyNameVal,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	--provider Name. Also handles externalGroup Name
	IF @providerNameVal IS NOT null AND @providerNameVal <> ''
	BEGIN
		exec EntityProviderNameToId @i, @put_invalid_id, @temp,@var output,@providerNameVal,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	IF @clientGroupNameVal IS NOT null AND @clientGroupNameVal <> ''
	BEGIN
		exec EntityClientGroupNameToId @i, @put_invalid_id, @temp,@var output,@clientGroupNameVal,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @calendarNameVal IS NOT null AND @calendarNameVal <> ''
	BEGIN
		exec EntityCalendarNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @snapShotEngineNameVal IS NOT null AND @snapShotEngineNameVal <> ''
	BEGIN
		exec EntitySnapShotEngineNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	IF @MMexportLocationVal IS NOT null AND @MMexportLocationVal <> ''
	BEGIN
		exec EntityMMexportLocationNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	IF @alertNameVal IS NOT null AND @alertNameVal <> ''
	BEGIN
		exec EntityAlertNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast, @userId
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @timeZoneNameVal IS NOT null AND @timeZoneNameVal <> ''
	BEGIN
		exec EntityTimeZoneNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
	end
	IF(@mediaNameVal IS NOT null AND @mediaNameVal <> '')
	BEGIN
		exec EntityMediaNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	IF(@mountPathNameVal IS NOT null AND @mountPathNameVal <> '')
	BEGIN
		exec EntityMountPathNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF(@trackingNameVal IS NOT null AND @trackingNameVal <> '')
	BEGIN
		exec EntityTrackingPolicyNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @releaseStringVal IS NOT null AND @releaseStringVal <> ''
	BEGIN
		exec EntityReleaseNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF  @syncWebFolderNameVal IS NOT null AND @syncWebFolderNameVal <> ''
	BEGIN
		exec EntitySyncWebFolderNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	IF @licenseNameVal IS NOT null AND @licenseNameVal <> ''
	BEGIN
		exec EntityLicenseNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @componentNameVal IS NOT null AND @componentNameVal <> ''
	BEGIN
		exec EntityComponentNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF @localeNameVal IS NOT null AND @localeNameVal <> ''
	BEGIN
		exec EntityLocaleNameToId @i, @put_invalid_id, @temp,@var output,@localeNameVal,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	IF (@taskNameVal IS NOT null AND @taskNameVal <> '') or (@subTaskNameVal IS NOT null AND @subTaskNameVal <> '')
	BEGIN
		exec EntityTaskSubtaskNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	END
	IF @schedulePolicyName IS NOT null AND @schedulePolicyName <> ''
	BEGIN
		exec EntitySchedulePolicyNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF  @activityNameVal IS NOT null AND @activityNameVal <> ''
	BEGIN
		exec EntityActivityNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		--Removing continue here inorder to convert WorkflowSchemaEntity attributes also
	end
	IF  @workflowNameVal IS NOT null AND @workflowNameVal <> ''
	BEGIN
		exec EntityWorkflowNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF  @schemaLocationUrlVal IS NOT null AND @schemaLocationUrlVal <> ''
	BEGIN
		exec EntitySchemaLocationNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
	IF  @schemaNamespaceVal IS NOT null AND @schemaNamespaceVal <> ''
	BEGIN
		exec EntitySchemaNamespaceToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		continue
	end
		IF ((@timeStr IS NOT null or @toTimeStr IS NOT null or @fromTimeStr IS NOT null)  AND (@globalTimeZoneId IS NOT NULL))
	BEGIN
				exec EntityTimeToId @i,@temp,@var output,@globalTimeZoneId,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
				continue
	END
	IF  @lmMPName IS NOT null AND @lmMPName <> ''
	BEGIN
		exec EntityMonitoringPolicyNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
	-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF  @customQueryName IS NOT null
	BEGIN
		exec EntityCustomQueryNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
	-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF  @containerName IS NOT null
	BEGIN
		exec EntityContainerNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
	-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	end
	IF  @sidbStoreName IS NOT null AND @sidbStoreName <> ''
	BEGIN
		exec EntitySIDBStoreNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	END
	IF @roleName IS NOT NULL AND @roleName <> ''
	BEGIN
		EXEC EntityRoleNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	END
	IF (@categoryname IS NOT NULL AND @categoryName <> '') OR (@permissionname IS NOT NULL AND @permissionName <> '')
	BEGIN
		EXEC EntityCategoryPermissionNameToId @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	END
	IF ((@customEntityTypeName IS NOT NULL AND @customEntityTypeName <> '') AND (@customEntityName IS NOT NULL AND @customEntityName <> ''))
	BEGIN
		EXEC EntityCustomEntityNameToIdConverter @i, @put_invalid_id, @temp,@var output,@ErrorSeverity output,@ErrorState output, @ErrorMessage output, @replaceVarLast
		-- In case of genericEntity structure, proceed to convert other attributes also.
		if (@type!=0)
			continue
	END
END
if @globalTimeZoneId is NULL and @iCountTimeZoneId > 1
BEGIN
    exec EntityTimeToId1 @var output
END
DECLARE @retainError as int = 1
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SELECT
        @ErrorMessage = @ErrorMessage + ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE();
END CATCH
IF @ErrorSeverity <> 0 OR @ErrorState <> 0
	RAISERROR('%s',@ErrorSeverity,@ErrorState,@ErrorMessage)
IF @ErrorMessage <> '' AND @retainError=1
BEGIN
	DECLARE @isPinfoSet bit
	SET @isPinfoSet = @var.exist('//processinginstructioninfo')
	IF(@isPinfoSet=0)
	BEGIN
		DECLARE @piinfo XML
		SET @piinfo = (SELECT @ErrorMessage as 'value',
			'ENTITY_ERROR_MESSAGE' as'name'
		FOR XML PATH('attributes'),ROOT('processinginstructioninfo'))
		--SELECT @PIINFO
		SET @var.modify('insert sql:variable("@piinfo") as first into (//./*)[1]')
	END
	ELSE
	BEGIN
		DECLARE @attributes xml= (SELECT @ErrorMessage as 'value',
		'ENTITY_ERROR_MESSAGE' as'name'
	FOR XML PATH('attributes'))
	SET @var.modify('insert sql:variable("@attributes") as first into (//./processinginstructioninfo)[1]')
	END
END
SELECT @var
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'EntityNameToIdConverter')
	delete from GxQscripts where name = 'EntityNameToIdConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityNameToIdConverter')
	delete from GXDBVersions where aliasname = 'EntityNameToIdConverter'
GO

insert into GXDBVersions values(2, 'EntityNameToIdConverter',  '00010095001200110000', 'EntityNameToIdConverter', '00010095001200110000')
GO

