

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityIdToNameConverterDynamic.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================+
--  | Stored Precedure: EntityIdToNameConverterDynamic()
--  |
--  | This stored procedure takes an input table name that should have columns
--  | entityTYpe1, entityID1, entityTYpe2, entityId2, entityType3, entityID3, entityType4, entityID4,
--  | entityTYpe5, entityId5, includeAll, genericEntityAssociated (XML).
--	| Based on the entity values, it computes and updates the genericEntityAssociated
--	| field for each record.
--	| Also we need to input the output parent field name. Like if the XML needs to be in this format
--	| <entity clientName="birbal" clientId="2" _type_="3"/>
--  | then we need to give the output field name as 'entity'
--	| Authors: jswaminathan & saggarwal
--  +====================================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='EntityIdToNameConverterDynamic')
BEGIN
	print '>>> Drop Stored Procedure: EntityIdToNameConverterDynamic <<<'
	drop procedure EntityIdToNameConverterDynamic
END
IF EXISTS (select * from GxQscripts where name='EntityIdToNameConverterDynamic')
	delete from GxQscripts where name = 'EntityIdToNameConverterDynamic'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityIdToNameConverterDynamic')
	delete from GXDBVersions where aliasname = 'EntityIdToNameConverterDynamic'
GO
print '... Creating Procedure: EntityIdToNameConverterDynamic'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure EntityIdToNameConverterDynamic
  @tableVariable NVARCHAR(MAX),
  @outputFieldName NVARCHAR(512) = 'entity'
AS
    /*	Sample table to be created:
		if object_id ('tempdb.dbo.#entitiesList') is not null
			drop table #entitiesList
		create table #entitiesList (entityType1 int, entityId1 int, entityType2 int, entityId2 int, entityType3 int, entityId3 int, entityType4 int, entityId4 int, entityType5 int, entityId5 int, includeAll int, genericEntityAssociated xml)
	*/
	IF OBJECT_ID('tempdb.dbo.#EntityIdToNameConverterDynamic_EntityTypesTable') IS NOT NULL
		DROP TABLE #EntityIdToNameConverterDynamic_EntityTypesTable
    CREATE TABLE #EntityIdToNameConverterDynamic_EntityTypesTable (entityTYpe int)
	declare @sqlString nvarchar(max)
	set @sqlString = 'insert into #EntityIdToNameConverterDynamic_EntityTypesTable select distinct dbo.getEntityLevelFromEntityHierarchy(entityType1, entityTYpe2, entityType3, entityTYpe4, entityTYpe5) from ' + @tableVariable
	exec (@sqlString)
	--updating all entities of a particular entity type is pretty much faster than iterating through individual entities
	declare @tempEntityType int
	declare entityIdToNameConverterCursor cursor for
select distinct entityTYpe from #EntityIdToNameConverterDynamic_EntityTypesTable where entityType not in (4, 5, 6, 7)
	open entityIdToNameConverterCursor
	fetch next from entityIdToNameConverterCursor into @tempEntityTYpe
	while @@fetch_status = 0
	begin
		declare @idCOlName nvarchar(512)
		declare @entityNameColName nvarchar(512)
		declare @entityNameInXML nvarchar(512)
		declare @entityIdINXML nvarchar(512)
		declare @tableName nvarchar(512)
		declare @isCustomEntity int = 0
		declare @entityTypeName nvarchar(512)
select @tableName = tableName, @idCOlName = idColName, @entityNameColName = entityNameColName, @entityNameInXML = entityNameInXML, @entityIdINXML = entityIdInXML, @isCustomEntity = (flags & 0x001), @entityTYpeName = entityTypeName
		from app_entity
		where entityType = @tempentitytype
		if (@isCustomEntity = 0)
		begin
if @tempEntityTYpe <> 15 and @tempEntityTYpe <> 62
			begin
				--normal entities like client group
				set @sqlString = 'update ' + @tableVariable + ' set genericENtityAssociated = (select ' + cast(@tempEntityType as nvarchar(10)) + ' as ''@_type_'', ' + @tableVariable + '.entityId1 as ''@' + @entityIdINXML + ''', entity.' + @entityNameColName + ' as ''@' + @entityNameInXML + ''' for xml path (''' + @outputFieldName + '''))
								   from ' + @tableName + ' entity
								   where ' + @tableVariable + '.includeAll = 0 and ' + @tableVariable + '.entityTYpe1 = ' + cast (@tempEntityType as nvarchar(10)) + ' and ' + @tableVariable + '.entityId1 = entity.' + @idCOlName
				exec (@sqlString)
			end
else if @tempEntityTYpe = 15					--special handling for user group entity and external group entity
			begin
				set @sqlString = 	'update ' + @tableVariable
									+ ' set genericENtityAssociated = (select 15 as ''@_type_'', entityId1 as ''@userGroupId'',
																   case when G.umdsProviderID <> 0 then (select domainName from UMDSProviders where id = G.umdsProviderId) + ''\'' + G.name
																		else G.name end as ''@userGroupName'' for xml path (''' + @outputFieldName + '''))
									 from umgroups G
									 where entityTYpe1 = 15 and G.id = entityId1'
				exec (@sqlString)
			end
else if @tempEntityTYpe = 62
			begin
				set @sqlString = 'update ' + @tableVariable +
								 ' set genericENtityAssociated = (select 62 as ''@_type_'',
																		  entityId1 as ''@groupId'',
																		  G.name as ''@externalGroupName'',
																		  (select domainName from UMDSProviders where id = G.umdsProviderId) as ''@providerDomainName'',
																		  G.umdsProviderId as ''@providerId''
																	for xml path (''' + @outputFieldName + '''))
								  from umgroups G
								  where entityTYpe1 = 62 and G.id = entityId1'
				exec (@sqlString)
			end
			--includeAll
			set @sqlString = 'update '+ @tableVariable +
							  ' set genericENtityAssociated = (select ' + cast(@tempEntityTYpe as nvarchar(10)) + ' as ''@_type_'', 1 as ''flags/@includeAll'' for xml path (''' + @outputFieldName + '''))
								where entityTYpe1 = ' + cast(@tempEntityType as nvarchar(10)) + ' and includeAll = 1'
			exec (@sqlString)
		end
		else
		begin
			--there are some entities like shared search who does not have entity name. For them fill only ids.
			if @entityNameColName is not null and @entityNameColName <> N''
			begin
				--single entities that have name defined in entity table
				set @sqlString = 'update ' + @tableVariable +
								  ' set genericENtityAssociated = (select 150 as ''@_type_'', ' + @tableVariable + '.entityType1 as ''@entityType'', ' + @tableVariable + '.entityId1 as ''@entityId'', ''' + @entityTypeName + ''' as ''@entityTypeName'', ' + 'entity.' + @entityNameColName + ' as ''@entityName'' for xml path (''' + @outputFieldName + '''))
								   from ' + @tableName + ' entity
								   where ' + @tableVariable + '.includeAll = 0 and ' + @tableVariable + '.entityType1 = ' + cast(@tempEntityType as nvarchar(10)) + ' and ' + @tableVariable + '.entityId1 = entity.' + @idCOlName
				exec (@sqlString)
			end
			else
			begin
				--single entities that have dont have name defined in entity table
				set @sqlString = 'update ' + @tableVariable +
								 ' set genericENtityAssociated = (select 150 as ''@_type_'', ' + @tableVariable + '.entityType1 as ''@entityType'', ' + @tableVariable + '.entityId1 as ''@entityId'', ''' + @entityTypeName + ''' as ''@entityTypeName'' for xml path (''' + @outputFieldName + '''))
									where ' + @tableVariable + '.includeAll = 0 and '  + @tableVariable + '.entityType1 = ' + cast(@tempEntityTYpe as nvarchar(10))
				exec (@sqlString)
			end
			--include All entities
			set @sqlString = 'update ' + @tableVariable +
							 ' set genericENtityAssociated = (select 150 as ''@_type_'', ' + cast(@tempEntityTYpe as nvarchar(10)) + ' as ''@entityType'', ''' + @entityTypeName + ''' as ''@entityTypeName'', 1 as ''flags/@includeAll'' for xml path (''' + @outputFieldName + '''))
							   where entityTYpe1 = ' + cast(@tempEntityTYpe as nvarchar(10)) + ' and includeAll = 1	'
			exec (@sqlString)
		end
		fetch next from entityIdToNameConverterCursor into @tempEntityTYpe
	end
	close entityIdToNameConverterCursor
	deallocate entityIdToNameConverterCursor
	drop table 	#EntityIdToNameConverterDynamic_EntityTypesTable
	--iDA entities
	set @sqlString = 'update ' + @tableVariable +
					 ' set genericENtityAssociated = (select 3 as ''@_type_'', entityId1 as ''@clientId'', app_client.name as ''@clientName'', app_client.displayName as ''@displayName'' for xml path (''' + @outputFieldName + '''))
					   from app_client
					   where entityType1 = 3 and entityType2 = 0 and app_client.id = entityID1 '
	exec (@sqlString)
	set @sqlString = 'update ' + @tableVariable +
					 ' set genericENtityAssociated = (select 4 as ''@_type_'', entityId1 as ''@clientId'', entityId2 as ''@applicationId'', app_client.name as ''@clientName'', app_client.displayName as ''@displayName'', APP_iDAType.name as ''@appName'' for xml path (''' + @outputFieldName + '''))
					   from app_client, app_idaType
					   where entityType2 = 4 and entityType3 = 0 and app_client.id = entityID1 and APP_iDAType.type = entityId2 '
	exec (@sqlString)
	set @sqlString = 'update ' + @tableVariable +
					 ' set genericENtityAssociated = (select 5 as ''@_type_'', entityId1 as ''@clientId'', entityId2 as ''@applicationId'', entityId3 as ''@instanceId'', app_client.name as ''@clientName'', app_client.displayName as ''@displayName'', APP_iDAType.name as ''@appName'', APP_InstanceName.name as ''@instanceName'' for xml path (''' + @outputFieldName + '''))
					   from app_client, app_idaType, APP_InstanceName
					   where entityType3 = 5 and entityType4 = 0 and app_client.id = entityID1 and APP_iDAType.type = entityId2 and APP_InstanceName.id = entityId3 '
	exec (@sqlString)
	set @sqlString = 'update ' + @tableVariable +
	                 ' set genericENtityAssociated = (select 6 as ''@_type_'', entityId1 as ''@clientId'', entityId2 as ''@applicationId'', entityId3 as ''@instanceId'', entityId4 as ''@backupsetId'', app_client.name as ''@clientName'', app_client.displayName as ''@displayName'', APP_iDAType.name as ''@appName'', APP_InstanceName.name as ''@instanceName'', APP_BackupSetName.name as ''@backupsetName'' for xml path (''' + @outputFieldName + '''))
					   from app_client, app_idaType, APP_InstanceName, APP_BackupSetName
					   where entityType4 = 6 and entityType5 = 0 and app_client.id = entityID1 and APP_iDAType.type = entityId2 and APP_InstanceName.id = entityId3 and APP_BackupSetName.id = entityId4 '
	exec (@sqlString)
	set @sqlString = 'update ' + @tableVariable +
					' set genericENtityAssociated = (select 7 as ''@_type_'', entityId1 as ''@clientId'', entityId2 as ''@applicationId'', entityId3 as ''@instanceId'', entityId4 as ''@backupsetId'', entityId5 as ''@subclientId'', app_client.name as ''@clientName'', app_client.displayName as ''@displayName'', APP_iDAType.name as ''@appName'', APP_InstanceName.name as ''@instanceName'', APP_BackupSetName.name as ''@backupsetName'', APP_Application.subclientName as ''@subclientName'' for xml path (''' + @outputFieldName + '''))
					  from app_client, app_idaType, APP_InstanceName, APP_BackupSetName, app_application
					  where entityType5 = 7 and app_client.id = entityID1 and APP_iDAType.type = entityId2 and APP_InstanceName.id = entityId3 and APP_BackupSetName.id = entityId4 and APP_Application.id = entityId5 '
	exec (@sqlString)
	set @sqlString = 'update ' + @tableVariable +
					  ' set genericENtityAssociated = (select 18 as ''@_type_'', AG.id as ''@storagePolicyId'', entityId1 as ''@copyId'', AG.name as ''@storagePolicyName'', AGC.name as ''@copyName'' for xml path (''' + @outputFieldName + '''))
					   from archGroup AG, archGroupCopy AGC
					   where entityType1 = 18 and AG.id = AGC.archGroupId and AGC.id = entityId1 '
	exec (@sqlString)
GO

IF EXISTS (select * from GxQscripts where name = 'EntityIdToNameConverterDynamic')
	delete from GxQscripts where name = 'EntityIdToNameConverterDynamic'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityIdToNameConverterDynamic')
	delete from GXDBVersions where aliasname = 'EntityIdToNameConverterDynamic'
GO

insert into GXDBVersions values(2, 'EntityIdToNameConverterDynamic',  '00000000000000000000', 'EntityIdToNameConverterDynamic', '00000000000000000000')
GO

