

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityIdToNameConverter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntityIdToNameConverter.sp,v $ $Id: EntityIdToNameConverter.sp,v 1.54.2.6 2019/09/11 15:31:11 alakra Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntityIdToNameConverter()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Gokul		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EntityIdToNameConverter')
BEGIN
	print '>>> Drop Stored Procedure: EntityIdToNameConverter <<<'
	drop procedure EntityIdToNameConverter
END
IF EXISTS (select * from GxQscripts where name='EntityIdToNameConverter')
	delete from GxQscripts where name = 'EntityIdToNameConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityIdToNameConverter')
	delete from GXDBVersions where aliasname = 'EntityIdToNameConverter'
GO
print '... Creating Procedure: EntityIdToNameConverter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityIdToNameConverter
  @var XML OUTPUT
AS
  DECLARE @output XML
-----------------------------------------------
-- Declare variables
DECLARE @clientNameVal			nvarchar(255)
DECLARE @appNameVal				nvarchar(255)
DECLARE @appGroupNameVal		nvarchar(255)
DECLARE @agentNameVal			nvarchar(255)
DECLARE @instanceNameVal		nvarchar(255)
DECLARE @backupSetNameVal		nvarchar(255)
DECLARE @subclientNameVal		nvarchar(255)
DECLARE @libraryNameVal 		nvarchar(255)
DECLARE @storagePolicyNameVal	nvarchar(255)
DECLARE @copyNameVal			nvarchar(255)
DECLARE @mediaAgentNameVal		nvarchar(255)
DECLARE @userGroupNameVal		nvarchar(255)
DECLARE @clientGroupNameVal		nvarchar(255)
DECLARE @calendarNameVal		nvarchar(255)
DECLARE @snapShotEngineNameVal	nvarchar(255)
DECLARE @exportLocationNameVal	nvarchar(255)
DECLARE @alertNameVal			nvarchar(255)
DECLARE @timeZoneNameVal		nvarchar(255)
DECLARE @masterPoolNameVal		nvarchar(255)
DECLARE @drivePoolNameVal		nvarchar(255)
DECLARE @userNameVal			nvarchar(255)
DECLARE @mediaNameVal			nvarchar(255)
DECLARE @scPolicyNameVal		nvarchar(255)
DECLARE @entityNameVal			nvarchar(255)
DECLARE @activityNameVal		nvarchar(255)
DECLARE @workflowNameVal		nvarchar(255)
DECLARE @schemaNamespaceVal		nvarchar(255)
DECLARE @schemaLocationUrlVal	nvarchar(255)
DECLARE @backupsetIdVal			int
DECLARE @instanceIdVal			int
DECLARE @appTypeIdVal			int
DECLARE @agentIdVal				int
DECLARE @appGroupIdVal			int
DECLARE @subclientIdVal			int
DECLARE @storagePolicyIdVal		int
DECLARE @copyIdVal				int
DECLARE @masterPoolIdVal		int
DECLARE @libraryIdVal			int
DECLARE @drivePoolIdVal			int
DECLARE @clientIdVal			int
DECLARE @mediaAgentIdVal		int
DECLARE @clientGroupIdVal		int
DECLARE @userIdVal				int
DECLARE @userGroupIdVal			int
DECLARE @calendarIdVal			int
DECLARE @snapShotEngineIdVal	int
DECLARE @exportLocationIdVal	int
DECLARE @alertIdVal				int
DECLARE @timeZoneIdVal			int
DECLARE @mediaIdVal				int
DECLARE @scPolicyIdVal			int
DECLARE @entityIdVal			int
DECLARE @activityIdVal			int
DECLARE @workflowIdVal			int
DECLARE @schemaIdVal			int
DECLARE @commCellIdVal			int
DECLARE @schemaLocationIdVal	int
DECLARE @customEntityTypeIdVal	int
DECLARE @customEntityIdVal		int
DECLARE @tempIdVal				nvarchar(255)
DECLARE @tempMediaAgentName		nvarchar(255)
DECLARE @tempclientName			nvarchar(255)
DECLARE @tempAppName			nvarchar(255)
DECLARE @tempAppGroupName		nvarchar(255)
DECLARE @tempAgentName			nvarchar(255)
DECLARE @tempInstName			nvarchar(255)
DECLARE @tempBkpSetName			nvarchar(255)
DECLARE @tempSubclntName 		nvarchar(255)
DECLARE @tempMasterPoolName		nvarchar(255)
DECLARE @tempLibraryName		nvarchar(255)
DECLARE @tempStoragePolicyName	nvarchar(255)
DECLARE @tempCopyName			nvarchar(255)
DECLARE @tempClientGroupName	nvarchar(255)
DECLARE @tempUserName			nvarchar(255)
DECLARE @tempUserGroupName		nvarchar(255)
DECLARE @tempCalendarName		nvarchar(255)
DECLARE @tempSnapShotEngineName	nvarchar(255)
DECLARE @tempExportLocationName	nvarchar(255)
DECLARE @tempAlertName			nvarchar(255)
DECLARE @tempTimeZoneName		nvarchar(255)
DECLARE @tempDrivePoolName		nvarchar(255)
DECLARE @tempMediaName			nvarchar(255)
DECLARE @tempSCPolicyName		nvarchar(255)
DECLARE @tempEntityName			nvarchar(255)
DECLARE @tempLocaleCountry		nvarchar(255)
DECLARE @localeCountry			nvarchar(255)
DECLARE @tempLocaleLanguage		nvarchar(255)
DECLARE @localeLanguage			nvarchar(255)
DECLARE @tempActivityNameVal		nvarchar(255)
DECLARE @tempWorkflowNameVal		nvarchar(255)
DECLARE @tempSchemaNamespaceVal		nvarchar(255)
DECLARE @tempSchemaLocationUrlVal			nvarchar(255)
DECLARE @commcellNameVal		nvarchar(256)
DECLARE @tempCommcellName 		nvarchar(255)
DECLARE @customEntityTypeNameVal	nvarchar(max)
DECLARE @customEntityNameVal		nvarchar(max)
DECLARE @tempCustomEntityTypeNameVal	nvarchar(max)
DECLARE @tempCustomEntityNameVal	nvarchar(max)
DECLARE @temp				XML
DECLARE @ErrorMessage		NVARCHAR(4000)
DECLARE @ErrorSeverity		INT
DECLARE @ErrorState			INT
DECLARE @ERROR_STATE		INT
SET	@ERROR_STATE		=	1
DECLARE @ERROR_SEVERITY		INT
SET @ERROR_SEVERITY		=	10
SET @ErrorSeverity =		0
SET @ErrorState	   =		0
SET @ErrorMessage  =		''
--MR 46450
DECLARE @iCountTimeZoneId		INT
DECLARE @globalTimeZoneId		INT
DECLARE @index					INT
DECLARE @displayString			nvarchar(255)
DECLARE	@tempId					int
DECLARE @type					int
DECLARE @utcDateTime			datetime
DECLARE @localDateTime			datetime
DECLARE @timeZoneStdName		nvarchar(255)
DECLARE @time					int
DECLARE @timeString				nvarchar(255)
DECLARE @toTime					int
DECLARE @toTimeString			nvarchar(255)
DECLARE @fromTime				int
DECLARE @fromTimeString			nvarchar(255)
DECLARE @monitorPolicyId        int
DECLARE @monitoringPolicyName  nvarchar(1024)
DECLARE @tempMonitoringPolicyName nvarchar(1024)
DECLARE @queryId				int
DECLARE @queryName				nvarchar(max)
DECLARE @tempQueryName			nvarchar(max)
DECLARE @roleNameVal			nvarchar(max)
DECLARE @tempRoleNameVal		nvarchar(max)
DECLARE @roleId					int
DECLARE @categoryNameVal		nvarchar(max)
DECLARE @tempCategoryNameVal	nvarchar(max)
DECLARE @categoryId				int
DECLARE @permissionNameVal		nvarchar(max)
DECLARE @tempPermissionNameVal	nvarchar(max)
DECLARE @permissionId			int
DECLARE @entityType				int
DECLARE @groupIdVal				int
DECLARE @tempGroupName			nvarchar(MAX)
DECLARE @externalGroupName		nvarchar(MAX)
DECLARE @providerIdVal			int
DECLARE @tempProviderName		nvarchar(MAX)
DECLARE @providerDomainName		nvarchar(MAX)
DECLARE @schedulePolicyId		int
DECLARE @schedulePolicyName		nvarchar(max)
DECLARE @tempSchedulePolicyName nvarchar(max)
DECLARE @containerId			int
DECLARE @containerName			nvarchar(255)
DECLARE @tempContainerName		nvarchar(255)
DECLARE @isOutputSelect         int		= 1
Declare @xQueryEntityTypeCHash  nvarchar(255) = '(//./@_type_)'
BEGIN TRY
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--MR 134087  set a Flag for determining if the output needs to be Selected at the end for Cpp calls
CREATE TABLE #tempTableForReplacement
(
	xpath NVARCHAR(MAX),
	value NVARCHAR(MAX),
	attrName NVARCHAR(MAX)
)
DECLARE @replaceVarLast		AS INT
SET @replaceVarLast = ISNULL((SELECT CONVERT(int,value)
							  FROM GXGlobalParam
							  WHERE name = 'OptimizeEntityIdToNameConverter' and modified=0),1)
if(@var.exist('//@isOutputSelect') != 0)
	BEGIN
	if(@var.value('(//@isOutputSelect)[1]','int') = 0)
		BEGIN
			SET @isOutputSelect=0
		END
	SET @var.modify('delete //@isOutputSelect')
	END
--MR 46450
if( (@var.exist('(//@time)') != 0) OR
    (@var.exist('(//@fromTime)')!=0) OR
    (@var.exist('(//@toTime)') != 0)
    )
BEGIN
	SET @iCountTimeZoneId = @var.value('count(//@TimeZoneID)','int')
	if (@iCountTimeZoneId = 0) or (@iCountTimeZoneId is NULL)
	BEGIN
		SET @globalTimeZoneId = (select TimeZoneID from SchedTimeZone where TimeZoneStdName = dbo.GetClientTimeZone(2))
	END
	if @iCountTimeZoneId = 1
	BEGIN
		SET @globalTimeZoneId =  @var.value('(//@TimeZoneID)[1]','int')
	END
END
DECLARE @iCount int
IF object_id('tempdb.dbo.#EntityIdToNameConverter_tempTbl') is not null
	DROP TABLE #EntityIdToNameConverter_tempTbl
create table #EntityIdToNameConverter_tempTbl
(
      tempVal xml,
      val int identity(1,1) primary key
)
delete from #EntityIdToNameConverter_tempTbl
insert into #EntityIdToNameConverter_tempTbl
select T.N.query('.')
from @var.nodes('(//.[@_type_])') as T(N)
SELECT @iCount = count(1) from #EntityIdToNameConverter_tempTbl
IF @iCount IS NULL
	SET @iCount = 0
DECLARE @i int
SET @i = 1
------------------------------------------------------------------------------------------
-- Loop through all entities
WHILE (@i <= @iCount)
BEGIN
	  select @temp = tempVal from #EntityIdToNameConverter_tempTbl
      		where val=@i
	 SET @ClientIdVal=@temp.value('(//./@clientId)[1]','int')
	 SET @tempclientName=@temp.value('(//./@clientName)[1]','nvarchar(255)')
	 SET @clientNameVal = @tempclientName
	 SET @appTypeIdVal=@temp.value('(//./@applicationId)[1]','int')
	 SET @tempAppName=@temp.value('(//./@appName)[1]','nvarchar(255)')
	 SET @appNameVal=@tempAppName
	 SET @appGroupIdVal=@temp.value('(//./@appGroupId)[1]','int')
	 SET @tempAppGroupName=@temp.value('(//./@appGroupName)[1]','nvarchar(255)')
	 SET @appGroupNameVal=@tempAppGroupName
	 SET @agentIdVal=@temp.value('(//./@appTypeId)[1]','int')
	 SET @tempAgentName=@temp.value('(//./@appTypeName)[1]','nvarchar(255)')
	 SET @agentNameVal=@tempAgentName
	 SET @instanceIdVal=@temp.value('(//./@instanceId)[1]','int')
	 SET @tempInstName=@temp.value('(//./@instanceName)[1]','nvarchar(255)')
	 SET @instanceNameVal=@tempInstName
	 SET @backupsetIdVal=@temp.value('(//./@backupsetId)[1]','int')
	 SET @tempBkpSetName=@temp.value('(//./@backupsetName)[1]','nvarchar(255)')
	 SET @backupSetNameVal=@tempBkpSetName
	 SET @subclientIdVal =@temp.value('(//./@subclientId)[1]','int')
	 SET @tempSubclntName=@temp.value('(//./@subclientName)[1]','nvarchar(255)')
	 SET @subclientNameVal=@tempSubclntName
	 SET @libraryIdVal=@temp.value('(//./@libraryId)[1]','int')
	 SET @tempLibraryName=@temp.value('(//./@libraryName)[1]','nvarchar(255)')
	 SET @libraryNameVal = @tempLibraryName
	 SET @copyIdVal=@temp.value('(//./@copyId)[1]','nvarchar(255)')
	 SET @tempCopyName = @temp.value('(//./@copyName)[1]','nvarchar(255)')
	 SET @copyNameVal = @tempCopyName
	 SET @storagePolicyIdVal=@temp.value('(//./@storagePolicyId)[1]','nvarchar(255)')
	 SET @tempStoragePolicyName = @temp.value('(//./@storagePolicyName)[1]','nvarchar(255)')
	 SET @storagePolicyNameVal = @tempStoragePolicyName
     SET @mediaAgentIdVal=@temp.value('(//./@mediaAgentId)[1]','nvarchar(255)')
	 SET @tempMediaAgentName = @temp.value('(//./@mediaAgentName)[1]','nvarchar(255)')
	 SET @mediaAgentNameVal = @tempMediaAgentName
	 SET @clientGroupIdVal=@temp.value('(//./@clientGroupId)[1]','nvarchar(255)')
	 SET @tempClientGroupName=@temp.value('(//./@clientGroupName)[1]','nvarchar(255)')
     SET @clientGroupNameVal = @tempClientGroupName
	 SET @userIdVal = @temp.value('(//./@userId)[1]','nvarchar(255)')
	 SET @tempUserName=@temp.value('(//./@userName)[1]','nvarchar(255)')
	 SET @userNameVal = @tempUserName
	 SET @userGroupIdVal = @temp.value('(//./@userGroupId)[1]','nvarchar(255)')
	 SET @tempUserGroupName=@temp.value('(//./@userGroupName)[1]','nvarchar(255)')
	 SET @userGroupNameVal = @tempUserName
	 SET @calendarIdVal = @temp.value('(//./@calendarId)[1]','nvarchar(255)')
	 SET @tempCalendarName=@temp.value('(//./@calendarName)[1]','nvarchar(255)')
	 SET @calendarNameVal = @tempCalendarName
	 SET @snapShotEngineIdVal = @temp.value('(//./@snapShotEngineId)[1]','nvarchar(255)')
	 SET @tempSnapShotEngineName=@temp.value('(//./@snapShotEngineName)[1]','nvarchar(255)')
	 SET @snapShotEngineNameVal = @tempSnapShotEngineName
	 SET @exportLocationIdVal  = @temp.value('(//./@locationId)[1]','nvarchar(255)')
	 SET @tempexportLocationName = @temp.value('(//./@locationName)[1]','nvarchar(255)')
	 SET @exportLocationNameVal = @tempExportLocationName
	 SET @alertIdVal = @temp.value('(//./@alertId)[1]','nvarchar(255)')
	 SET @tempAlertName=@temp.value('(//./@alertName)[1]','nvarchar(255)')
	 SET @alertNameVal = @tempAlertName
	 SET @timeZoneIdVal=@temp.value('(//./@TimeZoneID)[1]','nvarchar(255)')
	 SET @tempTimeZoneName=@temp.value('(//./@TimeZoneName)[1]','nvarchar(255)')
	 set @timeZoneNameVal = @tempTimeZoneName
	 SET  @masterPoolIdVal=@temp.value('(//./@masterPoolId)[1]','nvarchar(255)')
	 SET  @tempMasterPoolName=@temp.value('(//./@masterPoolName)[1]','int')
	 SET  @masterPoolNameVal = @tempMasterPoolName
	 SET @drivePoolIdVal=@temp.value('(//./@drivePoolId)[1]','nvarchar(255)')
	 SET @tempDrivePoolName = @temp.value('(//./@drivePoolName)[1]','nvarchar(255)')
	 SET @drivePoolNameVal = @tempDrivePoolName
	 SET @mediaIdVal=@temp.value('(//./@mediaId)[1]','nvarchar(255)')
	 SET @tempmediaName = @temp.value('(//./@mediaName)[1]','nvarchar(255)')
	 SET @mediaNameVal = @tempmediaName
	 SET @scPolicyIdVal=@temp.value('(//./@subclientPolicyId)[1]','int')
	 SET @tempSCPolicyName=@temp.value('(//./@subclientPolicyName)[1]','nvarchar(255)')
	 SET @scPolicyNameVal=@tempSCPolicyName
	 SET @commCellIdVal=@temp.value('(//./@commCellId)[1]','int')
	 set @tempCommcellName=@temp.value('(//./@commCellName)[1]','nvarchar(256)')
	 SET @activityIdVal=@temp.value('(//./@activityId)[1]','int')
	 SET @tempActivityNameVal=@temp.value('(//./@activityName)[1]','nvarchar(255)')
	 SET @activityNameVal = @tempActivityNameVal
	 SET @workflowIdVal=@temp.value('(//./@workflowId)[1]','int')
	 SET @tempWorkflowNameVal=@temp.value('(//./@workflowName)[1]','nvarchar(255)')
	 SET @workflowNameVal = @tempWorkflowNameVal
	 SET @schemaIdVal=@temp.value('(//./@schemaId)[1]','int')
	 SET @tempSchemaNamespaceVal=@temp.value('(//./@schemaNamespace)[1]','nvarchar(255)')
	 SET @schemaNamespaceVal = @tempSchemaNamespaceVal
	 SET @schemaLocationIdVal=@temp.value('(//./@schemaLocationId)[1]','int')
	 SET @tempSchemaLocationUrlVal=@temp.value('(//./@locationUrl)[1]','nvarchar(255)')
	 SET @schemaLocationUrlVal = @tempSchemaLocationUrlVal
	 SET @monitorPolicyId=@temp.value('(//./@policyId)[1]','int')
	 SET @tempMonitoringPolicyName=@temp.value('(//./@policyName)[1]','nvarchar(1024)')
	 SET @queryId = @temp.value('(//./@queryId)[1]','int')
	 SET @tempQueryName=@temp.value('(//./@queryName)[1]','nvarchar(max)')
	  --MR 46450
	 SET  @time=@temp.value('(//./@time)[1]','int')
	 SET  @fromTime=@temp.value('(//./@fromTime)[1]','int')
	 SET  @toTime=@temp.value('(//./@toTime)[1]','int')
	 SET @roleId=@temp.value('(//./@roleId)[1]','int')
	 SET @tempRoleNameVal=@temp.value('(//./@roleName)[1]','nvarchar(max)')
	 SET @categoryId = @temp.value('(//./@categoryId)[1]','int')
	 SET @tempCategoryNameVal = @temp.value('(//./@categoryName)[1]','nvarchar(max)')
	 SET @permissionId = @temp.value('(//./@permissionId)[1]','int')
	 SET @tempPermissionNameVal = @temp.value('(//./@permissionName)[1]','nvarchar(max)')
	 SET @entityType = @temp.value('(//./@_type_)[1]','int')
	 SET @groupIdVal = @temp.value('(//./@groupId)[1]','int')
	 SET @tempGroupName = @temp.value('(//./@externalGroupName)[1]', 'nvarchar(max)')
	 SET @providerIdVal = @temp.value('(//./@providerId)[1]', 'int')
	 SET @tempProviderName = @temp.value('(//./@providerDomainName)[1]', 'nvarchar(max)')
	 SET @schedulePolicyId = @temp.value('(//./@schedulePolicyId)[1]', 'int')
	 SET @tempSchedulePolicyName = @temp.value('(//./@schedulePolicyName)[1]', 'nvarchar(max)')
	 SET @containerId = @temp.value('(//./@containerId)[1]', 'int')
	 SET @tempContainerName = @temp.value('(//./@containerName)[1]', 'nvarchar(max)')
	 SET @customEntityTypeIdVal = @temp.value('(//./@entityType)[1]','int')
	 SET @tempCustomEntityTypeNameVal = @temp.value('(//./@entityTypeName)[1]','nvarchar(max)')
	 SET @customEntityIdVal = @temp.value('(//./@entityId)[1]','int')
	 SET @tempCustomEntityNameVal = @temp.value('(//./@entityName)[1]','nvarchar(max)')
	-- Get Subclient Name for subclientID
	IF (@subclientIdVal IS NOT NULL) AND (@subclientIdVal > 0)
	BEGIN
		DECLARE @newInstanceId int
		DECLARE @newBackupSetId int
		set @newInstanceId = 0
		set @newBackupSetId = 0
		SELECT @subclientNameVal = subclientName, @clientIdVal = clientId, @apptypeIdVal = appTypeId, @newInstanceId = instance, @newBackupSetId = backupSet
		FROM App_Application
		WHERE App_Application.id = @subclientIdVal
		IF @subclientNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid subclient Name for for subclientId [' + CAST(@subclientIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempsubclntName IS NULL
					SET @var.modify('insert (attribute subclientName {sql:variable("@subclientNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempsubclntName<>@subclientNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@subclientName)[1] with sql:variable("@subclientNameVal")')
			end
			else if (@tempsubclntName IS NULL OR (@tempsubclntName<>@subclientNameVal))
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @subclientNameVal, 'subclientName'
		END
		--# MR:48448--QR and Workflow job - upgrade
		--# Instaced id and backupset Id values are 0 for the QR and workflow upgrade job
		--# from sp we are fetching Instance Name and Backset Name based on subclient ID
		--# which is causing a break in taskmgr.createtask()
		--If instanceId is passed and it is not the same as what we get from db
		if @replaceVarLast=0
		begin
			IF @instanceIdVal IS NULL
				SET @var.modify('insert (attribute instanceId {sql:variable("@newInstanceId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			ELSE
			BEGIN
				IF @newInstanceId <> @instanceIdVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@instanceId)[1] with sql:variable("@newInstanceId")')
			END
		end
		else IF (@instanceIdVal IS NULL OR  (@newInstanceId <> @instanceIdVal))
			INSERT INTO #tempTableForReplacement(xPath, value, attrName)
			SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @newInstanceId, 'instanceId'
		SET @instanceIdVal = @newInstanceId
		if @replaceVarLast=0
		begin
			--If backupSetId is passed and and it is not the same as what we get from db
			IF @backupsetIdVal IS NULL
				SET @var.modify('insert (attribute backupsetId {sql:variable("@newBackupSetId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			ELSE
			BEGIN
				IF @newBackupSetId <> @backupsetIdVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@backupsetId)[1] with sql:variable("@newBackupSetId")')
			END
		END
		Else IF (@backupsetIdVal IS NULL OR (@newBackupSetId <> @backupsetIdVal))
			INSERT INTO #tempTableForReplacement(xPath, value, attrName)
			SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @newBackupSetId, 'backupsetId'
		SET  @backupsetIdVal = @newBackupSetId
		--# End of MR:48448 fix
	END
	IF (@backupSetIdVal IS NOT NULL)  AND (@backupSetIdVal <> 0)
	BEGIN
		SELECT @backupSetNameVal = name
		FROM  App_BackupSetName
		WHERE App_BackupSetName.id = @backupSetIdVal
		IF @backupSetNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid backup Set Name for backupset Id[' + CAST(@backupSetIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempbkpSetName IS NULL
					SET @var.modify('insert (attribute backupsetName {sql:variable("@backupsetNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempbkpSetName <> @backupsetNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@backupsetName)[1] with sql:variable("@backupsetNameVal")')
			end
			Else if  (@tempbkpSetName IS NULL OR (@tempbkpSetName <> @backupsetNameVal))
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @backupsetNameVal, 'backupsetName'
		END
	END
	IF (@scPolicyIdVal IS NOT NULL)  AND (@scPolicyIdVal <> 0)
	BEGIN
		SELECT @scPolicyNameVal = name
		FROM  App_BackupSetName
		WHERE App_BackupSetName.id = @scPolicyIdVal
		IF @scPolicyNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid subclient policy Name for subclient Id[' + CAST(@scPolicyIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempSCPolicyName IS NULL
					SET @var.modify('insert (attribute subclientPolicyName {sql:variable("@scPolicyNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempSCPolicyName <> @scPolicyNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@subclientPolicyName)[1] with sql:variable("@scPolicyNameVal")')
			end
			else if  (@tempSCPolicyName IS NULL OR (@tempSCPolicyName <> @scPolicyNameVal))
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @scPolicyNameVal, 'subclientPolicyName'
		END
	END
	IF (@instanceIdVal IS NOT NULL)  AND (@instanceIdVal <> 0)
	BEGIN
		SELECT @instanceNameVal = name
		FROM App_InstanceName
		WHERE App_InstanceName.id = @instanceIdVal
		SET @instanceNameVal = (select dbo.EncodeInvalidXMLChar(@instanceNameVal))
		IF @instanceNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Instance Name for Instance Id['+CAST(@instanceIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempInstName IS NULL
					SET @var.modify('insert (attribute instanceName {sql:variable("@instanceNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @instanceNameVal <> @tempInstName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@instanceName)[1] with sql:variable("@instanceNameVal")')
			end
			else if  (@tempInstName IS NULL OR (@instanceNameVal <> @tempInstName))
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @instanceNameVal, 'instanceName'
		END
	END
	IF (@appTypeIdVal IS NOT NULL)  AND (@appTypeIdVal <> 0)
	BEGIN
		DECLARE @t_operationType INT
		SET @t_operationType =  ISNULL(@var.value('(//@operationType)[1]','int'),0)
		IF ( ( @t_operationType != 4004) OR (@t_operationType = 4004 AND @appNameVal IS NULL) )
		BEGIN
		    -- Special handling for CommServManagement because display_name is incorrect in SimAppTypeLicTypeMap. Until SIM fixes it.
		    IF (@appTypeIdVal = 1000)
		    BEGIN
			   SELECT @appNameVal = name
			    FROM APP_iDAType
			    WHERE APP_iDAType.type = 1000
		    END
ELSE IF (@appTypeIdVal in (33,29) and EXISTS(SELECT id from App_client where id = @clientIdVal and (status & ( cast(0x8000000 as int) | cast(0x0080 as int) ) ) > 0 ))
			BEGIN
			   SELECT @appNameVal = name
			    FROM APP_iDAType
			    WHERE APP_iDAType.type = @appTypeIDVal
			END
	     	ELSE
		    BEGIN
			    SELECT @appNameVal = displayName
			    FROM app_idaType
			    WHERE app_idaType.type = @appTypeIdVal
		    END
	    END
		IF @appNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Application Name for AppTypeId ['+ CAST(@appTypeIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempAppName IS NULL
					SET @var.modify('insert (attribute appName {sql:variable("@appNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempAppName <> @appNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@appName)[1] with sql:variable("@appNameVal")')
			end
			else IF (@tempAppName IS NULL OR (@tempAppName <> @appNameVal))
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @appNameVal, 'appName'
		END
	END
	IF (@appGroupIdVal IS NOT NULL)  AND (@appGroupIdVal <> 0)
	BEGIN
		SELECT @appGroupNameVal = groupName
		FROM APP_appTypeGroup
		WHERE APP_appTypeGroup.appTypeGroupId = @appGroupIdVal
		IF @appGroupNameVal IS null
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Application Name for AppGroupId ['+ CAST(@appGroupIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempAppGroupName IS null
					SET @var.modify('insert (attribute appGroupName {sql:variable("@appGroupNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE If @tempAppGroupName <> @appGroupNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@appGroupName)[1] with sql:variable("@appGroupNameVal")')
			end
			else if (@tempAppGroupName IS null OR @tempAppGroupName <> @appGroupNameVal)
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @appGroupNameVal, 'appGroupName'
		END
	END
	IF (@agentIdVal IS NOT NULL)  AND (@agentIdVal <> 0)
	BEGIN
		SELECT @agentNameVal = name
		FROM app_IDAType
		WHERE app_IDAType.type = @agentIdVal
		IF @agentNameVal IS null
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Application Name for AppTypeId ['+ CAST(@agentIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempAgentName IS null
					SET @var.modify('insert (attribute appTypeName {sql:variable("@agentNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempAgentName<>@agentNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@appTypeName)[1] with sql:variable("@agentNameVal")')
			end
			else if (@tempAgentName IS null OR @tempAgentName<>@agentNameVal)
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @agentNameVal, 'appTypeName'
		END
	END
	IF(@clientIdVal IS NOT NULL)  AND (@clientIdVal <> 0)
	BEGIN
		SELECT @clientNameVal = name
		FROM App_Client
		WHERE App_Client.id = @clientIdVal
		IF @clientNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Client Name for ClientId ['+ CAST(@clientIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempclientName IS NULL
					SET @var.modify('insert (attribute clientName {sql:variable("@ClientNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempclientName<>@ClientNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@clientName)[1] with sql:variable("@ClientNameVal")')
			End
			else if (@tempclientName IS NULL OR @tempclientName<>@ClientNameVal)
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @ClientNameVal, 'clientName'
		END
	END
	IF(@libraryIdVal IS NOT NULL)  AND (@libraryIdVal <> 0)
	BEGIN
		SELECT @libraryNameVal = aliasName
		FROM MMLibrary
		WHERE MMLibrary.libraryId = @libraryIdVal
		IF @libraryNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Library Name for libraryId ['+ CAST(@libraryIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempLibraryName IS NULL
					SET @var.modify('insert (attribute libraryName {sql:variable("@libraryNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempLibraryName <> @libraryNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@libraryName)[1] with sql:variable("@libraryNameVal")')
			end
			else IF @tempLibraryName IS NULL OR @tempLibraryName <> @libraryNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @libraryNameVal, 'libraryName'
		END
	END
	IF(@copyIdVal IS NOT NULL)  AND (@copyIdVal <> 0)
	BEGIN
		SELECT @copyNameVal = name, @storagePolicyIdVal = archGroupId
		FROM ArchGroupCopy
		WHERE ArchGroupCopy.id = @copyIdVal
		IF @copyNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Copy Name for copyId ['+ CAST(@copyIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempCopyName IS NULL
					SET @var.modify('insert (attribute copyName {sql:variable("@copyNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE If @tempCopyName<>@copyNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@copyName)[1] with sql:variable("@copyNameVal")')
			end
			else IF @tempCopyName IS NULL OR @tempCopyName<>@copyNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @copyNameVal, 'copyName'
		END
	END
	IF(@storagePolicyIdVal IS NOT NULL)  AND (@storagePolicyIdVal <> 0)
	BEGIN
		SELECT @storagePolicyNameVal = name
		FROM ArchGroup
		WHERE ArchGroup.id = @storagePolicyIdVal
		IF @storagePolicyNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Storage Policy Name for Stroage Policy Id ['+ CAST(@storagePolicyIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempStoragePolicyName IS NULL
					SET @var.modify('insert (attribute storagePolicyName {sql:variable("@storagePolicyNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempStoragePolicyName<>@storagePolicyNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@storagePolicyName)[1] with sql:variable("@storagePolicyNameVal")')
			end
			else IF @tempStoragePolicyName IS NULL Or @tempStoragePolicyName<>@storagePolicyNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @storagePolicyNameVal, 'storagePolicyName'
			SET @tempIdVal = @temp.value('(//./@storagePolicyId)[1]','nvarchar(255)')
			if @replaceVarLast=0
			begin
				IF @tempIdVal IS NULL
					SET @var.modify('insert (attribute storagePolicyId {sql:variable("@storagePolicyIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE  if @tempIdVal<>@storagePolicyIdVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@storagePolicyId)[1] with sql:variable("@storagePolicyIdVal")')
			end
			else IF @tempIdVal IS NULL Or @tempIdVal<>@storagePolicyIdVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @storagePolicyIdVal, 'storagePolicyId'
		END
	END
	IF(@mediaAgentIdVal IS NOT NULL)  AND (@mediaAgentIdVal <> 0)
	BEGIN
		SELECT @mediaAgentNameVal = name
		FROM App_Client
		WHERE App_Client.id = @mediaAgentIdVal
		IF @mediaAgentNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Media Agent Name for Media Agent Id ['+ CAST(@mediaAgentIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempMediaAgentName IS NULL
					SET @var.modify('insert (attribute mediaAgentName {sql:variable("@mediaAgentNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempMediaAgentName<>@mediaAgentNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@mediaAgentName)[1] with sql:variable("@mediaAgentNameVal")')
			end
			else if @tempMediaAgentName IS NULL OR @tempMediaAgentName<>@mediaAgentNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @mediaAgentNameVal, 'mediaAgentName'
		END
	END
	IF(@userIdVal IS NOT NULL)  AND (@userIdVal <> 0)
	BEGIN
		SELECT @userNameVal = login
		FROM UMUsers
		WHERE UMUsers.id = @userIdVal
		IF @userNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid User Name for User Id ['+ CAST(@userIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempUserName IS null
					SET @var.modify('insert (attribute userName {sql:variable("@userNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE  if @tempUserName<>@userNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@userName)[1] with sql:variable("@userNameVal")')
			end
			else iF @tempUserName IS null OR @tempUserName<>@userNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @userNameVal, 'userName'
		END
	END
	IF (@userGroupIdVal IS NOT NULL)  AND (@userGroupIdVal <> 0)
	BEGIN
		SELECT @userGroupNameVal = CASE WHEN G.umdsProviderId = 0 THEN G.name ELSE Prov.domainName + '\' + G.name END
		FROM UMGroups G LEFT OUTER JOIN UMDSProviders Prov
		ON G.umdsProviderId = Prov.id
		WHERE G.id = @userGroupIdVal
		IF @userGroupNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid User Group Name for userGroupIdVal ['+ CAST(@userGroupIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempUserGroupName IS null
					SET @var.modify('insert (attribute userGroupName {sql:variable("@userGroupNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempUserGroupName<>@userGroupNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@userGroupName)[1] with sql:variable("@userGroupNameVal")')
			end
			else IF @tempUserGroupName IS null OR @tempUserGroupName<>@userGroupNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @userGroupNameVal, 'userGroupName'
		END
	END
	IF (@clientGroupIdVal IS NOT NULL)  AND (@clientGroupIdVal <> 0)
	BEGIN
		SELECT @clientGroupNameVal = name
		FROM APP_CLientGroup
		WHERE APP_ClientGroup.id = @clientGroupIdVal
		IF @clientGroupNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Client Group Name for client Group Id['+ CAST(@clientGroupIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempClientGroupName IS NULL
					SET @var.modify('insert (attribute clientGroupName {sql:variable("@clientGroupNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @clientGroupNameVal <>@tempClientGroupName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@clientGroupName)[1] with sql:variable("@clientGroupNameVal")')
			end
			else IF @tempClientGroupName IS NULL OR @clientGroupNameVal <> @tempClientGroupName
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @clientGroupNameVal, 'clientGroupName'
		END
	END
	IF(@calendarIdVal IS NOT NULL)  AND (@calendarIdVal <> 0)
	BEGIN
		SELECT @calendarNameVal = name
		FROM App_CustomCalendar
		WHERE App_CustomCalendar.id = @calendarIdVal
		IF @calendarNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Calendar Name for Calendar Id['+ CAST(@calendarIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempCalendarName IS NULL
					SET @var.modify('insert (attribute calendarName {sql:variable("@calendarNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempCalendarName<>@calendarNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@calendarName)[1] with sql:variable("@calendarNameVal")')
			end
			else IF @tempCalendarName IS NULL OR @tempCalendarName<>@calendarNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @calendarNameVal, 'calendarName'
		END
	END
	IF(@snapShotEngineIdVal IS NOT NULL)  AND (@snapShotEngineIdVal <> 0)
	BEGIN
		SELECT @snapShotEngineNameVal = SnapEngineName
		FROM SMSnapShotEngine
		WHERE SMSnapShotEngine.SnapShotEngineId = @snapShotEngineIdVal
		IF @snapShotEngineNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Snap Shot engine Name for Snapshot Id['+ CAST(@snapShotEngineIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempSnapShotEngineName IS NULL
					SET @var.modify('insert (attribute snapShotEngineName {sql:variable("@snapShotEngineNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempSnapShotEngineName<>@snapShotEngineNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@snapShotEngineName)[1] with sql:variable("@snapShotEngineNameVal")')
			end
			else IF @tempSnapShotEngineName IS NULL OR @tempSnapShotEngineName<>@snapShotEngineNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @snapShotEngineNameVal, 'snapShotEngineName'
		END
	END
	IF(@exportLocationIdVal IS NOT NULL) -- AND (@exportLocationIdVal <> 0) --MR 33950
	BEGIN
		SELECT @exportLocationNameVal = ExportLocation
		FROM MMExportLocation
		WHERE MMExportLocation.ExportLocationId = @exportLocationIdVal
		IF @exportLocationNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid ExportLocation Name for ExportLocation Id['+ CAST(@exportLocationIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempExportLocationName IS NULL
					SET @var.modify('insert (attribute locationName {sql:variable("@exportLocationNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempExportLocationName<>@exportLocationNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@locationName)[1] with sql:variable("@exportLocationNameVal")')
			end
			else IF @tempExportLocationName IS NULL OR @tempExportLocationName<>@exportLocationNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @exportLocationNameVal, 'locationName'
		END
	END
	IF(@alertIdVal IS NOT NULL)  AND (@alertIdVal <> 0)
	BEGIN
		SELECT @alertNameVal = notificationName
		FROM NTNotificationRule
		WHERE NTNotificationRule.id = @alertIdVal
		IF @alertNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Alert Name for Alert Id['+ CAST(@alertIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempAlertName IS NULL
					SET @var.modify('insert (attribute alertName {sql:variable("@alertNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempAlertName<>@alertNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@alertName)[1] with sql:variable("@alertNameVal")')
			end
			else if @tempAlertName IS NULL OR @tempAlertName<>@alertNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @alertNameVal, 'alertName'
		END
	END
	IF(@timeZoneIdVal IS NOT NULL)  AND (@timeZoneIdVal <> 0)
	BEGIN
		if (@timeZoneIdVal<>1001)
		begin
			SELECT @timeZoneNameVal = TimeZoneName
			FROM SchedTimeZone
			WHERE SchedTimeZone.TimeZoneId = @timeZoneIdVal
		end
		else
		begin
			set @timeZoneNameVal='Client Time Zone'
		end
		IF @timeZoneNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Timezone Name for Timezone Id['+ CAST(@timeZoneIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempTimeZoneName IS NULL
					SET @var.modify('insert (attribute TimeZoneName{sql:variable("@timeZoneNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempTimeZoneName<>@timeZoneNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@TimeZoneName)[1] with sql:variable("@timeZoneNameVal")')
			end
			else if @tempTimeZoneName IS NULL OR @tempTimeZoneName<>@timeZoneNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @timeZoneNameVal, 'TimeZoneName'
		END
	END
	IF(@masterPoolIdVal IS NOT NULL)  AND (@masterPoolIdVal <> 0)
	BEGIN
		SELECT @masterPoolNameVal = MasterPoolName
		FROM MMMasterPool
		WHERE MMMasterPool.MasterPoolId = @masterPoolIdVal
		IF @masterPoolNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid masterPool Name for masterPool Id['+ CAST(@masterPoolIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempMasterPoolName IS NULL
					SET @var.modify('insert (attribute masterPoolName {sql:variable("@masterPoolNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempMasterPoolName<>@masterPoolNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@masterPoolName)[1] with sql:variable("@masterPoolNameVal")')
			end
			else if @tempMasterPoolName IS NULL OR @tempMasterPoolName<>@masterPoolNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @masterPoolNameVal, 'masterPoolName'
		END
	END
	IF(@drivePoolIdVal IS NOT NULL)  AND (@drivePoolIdVal <> 0)
	BEGIN
		SELECT @drivePoolNameVal = DrivePoolName
		FROM MMDrivePool
		WHERE MMDrivePool.DrivePoolId = @drivePoolIdVal
		IF @drivePoolNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid DrivePool Name for DrivePool Id ['+ CAST(@drivePoolIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempDrivePoolName IS NULL
					SET @var.modify('insert (attribute drivePoolName {sql:variable("@drivePoolNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempDrivePoolName<>@drivePoolNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@drivePoolName)[1] with sql:variable("@drivePoolNameVal")')
			end
			else if @tempDrivePoolName IS NULL OR @tempDrivePoolName<>@drivePoolNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @drivePoolNameVal, 'drivePoolName'
		END
	END
	IF(@mediaIdVal IS NOT NULL) AND (@mediaIdVal <> 0)
	BEGIN
		SELECT @mediaNameVal = BarCode
		FROM MMMedia
		WHERE MMMedia.MediaId = @mediaIdVal
		IF @mediaNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Media Name for Media Id ['+ CAST(@mediaIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempMediaName IS null
					SET @var.modify('insert (attribute mediaName {sql:variable("@mediaNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempMediaName<>@mediaNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@mediaName)[1] with sql:variable("@mediaNameVal")')
			end
			else IF @tempMediaName IS null OR @tempMediaName<>@mediaNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @mediaNameVal, 'mediaName'
		END
	END
	-- TRACKING_POLICY_ENTITY
	SET @entityIdVal=@temp.value('(//./@trackingPolicyId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@trackingPolicyName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = PolicyName
		FROM VTPolicy
		WHERE VTPolicy.PolicyId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Policy Name for Policy Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute trackingPolicyName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@trackingPolicyName)[1] with sql:variable("@entityNameVal")')
			end
			else IF @tempEntityName IS null OR @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'trackingPolicyName'
		END
	END
	--DRIVE_ENTITY
	SET @entityIdVal=@temp.value('(//./@driveId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@driveName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = AliasName
		FROM MMDrive
		WHERE MMDrive.DriveId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid drive Name for drive Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute driveName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@driveName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'driveName'
		END
	END
	--MOUNT_PATH_ENTITY
	SET @entityIdVal=@temp.value('(//./@mountPathId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@mountPathName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = MountPathName
		FROM MMMountPath
		WHERE MMMountPath.MountPathId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid MountPath Name for MountPath Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute mountPathName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if  @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@mountPathName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'mountPathName'
		END
	END
	--MEDIA_SIDE_ENTITY
	SET @entityIdVal=@temp.value('(//./@mediaSideId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@mediaSideName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = SideName
		FROM MMMediaSide
		WHERE MMMediaSide.MediaSideId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid MediaSide Name for MediaSide Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute mediaSideName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@mediaSideName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'mediaSideName'
		END
	END
	--SHELF_ENTITY  : It is actually a shelf Library
	SET @entityIdVal=@temp.value('(//./@shelfId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@shelfName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = AliasName
		FROM MMLibrary
		WHERE MMLibrary.LibraryId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Library Name for Library Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute shelfName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@shelfName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'shelfName'
		END
	END
	--SPARE_MEDIA_GROUP_ENTITY
	SET @entityIdVal=@temp.value('(//./@spareMediaGroupId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@spareMediaGroupName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = SpareGroupName
		FROM MMSpareGroup
		WHERE MMSpareGroup.SpareGroupId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid SpareGroup Name for SpareGroup Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute spareMediaGroupName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@spareMediaGroupName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'spareMediaGroupName'
		END
	END
	--LIBRARY_MEDIA_TYPE_ENTITY
	SET @entityIdVal=@temp.value('(//./@libraryMediaTypeId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@libraryMediaTypeName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = MediaTypeName
		FROM MMMediaType
		WHERE MMMediaType.MediaTypeId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid MediaType Name for MediaType Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute libraryMediaTypeName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@libraryMediaTypeName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'libraryMediaTypeName'
		END
	END
	--SCRATCH_POOL_ENTITY : It is actually spareGroup
	SET @entityIdVal=@temp.value('(//./@scratchPoolId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@scratchPoolName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = SpareGroupName
		FROM MMSpareGroup
		WHERE MMSpareGroup.SpareGroupId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid SpareGroup Name for SpareGroup Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute scratchPoolName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@scratchPoolName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'scratchPoolName'
		END
	END
	--GalaxyReleaseEntity
	SET @entityIdVal=@temp.value('(//./@ReleaseID)[1]','int')
	SET @tempEntityName=@temp.value('(//./@ReleaseString)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = Release
		FROM SimAllGalaxyRel
		WHERE SimAllGalaxyRel.Id = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid ReleaseName for ReleaseId ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute ReleaseString {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@ReleaseString)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'ReleaseString'
		END
	END
	--License Entity
	SET @entityIdVal=@temp.value('(//./@LicenseId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@LicenseName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = short_name
		FROM SimLicApptypeV2
		WHERE SimLicApptypeV2.id = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid SimAppType Name for SimAppTypeId ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute LicenseName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@LicenseName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'LicenseName'
		END
	END
	--SIDB_STORE_ENTITY
	SET @entityIdVal=@temp.value('(//./@sidbStoreId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@sidbStoreName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = SIDBStoreName
		FROM IdxSIDBStore
		WHERE IdxSIDBStore.SIDBStoreId = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid SIDB Store Name for store Id ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute sidbStoreName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@sidbStoreName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'sidbStoreName'
		END
	END
	--ComponentEnitiy
	SET @entityIdVal=@temp.value('(//./@ComponentId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@ComponentName)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	IF(@entityIdVal IS NOT NULL) AND (@entityIdVal <> 0)
	BEGIN
		SELECT @entityNameVal = Name
		FROM SimPackage
		WHERE SimPackage.Id = @entityIdVal
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid SimPackage Name for SimPackageId ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute ComponentName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempEntityName<>@entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@ComponentName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'ComponentName'
		END
	END
		--ComponentEnitiy
	SET @entityIdVal=@temp.value('(//./@localeId)[1]','int')
	SET @tempEntityName=@temp.value('(//./@localeName)[1]','nvarchar(255)')
	SET @tempLocaleCountry = @temp.value('(//./@country)[1]','nvarchar(255)')
	SET @tempLocaleLanguage = @temp.value('(//./@language)[1]','nvarchar(255)')
	SET @entityNameVal = @tempEntityName
	SET @localeCountry = @tempLocaleCountry
	SET @localeLanguage = @tempLocaleLanguage
	IF(@entityIdVal IS NOT NULL)
	BEGIN
		--SELECT TOP 1 @entityNameVal = displayLocaleName
		--FROM evlocales
		--WHERE evlocales.cvLocaleId = @entityIdVal
		SELECT TOP 1 @entityNameVal = locale, @displayString = displayString
		FROM evlocales
		WHERE evlocales.cvLocaleId = @entityIdVal
		SET @index = PATINDEX ('%-%',@displayString)
		IF (@index <= 0)
		BEGIN
			SET @localeCountry = ''
			SET @localeLanguage = @displayString
		END
		ELSE
		BEGIN
			SET @localeCountry = SUBSTRING(@displayString,1,@index-1)
			SET @localeLanguage = SUBSTRING(@displayString,@index+1,(LEN(@displayString)-@index))
		END
		IF @entityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Locale Name for LocaleId ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempEntityName IS null
					SET @var.modify('insert (attribute localeName {sql:variable("@entityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE IF @tempEntityName <> @entityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@localeName)[1] with sql:variable("@entityNameVal")')
			end
			else if @tempEntityName IS null Or @tempEntityName<>@entityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityNameVal, 'localeName'
		END
		IF @localeCountry IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Locale Name for LocaleId ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempLocaleCountry IS null
					SET @var.modify('insert (attribute country {sql:variable("@localeCountry")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempLocaleCountry<>@localeCountry
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@country)[1] with sql:variable("@localeCountry")')
			end
			else if @tempLocaleCountry IS null Or @tempLocaleCountry<>@localeCountry
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @localeCountry, 'country'
		END
		IF @localeLanguage IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Locale Name for LocaleId ['+ CAST(@entityIdVal AS NVARCHAR(10))+'].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempLocaleLanguage IS null
					SET @var.modify('insert (attribute language {sql:variable("@localeLanguage")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempLocaleLanguage<>@localeLanguage
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@language)[1] with sql:variable("@localeLanguage")')
			end
			else if @tempLocaleLanguage IS null Or @tempLocaleLanguage<>@localeLanguage
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @localeLanguage, 'language'
		END
	END
	-- Workflow Activity Entity
	IF (@activityIdVal IS NOT NULL) AND (@activityIdVal <> 0)
	BEGIN
		SELECT @activityNameVal = Name
		FROM  WF_Activity
		WHERE WF_Activity.ActivityId = @activityIdVal
		IF @activityNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid activity name for activity Id[' + CAST(@activityIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempActivityNameVal IS NULL
					SET @var.modify('insert (attribute activityName {sql:variable("@activityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempActivityNameVal<>@activityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@activityName)[1] with sql:variable("@activityNameVal")')
			end
			else if @tempActivityNameVal IS null Or @tempActivityNameVal<>@activityNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @activityNameVal, 'activityName'
		END
	END
	-- Workflow Definition Entity
	IF (@workflowIdVal IS NOT NULL) AND (@workflowIdVal <> 0)
	BEGIN
		SELECT @workflowNameVal = Name
		FROM  WF_Definition
		WHERE WF_Definition.WorkflowId = @workflowIdVal
		IF @workflowNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid workflow name for workflow Id[' + CAST(@workflowIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempWorkflowNameVal IS NULL
					SET @var.modify('insert (attribute workflowName {sql:variable("@workflowNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempWorkflowNameVal<>@workflowNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@workflowName)[1] with sql:variable("@workflowNameVal")')
			end
			else if @tempWorkflowNameVal IS null Or @tempWorkflowNameVal<>@workflowNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @workflowNameVal, 'workflowName'
		END
	END
	-- Workflow Location Entity
	IF (@schemaLocationIdVal IS NOT NULL)
	BEGIN
		SELECT @schemaLocationUrlVal = LocationUrl
		FROM  WF_SchemaLocation
		WHERE WF_SchemaLocation.LocationId = @schemaLocationIdVal
		IF @schemaLocationUrlVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid location url for location Id[' + CAST(@schemaLocationIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempSchemaLocationUrlVal IS NULL
					SET @var.modify('insert (attribute schemaNamespace {sql:variable("@schemaLocationUrlVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempSchemaLocationUrlVal<>@schemaLocationUrlVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@schemaNamespace)[1] with sql:variable("@schemaLocationUrlVal")')
			end
			else if @tempSchemaLocationUrlVal IS null Or @tempSchemaLocationUrlVal<>@schemaLocationUrlVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @schemaLocationUrlVal, 'schemaNamespace'
		END
	END
	-- Workflow Schema Entity
	IF (@schemaIdVal IS NOT NULL)
	BEGIN
		SELECT @schemaNamespaceVal = Namespace
		FROM  WF_Schema
		WHERE WF_Schema.SchemaId = @schemaIdVal
		IF @schemaNamespaceVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid namespace for schema Id[' + CAST(@schemaIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempSchemaNamespaceVal IS NULL
					SET @var.modify('insert (attribute schemaNamespace {sql:variable("@schemaNamespaceVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempSchemaNamespaceVal<>@schemaNamespaceVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@schemaNamespace)[1] with sql:variable("@schemaNamespaceVal")')
			end
			else if @tempSchemaNamespaceVal IS null Or @tempSchemaNamespaceVal<>@schemaNamespaceVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @schemaNamespaceVal, 'schemaNamespace'
		END
	END
	--MonitoringPolicy Entity
	IF(@monitorPolicyId IS NOT NULL)AND (@monitorPolicyId<>0)
	BEGIN
		-- Both Monitoring Policy and Configuration policy use same variable name policyid
		-- Hence, we are always ending up with wrong policy name
		-- Therefore, in case of Configuration policy entity type, we will go to right table
		IF (@entityType <> 154)
		BEGIN
			SELECT @monitoringPolicyName =MonitorPolicyName
			FROM  APP_MonitoringPolicy
			WHERE monitorPolicyId=@monitorPolicyId
			IF @monitoringPolicyName IS NULL
			BEGIN
				SET @ErrorSeverity = @ERROR_SEVERITY
				SET @ErrorState	   = @ERROR_STATE
				SET @ErrorMessage  = @ErrorMessage + 'Invalid monitoringPolicy name for monitoring policy Id[' + CAST(@monitorPolicyId AS NVARCHAR(10)) + '].'
			END
			ELSE
			BEGIN
				if @replaceVarLast=0
				begin
					IF @tempMonitoringPolicyName IS NULL
						SET @var.modify('insert (attribute policyName {sql:variable("@monitoringPolicyName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
					ELSE if @tempMonitoringPolicyName<>@monitoringPolicyName
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@policyName)[1] with sql:variable("@monitoringPolicyName")')
				end
				else if @tempMonitoringPolicyName IS null Or @tempMonitoringPolicyName<>@monitoringPolicyName
					INSERT INTO #tempTableForReplacement(xPath, value, attrName)
					SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @monitoringPolicyName, 'policyName'
			END
		END
		ELSE
		BEGIN
			SELECT @monitoringPolicyName =policyName
			FROM  APP_ConfigurationPolicy
			WHERE policyId=@monitorPolicyId
			IF @monitoringPolicyName IS NULL
			BEGIN
				SET @ErrorSeverity = @ERROR_SEVERITY
				SET @ErrorState	   = @ERROR_STATE
				SET @ErrorMessage  = @ErrorMessage + 'Invalid configurationPolicy name for configuration policy Id[' + CAST(@monitorPolicyId AS NVARCHAR(10)) + '].'
			END
			ELSE
			BEGIN
				if @replaceVarLast=0
				begin
					IF @tempMonitoringPolicyName IS NULL
						SET @var.modify('insert (attribute policyName {sql:variable("@monitoringPolicyName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
					ELSE if @tempMonitoringPolicyName<>@monitoringPolicyName
						SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@policyName)[1] with sql:variable("@monitoringPolicyName")')
				end
				else if @tempMonitoringPolicyName IS null Or @tempMonitoringPolicyName<>@monitoringPolicyName
					INSERT INTO #tempTableForReplacement(xPath, value, attrName)
					SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @monitoringPolicyName, 'policyName'
			END
		END
	END
	-- Custom query entity
	--MonitoringPolicy Entity
	IF(@queryId IS NOT NULL)AND (@queryId>0)
	BEGIN
		SELECT @queryName =queryName
		FROM  NTQueryList
		WHERE queryId=@queryId
		IF @queryName IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Query name for query Id[' + CAST(@queryId AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempQueryName IS NULL
					SET @var.modify('insert (attribute queryName {sql:variable("@queryName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempQueryName<>@queryName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@queryName)[1] with sql:variable("@queryName")')
			end
			else if @tempQueryName IS null Or @tempQueryName<>@queryName
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @queryName, 'queryName'
		END
	END
	IF(@roleId IS NOT NULL) AND (@roleId > 0)
	BEGIN
		SELECT @roleNameVal =name
		FROM  UMRoles
		WHERE id=@roleId
		IF @roleNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid Role name for role Id[' + CAST(@roleId AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempRoleNameVal IS NULL
					SET @var.modify('insert (attribute roleName {sql:variable("@roleNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempRoleNameVal<>@roleNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@roleName)[1] with sql:variable("@roleNameVal")')
			end
			else if @tempRoleNameVal IS null Or @tempRoleNameVal<>@roleNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @roleNameVal, 'roleName'
		END
	END
	IF (@categoryId IS NOT NULL) AND (@categoryId > 0)
	BEGIN
		SELECT @categoryNameVal = categoryname
		FROM UMCategories
		WHERE id = @categoryId
		IF @categoryNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid category name for category Id[' + CAST(@categoryId AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempCategoryNameVal IS NULL
					SET @var.modify('insert (attribute categoryName {sql:variable("@categoryNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempCategoryNameVal<>@categoryNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@categoryName)[1] with sql:variable("@categoryNameVal")')
			end
			else if @tempCategoryNameVal IS null Or @tempCategoryNameVal<>@categoryNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @categoryNameVal, 'categoryName'
		END
	END
	IF (@permissionId IS NOT NULL) AND (@permissionId > 0)
	BEGIN
		SELECT @permissionNameVal = permissionName
		FROM UMPermissions
		WHERE id = @permissionId
		IF @permissionNameVal IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid permission name for permission Id[' + CAST(@permissionId AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempPermissionNameVal IS NULL
					SET @var.modify('insert (attribute permissionName {sql:variable("@permissionNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempPermissionNameVal<>@permissionNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@permissionName)[1] with sql:variable("@permissionNameVal")')
			end
			else if @tempPermissionNameVal IS null Or @tempPermissionNameVal<>@permissionNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @permissionNameVal, 'permissionName'
		END
	END
IF (@entityType) = 123
	BEGIN
		SET @categoryNameVal = 'All Permissions'
SET @entityType = 121
		if @replaceVarLast=0
		begin
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
		end
		else
			INSERT INTO #tempTableForReplacement(xPath, value, attrName)
			SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @entityType, '_type_'
		if @replaceVarLast=0
		begin
			IF @tempCategoryNameVal IS NULL
				SET @var.modify('insert (attribute categoryName {sql:variable("@categoryNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			ELSE if @tempCategoryNameVal<>@categoryNameVal
				SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@categoryName)[1] with sql:variable("@categoryNameVal")')
		end
		else if @tempCategoryNameVal IS null Or @tempCategoryNameVal<>@categoryNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @categoryNameVal, 'categoryName'
	END
	IF (@providerIdVal IS NOT NULL) AND (@providerIdVal > 0)
	AND (@groupIdVal IS NULL OR @groupIdVal = 0)
	--execute this code only for provider entity. External groups also will come with provider entity info filled. But for them the next block will take care of the conversion
	BEGIN
		SELECT @providerDomainName = domainName
		FROM UMDSProviders
		WHERE id = @providerIdVal
		IF (@providerDomainName IS NULL)
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid provider domain name for provider Id[' + CAST(@providerIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempProviderName IS NULL
					SET @var.modify('insert (attribute providerDomainName {sql:variable("@providerDomainName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempProviderName<>@providerDomainName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@providerDomainName)[1] with sql:variable("@providerDomainName")')
			end
			else if @tempProviderName IS null Or @tempProviderName<>@providerDomainName
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @providerDomainName, 'providerDomainName'
		END
	END
	IF (@groupIdVal IS NOT NULL) AND (@groupIdVal > 0)
	BEGIN
		DECLARE @tempProviderId int = @temp.value('(//./@providerId)[1]', 'int')
		SET @tempProviderName = @temp.value('(//./@providerDomainName)[1]', 'nvarchar(max)')
		SELECT @externalGroupName = G.name, @providerDomainName = P.domainName, @providerIdVal = P.id
		FROM UMGroups G INNER JOIN UMDSProviders P
		ON G.umdsProviderId = P.id
		WHERE G.id = @groupIdVal
		IF (@externalGroupName IS NULL) OR (@providerDomainName IS NULL)
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid group name for group Id[' + CAST(@groupIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempGroupName IS NULL
					SET @var.modify('insert (attribute externalGroupName {sql:variable("@externalGroupName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempGroupName<>@externalGroupName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@externalGroupName)[1] with sql:variable("@externalGroupName")')
			end
			else if @tempGroupName IS null Or @tempGroupName<>@externalGroupName
					INSERT INTO #tempTableForReplacement(xPath, value, attrName)
					SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @externalGroupName, 'externalGroupName'
			if @replaceVarLast=0
			begin
				IF @tempProviderId IS NULL
					SET @var.modify('insert (attribute providerId {sql:variable("@providerIdVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @providerIdVal<>@tempProviderId
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@providerId)[1] with sql:variable("@providerIdVal")')
			end
			else if @tempProviderId IS null Or @tempProviderId<>@providerIdVal
					INSERT INTO #tempTableForReplacement(xPath, value, attrName)
					SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @providerIdVal, 'providerId'
			if @replaceVarLast=0
			begin
				IF @tempProviderName IS NULL
					SET @var.modify('insert (attribute providerDomainName {sql:variable("@providerDomainName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempProviderName<>@providerDomainName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@providerDomainName)[1] with sql:variable("@providerDomainName")')
			end
			else if @tempProviderName IS null Or @tempProviderName<>@providerDomainName
					INSERT INTO #tempTableForReplacement(xPath, value, attrName)
					SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @providerDomainName, 'providerDomainName'
		END
	END
	IF (@schedulePolicyId IS NOT NULL) AND (@schedulePolicyId > 0)
	BEGIN
		SELECT @schedulePolicyName = taskName
		FROM TM_Task
		WHERE taskId = @schedulePolicyId
		IF @schedulePolicyName IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid schedule policy name for schedule policy Id[' + CAST(@schedulePolicyId AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempSchedulePolicyName IS NULL
					SET @var.modify('insert (attribute schedulePolicyName {sql:variable("@schedulePolicyName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempSchedulePolicyName<>@schedulePolicyName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@schedulePolicyName)[1] with sql:variable("@schedulePolicyName")')
			end
			else IF @tempSchedulePolicyName IS NULL OR @tempSchedulePolicyName<>@schedulePolicyName
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @schedulePolicyName, 'schedulePolicyName'
		END
	END
	IF (@containerID IS NOT NULL) AND (@containerID > 0)
	BEGIN
		SELECT @containerName = ContainerName
		FROM MMContainer
		WHERE containerId = @containerId
		IF @containerName IS NULL
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid container name for container Id[' + CAST(@containerID AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempContainerName IS NULL
					SET @var.modify('insert (attribute containerName {sql:variable("@containerName")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempContainerName<>@containerName
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@containerName)[1] with sql:variable("@containerName")')
			end
			else IF @tempContainerName IS NULL OR @tempContainerName<>@containerName
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @containerName, 'containerName'
		END
	END
	--custom entity
	IF (((@customEntityTypeIdVal IS NOT NULL) AND (@customEntityTypeIdVal > 0)) AND ((@customEntityIdVal IS NOT NULL) AND (@customEntityIdVal > 0)))
	BEGIN
		SET @customEntityTypeNameVal = (SELECT entityTypeName FROM APP_Entity WHERE entityType = @customEntityTypeIdVal)
		DECLARE	@varstmt NVARCHAR(MAX)
		DECLARE @idColName NVARCHAR(MAX)
		DECLARE @tableName NVARCHAR(MAX)
		DECLARE @entityNameColName NVARCHAR(MAX)
		SELECT @idColName = idColName, @tableName = tableName, @entityNameColName = entityNameColName
		FROM APP_Entity
		WHERE entityType = @customEntityTypeIdVal
		--Some entities can have either id or name column missing (like shared entity info).
		--In that case we should not end up in framing an improper dynamic SQL query
		IF @idColName IS NOT NULL AND @idColName <> N'' AND @tableName IS NOT NULL AND @tableName <> N'' AND @entityNameColName IS NOT NULL AND @entityNameColName <> N''
		BEGIN
			SET @varstmt = (SELECT 'SELECT @name = ' + @entityNameColName + ' FROM ' + @tableName + ' WHERE ' + @idColName  + ' = ' + CAST(@customEntityIdVal AS NVARCHAR(MAX)))
			--Sample query:
			--SELECT name FROM APP_Client WHERE id = 9
			IF @varStmt IS NOT NULL
				EXEC sp_executeSQL @varstmt, N'@name NVARCHAR(MAX) OUT', @customEntityNameVal OUT
		END
		IF ((@customEntityTypeNameVal IS NULL) OR (@customEntityNameVal IS NULL))
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid entity name for entity type - id [' + CAST(@customEntityTypeIdVal AS NVARCHAR(10)) + '] - [' + CAST(@customEntityIdVal  AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempCustomEntityTypeNameVal IS NULL
					SET @var.modify('insert (attribute entityTypeName {sql:variable("@customEntityTypeNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempCustomEntityTypeNameVal<>@customEntityTypeNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@entityTypeName)[1] with sql:variable("@customEntityTypeNameVal")')
				end
			else IF (@tempCustomEntityTypeNameVal IS NULL OR @tempCustomEntityTypeNameVal<>@customEntityTypeNameVal)
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @customEntityTypeNameVal, 'entityTypeName'
			if @replaceVarLast=0
			begin
				IF @tempCustomEntityNameVal IS NULL
					SET @var.modify('insert (attribute entityName {sql:variable("@customEntityNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempCustomEntityNameVal<>@customEntityNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@entityName)[1] with sql:variable("@customEntityNameVal")')
			end
			else IF (@tempCustomEntityNameVal IS NULL OR @tempCustomEntityNameVal<>@customEntityNameVal)
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @customEntityNameVal, 'entityName'
		END
	END
	--MR 46450
	SET @timeString = @temp.value('(//./@timeValue)[1]','nvarchar(255)')
	IF (@time IS NOT null AND @globalTimeZoneId IS NOT NULL and @time <> 0)
	BEGIN
				SET @type=@temp.value('(//./@type)[1]','int')
				IF @type is null
				 SET @type = 0
				IF(@type < 11 or @type > 15)
				BEGIN
					SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @globalTimeZoneId)
					IF @timeZoneStdName IS NOT null
					BEGIN
						SET @utcDateTime = dbo.GetDateTime(@time)
						SET @localDateTime = dbo.UTCToLocalTime(@utcDateTime,@timeZoneStdName)
						SET @displayString = CONVERT(NVARCHAR,@localDateTime,20)
						if @replaceVarLast=0
						begin
							IF @timeString is null
								SET @var.modify('insert (attribute timeValue {sql:variable("@displayString")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
							ELSE if @timeString<>@displayString
								SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@timeValue)[1] with sql:variable("@displayString")')
						end
						else IF @timeString IS NULL OR  @timeString<>@displayString
							INSERT INTO #tempTableForReplacement(xPath, value, attrName)
							SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'timeValue'
					END
				END
				ELSE
				BEGIN
					select @time =	(case(@type)
											when 13 then  (@time/(60*60))   -- RELATIVE_HOURS
											when 11 then  (@time/(60*60*24))   -- RELATIVE_DAYS
											when 12 then  (@time/(60*60*24*7))   -- RELATIVE_WEEKS
											--  when 14 then SET @time = @time  -- RELATIVE DO NOTHING
											end
									)
					SET @displayString = CONVERT(NVARCHAR,@time)
					if @replaceVarLast=0
					begin
						IF @timeString is null
							SET @var.modify('insert (attribute timeValue {sql:variable("@displayString")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						ELSE if @timeString<>@displayString
						    SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@timeValue)[1] with sql:variable("@displayString")')
					end
					else IF @timeString IS NULL OR  @timeString<>@displayString
						INSERT INTO #tempTableForReplacement(xPath, value, attrName)
						SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'timeValue'
				END
	END
	SET @toTimeString = @temp.value('(//./@toTimeValue)[1]','nvarchar(255)')
	IF (@toTime IS NOT null AND @globalTimeZoneId IS NOT NULL)
	BEGIN
				--DECLARE @xdata XML
				SET @type=@temp.value('(//./@type)[1]','int')
				IF @type is null
				 SET @type = 0
				IF(@type < 11 or @type > 15)
				BEGIN
					SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @globalTimeZoneId)
					IF @timeZoneStdName IS NOT null
					BEGIN
						SET @utcDateTime = dbo.GetDateTime(@toTime)
						SET @localDateTime = dbo.UTCToLocalTime(@utcDateTime,@timeZoneStdName)
						SET @displayString = CONVERT(NVARCHAR,@localDateTime,20)
						if @replaceVarLast=0
						begin
							IF @toTimeString is null
								SET @var.modify('insert (attribute toTimeValue {sql:variable("@displayString")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
							ELSE if @toTimeString<>@displayString
								SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@toTimeValue)[1] with sql:variable("@displayString")')
						end
						else IF @toTimeString is null OR  @toTimeString<>@displayString
							INSERT INTO #tempTableForReplacement(xPath, value, attrName)
							SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'toTimeValue'
					END
				END
				ELSE
				BEGIN
					select @toTime =	(case(@type)
											when 13 then  (@toTime/(60*60))   -- RELATIVE_HOURS
											when 11 then  (@toTime/(60*60*24))   -- RELATIVE_DAYS
											when 12 then  (@toTime/(60*60*24*7))   -- RELATIVE_WEEKS
											--  when 14 then SET @toTime = @toTime  -- RELATIVE DO NOTHING
											end
										)
					SET @displayString = CONVERT(NVARCHAR,@toTime)
					if @replaceVarLast=0
					begin
						IF @toTimeString is null
							SET @var.modify('insert (attribute toTimeValue {sql:variable("@displayString")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						ELSE if @toTimeString<>@displayString
						    SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@toTimeValue)[1] with sql:variable("@displayString")')
					end
					else IF @toTimeString is null OR  @toTimeString<>@displayString
							INSERT INTO #tempTableForReplacement(xPath, value, attrName)
							SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'toTimeValue'
				END
	END
	SET @fromTimeString = @temp.value('(//./@fromTimeValue)[1]','nvarchar(255)')
	IF (@fromTime IS NOT null AND @globalTimeZoneId IS NOT NULL)
	BEGIN
				SET @type=@temp.value('(//./@type)[1]','int')
				IF @type is null
				 SET @type = 0
				IF(@type < 11 or @type > 15)
				BEGIN
					SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @globalTimeZoneId)
					IF @timeZoneStdName IS NOT null
					BEGIN
						SET @utcDateTime = dbo.GetDateTime(@fromTime)
						SET @localDateTime = dbo.UTCToLocalTime(@utcDateTime,@timeZoneStdName)
						SET @displayString = CONVERT(NVARCHAR,@localDateTime,20)
						if @replaceVarLast=0
						begin
							IF @fromTimeString is null
								SET @var.modify('insert (attribute fromTimeValue {sql:variable("@displayString")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
							ELSE if @fromTimeString<>@displayString
								SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@fromTimeValue)[1] with sql:variable("@displayString")')
						end
						else IF @fromTimeString is null OR  @fromTimeString<>@displayString
							INSERT INTO #tempTableForReplacement(xPath, value, attrName)
							SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'fromTimeValue'
					END
				END
				ELSE
				BEGIN
					select @fromTime =	(case(@type)
											when 13 then  (@fromTime/(60*60))   -- RELATIVE_HOURS
											when 11 then  (@fromTime/(60*60*24))   -- RELATIVE_DAYS
											when 12 then  (@fromTime/(60*60*24*7))   -- RELATIVE_WEEKS
											--  when 14 then SET @fromTime = @fromTime  -- RELATIVE DO NOTHING
											end
										)
					SET @displayString = CONVERT(NVARCHAR,@fromTime)
					if @replaceVarLast=0
					begin
						IF @fromTimeString is null
							SET @var.modify('insert (attribute fromTimeValue {sql:variable("@displayString")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
						ELSE if @fromTimeString<>@displayString
							SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@fromTimeValue)[1] with sql:variable("@displayString")')
					end
					else IF @fromTimeString is null OR  @fromTimeString<>@displayString
						INSERT INTO #tempTableForReplacement(xPath, value, attrName)
						SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'fromTimeValue'
				END
	END
	if (@commCellIdVal is not null AND @commCellIdVal>0)
	begin
		set @commcellNameVal = ''
		select @commcellNameVal = App_Commcell.aliasName from App_Commcell where App_Commcell.id=@commCellIdVal
		IF @commcellNameVal IS NULL Or len(@commcellNameVal)=0
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid commcell Name for for commcellId [' + CAST(@commCellIdVal AS NVARCHAR(10)) + '].'
		END
		ELSE
		BEGIN
			if @replaceVarLast=0
			begin
				IF @tempCommcellName IS NULL
					SET @var.modify('insert (attribute commCellName {sql:variable("@commcellNameVal")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
				ELSE if @tempCommcellName<>@commcellNameVal
					SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@commCellName)[1] with sql:variable("@commcellNameVal")')
			end
			else IF @tempCommcellName IS NULL OR  @tempCommcellName<>@commcellNameVal
				INSERT INTO #tempTableForReplacement(xPath, value, attrName)
				SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @commcellNameVal, 'commCellName'
		END
	end
	SET @i = @i + 1
END
if @globalTimeZoneId is NULL and @iCountTimeZoneId > 1
BEGIN
    DECLARE @localTimeZoneId int
    SET @i = 1
    SET @iCount = 0
	set @xQueryEntityTypeCHash = '(//./@fromTime)'
	truncate table #EntityIdToNameConverter_tempTbl
	insert into #EntityIdToNameConverter_tempTbl
	select T.N.query('../*')
	from @var.nodes('(//.[@fromTime])') as T(N)
	SELECT @iCount = count(1) from #EntityIdToNameConverter_tempTbl
	IF @iCount IS NULL
		SET @iCount = 0
    if @iCount is not NULL
    while @i <= @iCount
    BEGIN
		--SET @temp = @var.query('((//*//.[@fromTime])[sql:variable("@i")])//..//*')
		select @temp = tempVal from #EntityIdToNameConverter_tempTbl
      		where val=@i
	   	if @temp is not NULL
		BEGIN
			SET @timeZoneIdVal = @temp.value('(//@TimeZoneID)[1]','int')
		    if(@timeZoneIdVal is not NULL)
				SET @localTimeZoneId = 	@timeZoneIdVal
			SET @temp = @temp.query('((//*//.[@fromTime])[sql:variable("@i")])[1]')
			SET @fromTime = @temp.value('((//./@fromTime)[1])','int')
			SET @fromTimeString = @temp.value('((//./@fromTimeValue)[1])','nvarchar(255)')
			IF (@fromTime IS NOT null)
			BEGIN
						SET @type=@temp.value('(//./@type)[1]','int')
						IF @type is null
						 SET @type = 0
						IF(@type < 11 or @type > 15)
						BEGIN
							SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @localTimeZoneId)
							IF @timeZoneStdName IS NOT null
							BEGIN
								SET @utcDateTime = dbo.GetDateTime(@fromTime)
								SET @localDateTime = dbo.UTCToLocalTime(@utcDateTime,@timeZoneStdName)
								SET @displayString = CONVERT(NVARCHAR,@localDateTime,20)
								if @replaceVarLast=0
								begin
									IF @fromTimeString is null
										SET @var.modify('insert (attribute fromTimeValue {sql:variable("@displayString")})into ((//*/.[@fromTime])[sql:variable("@i")])[1]')
									ELSE if @fromTimeString<>@displayString
										SET @var.modify('replace value of ((//.[@fromTime])[sql:variable("@i")]/@fromTimeValue)[1] with sql:variable("@displayString")')
								end
								else IF @fromTimeString IS NULL OR  @fromTimeString<>@displayString
									INSERT INTO #tempTableForReplacement(xPath, value, attrName)
									SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'fromTimeValue'
							END
						END
						ELSE
						BEGIN
							select @fromTime =	(case(@type)
											when 13 then  (@fromTime/(60*60))   -- RELATIVE_HOURS
											when 11 then  (@fromTime/(60*60*24))   -- RELATIVE_DAYS
											when 12 then  (@fromTime/(60*60*24*7))   -- RELATIVE_WEEKS
											--  when 14 then SET @fromTime = @fromTime  -- RELATIVE DO NOTHING
											end
										)
							SET @displayString = CONVERT(NVARCHAR,@fromTime)
							if @replaceVarLast=0
							begin
								IF @fromTimeString is null
									SET @var.modify('insert (attribute fromTimeValue {sql:variable("@displayString")})into ((//*/.[@fromTime])[sql:variable("@i")])[1]')
								ELSE if @fromTimeString<>@displayString
									SET @var.modify('replace value of ((//.[@fromTime])[sql:variable("@i")]/@fromTimeValue)[1] with sql:variable("@displayString")')
							end
							else IF @fromTimeString IS NULL OR  @fromTimeString<>@displayString
								INSERT INTO #tempTableForReplacement(xPath, value, attrName)
								SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'fromTimeValue'
						END
			END
		END
		SET @i = @i+ 1
	END
	SET @i = 1
    SET @iCount = 0
	truncate table #EntityIdToNameConverter_tempTbl
	insert into #EntityIdToNameConverter_tempTbl
	select T.N.query('../*')
	from @var.nodes('(//.[@toTime])') as T(N)
	SELECT @iCount = count(1) from #EntityIdToNameConverter_tempTbl
	IF @iCount IS NULL
		SET @iCount = 0
	set @xQueryEntityTypeCHash = '(//./@toTime)'
	--SET @iCount = @var.value('count(//@toTime)','int')
	if @iCount is not NULL
    while @i <= @iCount
    BEGIN
		--SET @temp = @var.query('((//*//.[@toTime])[sql:variable("@i")])//..//*')
		select @temp = tempVal from #EntityIdToNameConverter_tempTbl
      		where val=@i
	   	if @temp is not NULL
		BEGIN
			SET @timeZoneIdVal = @temp.value('(//@TimeZoneID)[1]','int')
		    if(@timeZoneIdVal is not NULL)
				SET @localTimeZoneId = 	@timeZoneIdVal
			SET @temp = @temp.query('((//*//.[@toTime])[sql:variable("@i")])[1]')
			SET @toTime = @temp.value('((//./@toTime)[1])','int')
			SET @toTimeString = @temp.value('((//./@toTimeValue)[1])','nvarchar(255)')
			IF (@toTime IS NOT null)
			BEGIN
						SET @type=@temp.value('(//./@type)[1]','int')
						IF @type is null
						 SET @type = 0
						IF(@type < 11 or @type > 15)
						BEGIN
							SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @localTimeZoneId)
							IF @timeZoneStdName IS NOT null
							BEGIN
								SET @utcDateTime = dbo.GetDateTime(@toTime)
								SET @localDateTime = dbo.UTCToLocalTime(@utcDateTime,@timeZoneStdName)
								SET @displayString = CONVERT(NVARCHAR,@localDateTime,20)
								if @replaceVarLast=0
								begin
									IF @toTimeString is null
										SET @var.modify('insert (attribute toTimeValue {sql:variable("@displayString")})into ((//*/.[@toTime])[sql:variable("@i")])[1]')
									ELSE if @toTimeString<>@displayString
										SET @var.modify('replace value of ((//.[@toTime])[sql:variable("@i")]/@toTimeValue)[1] with sql:variable("@displayString")')
								end
								else IF @toTimeString IS NULL OR  @toTimeString<>@displayString
									INSERT INTO #tempTableForReplacement(xPath, value, attrName)
									SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'toTimeValue'
							END
						END
						ELSE
						BEGIN
							select @toTime =	(case(@type)
											when 13 then  (@toTime/(60*60))   -- RELATIVE_HOURS
											when 11 then  (@toTime/(60*60*24))   -- RELATIVE_DAYS
											when 12 then  (@toTime/(60*60*24*7))   -- RELATIVE_WEEKS
											--  when 14 then SET @toTime = @toTime  -- RELATIVE DO NOTHING
											end
										)
							SET @displayString = CONVERT(NVARCHAR,@toTime)
							if @replaceVarLast=0
							begin
								IF @toTimeString is null
									SET @var.modify('insert (attribute toTimeValue {sql:variable("@displayString")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
								ELSE if @toTimeString<>	@displayString
									SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@toTimeValue)[1] with sql:variable("@displayString")')
							end
							else IF @toTimeString IS NULL OR  @toTimeString<>@displayString
									INSERT INTO #tempTableForReplacement(xPath, value, attrName)
									SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'toTimeValue'
						END
			END
		END
		SET @i = @i+ 1
	END
	SET @i = 1
    SET @iCount = 0
	truncate table #EntityIdToNameConverter_tempTbl
	insert into #EntityIdToNameConverter_tempTbl
	select T.N.query('../*')
	from @var.nodes('(//.[@time])') as T(N)
	SELECT @iCount = count(1) from #EntityIdToNameConverter_tempTbl
	set @xQueryEntityTypeCHash = '(//./@time)'
	IF @iCount IS NULL
		SET @iCount = 0
    while @i <= @iCount
    BEGIN
		--SET @temp = @var.query('((//*//.[@time])[sql:variable("@i")])//..//*')
		select @temp = tempVal from #EntityIdToNameConverter_tempTbl
      		where val=@i
	   	if @temp is not NULL
		BEGIN
		    SET @timeZoneIdVal = @temp.value('(//@TimeZoneID)[1]','int')
		    if(@timeZoneIdVal is not NULL)
				SET @localTimeZoneId = 	@timeZoneIdVal
			SET @temp = @temp.query('((//*//.[@time])[sql:variable("@i")])[1]')
			SET @time = @temp.value('((//./@time)[1])','int')
			SET @timeString = @temp.value('((//./@timeValue)[1])','nvarchar(255)')
			IF (@time IS NOT null and @time <> 0)
			BEGIN
						SET @type=@temp.value('(//./@type)[1]','int')
						IF @type is null
						 SET @type = 0
						IF(@type < 11 or @type > 15)
						BEGIN
							SET @timeZoneStdName = (select TimeZoneStdName from SchedTimeZone where TimeZoneID = @localTimeZoneId)
							IF @timeZoneStdName IS NOT null
							BEGIN
								SET @utcDateTime = dbo.GetDateTime(@time)
								SET @localDateTime = dbo.UTCToLocalTime(@utcDateTime,@timeZoneStdName)
								SET @displayString = CONVERT(NVARCHAR,@localDateTime,20)
								if @replaceVarLast=0
								begin
									IF @timeString is null
										SET @var.modify('insert (attribute timeValue {sql:variable("@displayString")})into ((//*/.[@time])[sql:variable("@i")])[1]')
									ELSE if @timeString<>@displayString
										SET @var.modify('replace value of ((//.[@time])[sql:variable("@i")]/@timeValue)[1] with sql:variable("@displayString")')
								end
								else if @timeString is null OR @timeString<>@displayString
									INSERT INTO #tempTableForReplacement(xPath, value, attrName)
									SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'timeValue'
							END
						END
						ELSE
						BEGIN
							select @time =	(case(@type)
											when 13 then  (@time/(60*60))   -- RELATIVE_HOURS
											when 11 then  (@time/(60*60*24))   -- RELATIVE_DAYS
											when 12 then  (@time/(60*60*24*7))   -- RELATIVE_WEEKS
											--  when 14 then SET @time = @time  -- RELATIVE DO NOTHING
											end
									)
							SET @displayString = CONVERT(NVARCHAR,@time)
							if @replaceVarLast=0
							begin
								IF @timeString is null
									SET @var.modify('insert (attribute timeValue {sql:variable("@displayString")})into ((//*/.[@time])[sql:variable("@i")])[1]')
								ELSE if @timeString<>@displayString
									SET @var.modify('replace value of ((//.[@time])[sql:variable("@i")]/@timeValue)[1] with sql:variable("@displayString")')
							end
							else if @timeString is null OR @timeString<>@displayString
								INSERT INTO #tempTableForReplacement(xPath, value, attrName)
								SELECT @xQueryEntityTypeCHash+'['+CONVERT(nvarchar(max),@i)+']', @displayString, 'timeValue'
						END
			END
		END
		SET @i = @i+ 1
	END
END
IF (@replaceVarLast = 1) AND ((SELECT COUNT(*) FROM #tempTableForReplacement) > 0)
BEGIN
	--We have a temp table with all the xpath elements, values and attribute names. Just replace them into var now
	DECLARE @replaceXML AS XML
	DECLARE @replaceXMLString AS NVARCHAR(MAX)
	DECLARE @replacedXML AS NVARCHAR(MAX)
	DECLARE @varMax AS NVARCHAR(MAX)
	DECLARE @retainError as int = 1
	SET @replaceXML = ISNULL((SELECT xpath AS '@xPathElem', dbo.EncodeInvalidXMLChar(value) AS '@xPathVal', attrName AS '@attrName'
							FROM #tempTableForReplacement
							FOR XML PATH('entity'), ROOT('CustomReplacer')),'</CustomReplacer>')
	SET @replaceXMLString = CONVERT(NVARCHAR(MAX),@replaceXML)
	SET @varMax = CONVERT (NVARCHAR(MAX), @var)
	--select @replaceXMLString
	--select @varMax
	exec ReplaceXMLAttributesNew @varMax output, @replaceXMLString,1,@retainError output
	SET @var = CONVERT(XML, @varMax)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	 SELECT
        @ErrorMessage = @ErrorMessage + ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE();
END CATCH
IF @ErrorSeverity <> 0 OR @ErrorState <> 0
	RAISERROR(@ErrorMessage,@ErrorSeverity,@ErrorState)
if(@isOutputSelect<>0)
	SELECT @var
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'EntityIdToNameConverter')
	delete from GxQscripts where name = 'EntityIdToNameConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityIdToNameConverter')
	delete from GXDBVersions where aliasname = 'EntityIdToNameConverter'
GO

insert into GXDBVersions values(2, 'EntityIdToNameConverter',  '00010054000200060000', 'EntityIdToNameConverter', '00010054000200060000')
GO

