

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityCustomEntityNameToIdConverter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +===================================================================================================================+
--  | Stored Procedure: EntityCustomEntityNameToIdConverter()
--  |
--  |  Authors: saggarwal and jswaminathan
--  |  Description: Custom entity name to id converter - fills entity type and entity id from entity type name
--	|				and entity name fields respectively.
--	|          		Works for all entities that are not part of generic entity and make use of CustomEntity structure.
--  |  Sample Input: <_type_="150" entityTypeName="Third party App" entityName="04D0F0B1-0CCA-4787-9EF3-E2155126B58D"/>
--	|  Sample Output: <_type_="150" entityTypeName="Third party App" entityName="04D0F0B1-0CCA-4787-9EF3-E2155126B58D"
--	|								entityType="151" entityId="9"/>
--  +===================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='EntityCustomEntityNameToIdConverter')
BEGIN
	print '>>> Drop Stored Procedure: EntityCustomEntityNameToIdConverter <<<'
	drop procedure EntityCustomEntityNameToIdConverter
END
IF EXISTS (select * from GxQscripts where name='EntityCustomEntityNameToIdConverter')
	delete from GxQscripts where name = 'EntityCustomEntityNameToIdConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityCustomEntityNameToIdConverter')
	delete from GXDBVersions where aliasname = 'EntityCustomEntityNameToIdConverter'
GO
print '... Creating Procedure: EntityCustomEntityNameToIdConverter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityCustomEntityNameToIdConverter
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast INT
AS
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
DECLARE @tempEntityTypeId INT		--this is filled if it is already present in input
DECLARE @tempEntityId INT			--this is filled if it is already present in input
DECLARE @entityTypeName NVARCHAR(MAX)
DECLARE @entityName NVARCHAR(MAX)
DECLARE @entityTypeId INT
DECLARE @entityId INT
DECLARE @entityType INT		--this is to be filled with CUSTOM_ENTITY (150) always
--Get values from input xml
SET @entityTypeName = @temp.value('(//./@entityTypeName)[1]','nvarchar(max)')
SET @entityName = @temp.value('(//./@entityName)[1]','nvarchar(max)')
IF SUBSTRING(@entityTypeName, 1, 1) = '|'
	SET @entityTypeName = (SELECT dbo.DecodeInvalidXMLChar(@entityTypeName))
IF SUBSTRING(@entityName, 1, 1) = '|'
	SET @entityName = (SELECT dbo.DecodeInvalidXMLChar(@entityName))
SET @tempEntityTypeId = @temp.value('(//./@entityType)[1]', 'int')
SET @tempEntityId = @temp.value('(//./@entityId)[1]', 'int')
IF @entityTypeName IS NOT NULL AND @entityName IS NOT NULL
BEGIN
	SET @entityTypeId = (SELECT entityType FROM APP_Entity WHERE entityTypeName = @entityTypeName)
	IF @entityTypeId IS NULL
	BEGIN
		SET @errorSeverity = @ERROR_SEVERITY
		SET @errorState = @ERROR_STATE
		SET @ErrorMessage  = @ErrorMessage + 'Invalid entity type id for entity type name [' + @entityTypeName + '].'
		IF (@put_invalid_id < 0)
		BEGIN
			SET @entityTypeId = @put_invalid_id
			SET @entityId = @put_invalid_id
		END
	END
	--Got valid entity type. Now get entity Id from the given name by looking into the corresponding entity table
	IF @entityTypeID IS NOT NULL
	BEGIN
		DECLARE	@varstmt NVARCHAR(MAX)
		DECLARE @idColName NVARCHAR(MAX)
		DECLARE @tableName NVARCHAR(MAX)
		DECLARE @entityNameColName NVARCHAR(MAX)
		SELECT @idColName = idColName, @tableName = tableName, @entityNameColName = entityNameColName
		FROM APP_Entity
		WHERE entityType = @entityTYpeID
		--setting the quoted identifier to OFF manually
		--doing it as part of the dynamic statement so that we dont affect the other SQL queries executed as part of this same batch
		SET @varstmt = 'SET QUOTED_IDENTIFIER ON'	+ CHAR(10)
		--Some entities can have either id or name column missing (like shared entity info).
		--In that case we should not end up in framing an improper dynamic SQL query
		IF @idColName IS NOT NULL AND @idColName <> N'' AND @tableName IS NOT NULL AND @tableName <> N'' AND @entityNameColName IS NOT NULL AND @entityNameColName <> N''
		BEGIN
				SET @varstmt += (SELECT 'SELECT @id = ' + @idColName + ' FROM ' + @tableName + ' WHERE ' + @entityNameColName + ' =  "' + @entityName + '"')
				--Sample query:
				--SET QUOTED_IDENTIFIER ON
				--SELECT id FROM APP_Client WHERE name = "client_1"
				IF @varstmt IS NOT NULL
					EXEC sp_executeSQL @varstmt, N'@id INT OUT', @entityId OUT
		END
		IF @entityId IS NULL
		BEGIN
			SET @errorSeverity = @ERROR_SEVERITY
			SET @errorState = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid entity id for entity [' + @entityTypeName + ']-[' + @entityName + '].'
			IF (@put_invalid_id < 0)
			BEGIN
				SET @entityId = @put_invalid_id
			END
		END
	END
	--If both entity type and entity id are fetched properly then let us fill the xml
	IF @entityTypeId IS NOT NULL AND @entityId IS NOT NULL
	BEGIN
SET @entityType = 150
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempEntityTypeId IS NULL
			BEGIN
				SET @var.modify('insert (attribute entityType {sql:variable("@entityTypeId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			BEGIN
				SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@entityType)[1] with sql:variable("@entityTypeId")')
			END
			IF @tempEntityId IS NULL
			BEGIN
				SET @var.modify('insert (attribute entityId {sql:variable("@entityId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			BEGIN
				SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@entityId)[1] with sql:variable("@entityId")')
			END
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'EntityCustomEntityNameToIdConverter')
	delete from GxQscripts where name = 'EntityCustomEntityNameToIdConverter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityCustomEntityNameToIdConverter')
	delete from GXDBVersions where aliasname = 'EntityCustomEntityNameToIdConverter'
GO

insert into GXDBVersions values(2, 'EntityCustomEntityNameToIdConverter',  '00000000000000000000', 'EntityCustomEntityNameToIdConverter', '00000000000000000000')
GO

