

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityContainerNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntityContainerNameToId.sp,v $ $Id: EntityContainerNameToId.sp,v 1.2.14.2 2018/03/22 01:49:35 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntityContainerNameToId()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	jswaminathan	 EntityContainerNameToId container name to id converter
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntityContainerNameToId <<<'

IF EXISTS (select * from sysobjects where name='EntityContainerNameToId')
	drop procedure EntityContainerNameToId
IF EXISTS (select * from GxQscripts where name='EntityContainerNameToId')
	delete from GxQscripts where name = 'EntityContainerNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityContainerNameToId')
	delete from GXDBVersions where aliasname = 'EntityContainerNameToId'
GO
print '... Creating Procedure: EntityContainerNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityContainerNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast int 
AS
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @tempIdVal int
declare @containerName nvarchar(max)
declare @containerId int
declare @entityType int
SET @containerName=@temp.value('(//./@containerName)[1]','nvarchar(max)')
 IF SUBSTRING(@containerName,1,1) = '|'
	SET @containerName= ( select dbo.DecodeInvalidXMLChar(@containerName))
IF @containerName IS NOT null AND @containerName <> ''
BEGIN
	SET @tempIdVal=@temp.value('(//./@containerId)[1]','nvarchar(1024)')
	SET @containerId=(select containerId from MMContainer  where containerName=@containerName )
	IF @containerId IS NULL
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
		SET @ErrorState	   = @ERROR_STATE
		SET @ErrorMessage  = @ErrorMessage + 'Invalid Container Id for Container name['+ @containerName +'].'
		IF (@put_invalid_id = 1)
			set @containerId = -1
	END
	IF (@containerId is not null)
	BEGIN
		SET @entityType = 130
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempIdVal IS null
			BEGIN
			 SET @var.modify('insert (attribute containerId {sql:variable("@containerId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@containerId)[1] with sql:variable("@containerId")')
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'EntityContainerNameToId')
	delete from GxQscripts where name = 'EntityContainerNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityContainerNameToId')
	delete from GXDBVersions where aliasname = 'EntityContainerNameToId'
GO

insert into GXDBVersions values(2, 'EntityContainerNameToId',  '00010002001400020000', 'EntityContainerNameToId', '00010002001400020000')
GO

