

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityComponentNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntityComponentNameToId.sp,v $ $Id: EntityComponentNameToId.sp,v 1.5.80.2 2018/03/27 08:10:09 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntityComponentNameToId()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Ravneet Singh Arora	 EntityNameToIdConverter is broken into small procedures
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntityComponentNameToId <<<'

IF EXISTS (select * from sysobjects where name='EntityComponentNameToId')
	drop procedure EntityComponentNameToId
IF EXISTS (select * from GxQscripts where name='EntityComponentNameToId')
	delete from GxQscripts where name = 'EntityComponentNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityComponentNameToId')
	delete from GXDBVersions where aliasname = 'EntityComponentNameToId'
GO
print '... Creating Procedure: EntityComponentNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityComponentNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast int 
AS
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @componentNameVal  nvarchar(255)
declare @osTypeVal nvarchar(255)
declare @tempIdVal int
declare @tempId int
SET @componentNameVal=@temp.value('(//./@ComponentName)[1]','nvarchar(255)')
 IF SUBSTRING(@componentNameVal,1,1) = '|'
	SET @componentNameVal= ( select dbo.DecodeInvalidXMLChar(@componentNameVal) )
--declare @storagePolicyNameVal nvarchar(255)
declare @entityType int
IF @componentNameVal IS NOT null
BEGIN
		SET @tempIdVal=@temp.value('(//./@ComponentId)[1]','nvarchar(255)')
	SET @osTypeVal=LOWER(@temp.value('(//./@osType)[1]','char(100)'))
	IF @componentNameVal = 'Windows File System'						--From 10.0 SP3A, the name of this component is changed to File System from Windows File System. So adding this for backward compatibility
				SET @componentNameVal = 'File System'
	IF ( @osTypeVal IS null OR LEN(@osTypeVal) = 0
		OR ( @osTypeVal <> 'windows' AND @osTypeVal <> 'unix' AND @osTypeVal <> 'netware' ) )
	BEGIN
		DECLARE @packageCount INT = (SELECT COUNT(*) FROM simPackage WHERE simPackage.Name=@componentNameVal)
		IF @packageCount > 1
		BEGIN
			SET @ErrorSeverity = @ERROR_SEVERITY
			SET @ErrorState	   = @ERROR_STATE
			SET @ErrorMessage  = @ErrorMessage + 'Invalid OS Type for Component Name['+ @componentNameVal +'].'
		END
		ELSE
		BEGIN
			SET @tempId=(select simPackage.id from simPackage where simPackage.name=@componentNameVal)
		END
	END
	ELSE
	BEGIN
		IF @osTypeVal = 'windows'
			SET @tempId=(select TOP 1 simPackage.id from simPackage where simPackage.name=@componentNameVal
			and simPackage.id BETWEEN 0 AND 1000)
		ELSE IF @osTypeVal = 'unix'
			SET @tempId=(select TOP 1 simPackage.id from simPackage where simPackage.name=@componentNameVal
			and simPackage.id BETWEEN 1001 AND 1999)
		ELSE IF @osTypeVal = 'netware'
			SET @tempId=(select TOP 1 simPackage.id from simPackage where simPackage.name=@componentNameVal
			and simPackage.id BETWEEN 2000 AND 2999)
		ELSE
			SET @tempId = null
	END
	IF @tempId IS null
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
		SET @ErrorState	   = @ERROR_STATE
		SET @ErrorMessage  = @ErrorMessage + 'Invalid Component Id for Component Name['+ @componentNameVal +'].'
		IF (@put_invalid_id < 0)
			set @tempId= @put_invalid_id
	END
	IF (@tempId is not null)
	BEGIN
		SET @entityType = 60
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempIdVal IS null
			BEGIN
			 SET @var.modify('insert (attribute ComponentId {sql:variable("@tempId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@ComponentId)[1] with sql:variable("@tempId")')
		END
	END
end
GO

IF EXISTS (select * from GxQscripts where name = 'EntityComponentNameToId')
	delete from GxQscripts where name = 'EntityComponentNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityComponentNameToId')
	delete from GXDBVersions where aliasname = 'EntityComponentNameToId'
GO

insert into GXDBVersions values(2, 'EntityComponentNameToId',  '00010005008000020000', 'EntityComponentNameToId', '00010005008000020000')
GO

