

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityCategoryPermissionNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +======================================================================================================+
--  | Stored Precedure: EntityCategoryPermissionNameToId()
--  |
--  |   Revisions  	Author 							Description
--  |   ---------  	----------    				----------------------------------------
--  |   1.0			jswaminathan & saggarwal	EntityNameToIdConverter is broken into small procedures
--  +======================================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntityCategoryPermissionNameToId <<<'

IF EXISTS (select * from sysobjects where name='EntityCategoryPermissionNameToId')
	drop procedure EntityCategoryPermissionNameToId
IF EXISTS (select * from GxQscripts where name='EntityCategoryPermissionNameToId')
	delete from GxQscripts where name = 'EntityCategoryPermissionNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityCategoryPermissionNameToId')
	delete from GXDBVersions where aliasname = 'EntityCategoryPermissionNameToId'
GO
print '... Creating Procedure: EntityCategoryPermissionNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityCategoryPermissionNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replacevarlast INT
AS
declare @permissionName nvarchar(255)
declare @categoryName nvarchar(255)
declare @entityType int
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @tempPermissionId int
declare @permissionId int
declare @tempCategoryId int
declare @categoryId int
SET @permissionName = @temp.value('(//./@permissionName)[1]','nvarchar(255)')
SET @categoryName = @temp.value('(//./@categoryName)[1]','nvarchar(255)')
IF SUBSTRING(@permissionName,1,1) = '|'
	SET @permissionName = ( select dbo.DecodeInvalidXMLChar(@permissionName) )
IF SUBSTRING(@categoryName,1,1) = '|'
	SET @categoryName = ( select dbo.DecodeInvalidXMLChar(@categoryName) )
SET @tempPermissionId = @temp.value('(//./@permissionId)[1]','int')
SET @tempCategoryId = @temp.value('(//./@categoryId)[1]','int')
IF (@categoryName IS NOT NULL) AND (@permissionName IS NULL)
BEGIN
	IF @categoryName = 'All Permissions'
	BEGIN
SET @entityType =  123
		SET @categoryId = 0
		SET @categoryName = ''
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@categoryName)[1] with sql:variable("@categoryName")')
	END
	ELSE
	BEGIN
SET @entityType = 121
		SET @categoryId = (SELECT id FROM UMCategories WITH (NOLOCK) WHERE categoryname = @categoryName)
	END
	IF @categoryId IS NULL
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
        SET @ErrorState    = @ERROR_STATE
        SET @ErrorMessage  = @ErrorMessage + 'Invalid Category Id for category[' + @categoryName + '].'
		IF @tempCategoryId IS NOT NULL
			SET @categoryId = @tempCategoryID	--when we are trying setting security associations from a GUI that is non-english, then
												--the category name will be the category name in that locale. So in that case, we should
												--not try to error out / replace the category Id with invalid_id value
        ELSE IF (@put_invalid_id < 0)
			set @categoryId= @put_invalid_id
	END
	IF @categoryid IS NOT NULL
	BEGIN
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempCategoryId IS NULL
				SET @var.modify('insert (attribute categoryId {sql:variable("@categoryId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			ELSE
				SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@categoryId)[1] with sql:variable("@categoryId")')
		END
	END
END
IF @permissionName IS NOT NULL
BEGIN
	SET @categoryId = (SELECT categoryId FROM UMPermissions WHERE permissionName = @permissionName)
	SET @permissionId = (SELECT id FROM UMPermissions WHERE permissionName = @permissionName)
SET @entityType = 122
	IF @permissionId IS NULL
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
        SET @ErrorState    = @ERROR_STATE
        SET @ErrorMessage  = @ErrorMessage + 'Invalid Permission Id for permission [' + @permissionName + '].'
		IF @tempCategoryId IS NOT NULL
			SET @categoryId = @tempCategoryID	--when we are trying setting security associations from a GUI that is non-english, then
												--the category name will be the category name in that locale. So in that case, we should
												--not try to error out / replace the category Id with invalid_id value
        ELSE IF (@put_invalid_id < 0)
			set @categoryId= @put_invalid_id
		IF @tempPermissionId IS NOT NULL
			SET @permissionId = @tempPermissionId
        ELSE IF (@put_invalid_id < 0)
            set @permissionId= @put_invalid_id
	END
	IF @permissionId IS NOT NULL
	BEGIN
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempCategoryId IS NULL
				SET @var.modify('insert (attribute categoryId {sql:variable("@categoryId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			ELSE
				SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@categoryId)[1] with sql:variable("@categoryId")')
			IF @tempPermissionId IS NULL
				SET @var.modify('insert (attribute permissionId {sql:variable("@permissionId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			ELSE
				SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@permissionId)[1] with sql:variable("@permissionId")')
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'EntityCategoryPermissionNameToId')
	delete from GxQscripts where name = 'EntityCategoryPermissionNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityCategoryPermissionNameToId')
	delete from GXDBVersions where aliasname = 'EntityCategoryPermissionNameToId'
GO

insert into GXDBVersions values(2, 'EntityCategoryPermissionNameToId',  '00000000000000000000', 'EntityCategoryPermissionNameToId', '00000000000000000000')
GO

