

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EntityAlertNameToId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/EntityAlertNameToId.sp,v $ $Id: EntityAlertNameToId.sp,v 1.4.80.4 2018/03/27 08:10:55 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: EntityAlertNameToId()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Ravneet Singh Arora	 EntityNameToIdConverter is broken into small procedures
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EntityAlertNameToId <<<'

IF EXISTS (select * from sysobjects where name='EntityAlertNameToId')
	drop procedure EntityAlertNameToId
IF EXISTS (select * from GxQscripts where name='EntityAlertNameToId')
	delete from GxQscripts where name = 'EntityAlertNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityAlertNameToId')
	delete from GXDBVersions where aliasname = 'EntityAlertNameToId'
GO
print '... Creating Procedure: EntityAlertNameToId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EntityAlertNameToId
  @i int,
  @put_invalid_id int,
  @temp XML OUTPUT,
  @var XML OUTPUT,
  @ErrorSeverity int OUTPUT,
  @ErrorState int OUTPUT,
  @ErrorMessage nvarchar(4000) OUTPUT,
  @replaceVarLast INT,
  @userId INT
AS
DECLARE @ERROR_STATE			int
SET @ERROR_STATE		=		1
DECLARE @ERROR_SEVERITY			int
SET	@ERROR_SEVERITY		=		10
declare @alertNameVal nvarchar(255)
declare @tempIdVal int
declare @tempId int
SET @alertNameVal=@temp.value('(//./@alertName)[1]','nvarchar(255)')
 IF SUBSTRING(@alertNameVal,1,1) = '|'
	SET @alertNameVal= ( select dbo.DecodeInvalidXMLChar(@alertNameVal) )
-- Find organization for logged in user.
DECLARE @organizationId	integer = 0
if @userId>0
begin
	set @organizationId = dbo.AppGetOrganizationForUser(@userId)
end
--declare @storagePolicyNameVal nvarchar(255)
declare @entityType int
IF @alertNameVal IS NOT null
BEGIN
	SET @tempIdVal=@temp.value('(//./@alertId)[1]','nvarchar(255)')
	select @tempId=NTnotificationRule.id from NTnotificationRule
		left join NTNotificationProp on NTNotificationRule.id=NTNotificationProp.componentNameId
and NTNotificationProp.attrname='OrganizationId' and IsNumeric(NTNotificationProp.attrval)>0
	WHERE notificationName = @alertNameVal and NTNotificationRule.revision>0 and IsNull(NTNotificationProp.attrval,0)=@organizationId
	IF @tempId IS NULL
	BEGIN
		SET @ErrorSeverity = @ERROR_SEVERITY
		SET @ErrorState	   = @ERROR_STATE
		SET @ErrorMessage  = @ErrorMessage + 'Invalid Notification Rule Id for notificationName['+ @alertNameVal + '].'
		IF (@put_invalid_id < 0)
			set @tempId= @put_invalid_id
	END
	IF (@tempId is not null)
	BEGIN
		SET @entityType = 64
		BEGIN
			SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@_type_)[1] with sql:variable("@entityType")')
			IF @tempIdVal IS null
			BEGIN
			 SET @var.modify('insert (attribute alertId {sql:variable("@tempId")})into ((//*/.[@_type_])[sql:variable("@i")])[1]')
			END
			ELSE
			   SET @var.modify('replace value of ((//.[@_type_])[sql:variable("@i")]/@alertId)[1] with sql:variable("@tempId")')
		END
	END
end
GO

IF EXISTS (select * from GxQscripts where name = 'EntityAlertNameToId')
	delete from GxQscripts where name = 'EntityAlertNameToId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EntityAlertNameToId')
	delete from GXDBVersions where aliasname = 'EntityAlertNameToId'
GO

insert into GXDBVersions values(2, 'EntityAlertNameToId',  '00010004008000040000', 'EntityAlertNameToId', '00010004008000040000')
GO

