

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EDiscoverySetClientProperties.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "EDiscoveryGetAllClients"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EDiscoverySetClientProperties <<<'

IF EXISTS (select * from sysobjects where name='EDiscoverySetClientProperties')
	drop procedure EDiscoverySetClientProperties
IF EXISTS (select * from GxQscripts where name='EDiscoverySetClientProperties')
	delete from GxQscripts where name = 'EDiscoverySetClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoverySetClientProperties')
	delete from GXDBVersions where aliasname = 'EDiscoverySetClientProperties'
GO
print '... Creating Procedure: EDiscoverySetClientProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EDiscoverySetClientProperties
  @xmlText XML
AS
	Declare @inventoryDataSourceId int
	Declare @userId int = 0
	Declare @clientId int= 0
	Declare @timeNow int = dbo.GetUnixTime(GETUTCDATE())
    Declare  @errorCode int = 0
    declare @errorString nvarchar(max) =''
    SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
    SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'int') AS client
                              FROM    @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClient') R ( ref )),0)
    SET @inventoryDataSourceId = ISNULL((SELECT  ref.value('@seaDataSourceId', 'int') AS client
                              FROM    @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClientInfo/inventoryDataSource') R ( ref )),0)
    BEGIN TRY
    --Rights
    IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
        DROP TABLE #getIdaObjects
    CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @userId,3,0,1,'#getIdaObjects'
    IF NOT EXISTS (SELECT 1 FROM #getIdaObjects where clientId = @clientId)
	    GOTO EXIT_OUT
    MERGE App_EdgeDriveAssociation AS target
        USING (SELECT @clientId, @inventoryDataSourceId) AS source (clientId, inventoryDataSourceId)
ON (target.clientId = source.clientId and target.entityType = 132)
        WHEN MATCHED THEN
            UPDATE SET entityId = source.inventoryDataSourceId
        WHEN NOT MATCHED THEN
            INSERT (clientId, entitytype, entityId)
VALUES (source.clientId, 132, source.inventoryDataSourceId);
    END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode    = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
    EXIT_OUT:
    DROP TABLE #getIdaObjects
    SET @xmlText = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
    SELECT @xmlText xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'EDiscoverySetClientProperties')
	delete from GxQscripts where name = 'EDiscoverySetClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoverySetClientProperties')
	delete from GXDBVersions where aliasname = 'EDiscoverySetClientProperties'
GO

insert into GXDBVersions values(2, 'EDiscoverySetClientProperties',  '00000000000000000000', 'EDiscoverySetClientProperties', '00000000000000000000')
GO

