

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EDiscoveryGetUsers.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_getUsers"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EDiscoveryGetUsers <<<'

IF EXISTS (select * from sysobjects where name='EDiscoveryGetUsers')
	drop procedure EDiscoveryGetUsers
IF EXISTS (select * from GxQscripts where name='EDiscoveryGetUsers')
	delete from GxQscripts where name = 'EDiscoveryGetUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryGetUsers')
	delete from GXDBVersions where aliasname = 'EDiscoveryGetUsers'
GO
print '... Creating Procedure: EDiscoveryGetUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EDiscoveryGetUsers
  @callerId INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @includeUsersFlags int= ( CAST (0x001 AS INT) )
DECLARE @excludeUsersFlags int= ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
IF OBJECT_ID('tempdb.dbo.#UsersSec_getUsersEdiscoveryTbl')  IS NOT NULL
	DROP TABLE #UsersSec_getUsersEdiscoveryTbl
CREATE TABLE  #UsersSec_getUsersEdiscoveryTbl  ( userId int);
EXEC sec_getUsersForThisUser '#UsersSec_getUsersEdiscoveryTbl' ,@callerId,0,3,@excludeUsersFlags,@includeUsersFlags
IF OBJECT_ID('tempdb.dbo.#UsergroupsSec_getUsersNewTbl')  IS NOT NULL
	DROP TABLE #UsergroupsSec_getUsersNewTbl
CREATE TABLE #UsergroupsSec_getUsersNewTbl  ( userGroupId int primary key);
exec sec_getUserGroupsForThisUser '#UsergroupsSec_getUsersNewTbl',@callerId
DECLARE @UsersGroupsTemp TABLE (
				uId int,
				GroupName nvarchar(255)
				 )
DECLARE @UsersGroupListTemp TABLE (
				uId int,
				GroupName nvarchar(max)
				 )
DECLARE @UsersTemp TABLE (
				userId int,
				Name nvarchar(255),
				LoginName nvarchar(255),
				Email nvarchar(255),
				UserGUID nvarchar(256),
				Lastlogintime int DEFAULT 0,
				Enabled int DEFAULT 0,
				UserGroups nvarchar(max) default ''
				 )
INSERT INTO @UsersTemp(userId, Name,LoginName,Email, userGUID, lastlogintime, enabled)
			SELECT
				U.Id,
				U.name,
				U.login,
				U.email,
				U.userGuid,
				U.lastlogIntime,
				u.enabled
			FROM UMUsers U
			INNER JOIN #UsersSec_getUsersEdiscoveryTbl sec ON U.id=sec.userId
			WHERE (U.flags & @excludeUsersFlags = 0) AND (U.flags & @includeUsersFlags <> 0)
			order by name
--Populate user groups for users
INSERT INTO @UsersGroupsTemp
SELECT u.userid,
											   CASE WHEN UMGroups.umdsProviderId <= 0 THEN UMGroups.name
											   ELSE P.domainName + '\' + UMGroups.name
											   END
											FROM @UsersTemp u
											inner join UMUserGroup on UMUserGroup.userId = u.userid
											INNER JOIN UMGroups ON UMUserGroup.groupId = UMGroups.id
											INNER JOIN #UsergroupsSec_getUsersNewTbl Sec ON Sec.userGroupId = UMGroups.id
											LEFT OUTER JOIN UMDSProviders P ON P.id = UMGroups.umdsProviderID
insert into @UsersGroupListTemp
SELECT
       uid, SUBSTRING(d.groupNameList,1, LEN(d.groupNameList) - 1) groupNameList
FROM
        (
            SELECT DISTINCT [uId]
            FROM @UsersGroupsTemp
        ) a
        CROSS APPLY
        (
            SELECT [groupName] + ', '
            FROM @UsersGroupsTemp AS B
            WHERE A.[uId] = B.[uId]
            FOR XML PATH('')
        ) D (groupNameList)
UPDATE @UsersTemp set UserGroups=ISNULL(GroupName, '')
from @UsersGroupListTemp  where uid=userId
SELECT Name, LoginName,Email,UserGUID,Lastlogintime, Enabled, UserGroups from @UsersTemp order by userId asc
DROP TABLE #UsersSec_getUsersEdiscoveryTbl
DROP TABLE #UsergroupsSec_getUsersNewTbl
GO

IF EXISTS (select * from GxQscripts where name = 'EDiscoveryGetUsers')
	delete from GxQscripts where name = 'EDiscoveryGetUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryGetUsers')
	delete from GXDBVersions where aliasname = 'EDiscoveryGetUsers'
GO

insert into GXDBVersions values(2, 'EDiscoveryGetUsers',  '00000000000000000000', 'EDiscoveryGetUsers', '00000000000000000000')
GO

