

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EDiscoveryGetClientNodes.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_getUsers"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='EDiscoveryGetClientNodes')
BEGIN
	print '>>> Drop Stored Procedure: EDiscoveryGetClientNodes <<<'
	drop procedure EDiscoveryGetClientNodes
END
IF EXISTS (select * from GxQscripts where name='EDiscoveryGetClientNodes')
	delete from GxQscripts where name = 'EDiscoveryGetClientNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryGetClientNodes')
	delete from GXDBVersions where aliasname = 'EDiscoveryGetClientNodes'
GO
print '... Creating Procedure: EDiscoveryGetClientNodes'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure EDiscoveryGetClientNodes
  @clientId int, 
  @clientGroup int,
  @i_userId int,
  @i_offset int = 0,
  @i_limit int = 0, -- by default if no limit is sent, all clients are returned
  @i_nameFilter NVARCHAR(256) = '',
  @i_clientGroupFilter int = 0,
  @i_datasourceType varchar(MAX) = '',
  @o_totalClientCount int     OUTPUT,
  @o_totalDsCount int     OUTPUT,
  @i_dsDisplayNameFilter NVARCHAR(256) = '',
  @i_planNameFilter NVARCHAR(256) = '',
  @i_crawTypeFilter VARCHAR(255) = '',
  @i_SortBy INT = 0, -- 1: client display name, 2: datasource display name, 3: plan name, 4: crawlType
  @i_SortDir INT = 0 -- 0: ASC, 1: DESC
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @propertyId INT
DECLARE @crawlTypepropertyId INT
-- Constants
DECLARE @SORT_BY_CLIENT_DISPLAY_NAME INT = 1
DECLARE @SORT_BY_DS_DISPLAY_NAME INT = 2
DECLARE @SORT_BY_PLAN_NAME INT = 3
DECLARE @SORT_BY_CRAWL_TYPE INT = 4
DECLARE @SORT_DIR_ASC INT = 0
DECLARE @SORT_DIR_DESC INT = 1
IF(@i_userId > 0)
BEGIN
	SELECT @propertyId = PropertyId from SEProperty where PropertyName = 'includedirectoriespath'
	SELECT @crawlTypepropertyId = PropertyId from SEProperty where PropertyName = 'crawltype'
	IF OBJECT_ID('tempdb.dbo.#tempDsDetails') IS NOT NULL     DROP TABLE #tempDsDetails
	CREATE TABLE #tempDsDetails (
		clientId INTEGER,
		clientName NVARCHAR(256),
		clientDisplayName NVARCHAR(256),
		nethostName NVARCHAR(256),
		datasourceId INTEGER,
		subClientId INTEGER,
		subClientName NVARCHAR(256),
		includeDirectoryPath NVARCHAR(MAX),
		datasourceName NVARCHAR(256),
		dsDisplayName NVARCHAR(256),
		datasourceType NVARCHAR(256),
		crawlType INTEGER,
		planName NVARCHAR(255) DEFAULT ''
	)
	CREATE INDEX clientId_idx ON #tempDsDetails(clientId)
	CREATE INDEX clientDisplayName_idx ON #tempDsDetails(clientDisplayName)
	CREATE INDEX clientName_idx ON #tempDsDetails(clientName)
	CREATE INDEX datasourceId_idx ON #tempDsDetails(datasourceId)
	CREATE INDEX dsDisplayName_idx ON #tempDsDetails(dsDisplayName)
	CREATE INDEX datasourceName_idx ON #tempDsDetails(datasourceName)
	-- create index for plan if filter is requested
	IF (@i_planNameFilter <> '')
	BEGIN
		CREATE INDEX planName_idx ON #tempDsDetails(planName)
	END
	-- Create index for sorting depending on which column is requested
	--
	IF (@i_SortBy = @SORT_BY_PLAN_NAME)
		IF (@i_SortDir = 0)
			CREATE INDEX planOrderAsc_idx ON #tempDsDetails(planName ASC, dsDisplayName, datasourceName)
		ELSE
			CREATE INDEX planOrderDesc_idx ON #tempDsDetails(planName DESC, dsDisplayName, datasourceName)
	ELSE IF (@i_SortBy = @SORT_BY_CRAWL_TYPE)
		IF (@i_SortDir = 0)
			CREATE INDEX crawTypeOrderAsc_idx ON #tempDsDetails(crawlType ASC, dsDisplayName, datasourceName)
		ELSE
			CREATE INDEX crawTypeOrderDesc_idx ON #tempDsDetails(crawlType DESC, dsDisplayName, datasourceName)
	ELSE IF (@i_SortBy > 0 OR @i_limit > 0)
	-- only create index when explicit sort by or pagination is requested
	--
	BEGIN
		-- default search by datasource display name and client name within a client
		IF (@clientId > 0)
			IF (@i_SortDir = 0)
				CREATE INDEX dsDisplayNameOrderAsc_idx ON #tempDsDetails(dsDisplayName ASC, datasourceName)
			ELSE
				CREATE INDEX dsDisplayNameOrderDesc_idx ON #tempDsDetails(dsDisplayName DESC, datasourceName)
		ELSE
		-- default search by clientdisplayname and clientname
			IF (@i_SortDir = 0)
				CREATE INDEX clientDisplayNameOrderAsc_idx ON #tempDsDetails(clientDisplayName ASC, clientName)
			ELSE
				CREATE INDEX clientDisplayNameOrderDesc_idx ON #tempDsDetails(clientDisplayName DESC, clientName)
	END
--
-- Table to be used by SP sec_getIDAObjectsForUserWithPrivacy
--
IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
BEGIN
    DROP TABLE #ClientsOutputTable
END
--
CREATE TABLE #ClientsOutputTable
(
	clientID INT,
	appTypeId INT,
	instanceId INT,
	backupsetID INT,
	subclientId INT
)
CREATE INDEX clientID_idx ON #ClientsOutputTable(clientID)
--
-- Fetch any clients even if any sub client is allowed under that client for the logged-in user
-- This behavior of inheriting permission from child also can be changed as per input in future if needed
--
EXEC sec_getIDAObjectsForUserWithPrivacy @i_userId, 3, 13, 1, '#ClientsOutputTable', 1
IF @clientGroup = 0
BEGIN
INSERT INTO #tempDsDetails
SELECT  ap.id, ap.name, ap.DisplayName, ap.net_hostname, acp.attrVal, 0 , '' , null ,sd.DataSourceName , sd.DisplayName , sdt.TypeName , null, ''
 FROM
App_client ap  WITH(NOLOCK)
INNER JOIN APP_ClientProp acp  WITH(NOLOCK)ON
acp.componentNameId = ap.id
INNER JOIN  SEDataSource sd  WITH(NOLOCK) ON
acp.attrVal =sd.DataSourceId
INNER JOIN  SEDataSourceType sdt  WITH(NOLOCK) ON
sdt.TypeId =sd.DataSourceType
WHERE
 acp.attrName = N'Indexing datasource id'
 AND acp.attrVal > 0
 AND acp.modified =0
 AND (@clientId = 0 OR ap.id = @clientId)
UNION
SELECT  ap.id , ap.name, ap.DisplayName, ap.net_hostname , acp.attrVal , app.id , app.subclientName  , null ,sd.DataSourceName , sd.DisplayName , sdt.TypeName , null, ''
FROM
	App_client ap  WITH(NOLOCK)
INNER JOIN APP_Application app  WITH(NOLOCK) ON
	app.clientId = ap.id
INNER JOIN APP_SubClientProp acp  WITH(NOLOCK) ON
	acp.componentNameId = app.id
INNER JOIN  SEDataSource sd  WITH(NOLOCK) ON
acp.attrVal =sd.DataSourceId
INNER JOIN  SEDataSourceType sdt  WITH(NOLOCK) ON
sdt.TypeId =sd.DataSourceType
WHERE
 acp.attrName = N'Indexing datasource id'
 AND acp.attrVal > 0
 AND acp.modified =0
 AND (@clientId = 0 OR ap.id = @clientId)
 UNION
 SELECT distinct c.id, c.name, c.displayName, c.net_hostname, bsp.attrVal, sc.id, sc.subclientName, null, sd.DataSourceName, sd.DisplayName, sdt.TypeName, 0, ''
	from  (select cp.componentNameId AS clientId, cp.attrName as attrName, cp.attrVal as attrVal
	FROM APP_ClientProp cp with(nolock) where cp.attrName in ('Virtual Machine Catalog Job Id', 'VSA Discover Subclient ID')
	AND cp.modified =0) AS SRC
	PIVOT
	(
		MAX(attrVal) FOR attrName in ([Virtual Machine Catalog Job Id] , [VSA Discover Subclient ID])
		)AS pvt
	inner join app_client c with(nolock) on
	pvt.clientId = c.id
	inner join APP_Application sc with(nolock) on
	PVT.[VSA Discover Subclient ID] = sc.id
	INNER JOIN APP_BackupSetName bs with(nolock) on
	sc.backupSet = bs.id
	INNER JOIN APP_BackupSetProp bsp with(nolock) on
	bsp.attrName = N'Indexing datasource id'
	AND bsp.attrVal > 0
	AND bsp.modified =0
	and bsp.componentNameId = bs.id
	INNER JOIN  SEDataSource sd  WITH(NOLOCK) ON
	bsp.attrVal =sd.DataSourceId
	INNER JOIN  SEDataSourceType sdt  WITH(NOLOCK) ON
	sdt.TypeId =sd.DataSourceType
    WHERE  ISNULL(pvt.[Virtual Machine Catalog Job Id], 0) > 0
	AND (@clientId = 0 OR c.id = @clientId)
--delete the dummy subclient record, if the same client,datasource combo is found at client as well as subclient level.
 DELETE A FROM #tempDsDetails AS  A INNER JOIN #tempDsDetails AS B ON A.datasourceId = B.datasourceId AND A.clientId = B.clientId
 WHERE  A.subClientId = 0 AND B.subClientId > 0
 -- honor security configuration by removing all clients which are not in the view clients list
 --
 DELETE T FROM #tempDsDetails T
 LEFT JOIN #ClientsOutputTable C ON C.clientID = T.clientId
 WHERE ISNULL(C.clientID,0) = 0
    -- honor client group filter
    --
    IF @i_clientGroupFilter <> 0
    BEGIN
	DECLARE @associatedEntitiesTable TABLE
    (
        xmlval xml
    )
	declare @associatedEntitiesRequest xml
    SET @associatedEntitiesRequest = (
            SELECT 3 '@expandLevel',
                (
                    SELECT @i_clientGroupFilter AS '@clientGroupId'
                    FOR XML PATH('entity'),
                        TYPE
                    )
            FOR XML PATH('App_GetAssociatedEntities'),
                TYPE
            )
	declare @associatedEntitiesResponse xml
    INSERT INTO @associatedEntitiesTable
    EXEC dbo.GetAssociatedEntities @associatedEntitiesRequest
    SET @associatedEntitiesResponse = ISNULL((select top 1 xmlval from @associatedEntitiesTable),'<App_GenericResponse/>')
    DECLARE @inTable table
    (
        clientId integer
    )
    INSERT INTO @inTable
    SELECT
    ISNULL(s.ref.value('@clientId', 'int'),0)
    FROM @associatedEntitiesResponse.nodes('/App_GenericResponse/response')  Tbl(Col)
        OUTER APPLY Col.nodes('entity') S(ref)
	delete from #tempDsDetails where clientId not in (select clientId from @inTable)
    END
 END
 ELSE
 BEGIN
 INSERT INTO #tempDsDetails
SELECT  ap.id, ap.name, ap.name, ap.name, acp.attrVal, 0 , '' , null ,sd.DataSourceName , sd.DisplayName , sdt.TypeName , null,''
 FROM
APP_ClientGroup ap  WITH(NOLOCK)
INNER JOIN APP_ClientGroupProp acp  WITH(NOLOCK)ON
acp.componentNameId = ap.id
INNER JOIN  SEDataSource sd  WITH(NOLOCK) ON
acp.attrVal =sd.DataSourceId
INNER JOIN  SEDataSourceType sdt  WITH(NOLOCK) ON
sdt.TypeId =sd.DataSourceType
WHERE
 acp.attrName = N'Indexing datasource id'
 AND acp.attrVal > 0
 AND acp.modified =0
 AND (@clientId = 0 OR ap.id = @clientId)
END
 UPDATE DS
SET DS.includeDirectoryPath =  DSD.includedirectoriespath,
	DS.crawlType = DSD.crawlType
FROM
(SELECT dsId,
	includedirectoriespath AS includedirectoriespath,
	ISNULL(crawlType, '0') AS crawlType
	 FROM
(SELECT DSP.dataSourceId AS dsId, P.PropertyName AS propName, DSP.PropertyValue as propValue
FROM SEDataSourceProperty DSP WITH (NOLOCK)
INNER JOIN SEProperty P
ON DSP.PropertyId = P.PropertyId
AND P.PropertyName IN ('includedirectoriespath', 'crawltype')
) AS SRC
PIVOT
(
	MAX(propValue) FOR propName in (includedirectoriespath, crawltype)
	)AS PVT) AS DSD
INNER JOIN #tempDsDetails DS
ON DS.dataSourceId = DSD.dsId
IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
BEGIN
    DROP TABLE #ClientsOutputTable
END
	IF (@i_datasourceType <> '')
	BEGIN
		-- honor datasourcetype filter if any
		IF OBJECT_ID('tempdb.dbo.#populateDsType') IS NOT NULL
			DROP TABLE #populateDsType
		CREATE TABLE #populateDsType(datasourceType NVARCHAR(256));
		INSERT INTO #populateDsType
		SELECT data FROM dbo.SplitString((@i_datasourceType),',')
		DELETE T FROM #tempDsDetails T
		LEFT JOIN #populateDsType P ON P.datasourceType = T.datasourceType
		WHERE ISNULL(P.datasourceType,'') = ''
		IF OBJECT_ID('tempdb.dbo.#populateDsType') IS NOT NULL
			DROP TABLE #populateDsType
	END
	-- honor crawltype filter if any
	IF (@i_crawTypeFilter <> '')
	BEGIN
		-- honor crawltype filter if any
		IF OBJECT_ID('tempdb.dbo.#populateCrawlType') IS NOT NULL
			DROP TABLE #populateCrawlType
		CREATE TABLE #populateCrawlType(crawlType INT);
		INSERT INTO #populateCrawlType
		SELECT _ID FROM dbo.SplitIDs(@i_crawTypeFilter)
		DELETE T FROM #tempDsDetails T
		LEFT JOIN #populateCrawlType P ON P.crawlType = T.crawlType
		WHERE ISNULL(P.crawlType, 0) = 0
		IF OBJECT_ID('tempdb.dbo.#populateCrawlType') IS NOT NULL
			DROP TABLE #populateCrawlType
	END
	-- check if need to sort by plan name or filter by plan name, if yes then need to update list with plan name and sort
	-- plan name sort can only available when clientid > 0
	IF (@i_SortBy = @SORT_BY_PLAN_NAME OR @i_planNameFilter <> '')
	BEGIN
		UPDATE #tempDsDetails
		-- honor plan name filter if any
		SET planName = A.name
		FROM SEDataSourceProperty DSP WITH(NOLOCK)
		INNER JOIN SEProperty P WITH(NOLOCK) ON P.PropertyId = DSP.PropertyId AND P.PropertyName = 'dcplanid'
		INNER JOIN #tempDsDetails T ON T.datasourceId = DSP.DataSourceId
		INNER JOIN App_Plan A WITH(NOLOCK) ON CAST(A.id AS NVARCHAR) = DSP.PropertyValue
	END
	-- initialize sort direction
	DECLARE @sortDirection AS VARCHAR(4)
	SET @sortDirection = (SELECT CASE WHEN @i_SortDir = 0 THEN 'ASC' ELSE 'DESC' END)
	-- form sort order when explicitly requested
	--
	DECLARE @orderBy AS NVARCHAR(MAX) = ''
	IF (@clientId > 0)
	BEGIN
		-- sort by plan, craw type, datasource display name,
		-- it has to go with datasource name to make sure the order is consistent
		--
		IF (@i_SortBy = @SORT_BY_PLAN_NAME)
			SET @orderBy = @orderBy + ' planName ' + @sortDirection + ', dsDisplayName, datasourceName'
		ELSE IF (@i_SortBy = @SORT_BY_CRAWL_TYPE)
			SET @orderBy = @orderBy + ' crawlType ' + @sortDirection + ', dsDisplayName, datasourceName'
		ELSE IF (@i_SortBy > 0 OR @i_limit > 0)
			SET @orderBy = @orderBy + ' dsDisplayName ' + @sortDirection + ', datasourceName'
	END
	ELSE IF (@i_SortBy > 0 OR @i_limit > 0)
	BEGIN
		SET @orderBy = 'clientDisplayName ' + @sortDirection + ', clientName '
	END
	-- honoring filter by parameters
	--
	DECLARE @filterWithinClient AS NVARCHAR(255) = N'(@i_dsDisplayNameFilter = '''' OR datasourceName LIKE @i_dsDisplayNameFilter)
														AND (@i_planNameFilter = '''' OR planName LIKE @i_planNameFilter) '
	DECLARE @filterClients AS NVARCHAR(255) = N'@i_nameFilter = '''' OR clientDisplayName LIKE @i_nameFilter'
	-- params for string query
	--
	DECLARE @paramsWithinClient NVARCHAR(256)
	DECLARE @paramsClient NVARCHAR(256)
	DECLARE @params NVARCHAR(256)
	SET @paramsWithinClient = '@i_dsDisplayNameFilter NVARCHAR(256), @i_planNameFilter NVARCHAR(256)'
	SET @paramsClient = '@i_nameFilter NVARCHAR(256)'
	-- form query to select and honor sorting
	--
	DECLARE @query AS NVARCHAR(MAX)
	IF (@i_limit <= 0)
	-- no pagination, only sort when explicit sort column is requested, otherwise returns as it is
		BEGIN
		SET @params = @paramsClient + ',' + @paramsWithinClient
			-- return all results, if client name filter is provided, return all results which match client name filter if provided
		SET @query = N'
			SELECT * FROM #tempDsDetails
			WHERE (' + @filterClients + ') AND ' + @filterWithinClient
		-- honor sort by if explicitly requested
		IF (@i_SortBy > 0)
			SET @query = @query + '	ORDER BY ' + @orderBy
		EXECUTE sp_Executesql @query, @params, @i_nameFilter, @i_dsDisplayNameFilter, @i_planNameFilter
			SET @o_totalDsCount = @@rowcount
			SET @o_totalClientCount = (SELECT COUNT(DISTINCT clientId) FROM #tempDsDetails WHERE (@i_nameFilter = '') OR (clientDisplayName LIKE @i_nameFilter))
		END
	ELSE
		BEGIN
		DECLARE @paramsPagination NVARCHAR(256)
		SET @paramsPagination = '@i_offset INT, @i_limit INT'
			-- make sure to have valid offset to apply pagination
			IF (@i_offset < 0)
				SET @i_offset = 0
			IF (@clientId > 0)
				-- pagination on listing datasources within a client
		-- filter based on datasource display name, crawtype, plan is only available within a client (clientid > 0)
				BEGIN
			SET @query = N'
					SELECT *
					FROM
						(
					SELECT *, ROW_NUMBER() OVER
						(ORDER BY '
							+ @orderBy + '
						) AS RN
							FROM #tempDsDetails
					WHERE ' + @filterWithinClient + '
						) TEMP
					WHERE TEMP.RN > @i_offset AND TEMP.RN <= @i_offset + @i_limit
			ORDER BY TEMP.RN '
			SET @params = @paramsWithinClient + ',' + @paramsPagination
			EXECUTE sp_Executesql @query, @params, @i_dsDisplayNameFilter, @i_planNameFilter, @i_offset, @i_limit
			SET @o_totalDsCount = (SELECT COUNT(datasourceId) FROM #tempDsDetails
									WHERE (@i_dsDisplayNameFilter = '' OR datasourceName LIKE @i_dsDisplayNameFilter)
											AND (@i_planNameFilter = '' OR planName LIKE @i_planNameFilter))
					SET @o_totalClientCount = 1
				END
			ELSE
				-- pagination on listing clients / client group (for client only)
				BEGIN
				-- first get list of distinct client id and client display name
				--
				IF OBJECT_ID('tempdb.dbo.#clientLists') IS NOT NULL
					DROP TABLE #clientLists
				CREATE TABLE #clientLists (
					clientId INTEGER,
					clientName NVARCHAR(256),
					clientDisplayName NVARCHAR(256)
				)
				CREATE INDEX clientDisplayName_idx ON #clientLists(clientDisplayName)
			IF (@i_SortDir = 0)
				CREATE INDEX clientOrderAsc_idx ON #clientLists(clientDisplayName ASC, clientName)
			ELSE
				CREATE INDEX clientOrderDesc_idx ON #clientLists(clientDisplayName DESC, clientName)
			-- get list of clients into temp table
			--
			INSERT INTO #clientLists
			SELECT DISTINCT clientId, clientName, clientDisplayName
			FROM #tempDsDetails
			SET @query = N'
				SELECT *
				FROM #tempDsDetails
				WHERE clientId IN
					(
						SELECT clientId
						FROM
						(
						SELECT clientId, ROW_NUMBER() OVER
						(ORDER BY ' + @orderBy + ') AS RN
							FROM #clientLists
						WHERE ((@i_nameFilter = '''') OR (clientDisplayName LIKE @i_nameFilter))
						) TEMP
						WHERE TEMP.RN > @i_offset AND TEMP.RN <= @i_offset + @i_limit
					)
			ORDER BY ' + @orderBy
			SET @params = @paramsClient + ',' + @paramsPagination
			EXECUTE sp_Executesql @query, @params, @i_nameFilter, @i_offset, @i_limit
			SET @o_totalDsCount = (SELECT COUNT(datasourceId) FROM #tempDsDetails WHERE ((@i_nameFilter = '') OR (clientDisplayName LIKE @i_nameFilter)))
			SET @o_totalClientCount = (SELECT COUNT(clientId) FROM #clientLists WHERE ((@i_nameFilter = '') OR (clientDisplayName LIKE @i_nameFilter)))
				IF OBJECT_ID('tempdb.dbo.#clientLists') IS NOT NULL
					DROP TABLE #clientLists
			END
		END
END
IF OBJECT_ID('tempdb.dbo.#tempDsDetails') IS NOT NULL     DROP TABLE #tempDsDetails
GO

IF EXISTS (select * from GxQscripts where name = 'EDiscoveryGetClientNodes')
	delete from GxQscripts where name = 'EDiscoveryGetClientNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryGetClientNodes')
	delete from GXDBVersions where aliasname = 'EDiscoveryGetClientNodes'
GO

insert into GXDBVersions values(2, 'EDiscoveryGetClientNodes',  '00000000000000000000', 'EDiscoveryGetClientNodes', '00000000000000000000')
GO

