

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EDiscoveryGetAllClients.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "EDiscoveryGetAllClients"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='EDiscoveryGetAllClients')
BEGIN
	print '>>> Drop Stored Procedure: EDiscoveryGetAllClients <<<'
	drop procedure EDiscoveryGetAllClients
END
IF EXISTS (select * from GxQscripts where name='EDiscoveryGetAllClients')
	delete from GxQscripts where name = 'EDiscoveryGetAllClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryGetAllClients')
	delete from GXDBVersions where aliasname = 'EDiscoveryGetAllClients'
GO
print '... Creating Procedure: EDiscoveryGetAllClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure EDiscoveryGetAllClients
  @callerId INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @csTimeZone varchar(255)
IF object_id('tempdb.dbo.#ClientListTbl') IS NOT null DROP TABLE #ClientListTbl
CREATE TABLE #ClientListTbl (
    [ClientId]              INT,
    [Nethostname]           NVARCHAR(255),
    [Name]					NVARCHAR(255),
    [csHostName]			NVARCHAR(255),
	[ClientGUID]			VARCHAR(40),
    [JObResultDir]          NVARCHAR(1024),
    [refTime]				INT,
    [modified]				INT,
    [AppType]               INT,
    [operatingSystem]       NVARCHAR(255) DEFAULT '',
    [InstanceType]			INT DEFAULT (-1),
	[OperatingSystemSubType]	NVARCHAR(255),
[ObjectType]			INT  DEFAULT 3,  -- CLIENT_ENTITY
	[isExchangeClient]		INT	DEFAULT 0
)
SET @csTimeZone = (SELECT TOP 1 attrVal FROM APP_ClientProp WHERE attrName ='Commcell timezone Id' AND modified=0)
-- create the client property temporary table
IF object_id('tempdb.dbo.#clientPropTbl') IS NOT null DROP TABLE #clientPropTbl
CREATE TABLE #clientPropTbl (
    cId							INT,
	[location]					VARCHAR(MAX)        DEFAULT(''),
    [BackedupStatus]			INT DEFAULT(0),
    [LastBackupTime]			INT DEFAULT (0),
    [ContentIndexingStatus]		INT DEFAULT (0),
    [CICloudId]					INT DEFAULT (0)
	)
-- visibility check
IF OBJECT_ID('tempdb.dbo.#allowedClientList') IS NOT NULL
	DROP TABLE #allowedClientList
CREATE TABLE #allowedClientList (clientId INT, apptypeId INT, instanceId INT, backupsetId INT, subclientId INT)
IF OBJECT_ID('tempdb.dbo.#visibleClientList') IS NOT NULL
	DROP TABLE #visibleClientList
CREATE TABLE #visibleClientList (clientId INT, apptypeId INT, instanceId INT, backupsetId INT, subclientId INT)
EXEC sec_getIdaObjectsForUser @callerId,
3,
							0,
							1,
							'#allowedClientList'
-- join APP_Application to get apptype, instance, backupset, subclient info
INSERT INTO #visibleClientList
SELECT Apl.clientId, Apl.apptypeId, Apl.instance, Apl.backupset, Apl.id
FROM #allowedClientList A JOIN APP_APplication Apl
ON A.clientId = Apl.clientId
IF OBJECT_ID('tempdb.dbo.#allowedClientList') IS NOT NULL
	DROP TABLE #allowedClientList
--DELETE file system PSEUDOCLIENT WITH NO PACKAGE EXCEPT NAS OS TYPE AND Cluster VM client
DELETE cl FROM #visibleClientList cl
JOIN APP_Client ap (NOLOCK) ON cl.ClientId = ap.id
JOIN simOperatingSystem OS (NOLOCK) ON ap.simOperatingSystemId =OS.id
LEFT JOIN APP_VMToPMMap VM (NOLOCK) ON cl.ClientId = VM.VMClientId
WHERE
cl.apptypeId = 33 AND
ap.specialClientFlags & 0x2 !=0
AND subtype != 'NAS'
AND VM.VMClientId IS NULL
--DELETE PSEUDO INDEX SERVER WITH NO PACKAGE
DELETE cl FROM #visibleClientList cl
INNER JOIN APP_Client(NOLOCK) ap
ON cl.ClientId = ap.id
INNER JOIN App_ClientProp(NOLOCK) prop
ON prop.componentNameId= ap.id
WHERE
cl.apptypeId = 64  AND
prop.attrName = 'Index Server Type'  AND
prop.attrVal IN (10 , 14, 15)
IF object_id('tempdb.dbo.#idaInfoTbl') IS NOT null DROP TABLE #idaInfoTbl
CREATE TABLE #idaInfoTbl
(
    [r_clientId] INT DEFAULT(0),
    [r_appName] nvarchar(MAX) DEFAULT(''),
    [r_appTypeIds] nvarchar(MAX) DEFAULT(''),
    [ClientGroup]            VARCHAR(MAX)        DEFAULT('')
)
DECLARE @appTypeTable TABLE (
    appTypeId       INT PRIMARY KEY
)
INSERT INTO @appTypeTable values (22) --ORACLE
INSERT INTO @appTypeTable values (81) --MSSQL
INSERT INTO @appTypeTable values (134)  --ONE DRIVE
INSERT INTO @appTypeTable values (78) --SHAREPOINT
INSERT INTO @appTypeTable values (137) --exchange pseudoclient
INSERT INTO @appTypeTable
SELECT DISTINCT appTypeId
FROM GetAppTypesForAppGroup(35,0)--FS
UNION
SELECT DISTINCT appTypeId
FROM GetAppTypesForAppGroup(25,0)--Exchange
INSERT INTO #ClientListTbl(Clientid, Nethostname,name,csHostName,ClientGUID,JObResultDir,refTime,modified,operatingSystem, OperatingSystemSubType, AppType)
SELECT distinct c.id, c.net_hostname, c.name, c.csHostName,c.GUID, c.jobResultDir, c.refTime, c.modified, simOs.Name, simOs.SubType, vis.appTypeId
FROM APP_Client c
LEFT JOIN  APP_ClientProp cp
ON      cp.componentNameId = c.id and cp.attrName ='PlatformDeleted 4' and cp.attrVal = 1 and cp.modified = 0
INNER JOIN #visibleClientList vis  on c.id=vis.clientId
INNER JOIN @appTypeTable apptype on apptype.appTypeId=vis.apptypeId
INNER JOIN simOperatingSystem (NOLOCK) simOs on simOs.id =c.simOperatingSystemId
WHERE    cp.componentNameId is null and C.status & 0x10000000 /*0x10000000*/ = 0
 INSERT INTO #clientPropTbl (cid, location,ContentIndexingStatus)
       SELECT  componentNameId                 AS clientId,
                [timezone Id]             AS timezone,
                [Content Indexing Enabled]                AS contentIndexingEnabled
        FROM (
                SELECT
                    componentNameId,
                    attrName,
                    attrVal
                FROM
                     App_ClientProp cp
					 INNER JOIN  #ClientListTbl C ON
                        c.clientId = cp.componentNameId
                        AND cp.modified = 0
                        AND attrName IN ('timezone Id',
                                'Content Indexing Enabled'
								)
								)
AS clients
        PIVOT   (   MAX(attrVal) FOR attrName IN (  [timezone Id],
                                [Content Indexing Enabled])) As p
DECLARE @appType35Table TABLE (
		appTypeId		INT PRIMARY KEY
	)
	INSERT INTO @appType35Table
		SELECT DISTINCT appTypeId
		FROM GetAppTypesForAppGroup(35,0)
--update ContentIndexingSTatus for FS
UPDATE #clientPropTbl
SET ContentIndexingStatus = 2
WHERE cId in (select sc.clientId from APP_SubClientProp scp inner join app_application sc on scp.componentNameId = sc.id where scp.attrName = 'Enable Content Indexing' and scp.modified = 0 and scp.attrVal <> 0)
-- Insert into prop table to update the lastbackup of all the clients
INSERT INTO #clientPropTbl (cId)
SELECT c.ClientId FROM #ClientListTbl c
LEFT OUTER JOIN #clientPropTbl prop ON c.ClientId=prop.cId
WHERE prop.cId IS NULL
update #clientPropTbl set LastBackupTime =(
SELECT MAX(servEndDate) FROM JMBkpStats
INNER JOIN APP_Application a ON a.id= JMBkpStats.appId -- and appType in  (SELECT appTypeId FROM @appType35Table) The app type check is not needed as pseudoclient may contains file system app type.. eg NAS
INNER JOIN #ClientListTbl c ON c.ClientId=a.clientId
WHERE STATUS IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
AND opType <> 14 and c.ClientId = cId)
--update BackedupStatus
UPDATE cp
SET BackedupStatus = CASE when (dbo.IsIndexingV2Enabled(c.ClientId, c.AppType, 0) <> 0) then 2 else 1 end
FROM #clientPropTbl cp
INNER JOIN #ClientListTbl c ON c.ClientId = cp.cId
WHERE LastBackupTime > 0
UPDATE  p
SET p.[InstanceType] = ip.attrVal
FROM #ClientListTbl P
LEFT OUTER JOIN  APP_Application a ON
a.clientId = P.ClientId
LEFT OUTER JOIN APP_InstanceProp ip ON a.instance = ip.componentNameId
WHERE
 ip.attrname = 'Cloud Apps Instance Type' --update the cloud app props.
--check for exchange client
UPDATE  p
SET p.[isExchangeClient] = 1
FROM #ClientListTbl P
WHERE (appType = 137 OR appType IN (SELECT DISTINCT appTypeId FROM GetAppTypesForAppGroup(25,0)))
AND P.operatingSystem != 'Reference Copy Client'
--GET ida
INSERT INTO #idaInfoTbl
SELECT
       clientId, SUBSTRING(d.idaNameList,1, LEN(d.idaNameList) - 1) idaNameList , SUBSTRING(e.appTypeIds,1, LEN(e.appTypeIds) - 1) appTypeIds , SUBSTRING(G.clientGroupList,1, LEN(G.clientGroupList) - 1) clientGroups
FROM
        (
            SELECT DISTINCT [clientId]
            FROM #visibleClientList
        ) a
        CROSS APPLY
        (
            SELECT DISTINCT [displayName] + ', '
            FROM #visibleClientList AS B
			INNER JOIN APP_iDAType I ON I.type=B.apptypeId
            WHERE A.[clientId] = B.[clientId]
            FOR XML PATH('')
        ) D (idaNameList)
	CROSS APPLY
        (
            SELECT DISTINCT cast(apptypeId as nvarchar(5)) + ','
            FROM #visibleClientList AS B
			INNER JOIN APP_iDAType I ON I.type=B.apptypeId
            WHERE A.[clientId] = B.[clientId]
            FOR XML PATH('')
        ) E (appTypeIds)
		CROSS APPLY
        (
            SELECT ag.name + ', '
            FROM APP_ClientGroupAssoc aga
			INNER  JOIN APP_ClientGroup ag ON
			ag.id= aga.clientGroupId
			WHERE 	aga.clientId = a.clientId
            FOR XML PATH('')
        ) G (clientGroupList)
--Include Client Group
DECLARE @isAllAssociationsSetVisibilty INT = 0
--get ALL association COMMCELL LEVEL check with Visibilty permission
EXEC sec_checkPermissionOnEntity @callerId, 31 /*EV_VISIBILITY*/, @isAllAssociationsSetVisibilty OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
IF OBJECT_ID('tempdb.dbo.#sec_ClientGroupEntity') IS NOT NULL     DROP TABLE #sec_ClientGroupEntity
CREATE  TABLE #sec_ClientGroupEntity ( clientGroupId INT)
--Get all client groups with EV_VISIBILITY CAPABILITY
IF @isAllAssociationsSetVisibilty =0
EXEC sec_getNonIdaObjectsForThisUser @callerId, 28 /*CLIENT_GROUP_ENTITY*/ ,  31 /*EV_VISIBILITY*/ ,'#sec_ClientGroupEntity'
--client groups
INSERT INTO #ClientListTbl ( [ClientId], [Name], [Nethostname], [ClientGUID], [refTime], [modified], [ObjectType])
SELECT id, name, name, GUID, refTime, modified, 28
FROM APP_ClientGroup CG
LEFT JOIN #sec_ClientGroupEntity T ON CG.id = T.clientGroupId AND @isAllAssociationsSetVisibilty =0
--always set ConteIndexingStatus as true for all the exchange clients
--output
select c.ClientId, c.Nethostname, c.Name,c.csHostName, c.JObResultDir , c.ClientGUID , c.refTime,c.modified , ISNULL( p.location, @csTimeZone) as 'location',
P.BackedupStatus as 'BackedupStatus', p.LastBackupTime,
(CASE WHEN C.isExchangeClient = 1 THEN 1 ELSE ISNULL( p.ContentIndexingStatus, 0) END) as 'ContentIndexingStatus' ,
ISNULL(p.[CICloudId],0) as 'CICloudId', I.r_appName, I.r_appTypeIds,c.operatingSystem, c.InstanceType, I.ClientGroup, ObjectType, C.OperatingSystemSubType
FROM #ClientListTbl c
Left outer join #clientPropTbl p on p.cId = c.ClientId AND C.ObjectType = 3
LEFT OUTER JOIN #idaInfoTbl I ON I.r_clientId = C.ClientId AND C.ObjectType = 3
ORDER BY c.ObjectType
DROP TABLE #idaInfoTbl
DROP TABLE #visibleClientList
DROP TABLE #ClientListTbl
DROP TABLE #clientPropTbl
DROP TABLE #sec_ClientGroupEntity
GO

IF EXISTS (select * from GxQscripts where name = 'EDiscoveryGetAllClients')
	delete from GxQscripts where name = 'EDiscoveryGetAllClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryGetAllClients')
	delete from GXDBVersions where aliasname = 'EDiscoveryGetAllClients'
GO

insert into GXDBVersions values(2, 'EDiscoveryGetAllClients',  '00000000000000000000', 'EDiscoveryGetAllClients', '00000000000000000000')
GO

