

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/EDiscoveryAuditOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  EDiscoveryAuditOperation()
--  | Description:  Perform the audit operation for the EDiscovery Entities
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EDiscoveryAuditOperation <<<'

IF EXISTS (select * from sysobjects where name='EDiscoveryAuditOperation')
	drop procedure EDiscoveryAuditOperation
IF EXISTS (select * from GxQscripts where name='EDiscoveryAuditOperation')
	delete from GxQscripts where name = 'EDiscoveryAuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryAuditOperation')
	delete from GXDBVersions where aliasname = 'EDiscoveryAuditOperation'
GO
print '... Creating Procedure: EDiscoveryAuditOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EDiscoveryAuditOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML = '',
  @i_entityType INT,
  @i_entityId INT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @opMsgId INTEGER
	DECLARE @userId INTEGER
	DECLARE @opEvMsgId INTEGER
	DECLARE @opId INTEGER
	DECLARE @paramMsgId INTEGER
	DECLARE @paramDataXml XML
	DECLARE @paramData NVARCHAR(MAX)
	DECLARE @dataIsEvent INTEGER = 0
	DECLARE @o_errorCode		INT = 0
	DECLARE @o_errorString		NVARCHAR(MAX) = ''
	DECLARE @clientId	INTEGER
BEGIN TRY
BEGIN TRAN
	IF object_id('tempdb.dbo.#CSParamDetail') is not null DROP TABLE #CSParamDetail
	CREATE TABLE #CSParamDetail
	(
		paramMsgId						INT,
		paramMsg				NVARCHAR(MAX),
	)
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	-- Set Gui Audit Operation
	SET @userId = ISNULL(( SELECT ref.value('@userId', 'int')
      							FROM @i_xmlText.nodes('DM2ContentIndexing_DM2AuditOperation') R ( ref ) ), 0)
	SET @opMsgId= ISNULL(( SELECT ref.value('@operationMsgId', 'int')
      							FROM @i_xmlText.nodes('DM2ContentIndexing_DM2AuditOperation') R ( ref ) ), 0)
    SET @clientId= ISNULL(( SELECT ref.value('@clientId', 'int')
      							FROM @i_xmlText.nodes('DM2ContentIndexing_DM2AuditOperation') R ( ref ) ), 0)
	IF(@opMsgId <= 0 OR @i_entityType <= 0 OR @i_entityId <= 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'ERROR: Invalid OperationMessge id, entity Type, or entity Id '
		GOTO EXIT_ERROR
	END
	ELSE
	BEGIN
		SET @opMsgId = (@opMsgId | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, @i_entityType, @i_entityId, @opEvMsgId OUTPUT, @opId OUTPUT
		IF(@opEvMsgId <= 0 OR @opId <= 0)
		BEGIN
			SET @o_errorCode = 2
			SET @o_errorString = 'ERROR: Invalid OperationMessge from evMsgs or EvGuiAuditOperation'
			GOTO EXIT_ERROR
		END
	END
	INSERT INTO #CSParamDetail (paramMsgId, paramMsg)
		SELECT DISTINCT
		ISNULL(ParamInfo.n.value('(@paramMsgId)', 'integer'), 0),
		ISNULL(dbo.DecodeInvalidXMLChar(ParamInfo.n.value('(paramDatas)[1]/@val', 'nvarchar(max)')), '')
	FROM
		@i_xmlText.nodes('DM2ContentIndexing_DM2AuditOperation/paramList') AS ParamInfo(n)
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	-- Set Gui Audit Parameter
	-- Open cursor for paramMsgIds
	DECLARE paramCursor CURSOR FAST_FORWARD FOR
	SELECT paramMsgId,paramMsg
	FROM #CSParamDetail
	OPEN paramCursor
	FETCH NEXT FROM paramCursor INTO @paramMsgId, @paramData
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		--Perform operation only if its a valid paramMessage id
		IF(@paramMsgId > 0)
		BEGIN
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			SET @paramMsgId = (@paramMsgId | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		FETCH NEXT FROM paramCursor INTO @paramMsgId, @paramData
	END
	CLOSE paramCursor
	DEALLOCATE paramCursor
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	IF @o_errorCode = 0
	BEGIN
		SET @o_errorString = 'NO ERROR'
	END
	SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'EDiscoveryAuditOperation')
	delete from GxQscripts where name = 'EDiscoveryAuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EDiscoveryAuditOperation')
	delete from GXDBVersions where aliasname = 'EDiscoveryAuditOperation'
GO

insert into GXDBVersions values(2, 'EDiscoveryAuditOperation',  '00000000000000000000', 'EDiscoveryAuditOperation', '00000000000000000000')
GO

