SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO

BEGIN
	DECLARE @ProcNameCursorFlag 	INTEGER
	SET 		@ProcNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 		@errorCode	= 0
	
	DECLARE	@ProcName		nvarchar(256)
		
	DECLARE	ProcNameListCursor CURSOR STATIC FOR
	SELECT	distinct aliasname
	FROM		GXDBVersions
	WHERE		type = 2 -- (For stored procedures)
		
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@ProcNameCursorFlag = 1
	OPEN	ProcNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM ProcNameListCursor
	INTO @ProcName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all stored procedures
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		
		IF EXISTS (select * from sysobjects where name = @ProcName and OBJECTPROPERTY(id, N'IsProcedure') = 1) 
		BEGIN
			print '>>> Drop Procedure: ' + @ProcName + ' <<<'
			EXEC ('DROP PROCEDURE [' + @ProcName + ']')
		END
			
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
					
		IF EXISTS (select * from GXDBVersions where aliasname = @ProcName AND type = 2)
			DELETE FROM GXDBVersions WHERE aliasname = @ProcName AND type = 2 
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM ProcNameListCursor
		INTO @ProcName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @ProcNameCursorFlag = 1
	BEGIN
			CLOSE				ProcNameListCursor
			DEALLOCATE	ProcNameListCursor
	END
END	

RETURN
GO

