

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DistributedClusterInstanceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DistributedClusterInstanceInfo')
BEGIN
	print '>>> Drop Stored Procedure: DistributedClusterInstanceInfo <<<'
	drop procedure DistributedClusterInstanceInfo
END
IF EXISTS (select * from GxQscripts where name='DistributedClusterInstanceInfo')
	delete from GxQscripts where name = 'DistributedClusterInstanceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DistributedClusterInstanceInfo')
	delete from GXDBVersions where aliasname = 'DistributedClusterInstanceInfo'
GO
print '... Creating Procedure: DistributedClusterInstanceInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DistributedClusterInstanceInfo
  @i_xml XML
AS
	set transaction isolation level read uncommitted
IF object_id('temp.dbo.#newInstanceProperties') IS NOT null DROP TABLE #newInstanceProperties
IF object_id('temp.dbo.#SegmentstoUpdate') IS NOT null DROP TABLE #SegmentstoUpdate
IF object_id('temp.dbo.#MongosToUpdate') IS NOT null DROP TABLE #MongosToUpdate
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg NVARCHAR(1024) = N''
	DECLARE @instanceId INTEGER = (SELECT @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/instance/@instanceId)[1]','INT'))
	DECLARE @optype INTEGER = (SELECT @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/@opType)[1]','INT'))
	DECLARE @instanceName NVARCHAR(MAX) = (ISNULL((SELECT name FROM APP_InstanceName WHERE id = @instanceId),'Unknown'))
	DECLARE @currentTime INTEGER = CommServ.dbo.GetUnixTime(GETUTCDATE())
	DECLARE @pit INTEGER = (ISNULL((SELECT @i_xml.value('(/App_DistributedClusterInstanceReq/@pointInTime)[1]','INT')), @currentTime))
	IF @pit = 0
		SET @pit = @currentTime
	DECLARE @clusterType INTEGER = (ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE attrName = 'Distributed Cluster Type' AND componentNameId = @instanceId AND modified = 0), 0))
	IF @clusterType = 0
		SET @clusterType = (ISNULL((SELECT @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/@clusterType)[1]','INT')), 0))
	-- DistributedClusterType_UNKNOWN= 0
	-- DistributedClusterType_GREENPLUM= 1
	-- DistributedClusterType_HADOOP= 2
	-- DistributedClusterType_GPFS= 3
	-- DistributedClusterType_UXFS= 4
	-- DistributedClusterType_MONGODB = 8
	-- DistributedOperationType_UNKNOWN= 0
	-- DistributedOperationType_GET= 1
	-- DistributedOperationType_SET= 2
	DECLARE @masterNodeName 				VARCHAR(MAX)
	DECLARE @masterPort 					INT
	DECLARE @masterDirectory				VARCHAR(MAX)
	DECLARE @initVersion					VARCHAR(MAX)
	DECLARE @currentVersion					VARCHAR(MAX)
	DECLARE @postgresVersion				VARCHAR(MAX)
	DECLARE @masterRole 					SMALLINT
	DECLARE @masterStandbyNode 				VARCHAR(MAX)
	DECLARE @standbyState 					SMALLINT
	DECLARE @greenplumHome					VARCHAR(MAX)
	DECLARE @adminUser						VARCHAR(MAX)
	DECLARE @defaultDatabase				VARCHAR(MAX)
	DECLARE @isAgentless					INT
	DECLARE @xmlResult						XML
	DECLARE @masterClientId                 INT
	DECLARE @hadoopConfig 					XML
	DECLARE @coordinatorNode				XML
	DECLARE @hadoopSites					XML
	DECLARE @coordinatorNodeId				INT
	IF @clusterType = 1
	BEGIN
		IF @optype = 1
		BEGIN
			SET @masterNodeName = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Master Node Name' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @masterPort = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Master Port Number' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @masterDirectory = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Master Diretory' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @initVersion = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Initial Version' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @currentVersion = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Current Version' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @postgresVersion = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Postgres Version' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @masterRole = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Master Role' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @masterStandbyNode = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Master Standby Node' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @standbyState = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'State of standby node' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @greenplumHome = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Greenplum Home' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @adminUser = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Greenplum Admin User' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @defaultDatabase = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Greenplum Default Database' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @masterClientId = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Greenplum Master Client Id' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @isAgentless = (SELECT attrVal FROM APP_InstanceProp  WHERE componentNameID = @InstanceId AND attrName = 'Greenplum Agentless' AND created <= @pit AND (modified = 0 OR modified > @pit))
			SET @xmlResult =
					(SELECT
						@clusterType as '@clusterType',
						(SELECT
							@instanceId as '@instanceId',
							@instanceName as '@instanceName'
						FOR XML PATH('instance'), TYPE),
						(SELECT
							(SELECT
								@masterNodeName as '@masterNodeName',
								@masterPort as '@masterPort',
								@masterDirectory as '@masterDirectory',
								@initVersion as '@initVersion',
								@currentVersion as '@currentVersion',
								@postgresVersion as '@postgresVersion',
								@masterRole as '@masterRole',
								@masterStandbyNode as '@masterStandbyNode',
								@standbyState  as '@standbyState',
								@greenplumHome as '@greenplumHome',
								@adminUser as '@adminUser',
								@defaultDatabase as '@defaultDatabase',
								@isAgentless as '@isAgentless',
								(SELECT
									@masterClientId as '@clientId'
								FOR XML PATH('masterClient'), TYPE),
								(SELECT
									gp.address as '@address',
									gp.currentRole as '@currentRole',
									gp.mirrorStatus as '@mirrorStatus',
									gp.port as '@port',
									gp.preferredRole as '@preferredRole',
									gp.presentStatus as '@presentStatus',
									gp.DataDirectory as '@segmentDataDirectory',
									gp.dbId as '@dbId',
									gp.segmentContent as '@segmentContent',
									(SELECT
										gp.hostName as '@hostName',
										(SELECT
											gp.clientId as '@clientId'
										FOR XML PATH('client'), TYPE)
									FOR XML PATH ('node'), TYPE)
								FROM APP_GreenPlumAssociation gp
								WHERE instanceId = @instanceId AND created <= @pit AND (modified = 0 OR modified > @pit)
								FOR XML PATH('segments'), TYPE)
							FOR XML PATH('gpConfig'), TYPE)
						FOR XML PATH('clusterConfig'), TYPE)
					FOR XML PATH('dcInstance'), TYPE)
		END
		ELSE IF @opType = 2
		BEGIN
			SET @masterNodeName				 = @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/@masterNodeName)[1]','nvarchar(MAX)')
			SET @initVersion				 = @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/@initVersion)[1]','nvarchar(MAX)')
			SET @currentVersion				 = @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/@currentVersion)[1]','nvarchar(MAX)')
			SET @postgresVersion			 = @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/@postgresVersion)[1]','nvarchar(MAX)')
			SET @masterRole					 = @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/@masterRole)[1]','nvarchar(MAX)')
			SET @masterStandbyNode			 = @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/@masterStandbyNode)[1]','nvarchar(MAX)')
			SET @standbyState				 = @i_xml.value('(/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/@standbyState)[1]','nvarchar(MAX)')
			CREATE TABLE #newInstanceProperties (attrName NVARCHAR(1024), attrVal NVARCHAR(MAX))
			INSERT INTO #newInstanceProperties VALUES ('Master Node Name', @masterNodeName)
			INSERT INTO #newInstanceProperties VALUES ('Initial Version', @initVersion)
			INSERT INTO #newInstanceProperties VALUES ('Current Version', @currentVersion)
			INSERT INTO #newInstanceProperties VALUES ('Postgres Version', @postgresVersion)
			INSERT INTO #newInstanceProperties VALUES ('Master Role', @masterRole)
			INSERT INTO #newInstanceProperties VALUES ('Master Standby Node', @masterStandbyNode)
			INSERT INTO #newInstanceProperties VALUES ('State of standby node', @standbyState)
			DECLARE @nowTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
			-- Update the modified time of existing properties if new properties have different values
			UPDATE	APP_InstanceProp
			SET		modified = @nowTime
			FROM	#newInstanceProperties N
				LEFT OUTER JOIN APP_InstanceProp P
				ON N.attrName = P.attrName
			WHERE	P.componentNameId = @instanceId
				AND	P.modified = 0
				AND	P.attrVal IS NOT NULL
				AND	N.attrVal <> P.attrVal
			-- Insert new properties into the table
			INSERT INTO APP_InstanceProp (componentNameId, [attrName], [attrType], [attrVal], created, modified, ccpId)
			SELECT	@instanceId, N.attrName, 1, N.attrVal, @nowTime, 0, 0
			FROM	#newInstanceProperties N LEFT OUTER JOIN
				(SELECT attrName, attrVal, modified FROM APP_InstanceProp
				WHERE componentNameId = @instanceId AND modified = 0) P
			ON N.attrName = P.attrName AND P.modified = 0
			WHERE P.attrVal IS NULL AND N.attrVal IS NOT NULL
			--CREATE TABLE #suppressInsertMsgs	(a INT,b INT, c INT,d Nvarchar(max))
			--INSERT INTO #suppressInsertMsgs EXEC AppInsertInstanceProp @instanceId,1,@currentTime,'Master Node Name',1,@masterNodeName
			--INSERT INTO #suppressInsertMsgs EXEC AppInsertInstanceProp @instanceId,1,@currentTime,'Initial Version',1,@initVersion
			--INSERT INTO #suppressInsertMsgs EXEC AppInsertInstanceProp @instanceId,1,@currentTime,'Current Version',1,@currentVersion
			--INSERT INTO #suppressInsertMsgs EXEC AppInsertInstanceProp @instanceId,1,@currentTime,'Postgres Version',1,@postgresVersion
			--INSERT INTO #suppressInsertMsgs EXEC AppInsertInstanceProp @instanceId,1,@currentTime,'Master Role',7,@masterRole
			--INSERT INTO #suppressInsertMsgs EXEC AppInsertInstanceProp @instanceId,1,@currentTime,'Master Standby Node',1,@masterStandbyNode
			--INSERT INTO #suppressInsertMsgs EXEC AppInsertInstanceProp @instanceId,1,@currentTime,'State of standby node',7,@standbyState
			IF ISNULL(@instanceId, 0) > 0
			BEGIN
				CREATE TABLE #SegmentstoUpdate (clientId int,
												hostname NVARCHAR(max),
												dataDirectory NVARCHAR(max),
												port INT,
												presentStatus INT,
												mirrorStatus INT,
												currentRole INT,
												preferredRole INT,
												address NVARCHAR(MAX),
												dbId INT,
												segmentContent INT)
				-----------------------------------------------------------------------------------------
				---   Get all the segments which should be updated									-----
				-----------------------------------------------------------------------------------------
				INSERT INTO #SegmentstoUpdate
					SELECT
						ISNULL(segmentList.segment.value('(node/client/@clientId)[1]','INT'),gpAssociation.clientId) as clientId,
						segmentList.segment.value('(node/@hostName)[1]','nvarchar(max)') as hostName,
						segmentList.segment.value('(@segmentDataDirectory)','nvarchar(max)') as dataDirectory,
						segmentList.segment.value('(@port)','int') as port,
						segmentList.segment.value('(@presentStatus)','smallint') as presentStatus,
						segmentList.segment.value('(@mirrorStatus)','smallint') as presentStatus,
						segmentList.segment.value('(@currentRole)','smallint') as currentRole,
						segmentList.segment.value('(@preferredRole)','smallint') as preferredRole,
						segmentList.segment.value('@address', 'nvarchar(max)') as address,
						ISNULL(segmentList.segment.value('@dbId', 'nvarchar(max)'),0) as dbId,
						segmentList.segment.value('@segmentContent', 'nvarchar(max)') as segmentContent
					FROM
						@i_xml.nodes('/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/segments') as segmentList(segment)
						LEFT JOIN
						(
							SELECT *
							FROM APP_GreenPlumAssociation
							WHERE instanceId = @instanceId
								  AND modified = 0
						) as gpAssociation
						ON gpAssociation.hostName = segmentList.segment.value('(node/@hostName)[1]','nvarchar(max)')
						AND gpAssociation.dataDirectory = segmentList.segment.value('(@segmentDataDirectory)','nvarchar(max)')
					WHERE
						segmentList.segment.value('(@port)','int') <> ISNULL(gpAssociation.port,-1)
						OR segmentList.segment.value('(@presentStatus)','smallint') <> ISNULL(gpAssociation.presentStatus,-1)
						OR segmentList.segment.value('(@mirrorStatus)','smallint') <> ISNULL(gpAssociation.mirrorStatus, -1)
						OR segmentList.segment.value('(@currentRole)','smallint') <> ISNULL(gpAssociation.currentRole,-1)
						OR segmentList.segment.value('(@preferredRole)','smallint') <> ISNULL(gpAssociation.preferredRole,-1)
						OR segmentList.segment.value('@address', 'nvarchar(max)') <> ISNULL(gpAssociation.address, '')
						OR segmentList.segment.value('@dbId', 'INT') <> ISNULL(gpAssociation.dbId,-1)
						OR segmentList.segment.value('@segmentContent', 'INT') <> ISNULL(gpAssociation.segmentContent,-1)
						OR ISNULL(segmentList.segment.value('(node/client/@clientId)[1]','INT'),gpAssociation.clientId) <> gpAssociation.clientId
				--------------------------------------------------------------------------------------
				--		Update clientId if client exisits with same name as segment host name		--
				--------------------------------------------------------------------------------------
				UPDATE	#SegmentsToUpdate
				SET		clientId = C.id
				FROM	#SegmentstoUpdate S
					INNER JOIN APP_Client C
						ON S.hostname = C.net_hostname
				WHERE	S.clientId = 0
				--------------------------------------------------------------------------------------
				--		Set modified time for segments to be updated 								--
				--------------------------------------------------------------------------------------
				UPDATE 	gpAssociation
				SET 	modified = @currentTime
				FROM	#SegmentstoUpdate as segUpdate
					JOIN
					(
						SELECT *
						FROM APP_GreenPlumAssociation
						WHERE instanceid = @instanceId
							  AND modified = 0
					) as gpAssociation
						ON  segUpdate.hostName = gpAssociation.hostname
						AND segUpdate.dataDirectory = gpAssociation.dataDirectory
				--------------------------------------------------------------------------------------
				--			Set modifed time for deleted segments									--
				--------------------------------------------------------------------------------------
				UPDATE 	gpAssociation
				SET 	modified = @currentTime
				FROM	@i_xml.nodes('/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/gpConfig/segments') as segmentList(segment)
					RIGHT JOIN
					(
						SELECT *
						FROM APP_GreenPlumAssociation
						WHERE instanceId = @instanceId
							  AND modified = 0
					) as gpAssociation
						ON gpAssociation.hostName = segmentList.segment.value('(node/@hostName)[1]','nvarchar(max)')
						AND gpAssociation.dataDirectory = segmentList.segment.value('(@segmentDataDirectory)','nvarchar(max)')
				WHERE
					segmentList.segment.value('(node/@hostName)[1]','nvarchar(max)') IS null
				---------------------------------------------------------------------------------------
				--		Insert new updated segments 												 --
				---------------------------------------------------------------------------------------
				INSERT INTO APP_GreenPlumAssociation
					SELECT
						@instanceId,
						ISNULL(segUpdate.clientId, 0),
						ISNULL(segUpdate.port, 0),
						ISNULL(segUpdate.presentStatus, 0),
						ISNULL(segUpdate.mirrorStatus, 0),
						ISNULL(segUpdate.currentRole, 0),
						ISNULL(segUpdate.preferredRole, 0),
						ISNULL(segUpdate.hostName, ''),
						ISNULL(segUpdate.address, ''),
						ISNULL(segUpdate.dataDirectory, ''),
						ISNULL(segUpdate.dbId, 0),
						ISNULL(segUpdate.segmentContent, 0),
						NULL,
						@currentTime as created,
						0 as modified,
						0 as specialFlags
					FROM #SegmentstoUpdate as segUpdate
			END
			ELSE
			BEGIN
				SET @errorCode = 1
				SET @errorMsg = 'Invalid or missing instanceId in the request'
			END
		END
		ELSE
		BEGIN
			SET @errorCode = 2
			SET @errorMsg = 'Invaid opType ' + CONVERT(VARCHAR(8), @opType) + ' found in the request'
		END
	END
	ELSE IF @clusterType = 2
	BEGIN
		IF @optype = 1
		BEGIN
			SET @hadoopConfig = ISNULL((SELECT CAST(attrVal AS XML) FROM App_InstanceProp WHERE attrName = 'Hadoop Config' AND componentNameId = @InstanceId AND modified = 0), '<App_HadoopConfig/>')
			SET @coordinatorNode = @hadoopConfig.query('/App_HadoopConfig/coordinatorNode')
			SET @hadoopSites = @hadoopConfig.query('/App_HadoopConfig/hadoopSites')
			SET @xmlResult =
					(SELECT
						@clusterType as '@clusterType',
						(SELECT
							@instanceId as '@instanceId',
							@instanceName as '@instanceName'
						FOR XML PATH('instance'), TYPE),
						(SELECT
							(SELECT
								@hadoopSites,
								@coordinatorNode
							FOR XML PATH('hadoopConfig'), TYPE)
						FOR XML PATH('clusterConfig'), TYPE)
					FOR XML PATH('dcInstance'), TYPE)
		END
		ELSE
		BEGIN
			SET @errorCode = 2
			SET @errorMsg = 'Invaid opType ' + CONVERT(VARCHAR(8), @opType) + ' found in the request'
		END
	END
	ELSE IF @clusterType = 3 OR @clusterType = 4
	BEGIN
		IF @optype = 1
		BEGIN
			DECLARE @daNodesXml XML
			SET @coordinatorNodeId = ISNULL((SELECT CAST(attrVal AS INT) FROM App_InstanceProp WHERE attrName = 'Coordinator Node' AND componentNameId = @InstanceId AND modified = 0), 0)
			SET @daNodesXml = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Coordinator Node' AND componentNameId = @InstanceId AND modified = 0), '<App_DataAccessNodes />')
			SET @xmlResult =
					(SELECT
						@clusterType as '@clusterType',
						(SELECT
							@instanceId as '@instanceId',
							@instanceName as '@instanceName'
						FOR XML PATH('instance'), TYPE),
						(SELECT
							(SELECT
								(SELECT
									@coordinatorNodeId as '@clientId'
								FOR XML PATH ('coordinatorNode'), TYPE)
							FOR XML PATH('uxfsConfig'), TYPE)
						FOR XML PATH('clusterConfig'), TYPE),
						(SELECT @daNodesXml.query('/App_DataAccessNodes/*')
							FOR XML PATH('dataAccessNodes'), TYPE)
					FOR XML PATH('dcInstance'), TYPE)
		END
		ELSE
		BEGIN
			SET @errorCode = 2
			SET @errorMsg = 'Invaid opType ' + CONVERT(VARCHAR(8), @opType) + ' found in the request'
		END
	END
	ELSE IF  @clusterType = 8 -- DistributedClusterType_MONGODB = 8
	BEGIN
		IF @opType = 1 -- GET
		BEGIN
		DECLARE @mdbServerType			INT
		DECLARE @MongoAdminUser				NVARCHAR(1024)
		DECLARE @MongoAdminPassword			NVARCHAR(MAX)
		DECLARE @portNumber					INTEGER
		DECLARE @binPath					NVARCHAR(1024)
		DECLARE @osUser						NVARCHAR(256)
		DECLARE @hostName					NVARCHAR(256)
		SET @coordinatorNodeId = ISNULL((SELECT CAST(attrVal AS INT) FROM App_InstanceProp WHERE attrName = 'Coordinator Node' AND componentNameId = @instanceId AND modified = 0), 0)
SET @mdbServerType = ISNULL((SELECT CAST(attrVal AS INT) FROM App_InstanceProp WHERE attrName = 'MongoDB Server Type' AND componentNameId = @instanceId AND modified = 0),0)
SET @MongoAdminUser = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'MongoDB DB Username' AND componentNameId = @instanceId AND modified = 0),0)
SET @MongoAdminPassword = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM App_InstanceProp WHERE attrName = 'MongoDB DB Password' AND componentNameId = @instanceId AND modified = 0),0)
SET @portNumber = ISNULL((SELECT CAST(attrVal AS INT) FROM App_InstanceProp WHERE attrName = 'MongoDB Port' AND componentNameId = @instanceId AND modified = 0),0)
SET @binPath = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'MongoDB Binary Path' AND componentNameId = @instanceId AND modified = 0),0)
SET @osUser	= ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'MongoDB OS Username' AND componentNameId = @instanceId AND modified = 0),0)
SET @hostName	= ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'MongoDB Hostname' AND componentNameId = @instanceId AND modified = 0),'')
		SET @xmlResult =
				(SELECT
					@clusterType as '@clusterType',
					(SELECT
						@instanceId as '@instanceId',
						dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
					FOR XML PATH('instance'), TYPE),
					(SELECT
						(SELECT
							@mdbServerType as '@mdbServerType',
							(SELECT
								@portNumber as '@portNumber',
								@binPath as '@binPath',
								@osUser as '@osUser',
								@hostName as '@hostName',
								(SELECT @coordinatorNodeId as'@clientId',
									   (SELECT name FROM App_Client WHERE id = @coordinatorNodeId) as '@clientName'
								FOR XML PATH('client'), TYPE)
							FOR XML PATH('masterNode'), TYPE),
							(SELECT
								@MongoAdminUser as '@userName',
								@MongoAdminPassword as '@password'
							FOR XML PATH('adminUser'), TYPE),
							(SELECT
								mdbVersion as '@mdbVersion',
								engineName as '@engineName',
								hostName as '@hostName',
								portNumber as '@portNumber',
								dataPath as '@dataPath',
								osUser as '@osUser',
								cmdLineOption as '@cmdLineOption',
								confgFilePath as '@configFilePath',
								repsetName as '@repsetName',
								subType as '@subType',
								role as '@role',
								binPath as '@binPath',
								health as '@health',
								configContents as '@configContents',
                                useAsDataAccessNode as '@useAsDataAccessNode',
								(SELECT
									clientId as '@clientId',
									(SELECT name FROM App_Client WHERE id = clientId) as '@clientName'
								FOR XML PATH('client'), TYPE)
							FROM APP_MongoDbAssociation
							WHERE instanceId = @instanceId AND created <= @pit AND (modified = 0 OR modified > @pit)
							FOR XML PATH('mdbServerList'), TYPE)
						FOR XML PATH('mdbConfig'), TYPE)
					FOR XML PATH('clusterConfig'), TYPE)
				FOR XML PATH('dcInstance'), TYPE)
		END
		ELSE IF @opType = 2 -- SET
		BEGIN
			CREATE TABLE #MongosToUpdate(clientId		INTEGER,
										mdbVersion		NVARCHAR(1024),
										engineName		NVARCHAR(1024),
										hostName		NVARCHAR(1024),
										portNumber 		INTEGER,
										dataPath		NVARCHAR(1024),
										osUser			NVARCHAR(1024),
										cmdLineOption	NVARCHAR(MAX),
										confgFilePath	NVARCHAR(1024),
										repsetName		NVARCHAR(1024),
										subType			INTEGER,
										role			INTEGER,
										binPath			NVARCHAR(1024),
										health			INTEGER,
										configContents	NVARCHAR(MAX),
										useAsDataAccessNode SMALLINT)
			-------------------------------------------------------------------------------------
			---   Get all the nodes which should be updated									-----
			-------------------------------------------------------------------------------------
			INSERT INTO #MongosToUpdate
			SELECT	ISNULL(node.prop.value('(client/@clientId)[1]', 'integer'), mdbServerProp.clientId ),
					node.prop.value('@mdbVersion', 'nvarchar(1024)'),
					node.prop.value('@engineName', 'nvarchar(1024)'),
					node.prop.value('@hostName', 'nvarchar(1024)'),
					node.prop.value('@portNumber', 'integer'),
					node.prop.value('@dataPath', 'nvarchar(1024)'),
					node.prop.value('@osUser', 'nvarchar(1024)'),
					node.prop.value('@cmdLineOption', 'nvarchar(max)'),
					node.prop.value('@configFilePath', 'nvarchar(1024)'),
					node.prop.value('@repsetName', 'nvarchar(1024)'),
					node.prop.value('@subType', 'integer'),
					node.prop.value('@role', 'integer'),
					node.prop.value('@binPath', 'nvarchar(1024)'),
					node.prop.value('@health', 'integer'),
					node.prop.value('@configFileContents', 'nvarchar(max)'),
					node.prop.value('@useAsDataAccessNode', 'SMALLINT')
			FROM
				@i_xml.nodes('/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/mdbConfig/mdbServerList') as node(prop)
				LEFT JOIN
				(
					SELECT *
					FROM APP_MongoDbAssociation
					WHERE instanceId = @instanceId
						AND modified = 0
				) as mdbServerProp
				ON mdbServerProp.hostName = node.prop.value('@hostName', 'nvarchar(1024)') AND
				mdbServerProp.portNumber = node.prop.value('@portNumber', 'integer')
			WHERE
				node.prop.value('(client/@clientId)[1]', 'integer') <> ISNULL(mdbServerProp.clientId, -1) OR
				node.prop.value('@mdbVersion', 'nvarchar(1024)') <> ISNULL(mdbServerProp.mdbVersion,'') OR
				node.prop.value('@engineName', 'nvarchar(1024)') <> ISNULL(mdbServerProp.engineName, '') OR
				node.prop.value('@dataPath', 'nvarchar(1024)') <> ISNULL(mdbServerProp.dataPath,'') OR
				node.prop.value('@osUser', 'nvarchar(1024)') <> ISNULL(mdbServerProp.osUser, '') OR
				node.prop.value('@cmdLineOption', 'nvarchar(max)') <> ISNULL(mdbServerProp.cmdLineOption, '') OR
				node.prop.value('@configFilePath', 'nvarchar(1024)') <> ISNULL(mdbServerProp.confgFilePath, '') OR
				node.prop.value('@repsetName', 'nvarchar(1024)') <> ISNULL(mdbServerProp.repsetName,'') OR
				node.prop.value('@subType', 'integer') <> ISNULL(mdbServerProp.subType, -1) OR
				node.prop.value('@role', 'integer') <> ISNULL(mdbServerProp.role, -1) OR
				node.prop.value('@binPath', 'nvarchar(1024)') <> ISNULL(mdbServerProp.binPath,'') OR
				node.prop.value('@health', 'integer') <> ISNULL(mdbServerProp.health, -1) OR
				node.prop.value('@configFileContents', 'nvarchar(max)') <> ISNULL(mdbServerProp.configContents, '') OR
				node.prop.value('@useAsDataAccessNode', 'integer') <> ISNULL(mdbServerProp.useAsDataAccessNode, 0)
			--------------------------------------------------------------------------------------
			--		Set modified time for nodes to be updated 									--
			--------------------------------------------------------------------------------------
			UPDATE mdbServerProp
			SET modified = @currentTime
			FROM #MongosToUpdate as uNodes
				JOIN
				(
					SELECT hostName,portNumber, modified
					FROM APP_MongoDbAssociation
					WHERE instanceId = @instanceId
						AND modified = 0
				) as mdbServerProp
				ON mdbServerProp.hostName = uNodes.hostName AND
				mdbServerProp.portNumber = uNodes.portNumber
			--------------------------------------------------------------------------------------
			--			Set modified time for deleted nodes 										--
			--------------------------------------------------------------------------------------
			UPDATE mdbServerProp
			SET modified = @currentTime
			FROM @i_xml.nodes('/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/mdbConfig/mdbServerList') as node(prop)
				RIGHT JOIN
				(
					SELECT hostName,portNumber, modified
					FROM APP_MongoDbAssociation
					WHERE instanceId = @instanceId
						AND modified = 0
				) as mdbServerProp
				ON mdbServerProp.hostName = node.prop.value('@hostName', 'nvarchar(1024)') AND
				mdbServerProp.portNumber = node.prop.value('@portNumber', 'integer')
			WHERE
				node.prop.value('@hostName', 'nvarchar(1024)') IS NULL
			---------------------------------------------------------------------------------------
			--		Insert new updated nodes 	 												 --
			---------------------------------------------------------------------------------------
			INSERT INTO APP_MongoDbAssociation
				(
					instanceId,
					clientId,
					mdbVersion,
					engineName,
					hostName,
					portNumber,
					dataPath,
					osUser,
					cmdLineOption,
					confgFilePath,
					repsetName,
					subType,
					role,
					binPath,
					health,
					configContents,
					extendedProps,
					created,
					modified,
					specialFlags,
					useAsDataAccessNode
				)
			SELECT
					@instanceId,
					ISNULL(clientId, 0),
					ISNULL(mdbVersion,''),
					ISNULL(engineName,''),
					hostName,
					portNumber,
					ISNULL(dataPath,''),
					ISNULL(osUser,''),
					ISNULL(cmdLineOption,''),
					ISNULL(confgFilePath,''),
					ISNULL(repsetName,''),
					ISNULL(subType,0),
					ISNULL(role,0),
					ISNULL(binPath,''),
					ISNULL(health,0),
					ISNULL(configContents,''),
					'',
				   @currentTime,
				   0,
				   0,
				   ISNULL(useAsDataAccessNode,0)
			FROM #MongosToUpdate
			-- Update Work QUEUE
			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
			SELECT DISTINCT clientId, 4, N'', @currentTime, 0, 0, 0, -1 -- 4 = WORK_TOKEN_OSC
			FROM #MongosToUpdate
			WHERE clientId <> 0
			-- Syncronize new nodes added to the cluster
			EXEC App_SetMongoDbSCPriority 0, @instanceId, 2, ''
		END
		ELSE IF @opType = 3 -- LISTNODES
		BEGIN
			SET @xmlResult =
				(SELECT
					@clusterType as '@clusterType',
					(SELECT
						@instanceId as '@instanceId',
						dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
					FOR XML PATH('instance'), TYPE),
					(SELECT
						(SELECT
							(SELECT
								hostName as '@hostName',
								portNumber as '@portNumber',
								repsetName as '@repsetName',
								subType as '@subType',
								role as '@role',
								(SELECT
									clientId as '@clientId',
									(SELECT name FROM App_Client WHERE id = clientId) as '@clientName'
								FOR XML PATH('client'), TYPE)
							FROM APP_MongoDbAssociation
							WHERE instanceId = @instanceId AND created <= @pit AND (modified = 0 OR modified > @pit)
							FOR XML PATH('mdbServerList'), TYPE)
						FOR XML PATH('mdbConfig'), TYPE)
					FOR XML PATH('clusterConfig'), TYPE)
				FOR XML PATH('dcInstance'), TYPE)
		END
	END
	ELSE IF @clusterType = 9
	BEGIN
		IF @opType = 1 -- GET
		BEGIN
		DECLARE @cassandraGatewayHost	VARCHAR(1024)
		DECLARE @gatewayCQLPort			INT
		DECLARE @gatewayUsername		VARCHAR(1024)
		DECLARE @gatewayPassword		VARCHAR(1024)
		DECLARE @jmxConnection			XML
		DECLARE @javaHome				VARCHAR(256)
		DECLARE @clusterName			VARCHAR(256)
		DECLARE @cassandraVersion		VARCHAR(512)
		DECLARE @authConfig				XML
		DECLARE @enableCommitLog		INT
		DECLARE @archiveLogPath			VARCHAR(512)
		DECLARE @archiveCommand			VARCHAR(512)
		DECLARE @configFilePath			VARCHAR(512)
		SET @coordinatorNodeId = ISNULL((SELECT CAST(attrVal AS INT) FROM App_InstanceProp WHERE attrName = 'Coordinator Node' AND componentNameId = @instanceId AND modified = 0), 0)
		SET @cassandraGatewayHost = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra gateway host' AND componentNameId = @instanceId AND modified = 0),'')
		SET @gatewayCQLPort = ISNULL((SELECT CAST(attrVal AS INT) FROM App_InstanceProp WHERE attrName = 'Cassandra gateway CQL port' AND componentNameId = @instanceId AND modified = 0),0)
		SET @gatewayUsername = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra gateway username' AND componentNameId = @instanceId AND modified = 0),'')
		SET @gatewayPassword = ISNULL((SELECT dbo.pswConvertV5ToV3(attrVal) FROM App_InstanceProp WHERE attrName = 'Cassandra gateway passowrd' AND componentNameId = @instanceId AND modified = 0),'')
		SET @cassandraVersion = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra Version' AND componentNameId = @instanceId AND modified = 0),'')
		SET @jmxConnection = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra gateway configuration' AND componentNameId = @instanceId AND modified = 0),'<App_JMXConnection />')
		SET @javaHome = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra gateway java home' AND componentNameId = @instanceId AND modified = 0),'')
		SET @clusterName = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra Cluster Name' AND componentNameId = @instanceId AND modified = 0),'')
		SET @authConfig = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra Authentication Configurations' AND componentNameId = @instanceId AND modified = 0),'<App_AuthConfig />')
SET @enableCommitLog = ISNULL((SELECT CAST(attrVal AS INT) FROM App_InstanceProp WHERE attrName = 'Cassandra Enable Commit Log Backups' AND componentNameId = @instanceId AND modified = 0),0)
SET @archiveLogPath = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra Commit Log Path' AND componentNameId = @instanceId AND modified = 0),'')
SET @archiveCommand = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra Archive Command' AND componentNameId = @instanceId AND modified = 0),'')
		SET @configFilePath = ISNULL((SELECT attrVal FROM App_InstanceProp WHERE attrName = 'Cassandra Configuration File Path' AND componentNameID = @instanceId AND modified = 0),'')
		DECLARE @keyStorePassV5 NVARCHAR(MAX), @trustStorePassV5 NVARCHAR(MAX)
		DECLARE @JMXConnectionPassword NVARCHAR(MAX)
		SET @keyStorePassV5 = dbo.pswConvertV5ToV3(@authConfig.value('(/App_AuthConfig/sslConfig/@keyStorePass)[1]', 'NVARCHAR(MAX)'))
		SET	@trustStorePassV5 = dbo.pswConvertV5ToV3(@authConfig.value('(/App_AuthConfig/sslConfig/@trustStorePass)[1]', 'NVARCHAR(MAX)'))
		SET @authConfig.modify('replace value of (/App_AuthConfig/sslConfig/@keyStorePass)[1] with sql:variable("@keyStorePassV5")')
		SET @authConfig.modify('replace value of (/App_AuthConfig/sslConfig/@trustStorePass)[1] with sql:variable("@trustStorePassV5")')
		SET @JMXConnectionPassword = dbo.pswConvertV3ToV5(@jmxConnection.value('(/App_JMXConnection/userPassword/@password)[1]', 'NVARCHAR(MAX)'))
		SET @jmxConnection.modify('replace value of (/App_JMXConnection/userPassword/@password)[1] with sql:variable("@JMXConnectionPassword")')
		SET @xmlResult =
				(SELECT
					@clusterType as '@clusterType',
					(SELECT
						@instanceId as '@instanceId',
						dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
					FOR XML PATH('instance'), TYPE),
					(SELECT
						(SELECT
							@cassandraVersion as '@version',
							@clusterName as '@clusterName',
							@enableCommitLog as '@enableCommitLog',
							@archiveLogPath as '@archiveLogPath',
							@archiveCommand as '@archiveCommand',
							@configFilePath as '@configFilePath',
							(SELECT
								@gatewayCQLPort as '@gatewayCQLPort',
								(SELECT
									@gatewayUsername as '@userName',
									@gatewayPassword as '@password'
								FOR XML PATH('gatewayCQLUser'),TYPE),
								(SELECT
									@javaHome as '@javaHome',
									@cassandraGatewayHost as '@ipAddress',
									(SELECT
										@coordinatorNodeId as '@clientId'
									FOR XML PATH ('clientNode'), TYPE),
									(SELECT
										   conn.prop.value('@host','nvarchar(256)') as '@host',
										   conn.prop.value('@port','int') as '@port',
										   conn.prop.value('@sslKey','nvarchar(2048)') as '@sslKey',
										   conn.prop.query('*')
									FROM @jmxConnection.nodes('/App_JMXConnection') as conn(prop)
									FOR XML PATH('jmxConnection'), TYPE),
									(SELECT
										@authConfig.query('/App_AuthConfig/*')
									FOR XML PATH('authConfig'), TYPE)
								FOR XML PATH('node'), TYPE)
							FOR XML PATH('gateway'), TYPE),
							(SELECT
								property.value('(/App_CassandraNode/@hostId)[1]', 'nvarchar(256)') as '@hostId',
								property.value('(/App_CassandraNode/@nodeName)[1]', 'nvarchar(256)') as '@nodeName',
								property.value('(/App_CassandraNode/@ipAddress)[1]', 'nvarchar(256)') as '@ipAddress',
								property.value('(/App_CassandraNode/@dataCenter)[1]', 'nvarchar(256)') as '@dataCenter',
								property.value('(/App_CassandraNode/@racValue)[1]', 'nvarchar(256)') as '@racValue',
								property.value('(/App_CassandraNode/@tokenList)[1]', 'nvarchar(max)') as '@tokenList',
								property.value('(/App_CassandraNode/@status)[1]' , 'integer') as '@status',
								property.value('(/App_CassandraNode/@isDead)[1]', 'integer') as '@isDead',
								property.value('(/App_CassandraNode/@dataDir)[1]', 'nvarchar(256)') as '@dataDir',
								property.value('(/App_CassandraNode/@binDir)[1]', 'nvarchar(256)') as '@binDir',
								property.value('(/App_CassandraNode/@configFile)[1]', 'nvarchar(512)') as '@configFile',
								property.value('(/App_CassandraNode/@isSupportIncremental)[1]', 'integer') as '@isSupportIncremental',
								property.value('(/App_CassandraNode/@javaHome)[1]', 'nvarchar(256)') as '@javaHome',
								property.value('(/App_CassandraNode/@isPlaceHolder)[1]', 'integer') as '@isPlaceHolder',
								property.value('(/App_CassandraNode/@agentInstanceName)[1]', 'nvarchar(256)') as '@agentInstanceName',
								property.query('/App_CassandraNode/clientNode'),
								property.query('/App_CassandraNode/userPassword'),
								property.query('/App_CassandraNode/jmxConnection')
							FROM APP_CassandraNodeProps
							WHERE instanceId = @instanceId and modified = 0
							FOR XML PATH('nodes'), TYPE)
						FOR XML PATH('cassandraConfig'), TYPE)
					FOR XML PATH('clusterConfig'), TYPE)
				FOR XML PATH('dcInstance'), TYPE)
		END
		ELSE IF @opType = 2 -- SET
		BEGIN
			DECLARE @nodesToUpdate TABLE(nodeClientId integer, nodeIpAddress nvarchar(256), property XML)
			-------------------------------------------------------------------------------------
			---   Get all the nodes which should be updated									-----
			-------------------------------------------------------------------------------------
			INSERT INTO @nodesToUpdate
			SELECT ISNULL(node.prop.value('(clientNode/@clientId)[1]', 'integer'),0),
				   node.prop.value('@ipAddress', 'nvarchar(256)'),
				(SELECT
					node.prop.value('@hostId', 'nvarchar(256)') as '@hostId',
					node.prop.value('@nodeName', 'nvarchar(256)') as '@nodeName',
					node.prop.value('@ipAddress', 'nvarchar(256)') as '@ipAddress',
					node.prop.value('@dataCenter', 'nvarchar(256)') as '@dataCenter',
					node.prop.value('@racValue', 'nvarchar(256)') as '@racValue',
					node.prop.value('@tokenList', 'nvarchar(max)') as '@tokenList',
					node.prop.value('@status' , 'integer') as '@status',
					node.prop.value('@isDead', 'integer') as '@isDead',
					node.prop.value('@dataDir', 'nvarchar(256)') as '@dataDir',
					node.prop.value('@binDir', 'nvarchar(256)') as '@binDir',
					node.prop.value('@configFile', 'nvarchar(512)') as '@configFile',
					node.prop.value('@isSupportIncremental', 'integer') as '@isSupportIncremental',
					node.prop.value('@javaHome', 'nvarchar(256)') as '@javaHome',
					node.prop.value('@isPlaceHolder', 'integer') as '@isPlaceHolder',
					node.prop.value('@agentInstanceName', 'nvarchar(256)') as '@agentInstanceName',
					node.prop.query('userPassword'),
					node.prop.query('jmxConnection'),
					-- To avoid adding hostname
					(SELECT node.prop.value('(clientNode/@clientId)[1]', 'integer') as '@clientId',
							node.prop.value('(clientNode/@clientName)[1]', 'nvarchar(256)') as '@clientName'
					FOR XML PATH('clientNode'), TYPE)
				FOR XML PATH('App_CassandraNode'), TYPE)
			FROM
				@i_xml.nodes('/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/cassandraConfig/nodes') as node(prop)
				LEFT JOIN
				(
					SELECT nodeClientId, instanceId, property
					FROM APP_CassandraNodeProps
					WHERE instanceId = @instanceId
						AND modified = 0
				) as cassNodeProp
				ON node.prop.value('@ipAddress', 'nvarchar(256)') = cassNodeProp.property.value('(/App_CassandraNode/@ipAddress)[1]', 'nvarchar(256)')
			WHERE
					cassNodeProp.nodeClientId <> node.prop.value('(clientNode/@clientId)[1]', 'integer') OR
					node.prop.value('@hostId', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@hostId)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('@nodeName', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@nodeName)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('@dataCenter', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@dataCenter)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('@racValue', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@racValue)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('@tokenList', 'nvarchar(max)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@tokenList)[1]', 'nvarchar(max)'),'') OR
					node.prop.value('@status' , 'integer') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@status)[1]', 'integer'),0) OR
					node.prop.value('@isDead', 'integer') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@isDead)[1]', 'integer'),0) OR
					node.prop.value('@dataDir', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@dataDir)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('@binDir', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@binDir)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('@configFile', 'nvarchar(512)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@configFile)[1]', 'nvarchar(512)'),'') OR
					node.prop.value('@isSupportIncremental', 'integer') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@isSupportIncremental)[1]', 'integer'),0) OR
					node.prop.value('@javaHome', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@javaHome)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('@isPlaceHolder', 'integer') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@isPlaceHolder)[1]', 'integer'),0) OR
					node.prop.value('@agentInstanceName', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/@agentInstanceName)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('(userPassword/@userName)[1]', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/userPassword/@userName)[1]', 'nvarchar(256)'),'') OR
					node.prop.value('(userPassword/@passowrd)[1]', 'nvarchar(max)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/userPassword/@passowrd)[1]', 'nvarchar(max)'),'') OR
					node.prop.value('(jmxConnection/@host)[1]', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/jmxConnection/@host)[1]','nvarchar(256)'),'') OR
					node.prop.value('(jmxConnection/@port)[1]', 'integer') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/jmxConnection/@port)[1]','nvarchar(256)'),'') OR
					node.prop.value('(jmxConnection/@sslKey)[1]', 'nvarchar(max)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/jmxConnection/@sslKey)[1]','nvarchar(max)'),'') OR
					node.prop.value('(jmxConnection/userPassword/@userName)[1]', 'nvarchar(256)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/jmxConnection/userPassword/@userName)[1]','nvarchar(256)'),'') OR
					node.prop.value('(jmxConnection/userPassword/@passowrd)[1]', 'nvarchar(max)') <> ISNULL(cassNodeProp.property.value('(/App_CassandraNode/jmxConnection/userPassword/@passowrd)[1]','nvarchar(max)'),'')
			--------------------------------------------------------------------------------------
			--		Set modified time for nodes to be updated 									--
			--------------------------------------------------------------------------------------
			UPDATE cassNodeProp
			SET modified = @currentTime
			FROM @nodesToUpdate as uNodes
				JOIN
				(
					SELECT property, modified
					FROM APP_CassandraNodeProps
					WHERE instanceId = @instanceId
						AND modified = 0
				) as cassNodeProp
				ON cassNodeProp.property.value('(/App_CassandraNode/@ipAddress)[1]', 'nvarchar(256)') = uNodes.nodeIpAddress
			--------------------------------------------------------------------------------------
			--			Set modifed time for deleted nodes 										--
			--------------------------------------------------------------------------------------
			UPDATE cassNodeProp
			SET modified = @currentTime
			FROM @i_xml.nodes('/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/cassandraConfig/nodes') as node(prop)
				RIGHT JOIN
				(
					SELECT nodeClientId, instanceId, property, modified
					FROM APP_CassandraNodeProps
					WHERE instanceId = @instanceId
						AND modified = 0
				) as cassNodeProp
					ON cassNodeProp.property.value('(/App_CassandraNode/@ipAddress)[1]', 'nvarchar(256)') = node.prop.value('@ipAddress', 'nvarchar(256)')
			WHERE
				node.prop.value('@ipAddress', 'nvarchar(256)') IS NULL
			---------------------------------------------------------------------------------------
			--		Insert new updated nodes 	 												 --
			---------------------------------------------------------------------------------------
			INSERT INTO APP_CassandraNodeProps
			SELECT nodeClientId,
				   @instanceId,
				   property,
				   @currentTime,
				   0
			FROM @nodesToUpdate
		END
	END
ELSE IF @clusterType = 16 -- Splunk
	BEGIN
		IF @opType = 1 -- GET
		BEGIN
			DECLARE @splunkUrl varchar(max) = dbo.GetAppInstanceProp_String(@instanceId,'Splunk Url');
			DECLARE @splunkUser varchar(max) = dbo.GetAppInstanceProp_String(@instanceId,'Splunk User');
			DECLARE @splunkPassword varchar(max) = dbo.GetAppInstanceProp_String(@instanceId,'Splunk Password');
			DECLARE @splunkPrimaryClientId int = dbo.GetAppInstanceProp_Int(@instanceId,'Splunk Primary Node Client Id');
			DECLARE @splunkPrimaryClientName varchar(max) = dbo.GetAppInstanceProp_String(@instanceId,'Splunk Primary Node Client Name');
			DECLARE @splunkPrimaryPath varchar(max) = dbo.GetAppInstanceProp_String(@instanceId,'Splunk Primary Node Path');
			SET @xmlResult =
			(SELECT @clusterType as '@clusterType',
				(SELECT
					@instanceId as '@instanceId',
					dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
				FOR XML PATH('instance'), TYPE)
				,
				(SELECT
					(SELECT	-- SplunkConfig
					@splunkUrl as '@url',
					(SELECT
						@splunkPrimaryPath as '@path',
						(SELECT @splunkPrimaryClientId as '@clientId',
									@splunkPrimaryClientName as '@clientName'
									FOR XML PATH('entity'), TYPE)
					FOR XML PATH('primaryNode'), TYPE),
						(SELECT
						@splunkUser as '@userName',
						@splunkPassword as '@password'
						FOR XML PATH('splunkUser'), TYPE)
						,(SELECT
							property.value('(/nodes/@path)[1]', 'nvarchar(256)') as '@path',
							(SELECT
								property.value('(/nodes/entity/@clientId)[1]', 'nvarchar(256)') as '@clientId',
								property.value('(/nodes/entity/@clientName)[1]', 'nvarchar(256)') as '@clientName'
							FOR XML PATH('entity'),TYPE)
						FROM App_SplunkNodes
						WHERE instanceId=@instanceId and modified = 0
						FOR XML PATH('nodes'),TYPE)
					FOR XML PATH('splunkConfig'), TYPE)
				FOR XML PATH('clusterConfig'), TYPE)
			FOR XML PATH('dcInstance'), TYPE);
		END
		ELSE IF @opType = 2 -- SET
		BEGIN
			DECLARE @splunkNodesToUpdate TABLE(nodeClientId integer, property XML, isDeleted bit, isNew bit)
			insert into @splunkNodesToUpdate
			select
			COALESCE(node.prop.value('(entity/@clientId)[1]', 'integer'),splunkNode.property.value('(*/entity/@clientId)[1]', 'integer'))
			,
				(SELECT
					node.prop.value('@path', 'nvarchar(256)') as '@path',
						(SELECT
							node.prop.value('(entity/@clientId)[1]', 'integer') as '@clientId',
							node.prop.value('(entity/@clientName)[1]', 'nvarchar(256)') as '@clientName'
						FOR XML PATH('entity'), TYPE)
					FOR XML PATH('nodes'), TYPE)
			,CASE WHEN node.prop IS NULL THEN 1 ELSE 0 END -- isDeleted
			,CASE WHEN splunkNode.nodeClientId IS NULL THEN 1 ELSE 0 END -- isNew
			from
			@i_xml.nodes('/App_DistributedClusterInstanceReq/dcInstance/clusterConfig/splunkConfig/nodes') as node(prop)
			FULL OUTER JOIN
				(
					SELECT nodeClientId, instanceId, property
					FROM APP_SplunkNodes
					WHERE instanceId = @instanceId AND modified = 0
				) as splunkNode
					ON node.prop.value('(entity/@clientId)[1]', 'integer') = splunkNode.property.value('(*/entity/@clientId)[1]', 'integer')
			WHERE ISNULL(splunkNode.nodeClientId,0) <> ISNULL(node.prop.value('(entity/@clientId)[1]', 'integer'),0)
				OR ISNULL(node.prop.value('(entity/@clientName)[1]', 'nvarchar(256)'),'') <> ISNULL(splunkNode.property.value('(*/entity/@clientName)[1]', 'nvarchar(256)'),'')
				OR ISNULL(node.prop.value('@path', 'nvarchar(256)'),'') <> ISNULL(splunkNode.property.value('(/nodes/@path)[1]', 'nvarchar(256)'),'')
			--------------------------------------------------------------------------------------
			--		Set modified time for modified & deleted nodes								--
			--------------------------------------------------------------------------------------
			UPDATE SN
			SET modified = @currentTime
			FROM @splunkNodesToUpdate as uNodes
			JOIN APP_SplunkNodes SN ON SN.instanceId=@instanceId AND SN.modified=0 AND SN.nodeClientId=uNodes.nodeClientId
			WHERE uNodes.IsNew=0
			---------------------------------------------------------------------------------------
			--		Insert new & updated nodes 	 												 --
			---------------------------------------------------------------------------------------
			INSERT INTO APP_SplunkNodes
			SELECT nodeClientId, @instanceId, property, @currentTime, 0
			FROM @splunkNodesToUpdate
			WHERE isDeleted=0
		END
		ELSE IF @opType = 3 -- LISTNODES
		BEGIN
			SET @xmlResult =
				(SELECT
					@clusterType as '@clusterType',
					(SELECT
						@instanceId as '@instanceId',
						dbo.encodeInvalidXMLChar(@instanceName) as '@instanceName'
					FOR XML PATH('instance'), TYPE),
					(SELECT
						(SELECT
							(SELECT
								SN.property.value('(/nodes/@path)[1]','nvarchar(max)') as '@path'
								,(SELECT
									SN.property.value('(*/entity/@clientId)[1]','int') as '@clientId',
									SN.property.value('(*/entity/@clientName)[1]','nvarchar(256)') as '@clientName'
								FOR XML PATH('entity'), TYPE)
							FROM App_SplunkNodes SN
							WHERE instanceId = @instanceId AND created <= @pit AND (modified = 0 OR modified > @pit)
							FOR XML PATH('nodes'), TYPE)
						FOR XML PATH('splunkConfig'), TYPE)
					FOR XML PATH('clusterConfig'), TYPE)
				FOR XML PATH('dcInstance'), TYPE);
		END
	END
	----
	ELSE
	BEGIN
		SET @errorCode = 3
		SET @errorMsg = 'Invalid clusterType ' + CONVERT(VARCHAR(8), @clusterType) + ' found.'
	END
SELECT	@xmlResult,
		(SELECT
			@errorCode as '@errorCode',
			@errorMsg as '@errorMessage'
			FOR XML PATH('error'), TYPE)
FOR XML PATH('App_DistributedClusterInstanceResp'), TYPE
IF object_id('temp.dbo.#newInstanceProperties') IS NOT null DROP TABLE #newInstanceProperties
IF object_id('temp.dbo.#SegmentstoUpdate') IS NOT null DROP TABLE #SegmentstoUpdate
IF object_id('temp.dbo.#MongosToUpdate') IS NOT null DROP TABLE #MongosToUpdate
GO

IF EXISTS (select * from GxQscripts where name = 'DistributedClusterInstanceInfo')
	delete from GxQscripts where name = 'DistributedClusterInstanceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DistributedClusterInstanceInfo')
	delete from GXDBVersions where aliasname = 'DistributedClusterInstanceInfo'
GO

insert into GXDBVersions values(2, 'DistributedClusterInstanceInfo',  '00000000000000000000', 'DistributedClusterInstanceInfo', '00000000000000000000')
GO

