

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DisableReportSchedules.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DisableReportSchedules.sp,v $ $Id: DisableReportSchedules.sp,v 1.1.54.1 2018/03/20 00:33:12 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  DisableReportSchedules()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output: Disables all the schedules for metrics commcell or web report
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhushan Kharabe   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DisableReportSchedules <<<'

IF EXISTS (select * from sysobjects where name='DisableReportSchedules')
	drop procedure DisableReportSchedules
IF EXISTS (select * from GxQscripts where name='DisableReportSchedules')
	delete from GxQscripts where name = 'DisableReportSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DisableReportSchedules')
	delete from GXDBVersions where aliasname = 'DisableReportSchedules'
GO
print '... Creating Procedure: DisableReportSchedules'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DisableReportSchedules
  @commcellMapId int = 0,
  @reportId int = 0
AS
SET NOCOUNT ON
BEGIN
IF( @commcellMapId <> 0)
BEGIN
	UPDATE TM_Task SET disabled = 1
	WHERE taskId IN
	(SELECT 	taskId
	FROM TM_SubTaskXMLOptions STO
	INNER JOIN TM_SubTask ST
	ON STO.subTaskId = ST.subTaskId
	AND ST.operationType = 4004
	CROSS APPLY STO.xmlValue.nodes('/TMMsg_JobOption/adminOpts/reportOption') AS OPT(o)
	WHERE o.exist('//webReportOption') = 1
	AND o.value('webReportOption[1]/@reportId', 'nvarchar(255)') LIKE '%commUniId=' + CONVERT(nvarchar(20), @commcellMapId) + '%')
END
IF( @reportId <> 0)
BEGIN
	UPDATE TM_Task SET disabled = 1
	WHERE taskId IN
	(SELECT 	taskId
	FROM TM_SubTaskXMLOptions STO
	INNER JOIN TM_SubTask ST
	ON STO.subTaskId = ST.subTaskId
	AND ST.operationType = 4004
	CROSS APPLY STO.xmlValue.nodes('/TMMsg_JobOption/adminOpts/reportOption') AS OPT(o)
	WHERE o.exist('//webReportOption') = 1
	AND o.value('webReportOption[1]/@reportId', 'nvarchar(255)') = CONVERT(nvarchar(20), @reportId))
END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DisableReportSchedules')
	delete from GxQscripts where name = 'DisableReportSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DisableReportSchedules')
	delete from GXDBVersions where aliasname = 'DisableReportSchedules'
GO

insert into GXDBVersions values(2, 'DisableReportSchedules',  '00010001005400010000', 'DisableReportSchedules', '00010001005400010000')
GO

