

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Diag_XEOperations.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Diag_XEOperations.sp,v $ $Id: Diag_XEOperations.sp,v 1.1.2.2 2020/11/20 15:39:40 abilbrey Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Diag_XEOperations')
BEGIN
	print '>>> Drop Stored Procedure: Diag_XEOperations <<<'
	drop procedure Diag_XEOperations
END
IF EXISTS (select * from GxQscripts where name='Diag_XEOperations')
	delete from GxQscripts where name = 'Diag_XEOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Diag_XEOperations')
	delete from GXDBVersions where aliasname = 'Diag_XEOperations'
GO
print '... Creating Procedure: Diag_XEOperations'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Diag_XEOperations
  @status INT,
  @opType INT,
  @xeName VARCHAR(128),
  @errorCode INT OUTPUT,
  @errorMsg VARCHAR(128) OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	-- Determine if Windows, Linux, Azure SQL Server
	DECLARE @windows TINYINT = 1
    DECLARE @linux TINYINT = 2
    DECLARE @AruzeSQLMangedInstance TINYINT = 3
	DECLARE @sqlVersion		NVARCHAR(MAX),
			@osType			TINYINT,
			@newLine		NVARCHAR(4),
			@pathSep		NVARCHAR(2)
	EXEC SQLServerOSType @sqlVersion OUTPUT, @osType OUTPUT, @newLine OUTPUT, @pathSep OUTPUT
	SET @errorCode = 0
	SET @errorMsg = 'Success'
	-- CS_TempdbMonitor Only valid on SQL Server 2014 SP2+
	DECLARE @CS_TempdbMonitor_cfg NVARCHAR(MAX) = N'
CREATE EVENT SESSION [CS_TempdbMonitor] ON SERVER
ADD EVENT sqlserver.database_file_size_change(
    ACTION(package0.event_sequence,sqlserver.client_connection_id,sqlserver.client_hostname,sqlserver.client_pid,sqlserver.database_id,sqlserver.session_id,sqlserver.sql_text,sqlserver.tsql_stack)
    WHERE ([database_id]=(2) AND [session_id]>(50))),
ADD EVENT sqlserver.databases_log_file_size_changed(
    ACTION(package0.event_sequence,sqlserver.client_connection_id,sqlserver.client_hostname,sqlserver.database_id,sqlserver.session_id,sqlserver.sql_text,sqlserver.tsql_stack)
    WHERE ([package0].[equal_uint64]([database_id],(2)) AND [package0].[greater_than_uint64]([sqlserver].[session_id],(50)))),
ADD EVENT sqlserver.exchange_spill(
    ACTION(sqlserver.client_app_name,sqlserver.session_id,sqlserver.sql_text,sqlserver.tsql_stack)
    WHERE ([package0].[counter]<(150))),
ADD EVENT sqlserver.hash_spill_details(
    ACTION(sqlserver.client_connection_id,sqlserver.session_id,sqlserver.sql_text,sqlserver.tsql_stack)
    WHERE ([workfile_physical_writes]>(10000) AND [package0].[counter]<(50))),
ADD EVENT sqlserver.hash_warning(
    ACTION(sqlserver.client_app_name,sqlserver.session_id,sqlserver.sql_text,sqlserver.tsql_stack)
    WHERE ([workfile_physical_writes]>(10000) AND [package0].[counter]<(50))),
ADD EVENT sqlserver.sort_warning(
    ACTION(sqlserver.client_app_name,sqlserver.session_id,sqlserver.sql_text,sqlserver.tsql_stack)
    WHERE ([package0].[counter]<(100) AND [worktable_physical_reads]>(10000)))
ADD TARGET package0.event_file(SET filename=N''__XE_NAME_HERE__'',max_file_size=(10),max_rollover_files=(5))
WITH (MAX_MEMORY=4096 KB,EVENT_RETENTION_MODE=ALLOW_SINGLE_EVENT_LOSS,MAX_DISPATCH_LATENCY=5 SECONDS,MAX_EVENT_SIZE=0 KB,MEMORY_PARTITION_MODE=NONE,TRACK_CAUSALITY=OFF,STARTUP_STATE=ON)
'
	DECLARE @CSBlockedSessions_cfg NVARCHAR(MAX) = N'
CREATE EVENT SESSION [CSBlockedSessions] ON SERVER
ADD EVENT sqlserver.blocked_process_report(
    ACTION(sqlserver.client_app_name,sqlserver.client_hostname,sqlserver.database_name)),
ADD EVENT sqlserver.xml_deadlock_report(
    ACTION(sqlserver.client_app_name,sqlserver.client_hostname,sqlserver.database_name))
ADD TARGET package0.event_file(SET filename=N''__XE_NAME_HERE__'',max_file_size=(5),max_rollover_files=(6))
WITH (MAX_MEMORY=4096 KB,EVENT_RETENTION_MODE=ALLOW_SINGLE_EVENT_LOSS,MAX_DISPATCH_LATENCY=5 SECONDS,MAX_EVENT_SIZE=0 KB,MEMORY_PARTITION_MODE=NONE,TRACK_CAUSALITY=OFF,STARTUP_STATE=ON)
'
	DECLARE @xeStartCmd NVARCHAR(MAX) = 'ALTER EVENT SESSION __XE_NAME_HERE__ ON SERVER STATE = START;'
	DECLARE @xeDropCmd NVARCHAR(MAX) = 'DROP EVENT SESSION __XE_NAME_HERE__ ON SERVER;'
	-- Validate XE Name for supported names
	DECLARE @xeSqlCmd NVARCHAR(MAX) = NULL
	SELECT
		 @xeSqlCmd = CASE @xeName
						WHEN 'CS_TempDbMonitor' THEN @CS_TempdbMonitor_cfg
						WHEN 'CSBlockedSessions' THEN @CSBlockedSessions_cfg
						ELSE NULL
					END
	IF (@xeSqlCmd IS NULL)
	BEGIN
		SET @errorCode = 100
		SET @errorMsg = 'XE Name [' + @xeName + '] not supported.'
		RETURN @errorCode
	END
	-- Valid Op Type?
	IF (@opType NOT IN (1,2))
	BEGIN
		SET @errorCode = 101
		SET @errorMsg = 'Operation Type [' + CAST(@opType AS VARCHAR(12)) + '] invalid.'
		RETURN @errorCode
	END
	-- Set XE Filename in creation script
	IF (@osType = @AruzeSQLMangedInstance)
	BEGIN
		DECLARE @defAzureXEContainer NVARCHAR(128) = N'cv-extendedevents'
		-- Check if the Azure Storage Container has been overriden
		SELECT
			@defAzureXEContainer = CAST(value AS NVARCHAR(128))
		FROM GXGlobalParam WITH(NOLOCK)
		WHERE
			name = N'CV_Azure_XEContainer_Name'
			AND modified = 0
		-- Now lookup the Azure Container URL
		DECLARE @azureURL NVARCHAR(512) = NULL
		SET @defAzureXEContainer = N'%' + @defAzureXEContainer + N'%'
		SELECT TOP 1
			@azureURL = name
		FROM master.sys.credentials WITH(NOLOCK)
		WHERE
			name LIKE @defAzureXEContainer
		IF (@azureURL IS NULL)
		BEGIN
			SET @errorCode = 200
			SET @errorMsg = 'Azure XE Storage Container is not configured in master.sys.credentials for [' + @defAzureXEContainer + ']'
			RETURN @errorCode
		END
		DECLARE @azureFilePath NVARCHAR(MAX) = @azureURL + @pathSep + @xeName
		SELECT @xeSqlCmd = REPLACE(@xeSqlCmd, '__XE_NAME_HERE__', @azureFilePath)
	END
	ELSE
	BEGIN
		-- Regular SQL Server replace with just XE Name
		SELECT @xeSqlCmd = REPLACE(@xeSqlCmd, '__XE_NAME_HERE__', @xeName)
	END
	IF (@opType = 1)
	BEGIN
		-- XE Configuration
		IF (@status = 0)
		BEGIN
			BEGIN TRY
				-- configure XE and start it
				EXEC(@xeSqlCmd)
				SELECT @xeSqlCmd = REPLACE(@xeStartCmd, '__XE_NAME_HERE__', @xeName)
				EXEC(@xeSqlCmd)
			END TRY
			BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
				SET @errorCode = 500
				SET @errorMsg = ERROR_MESSAGE()
				RETURN @errorCode
			END CATCH
		END
		ELSE IF (@status = 1)
		BEGIN
			-- Just need to start it
			BEGIN TRY
				SELECT @xeSqlCmd = REPLACE(@xeStartCmd, '__XE_NAME_HERE__', @xeName)
				EXEC(@xeSqlCmd)
			END TRY
			BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
				SET @errorCode = 501
				SET @errorMsg = ERROR_MESSAGE()
				RETURN @errorCode
			END CATCH
		END
	END
	ELSE
	BEGIN
		-- XE Deconfiguration
		IF (@status <> 0)
		BEGIN
			BEGIN TRY
				SELECT @xeSqlCmd = REPLACE(@xeDropCmd, '__XE_NAME_HERE__', @xeName)
				EXEC(@xeSqlCmd)
			END TRY
			BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
				SET @errorCode = 502
				SET @errorMsg = ERROR_MESSAGE()
				RETURN @errorCode
			END CATCH
		END
	END
	RETURN @errorCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'Diag_XEOperations')
	delete from GxQscripts where name = 'Diag_XEOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Diag_XEOperations')
	delete from GXDBVersions where aliasname = 'Diag_XEOperations'
GO

insert into GXDBVersions values(2, 'Diag_XEOperations',  '00010001000200020000', 'Diag_XEOperations', '00010001000200020000')
GO

