

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DeleteTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author:
--	Date:
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DeleteTopology.sp,v $ $Id: DeleteTopology.sp,v 1.1.2.14 2020/08/13 22:30:06 sneralla Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='deleteTopology')
BEGIN
	print '>>> Drop Stored Procedure: deleteTopology <<<'
	drop procedure deleteTopology
END
IF EXISTS (select * from GxQscripts where name='deleteTopology')
	delete from GxQscripts where name = 'deleteTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='deleteTopology')
	delete from GXDBVersions where aliasname = 'deleteTopology'
GO
print '... Creating Procedure: deleteTopology'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure deleteTopology
  @topologyId INT,
  @topologies NWTopoGroupInfoTableType READONLY,
  @topologyType INT,
  @extendedOptions XML
AS
DECLARE @external	int
DECLARE @internal	int
DECLARE	@proxied	int
DECLARE @perimeterProxy int
DECLARE @clientGroupId INT = 0
DECLARE @fwGroupType INT = 0
DECLARE @isTopoSmart INT = 0
DECLARE @oldAppFirewallToBeDel TABLE (routeId INT)
DECLARE @oldAppFwOutgoingRoutesToBeDel TABLE (routeId INT)
DECLARE @encryptTraffic INT = ISNULL(@extendedOptions.value('/App_TopologyExtendedProperties[1]/@encryptTraffic', 'int'), 0)
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	SELECT
       @internal = CASE t.fwGroupType
WHEN 1 THEN t.clientGroupId
                                  ELSE @internal
                           END,
       @external = CASE t.fwGroupType
WHEN 2 THEN t.clientGroupId
                                  ELSE @external
                           END,
       @proxied = CASE t.fwGroupType
WHEN 3 THEN t.clientGroupId
                                  ELSE @proxied
                           END,
	   @perimeterProxy = CASE t.fwGroupType
WHEN 4 THEN t.clientGroupId
								  ELSE @perimeterProxy
						   END
	FROM @topologies t
SELECT @isTopoSmart = ( flag & 1 ) FROM APP_FirewallTopology WHERE topologyId = @topologyId
	INSERT INTO @oldAppFirewallToBeDel
	SELECT routeId FROM App_FirewallRoutesTopoAssoc WHERE topologyId = @topologyId
	-- Update flag column to indicate smart vs non-smart
	IF @isTopoSmart=1
	BEGIN
		UPDATE AF
SET AF.flag=(AF.flag & ~4)
		FROM APP_Firewall AF
		INNER JOIN @oldAppFirewallToBeDel Old
		ON AF.id=Old.routeId
		LEFT OUTER JOIN
		(	SELECT RTA.routeId
			FROM  App_FirewallRoutesTopoAssoc RTA
			INNER JOIN APP_FirewallTopology AFT
			ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 = 1 AND AFT.topologyId <> @topologyId
		) Rout
		ON Old.routeId = Rout.routeId
		WHERE Rout.routeId IS NULL
	END
	ELSE
	BEGIN
		UPDATE AF
SET AF.flag=(AF.flag & ~2)
		FROM APP_Firewall AF
		INNER JOIN @oldAppFirewallToBeDel Old
		ON AF.id=Old.routeId
		LEFT OUTER JOIN
		(	SELECT RTA.routeId
			FROM  App_FirewallRoutesTopoAssoc RTA
			INNER JOIN APP_FirewallTopology AFT
			ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 = 0  AND AFT.topologyId <> @topologyId
		) Rout
		ON Old.routeId = Rout.routeId
		WHERE Rout.routeId IS NULL
	END
	-- Don't delete routeIds that are being referenced by other topologies
	DELETE OAF
	FROM @oldAppFirewallToBeDel OAF
	INNER JOIN App_FirewallRoutesTopoAssoc AFRTA ON OAF.routeId = AFRTA.routeId AND topologyId <> @topologyId
	INSERT INTO @oldAppFwOutgoingRoutesToBeDel
	SELECT routeId FROM App_FWOutGoingRoutesTopoAssoc WHERE topologyId = @topologyId
	-- Update flag column to indicate smart vs non-smart
	IF @isTopoSmart=1
	BEGIN
		UPDATE AF
SET AF.flag=(AF.flag & ~4)
		FROM App_FwOutGoingRoutes AF
		INNER JOIN @oldAppFwOutgoingRoutesToBeDel Old
		ON AF.id=Old.routeId
		LEFT OUTER JOIN
		(	SELECT RTA.routeId
			FROM  App_FWOutGoingRoutesTopoAssoc RTA
			INNER JOIN APP_FirewallTopology AFT
			ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 = 1 AND AFT.topologyId <> @topologyId
		) Rout
		ON Old.routeId = Rout.routeId
		WHERE Rout.routeId IS NULL
	END
	ELSE
	BEGIN
		UPDATE AF
SET AF.flag=(AF.flag & ~2)
		FROM App_FwOutGoingRoutes AF
		INNER JOIN @oldAppFwOutgoingRoutesToBeDel Old
		ON AF.id=Old.routeId
		LEFT OUTER JOIN
		(	SELECT RTA.routeId
			FROM  App_FWOutGoingRoutesTopoAssoc RTA
			INNER JOIN APP_FirewallTopology AFT
			ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 = 0  AND AFT.topologyId <> @topologyId
		) Rout
		ON Old.routeId = Rout.routeId
		WHERE Rout.routeId IS NULL
	END
	-- We want to update with opposite
	DECLARE @connectionProtocol INT
	IF @encryptTraffic=1
SET @connectionProtocol=2
	ELSE
SET @connectionProtocol=1
	-- Update route connectionProtocol as per "encryptTraffic" property of topology
	UPDATE FO
	SET fwOutGoingRouteOptions.modify('
				replace value of (/App_FireWallOutGoingRouteOptions/@connectionProtocol)[1]
				with sql:variable("@connectionProtocol")
	')
	FROM App_FWOutGoingRoutes FO
	INNER JOIN @oldAppFwOutgoingRoutesToBeDel TD
	ON FO.id=TD.routeId
	WHERE @encryptTraffic NOT IN (
		SELECT ISNULL(Props.p.value('@encryptTraffic', 'int'), 0)
		FROM App_FWOutGoingRoutes AFOR
		INNER JOIN App_FWOutGoingRoutesTopoAssoc Assoc
		ON AFOR.id=Assoc.routeId
		INNER JOIN @oldAppFwOutgoingRoutesToBeDel TD
		ON AFOR.id=TD.routeId
		INNER JOIN APP_FirewallTopology AFT
		ON Assoc.topologyId=AFT.topologyId
		CROSS APPLY AFT.extendedProperties.nodes('/App_TopologyExtendedProperties') Props(p)
		WHERE AFT.topologyId<>@topologyId)
	-- Find out if the route is part of multiple topologies
	DECLARE @RoutePartOfMultipleTopologies TABLE (routeId INTEGER, topologyId INTEGER, connectionProtocol INTEGER, numberOfStreams INTEGER, connectionProtocolRank INTEGER)
	-- Old topologies created before SP21 or via commcell console do not have the connectionProtocol set. They only have encryptTraffic attribute.
	INSERT INTO @RoutePartOfMultipleTopologies (routeId, topologyId, connectionProtocol, numberOfStreams)
	SELECT FWORA1.routeId, FWORA2.topologyId,  CASE ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@encryptTraffic', 'INTEGER'), 0)
WHEN 1 THEN 1
ELSE ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@connectionProtocol', 'INTEGER'), 2) END, ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@numberOfStreams', 'INTEGER'), 1)
	FROM App_FWOutGoingRoutesTopoAssoc FWORA1
	INNER JOIN App_FWOutGoingRoutesTopoAssoc FWORA2
	ON FWORA1.routeId=FWORA2.routeId
	INNER JOIN APP_FirewallTopology FT
	ON FWORA2.topologyId=FT.topologyId
	CROSS APPLY FT.extendedProperties.nodes('/App_TopologyExtendedProperties') Props(col)
	WHERE FWORA1.topologyId = @topologyId AND FWORA1.topologyId<>FWORA2.topologyId -- We shouldn't consider options from the route that is about to be deleted
	Update FO
		set extendedProperties.modify('
			replace value of (/App_FirewallExtendedProperties/@defaultOutgoingProtocol)[1]
			with "0"
		')
		from App_FirewallOptions FO
		inner join APP_FirewallTopologyAssoc FTA1
		on FO.clientGroupId=FTA1.groupId
		where FTA1.topologyId=@topologyId and  FO.clientGroupId not in
		(
		select FTA.groupId
		from APP_FirewallTopology FT
		inner join APP_FirewallTopologyAssoc FTA
		on FT.topologyId=FTA.topologyId
		where FTA.groupId in ( select groupid from APP_FirewallTopologyAssoc where topologyId=@topologyId)
		and FT.topologyId<>@topologyId -- current topology id
		and FT.extendedProperties.value('(/App_TopologyExtendedProperties/@encryptTraffic)[1]','int') = 1
		)
	-- Don't delete routeIds that are being referenced by other topologies
	DELETE OAFR
	FROM @oldAppFwOutgoingRoutesToBeDel OAFR
	INNER JOIN App_FWOutGoingRoutesTopoAssoc AFRTA ON OAFR.routeId = AFRTA.routeId AND topologyId <> @topologyId
	DELETE AF
	FROM APP_Firewall AF INNER JOIN @oldAppFirewallToBeDel OldRoutes ON AF.id = OldRoutes.routeId
	DELETE AFOR
	FROM App_FWOutGoingRoutes AFOR INNER JOIN @oldAppFwOutgoingRoutesToBeDel OldRoutes ON AFOR.id = OldRoutes.routeId
	DECLARE @ThisTopoCGsNotInMultipleTopos TABLE (clientGroupId INTEGER)
	INSERT INTO @ThisTopoCGsNotInMultipleTopos
	SELECT AFTA.groupId AS clientGroupId
	FROM APP_FirewallTopologyAssoc AFTA
	INNER JOIN @topologies TP2
	ON AFTA.groupId=TP2.clientGroupId
	WHERE AFTA.groupId > 0
	GROUP BY AFTA.groupId
	HAVING COUNT (*) = 1
	DELETE FW
	FROM [dbo].[App_FirewallOptions] FW
	INNER JOIN @ThisTopoCGsNotInMultipleTopos ToBeDeleted
	ON FW.clientGroupId = ToBeDeleted.clientGroupId
	-- Update flag to reflect smart vs non-smart
	IF @isTopoSmart=1
	BEGIN
		UPDATE AFO
SET AFO.flag=(AFO.flag & ~4)
		FROM App_FirewallOptions AFO
		INNER JOIN @topologies InputT
		ON AFO.clientGroupId = InputT.clientGroupId
		LEFT OUTER JOIN
		(	SELECT groupId
			FROM APP_FirewallTopology AFT
			INNER JOIN APP_FirewallTopologyAssoc AFTA
			ON AFT.topologyId=AFTA.topologyId
			INNER JOIN @topologies T
			ON AFTA.groupId=T.clientGroupId
WHERE AFT.flag & 1 = 1 AND AFT.topologyId <> @topologyId
		) Topo
		ON AFO.clientGroupId = Topo.groupId
		WHERE Topo.groupId IS NULL
	END
	ELSE
	BEGIN
		UPDATE AFO
SET AFO.flag=(AFO.flag & ~2)
		FROM App_FirewallOptions AFO
		INNER JOIN @topologies InputT
		ON AFO.clientGroupId = InputT.clientGroupId
		LEFT OUTER JOIN
		(	SELECT groupId
			FROM APP_FirewallTopology AFT
			INNER JOIN APP_FirewallTopologyAssoc AFTA
			ON AFT.topologyId=AFTA.topologyId
			INNER JOIN @topologies T
			ON AFTA.groupId=T.clientGroupId
WHERE AFT.flag & 1 = 0 AND AFT.topologyId <> @topologyId
		) Topo
		ON AFO.clientGroupId = Topo.groupId
		WHERE Topo.groupId IS NULL
	END
	-- If the external CG is part of multiple topologies and has the useWildCardProxy option,
	-- We have to check if it is external in any other proxy topology and if it isn't, we should remove the option
IF @topologyType=1 /*proxy*/
	BEGIN
		IF NOT EXISTS (SELECT 1
						FROM APP_FirewallTopologyAssoc FTA
						INNER JOIN APP_FirewallTopology FT
						ON FTA.topologyId=FT.topologyId AND FT.topologyId<>@topologyId
AND FT.topologyType=1
						WHERE FTA.groupId=@external AND FTA.fwGroupType=2)
		BEGIN
			EXEC AppDeleteProxyWildCardOption @external
		END
	END
IF @proxied>0 AND (@topologyType=1 OR @topologyType=4)
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM APP_FirewallTopologyAssoc AFTA INNER JOIN APP_FirewallTopology AFT
		ON AFTA.topologyId = AFT.topologyId AND AFT.topologyId <> @topologyId
AND (AFT.topologyType = 1 OR AFT.topologyType = 4)
WHERE AFTA.groupId = @proxied AND (AFTA.fwGroupType = 3 OR AFTA.fwGroupType = 4))
		BEGIN
			UPDATE APP_FirewallOptions
			SET isDMZ = 0
			WHERE clientGroupId = @proxied
		END
	END
IF @perimeterProxy>0 AND @topologyType=4
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM APP_FirewallTopologyAssoc AFTA INNER JOIN APP_FirewallTopology AFT
		ON AFTA.topologyId = AFT.topologyId AND AFT.topologyId <> @topologyId
AND (AFT.topologyType = 1 OR AFT.topologyType = 4)
WHERE AFTA.groupId = @perimeterProxy AND (AFTA.fwGroupType = 3 OR AFTA.fwGroupType = 4))
		BEGIN
			UPDATE APP_FirewallOptions
			SET isDMZ = 0
			WHERE clientGroupId = @perimeterProxy
		END
	END
	IF @isTopoSmart = 0
	BEGIN
		UPDATE  FWTC
SET isTrivialConfig = 0
		FROM [dbo].[App_FWTrivialConfig] FWTC
		INNER JOIN @topologies T ON FWTC.clientGroupId = T.clientGroupId
		LEFT JOIN
		(SELECT AFTA.groupId FROM APP_FirewallTopologyAssoc AFTA INNER JOIN @topologies T ON AFTA.groupId = T.clientGroupId INNER JOIN APP_FirewallTopology AFT ON AFTA.topologyId = AFT.topologyId AND AFT.flag & 1 <> 1 WHERE AFT.topologyId <> @topologyId) TopoCGAssoc(groupId)
		ON TopoCGAssoc.groupId = FWTC.clientGroupId
		WHERE TopoCGAssoc.groupId IS NULL
	END
-- Start of UpdateTopologySpecificOptions
	-- Now update Topology specific options
	-- We need to consider MAX of numberOfStreams
	DECLARE @RouteStreams TABLE(routeId INTEGER, numberOfStreams INTEGER)
	INSERT INTO @RouteStreams
	SELECT routeId, MAX(numberOfStreams)
	FROM @RoutePartOfMultipleTopologies
	GROUP BY routeId
	-- Update App_FWOutGoingRoutes accordingly
	UPDATE FWOR
	SET fwOutGoingRouteOptions.modify(' replace value of (/App_FireWallOutGoingRouteOptions/@numberOfStreams)[1]
            with sql:column("RS.numberOfStreams")')
	FROM App_FWOutGoingRoutes FWOR
	INNER JOIN @RouteStreams RS
	ON FWOR.id=RS.routeId
	-- For connectionProtocol, we have the following priority order : https (1) > httpsa (2) > http (0) > raw  (3)
	-- For ease of enforcing this priority, let us map connection protocols to the following ranks
	-- Rank 1 => HTTPS	(enum value 1)
	-- Rank 2 => HTTPSA (enum value 2)
	-- Rank 3 => HTTP	(enum value 0)
	-- Rank 4 => RAW	(enum value 3)
	UPDATE @RoutePartOfMultipleTopologies
SET connectionProtocolRank = CASE connectionProtocol WHEN 1 THEN 1
WHEN 2	THEN 2
WHEN 0 THEN 3
WHEN 3 THEN 4
														 END
	DECLARE @RouteProtocol TABLE(routeId INTEGER, connectionProtocolRank INTEGER, connectionProtocol INTEGER)
	INSERT INTO @RouteProtocol (routeId, connectionProtocolRank)
	SELECT routeId, MIN(connectionProtocolRank)
	FROM @RoutePartOfMultipleTopologies
	GROUP BY routeId
	-- Reverse mapping rank to protocol (as we cannot use rank directly in xml.modify(replace value of) with a case statement)
	UPDATE @RouteProtocol
SET connectionProtocol = CASE connectionProtocolRank WHEN 1 THEN 1
WHEN 2	THEN 2
WHEN 3 THEN 0
WHEN 4 THEN 3
														 END
	-- Update App_FWOutGoingRoutes accordingly
	UPDATE FWOR
	SET fwOutGoingRouteOptions.modify(' replace value of (/App_FireWallOutGoingRouteOptions/@connectionProtocol)[1]
            with sql:column("RP.connectionProtocol")')
	FROM App_FWOutGoingRoutes FWOR
	INNER JOIN @RouteProtocol RP
	ON FWOR.id=RP.routeId
-- End of UpdateTopologySpecificOptions
END
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteTopology')
	delete from GxQscripts where name = 'DeleteTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteTopology')
	delete from GXDBVersions where aliasname = 'DeleteTopology'
GO

insert into GXDBVersions values(2, 'DeleteTopology',  '00010001000200140000', 'DeleteTopology', '00010001000200140000')
GO

