

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DeleteThirdPartyAppsForCompany.sp] ---------- 

--  +=============================================================================================+
--  |						Name: DeleteThirdPartyAppsForCompany()
--  | Description: Deletes all thirdparty apps(right now it has support for saml apps only)
--	|  Usage: while deleting a company.
--  |
--  |       Input: companyId, userId, localeId,skipSecCheck
--  +=============================================================================================+
------------------
--   PARAMETERS
------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DeleteThirdPartyAppsForCompany')
BEGIN
	print '>>> Drop Stored Procedure: DeleteThirdPartyAppsForCompany <<<'
	drop procedure DeleteThirdPartyAppsForCompany
END
IF EXISTS (select * from GxQscripts where name='DeleteThirdPartyAppsForCompany')
	delete from GxQscripts where name = 'DeleteThirdPartyAppsForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteThirdPartyAppsForCompany')
	delete from GXDBVersions where aliasname = 'DeleteThirdPartyAppsForCompany'
GO
print '... Creating Procedure: DeleteThirdPartyAppsForCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DeleteThirdPartyAppsForCompany
  @companyId INT, 
  @userId INT, 
  @localeId INT = 0, 
  @skipSecCheck INT = 0
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
IF @skipSecCheck = 0
BEGIN
	IF NOT EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id
WHERE ((UG.groupFlags & 0x10000 <> 0) or (UG.groupFlags & 0x40000 <> 0)) and UU.userId=@userId and UG.umdsProviderId = @companyId)
		BEGIN
			SET @errorCode = 1
SET @errorString = ( SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId )
		END
	ELSE
	BEGIN
		DECLARE @isAdminUser INT
		--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
		IF(@isAdminUser = 0)
		BEGIN
			SET @errorCode  = 1
SET @errorString = ( SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId )
			GOTO SCRIPT_EXIT
		END
	END
END
DECLARE @appKeysForDeletion TABLE (appKey nvarchar(40))
DECLARE @query XML
insert into @appKeysForDeletion (appKey) (SELECT atp.appKey FROM App_ThirdPartyApp ATP JOIN UMDSProviderProp umdsprop on ATP.id = cast(umdsprop.attrVal as INTEGER)
										JOIN UMDSProviders umds on umds.id = umdsprop.componentNameId
WHERE umdsprop.attrName = 'SAML IDP' and umds.serviceType = 11 and umds.ownerCompany = @companyId )
SET @query =
	(SELECT 2 as '@opType',
		(SELECT
			(SELECT @userid as '@userId' FOR XML PATH('user'),TYPE),
			(SELECT @localeId as '@localeId' FOR XML PATH('locale'),TYPE)
		FOR XML PATH('processinginstructioninfo'), TYPE),
		(SELECT appKey as '@appKey' FROM @appKeysForDeletion
		FOR XML PATH('clientThirdPartyApps') ,TYPE)
    FOR XML PATH('App_SetClientThirdPartyAppPropReq'), TYPE)
DECLARE @tempTable TABLE(outXml XML)
INSERT INTO @tempTable
EXEC AppSetThirdPartyAppInfo @query
select @errorCode = outXml.value('(/App_SetClientThirdPartyAppPropResp/error[1]/@errorCode)[1]', 'nvarchar(20)'),
@errorString = outXml.value('(/App_SetClientThirdPartyAppPropResp/error[1]/@errorString)[1]','nvarchar(200)') from @tempTable
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SELECT @errorCode as 'errorCode', @errorString as 'errorString'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteThirdPartyAppsForCompany')
	delete from GxQscripts where name = 'DeleteThirdPartyAppsForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteThirdPartyAppsForCompany')
	delete from GXDBVersions where aliasname = 'DeleteThirdPartyAppsForCompany'
GO

insert into GXDBVersions values(2, 'DeleteThirdPartyAppsForCompany',  '00000000000000000000', 'DeleteThirdPartyAppsForCompany', '00000000000000000000')
GO

