

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DeleteStoreApp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DeleteStoreApp.sp,v $ $Id: DeleteStoreApp.sp,v 1.1.2.5 2018/03/20 00:48:08 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		            Procedure   : "DeleteStoreApp"	         		    |
--  |                 Gets App information for App Builder                  |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DeleteStoreApp <<<'

IF EXISTS (select * from sysobjects where name='DeleteStoreApp')
	drop procedure DeleteStoreApp
IF EXISTS (select * from GxQscripts where name='DeleteStoreApp')
	delete from GxQscripts where name = 'DeleteStoreApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteStoreApp')
	delete from GXDBVersions where aliasname = 'DeleteStoreApp'
GO
print '... Creating Procedure: DeleteStoreApp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DeleteStoreApp
  @i_UserId INT = NULL,
  @i_AppId INT = 0
AS
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET XACT_ABORT ON
DECLARE @ErrorCode INT = 0
DECLARE @ErrorMessage NVARCHAR(MAX) = 'Successfully deleted App ID ' + CAST(@i_AppId AS NVARCHAR(MAX))
DECLARE @isUserScheduleAdmin INT = 0
BEGIN TRY
    IF NOT EXISTS(SELECT TOP 1 1 FROM Store_App WHERE AppId = @i_AppId)
    BEGIN
        SET @ErrorCode = 1
        SET @ErrorMessage = 'The app does not exist.'
        GOTO ERROR_EXIT
    END
EXEC sec_checkPermissionOnEntity @i_UserId, '1', @isUserScheduleAdmin OUTPUT, 1, 2
    IF (@isUserScheduleAdmin = 0)
    BEGIN
        SET @errorCode = 2
        SET @errorMessage = 'The user does not have the permission to delete this app.'
        GOTO ERROR_EXIT
    END
    BEGIN TRANSACTION DeleteStoreApp
    IF OBJECT_ID('tempdb..#ComponentsToBeDeleted') IS NOT NULL DROP TABLE #ComponentsToBeDeleted
    CREATE TABLE #ComponentsToBeDeleted (id INT)
    INSERT INTO #ComponentsToBeDeleted
    SELECT AppComponent.compId
    FROM Store_AppComponentAssoc AppComponent
        LEFT OUTER JOIN Store_AppComponentAssoc sharedComponent
            ON  appComponent.compId = sharedComponent.compId
                AND sharedComponent.appId != @i_AppId
    WHERE appComponent.appId = @i_AppId
                AND sharedComponent.compId IS NULL
    DELETE FROM C
    FROM Store_Component C INNER JOIN #ComponentsToBeDeleted t ON t.id = C.compId
    DELETE FROM Store_App WHERE appId = @i_appId
    DELETE FROM Store_AppComponentAssoc WHERE appId = @i_appId
    DELETE FROM HistoryDb..Store_AppHistory WHERE appId = @i_appId
EXEC sec_deleteSecurityAssociationsForEntity 177, @i_AppId
    IF @@TRANCOUNT > 0
        COMMIT TRANSACTION DeleteStoreApp
    ELSE
    BEGIN
        SET @ErrorCode = 3
        SET @ErrorMessage = 'Something went wrong while commiting the changes to the database.'
        GOTO ERROR_EXIT
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorMessage = ERROR_MESSAGE()
    GOTO ERROR_EXIT
END CATCH
ERROR_EXIT:
IF @@TRANCOUNT > 0
BEGIN
    IF(@ErrorCode = 0)
    BEGIN
        SET @ErrorCode = 3
        SET @ErrorMessage = 'Something went wrong while commiting the changes to the database.'
    END
    ROLLBACK TRANSACTION DeleteStoreApp
END
SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH ('App_GenericResp')
IF OBJECT_ID('tempdb.dbo.#DeletableApps') IS NOT NULL DROP TABLE #DeletableApps
IF OBJECT_ID('tempdb..#ComponentsToBeDeleted') IS NOT NULL DROP TABLE #ComponentsToBeDeleted
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteStoreApp')
	delete from GxQscripts where name = 'DeleteStoreApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteStoreApp')
	delete from GXDBVersions where aliasname = 'DeleteStoreApp'
GO

insert into GXDBVersions values(2, 'DeleteStoreApp',  '00010001000200050000', 'DeleteStoreApp', '00010001000200050000')
GO

