

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DeleteServicePackINIInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DeleteServicePackINIInfo.sp,v $ $Id: DeleteServicePackINIInfo.sp,v 1.6.202.2 2020/10/04 00:56:07 abilbrey Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "DeleteServicePackINIInfo"
--	|Erases SP info from PatchINI table
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DeleteServicePackINIInfo')
BEGIN
	print '>>> Drop Stored Procedure: DeleteServicePackINIInfo <<<'
	drop procedure DeleteServicePackINIInfo
END
IF EXISTS (select * from GxQscripts where name='DeleteServicePackINIInfo')
	delete from GxQscripts where name = 'DeleteServicePackINIInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteServicePackINIInfo')
	delete from GXDBVersions where aliasname = 'DeleteServicePackINIInfo'
GO
print '... Creating Procedure: DeleteServicePackINIInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DeleteServicePackINIInfo
  @inReleaseID integer,
  @inOSType integer,
  @inSP varchar(20)
AS
  DECLARE @rupdateCount integer;
SET NOCOUNT ON
DECLARE @tmpSPack table(t_sp varchar(20))
DECLARE @spID varchar(20)
DECLARE @oCurrentSP varchar(255)
DECLARE @oNewSP varchar(255)
-- This table stores distinct servicepack information from PatchINI table
IF object_id('tempdb.dbo.#AU_DistinctServicepack') IS NOT null DROP TABLE #AU_DistinctServicepack
CREATE	TABLE #AU_DistinctServicepack
(
   CurServicePackString [nvarchar](255) NOT NULL,
   NewServicePackString [nvarchar](255)
)
-- select all the distinct servicepack strings which will be modified
INSERT INTO #AU_DistinctServicepack SELECT DISTINCT(Servicepacks),' ' FROM PatchINI PI WHERE PI.ReleaseId=@inReleaseID AND
                                                                                             PI.OSId =@inOSType
-- Create new servicepack information for temporary table. New servicepack information will be stored in same temporary table
DECLARE CreateNewSPString CURSOR FOR SELECT CurServicePackString,NewServicePackString FROM #AU_DistinctServicepack
OPEN CreateNewSPString
FETCH NEXT FROM CreateNewSPString INTO @oCurrentSP, @oNewSP
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @tmpSP varchar(20)
	SET @tmpSP=''
    -- Select all servicepacks except the one to be deleted
   	insert into @tmpSPack select _ID from SplitIDString(@oCurrentSP) where _ID <> @inSP
    -- Concatenate remaining servicepack numbers by ","
	DECLARE getSPIds CURSOR FOR select t_sp from @tmpSPack
	OPEN getSPIds
	FETCH NEXT FROM getSPIds into @spID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		if @tmpSP =''
		begin
			set @tmpSP =@spID
		end
		ELSE
		BEGIN
			set @tmpSP =@tmpSP + ',' + @spID
		END
		FETCH NEXT FROM getSPIds into @spID
	END
	CLOSE getSPIds
	DEALLOCATE getSPIds
	DELETE FROM @tmpSPack
	-- Update this new servicepack information in temporary table
	IF @tmpSP =''
	 begin
	    -- if servicepack string is empty, set it to 0
		UPDATE 	#AU_DistinctServicepack SET NewServicePackString='0' WHERE CurServicePackString=@oCurrentSP
	end
	else
	begin
		UPDATE 	#AU_DistinctServicepack SET NewServicePackString=@tmpSP WHERE CurServicePackString=@oCurrentSP
	end
	FETCH NEXT FROM CreateNewSPString INTO @oCurrentSP, @oNewSP
END
CLOSE CreateNewSPString
DEALLOCATE CreateNewSPString
-- Now modify the servicepack information using the temporary table which is created
UPDATE PatchINI SET Servicepacks=AU.NewServicePackString
                FROM #AU_DistinctServicepack AS AU
                WHERE ReleaseId=@inReleaseID AND
                      OSId=@inOSType AND
                      Servicepacks=AU.CurServicePackString
DROP TABLE #AU_DistinctServicepack
select @@rowcount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteServicePackINIInfo')
	delete from GxQscripts where name = 'DeleteServicePackINIInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteServicePackINIInfo')
	delete from GXDBVersions where aliasname = 'DeleteServicePackINIInfo'
GO

insert into GXDBVersions values(2, 'DeleteServicePackINIInfo',  '00010006020200020000', 'DeleteServicePackINIInfo', '00010006020200020000')
GO

