

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DeleteExportLocation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DeleteExportLocation.sp,v $ $Id: DeleteExportLocation.sp,v 1.11.210.2 2018/03/20 19:44:47 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: DeleteExportLocation()
--  |
--  | Description:  run media movement policy.
--  |
--  |	    Input:  integer i_commcellId, i_policyId
--  |
--  |
--  |      Return:  Return code and error string.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        awang    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DeleteExportLocation <<<'

IF EXISTS (select * from sysobjects where name='DeleteExportLocation')
	drop procedure DeleteExportLocation
IF EXISTS (select * from GxQscripts where name='DeleteExportLocation')
	delete from GxQscripts where name = 'DeleteExportLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteExportLocation')
	delete from GXDBVersions where aliasname = 'DeleteExportLocation'
GO
print '... Creating Procedure: DeleteExportLocation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DeleteExportLocation
  @i_exportLocationId INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION
/****************************************************************************************/
/************ Initialize and declare temparary variables ********************************/
/****************************************************************************************/
	DECLARE @mediaCount				INTEGER
	DECLARE @standAloneMediaCount	INTEGER
	DECLARE	@policyCount			INTEGER
	DECLARE	@actionCount			INTEGER
	DECLARE @actionMediaCount		INTEGER
	DECLARE @historyCount			INTEGER
	DECLARE @ruleCount				INTEGER
	DECLARE @rowCount			INTEGER
	DECLARE @retValFlag			INTEGER
	DECLARE	@checkTransaction	INTEGER
	SET @retVal = 0
	SET @retValFlag = 0
	SET @errorString = 'Fail to delete export locaiton: '
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	CREATE TABLE #ptor (
		PolicyId INT,
		RuleId INT,
		LocationCount INT,
		NewLocationCount INT
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot create temprary table #ptor'
			GOTO CX_ERROR_EXIT
	END
	CREATE TABLE #tmExportLocationRef (
			MediaCount INT,
			StandAloneMediaCount INT,
			PolicyCount INT,
			ActionCount INT,
			ActionMediaCount INT,
			HistoryCount INT,
			RuleCount INT
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot create table #tmExportLocationRef'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/******************** Check export location used by schedule ****************************/
/****************************************************************************************/
DECLARE @EXPORTLOCATION_LOCATION_ID bigint = 2010403802
DECLARE @expLocation NVARCHAR(MAX) = CONVERT(VARCHAR(20), @i_exportLocationId)
DECLARE @scheduleTable TABLE (taskId int, subTaskId int, subTaskType int)
INSERT INTO @scheduleTable
EXEC TM_GetTasksWithOption @EXPORTLOCATION_LOCATION_ID, 1, 0, @expLocation
SELECT	@retVal = @@ERROR
IF		@retVal != 0
BEGIN
			SET @errorString = @errorString + 'Failed to get schedules using this export location.'
			GOTO CX_ERROR_EXIT
END
IF EXISTS (SELECT * FROM @scheduleTable)
BEGIN
			SET @errorString = @errorString + 'Export Location is used by schedule.'
			SET	@retValFlag = -1
			GOTO CX_ERROR_EXIT
END
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
	--Get reference in MMMedia table
	-- only consider stand alone media that is outside
	INSERT	INTO #tmExportLocationRef
	SELECT	count(*), 0, 0, 0, 0, 0, 0
	FROM	MMMedia
	WHERE	ExportLocationId = @i_exportLocationId
	AND		(MediaLocation = 3
	OR		(MediaLocation in (1,2) AND LibraryId in (SELECT LibraryId from MMLibrary where librarytypeid = 8)))
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from MMMedia table.'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmExportLocationRef
	SET		StandAloneMediaCount = (	SELECT	COUNT(*)
							FROM	MMMedia
							WHERE	ExportLocationId = @i_exportLocationId
							AND		MediaLocation in (1,2)
							AND		LibraryId IN (SELECT LibraryId FROM MMLibrary WHERE LibraryTypeId IN (4, 5))
							)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from MMMedia table for stand alone media.'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	--Get reference in VTPolicy table
	UPDATE #tmExportLocationRef
	SET		PolicyCount = (	SELECT	COUNT(p.PolicyId)
							FROM	VTPolicy p, VTLocation l
							WHERE	p.DestinationId > 0
							AND		p.DestinationId = l.LocationId
							AND		l.Value = @i_exportLocationId
AND		l.Type = 2)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from VTPolicy table.'
			GOTO CX_ERROR_EXIT
	END
	UPDATE #tmExportLocationRef
	SET		PolicyCount = PolicyCount + (	SELECT	COUNT(p.PolicyId)
							FROM	VTPolicy p, VTLocation l
							WHERE	p.InTransitId > 0
							AND		p.InTransitId = l.LocationId
							AND		l.Value = @i_exportLocationId
AND		l.Type = 2)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from VTPolicy table.'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	--Get reference in VTAction table
	UPDATE #tmExportLocationRef
	SET		ActionCount = (	SELECT	COUNT(a.ActionId)
							FROM	VTAction a, VTLocation l
							WHERE	a.SourceId > 0
							AND		a.SourceId = l.LocationId
							AND		l.Value = @i_exportLocationId
AND		l.Type = 2)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from VTAction table.'
			GOTO CX_ERROR_EXIT
	END
	UPDATE #tmExportLocationRef
	SET		ActionCount = ActionCount + (	SELECT	COUNT(a.ActionId)
							FROM	VTAction a, VTLocation l
							WHERE	a.InTransitId > 0
							AND		a.InTransitId = l.LocationId
							AND		l.Value = @i_exportLocationId
AND		l.Type = 2)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from VTAction table.'
			GOTO CX_ERROR_EXIT
	END
	UPDATE #tmExportLocationRef
	SET		ActionCount = ActionCount + (	SELECT	COUNT(a.ActionId)
							FROM	VTAction a, VTLocation l
							WHERE	a.DestinationId > 0
							AND		a.DestinationId = l.LocationId
							AND		l.Value = @i_exportLocationId
AND		l.Type = 2)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from VTAction table.'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	--Get reference in VTActionMedia table
	UPDATE #tmExportLocationRef
	SET		ActionMediaCount = (	SELECT	COUNT(a.ActionId)
							FROM	VTActionMedia a, VTLocation l
							WHERE	a.CurrentId > 0
							AND		a.CurrentId = l.LocationId
							AND		l.Value = @i_exportLocationId
AND		l.Type = 2)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from VTActionMedia table.'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	-- get rule ref
	UPDATE #tmExportLocationRef
	SET		RuleCount = (	SELECT	COUNT(rts.RuleId)
							FROM	VTRuleSchema s, VTRuleToSchema rts
							WHERE	rts.SchemaId = s.SchemaId
AND		s.Type = 2
							AND		rts.Param = @i_exportLocationId
AND		(rts.Flag & 2) > 0)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot count references from VTRule table.'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/******************* remove export location if not referenced ***************************/
/****************************************************************************************/
	SELECT	@mediaCount = MediaCount, @standAloneMediaCount = StandAloneMediaCount, @policyCount = PolicyCount,
			@actionCount = ActionCount, @actionMediaCount = @ActionMediaCount,
			@historyCount = HistoryCount, @ruleCount = RuleCount
	FROM	#tmExportLocationRef
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot retrieve from #tmExportLocationRef'
			GOTO CX_ERROR_EXIT
	END
	IF		@i_exportLocationId = 0
	BEGIN
			SET	@retValFlag = -1
			SET @errorString = @errorString + 'cannot delete default export location'
			GOTO CX_ERROR_EXIT
	END
	IF		@mediaCount > 0
	BEGIN
			SET	@retValFlag = -1
			SET @errorString = @errorString + 'there are media currently at this location'
			GOTO CX_ERROR_EXIT
	END
	IF		@standAloneMediaCount > 0
	BEGIN
			SET	@retValFlag = -1
			SET @errorString = @errorString + 'there are mounted standalone media using this location'
			GOTO CX_ERROR_EXIT
	END
	-- reset ExportLocationId from MMMedia table
	UPDATE	MMMedia
SET		ExportLocationId = 0
	WHERE	ExportLocationId = @i_exportLocationId
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot reset export location in MMMedia table'
			GOTO CX_ERROR_EXIT
	END
	IF		@policyCount > 0
	BEGIN
			SET	@retValFlag = -1
			SET @errorString = @errorString + 'there are Tracking Policies using this location in transit or destination'
			GOTO CX_ERROR_EXIT
	END
	IF		@actionCount > 0
	BEGIN
			SET	@retValFlag = -1
			SET @errorString = @errorString + 'there are media movement action using this location'
			GOTO CX_ERROR_EXIT
	END
	IF		@actionMediaCount > 0
	BEGIN
			SET	@retValFlag = -1
			SET @errorString = @errorString + 'there are media currently at this location'
			GOTO CX_ERROR_EXIT
	END
	IF		@ruleCount > 0
	BEGIN
			INSERT  INTO #ptor
			SELECT	DISTINCT r.PolicyId, rts.RuleId, 0, 0
			FROM	VTPolicyToRule r, VTRuleToSchema rts, VTRuleSchema s
			WHERE	rts.RuleId = r.RuleId
			AND		rts.SchemaId = s.SchemaId
AND		s.Type = 2
			AND		Param = @i_exportLocationId
AND		(rts.Flag & 2) > 0
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'cannot look up rule and policy'
					GOTO CX_ERROR_EXIT
			END
			UPDATE	#ptor
			SET		LocationCount = r.RuleId
			FROM	#ptor p, VTRuleToSchema r, VTRuleSchema s
			WHERE	p.RuleId = r.RuleId
			AND		r.SchemaId = s.SchemaId
AND		s.Type = 2
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'cannot get location reference count'
					GOTO CX_ERROR_EXIT
			END
			DELETE FROM VTRuleToSchema
WHERE	SchemaId IN (SELECT SchemaId FROM VTRuleSchema WHERE Type = 2)
			AND		Param = @i_exportLocationId
AND		(Flag & 2) > 0
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'cannot remove location from VTRuleToSchema table'
					GOTO CX_ERROR_EXIT
			END
			UPDATE	#ptor
			SET		NewLocationCount = r.RuleId
			FROM	#ptor p, VTRuleToSchema r, VTRuleSchema s
			WHERE	p.RuleId = r.RuleId
			AND		r.SchemaId = s.SchemaId
AND		s.Type = 2
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'cannot get new location reference count'
					GOTO CX_ERROR_EXIT
			END
			UPDATE	VTPolicy
SET		Flag = Flag & ~1, OfflineReason = 2
			WHERE	PolicyId IN (SELECT PolicyId FROM #ptor WHERE LocationCount > 0 AND NewLocationCount = 0)
			SELECT	@retVal = @@ERROR
			IF		@retVal != 0
			BEGIN
					SET @errorString = @errorString + 'cannot disable the policy'
					GOTO CX_ERROR_EXIT
			END
	END
	-- remove from VTLocation table
	DELETE	FROM VTLocation
	WHERE	LocationId > 0
AND		Type = 2
	AND		Value = @i_exportLocationId
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot delete from VTLocation table'
			GOTO CX_ERROR_EXIT
	END
	-- remove from MMExportLocation table
	DELETE	FROM MMExportLocation
	WHERE	ExportLocationId = @i_exportLocationId
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'cannot delete from MMExportLocation table'
			GOTO CX_ERROR_EXIT
	END
	SET @errorString = ''
/****************************************************************************************/
/**************** Drop temparary table **************************************************/
/****************************************************************************************/
	DROP TABLE #tmExportLocationRef
	DROP TABLE #ptor
/****************************************************************************************/
/****************************************************************************************/
--  +----------------------------+
--  |	NORMAL, "HAPPY" EXIT:    |
--  +----------------------------+
	COMMIT	TRANSACTION
	SELECT	@checkTransaction = @@ERROR
	IF		@checkTransaction != 0
	BEGIN
			SET @retVal = @checkTransaction
			SET @errorString = 'fail to commit transaction'
	END
	IF		@retVal = 0
	BEGIN
			SET @errorString = ''
	END
	SELECT	@retVal, @errorString
	RETURN	@retVal;
--  +----------------------------+
--  |   ABNORMAL, "ERROR" EXIT:  |
--  +----------------------------+
CX_ERROR_EXIT:
	DROP TABLE #tmExportLocationRef
	DROP TABLE #ptor
	ROLLBACK	TRANSACTION
	SELECT	@checkTransaction = @@ERROR
	IF		@checkTransaction != 0
	BEGIN
			SET @retVal = @checkTransaction
			SET @errorString = 'cannot rollback transaction'
	END
	IF		@retVal = 0
	BEGIN
			SET	@retVal = @retValFlag
	END
	SELECT	@retVal, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteExportLocation')
	delete from GxQscripts where name = 'DeleteExportLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteExportLocation')
	delete from GXDBVersions where aliasname = 'DeleteExportLocation'
GO

insert into GXDBVersions values(2, 'DeleteExportLocation',  '00010011021000020000', 'DeleteExportLocation', '00010011021000020000')
GO

