

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DeleteEmailTemplate.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 1/19/2018
-- Description:	To delete email template
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DeleteEmailTemplate <<<'

IF EXISTS (select * from sysobjects where name='DeleteEmailTemplate')
	drop procedure DeleteEmailTemplate
IF EXISTS (select * from GxQscripts where name='DeleteEmailTemplate')
	delete from GxQscripts where name = 'DeleteEmailTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteEmailTemplate')
	delete from GXDBVersions where aliasname = 'DeleteEmailTemplate'
GO
print '... Creating Procedure: DeleteEmailTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DeleteEmailTemplate
  @i_userId INT,
  @i_localeId INT,
  @i_templateId INT,
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @debug  AS INT = 0
DECLARE @errorCode          INT = 0
DECLARE @errorString        NVARCHAR(MAX) = ''
Declare @ownerCompanyId as int
DECLARE @canManageProvider INT
select @ownerCompanyId = ownerCompanyId from app_emailtemplate where id = @i_templateId
EXEC sec_checkPermissionOnEntity  @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompanyId
if(@canManageProvider != 1)
BEGIN
	SET @errorCode =  5
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
	GOTO PROC_EXIT
END
BEGIN TRY
		BEGIN TRAN
		delete from App_EmailTemplateProp where componentNameId = @i_templateId
		delete from App_EmailTemplate where id = @i_templateId
		IF  @@ROWCOUNT = 0
		BEGIN
			ROLLBACK TRAN
			SET @errorCode = 1
			SET @errorString = 'Error. No record found to delete'
			GOTO PROC_EXIT
		END
		ELSE
		BEGIN
			COMMIT TRAN
			select @errorCode =  0, @errorString = ''
			GOTO PROC_EXIT
		END
END TRY
BEGIN CATCH
		ROLLBACK TRAN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR) --dbUpgrade scripts replace this const with a print statement to log errors. required for all catch blocks.
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
		GOTO PROC_EXIT
END CATCH
PROC_EXIT:
	SET @o_xmlText = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								 FOR XML PATH('Api_GenericResp'), TYPE)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteEmailTemplate')
	delete from GxQscripts where name = 'DeleteEmailTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteEmailTemplate')
	delete from GXDBVersions where aliasname = 'DeleteEmailTemplate'
GO

insert into GXDBVersions values(2, 'DeleteEmailTemplate',  '00000000000000000000', 'DeleteEmailTemplate', '00000000000000000000')
GO

