

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DeletableVMClientEntities.sp] ---------- 

--  +========================================================================+
--  | Name:  DeletableVMClientEntities
--  | Description:  Gets VM backup information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DeletableVMClientEntities.sp,v $ $Id: DeletableVMClientEntities.sp,v 1.5.44.2 2018/03/27 09:18:45 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DeletableVMClientEntities <<<'

IF EXISTS (select * from sysobjects where name='DeletableVMClientEntities')
	drop procedure DeletableVMClientEntities
IF EXISTS (select * from GxQscripts where name='DeletableVMClientEntities')
	delete from GxQscripts where name = 'DeletableVMClientEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeletableVMClientEntities')
	delete from GXDBVersions where aliasname = 'DeletableVMClientEntities'
GO
print '... Creating Procedure: DeletableVMClientEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DeletableVMClientEntities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_vmClientId INT
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_clientId INT
  DECLARE @o_vmName NVARCHAR(256)
	IF object_id('tempdb.dbo.#deletableVMClients') IS NOT null DROP TABLE #deletableVMClients
	CREATE TABLE #deletableVMClients (
		clientId	INT,
		vmName		NVARCHAR(256)
	)
	DECLARE @waitTimeDays INT = 30, @systemPolicyId INT = 1
	SELECT @waitTimeDays = CAST(value AS INT) FROM GXGlobalParam WHERE name = 'Delete VM Client Wait Time' AND modified = 0
	SELECT @systemPolicyId = id FROM App_VMAllocationPolicy WHERE name  = '_NO_NAME_'
	IF @i_vmClientId = 0
	BEGIN
		INSERT INTO #deletableVMClients(clientId, vmName)
		SELECT	clientId, name
		FROM	APP_VM
		WHERE	removalTimeStamp IS NOT NULL
			AND	removalTimeStamp < DATEADD(dd, -@waitTimeDays, GETUTCDATE())
			AND vmAllocationPolicyId <> @systemPolicyId
	END
	ELSE
	BEGIN
		INSERT INTO #deletableVMClients(clientId, vmName)
		SELECT	clientId, name
		FROM	APP_VM
		WHERE	clientId = @i_vmClientId
			AND vmAllocationPolicyId <> @systemPolicyId
	END
	-- Exclude the entities that are not virtual discovered clients
	DELETE	#deletableVMClients
	FROM	#deletableVMClients D
			LEFT OUTER JOIN App_ClientProp CP
			ON D.clientId = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients'
	WHERE	CP.attrVal IS NULL
	-- Exclude the entities that have backups existing
	DELETE	#deletableVMClients
	FROM	#deletableVMClients D
			LEFT OUTER JOIN APP_VMProp V
			ON D.clientId = V.VMclientId
	WHERE	V.VMclientID IS NOT NULL
	-- Exclude the entities that have packages installed
	DELETE	#deletableVMClients
	FROM	#deletableVMClients D
			LEFT OUTER JOIN simInstalledPackages S
			ON D.clientId = S.ClientId
	WHERE	S.ClientId IS NOT NULL
	-- Exclude the entities with specialClientFlags <> 11
	DELETE	#deletableVMClients
	FROM	#deletableVMClients D
			INNER JOIN APP_Client C
			ON D.clientId = C.id
	WHERE	C.specialClientFlags <> 11
	-- Exclude the entites that have at least once subclient
	DELETE	#deletableVMClients
	FROM	#deletableVMClients D
			INNER JOIN APP_Application A
			ON D.clientID = A.clientId
	-- Exclude the entites that have association
	DELETE	#deletableVMClients
	FROM	#deletableVMClients D
			INNER JOIN APP_Application A WITH(NOLOCK)
				ON D.clientID = A.clientId
			INNER JOIN archFile af WITH(NOLOCK)
				ON af.appId = A.id
	SELECT clientId, vmName FROM #deletableVMClients
	IF object_id('tempdb.dbo.#deletableVMClients') IS NOT null DROP TABLE #deletableVMClients
END
GO

IF EXISTS (select * from GxQscripts where name = 'DeletableVMClientEntities')
	delete from GxQscripts where name = 'DeletableVMClientEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeletableVMClientEntities')
	delete from GXDBVersions where aliasname = 'DeletableVMClientEntities'
GO

insert into GXDBVersions values(2, 'DeletableVMClientEntities',  '00010005004400020000', 'DeletableVMClientEntities', '00010005004400020000')
GO

