

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DelSubclientProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DelSubclientProp.sp,v $ $Id: DelSubclientProp.sp,v 1.9 2014/07/30 18:07:49 gharidas Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   DelSubclientProp   - Delete the subclient Properties
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DelSubclientProp <<<'

IF EXISTS (select * from sysobjects where name='DelSubclientProp')
	drop procedure DelSubclientProp
IF EXISTS (select * from GxQscripts where name='DelSubclientProp')
	delete from GxQscripts where name = 'DelSubclientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DelSubclientProp')
	delete from GXDBVersions where aliasname = 'DelSubclientProp'
GO
print '... Creating Procedure: DelSubclientProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DelSubclientProp
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @scId integer,
  @pit integer,
  @timeStamp integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
declare @attrType				int
declare @errorCode				int
declare @errorSTring				nvarchar(1024)
SET @timeStamp = dbo.GetUnixTime (GetUTCdate())
set @errorCode = 0				  -- Assume it will work!
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
BEGIN
	if (@pit = 1)
		Update APP_SubClientProp set modified = @timeStamp FROM APP_SubClientProp as SP, APP_SubClientPropTemp as SP2 where SP.componentnameid = @scId and   SP.cs_attrName = SP2.cs_attrName and SP.attrType = SP2.attrType	and modified = 0
	else
		delete APP_SubClientProp  FROM APP_SubClientProp as SP, APP_SubClientPropTemp as SP2 where SP.componentnameid = @scId and   SP.cs_attrName = SP2.cs_attrName and SP.attrType = SP2.attrType	and modified = 0
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO ERROR_EXIT
--Error Check
END
ERROR_EXIT:
	EXEC SQLUtilTruncateTable 'APP_SubClientPropTemp'
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'DelSubclientProp')
	delete from GxQscripts where name = 'DelSubclientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DelSubclientProp')
	delete from GXDBVersions where aliasname = 'DelSubclientProp'
GO

insert into GXDBVersions values(2, 'DelSubclientProp',  '00010009000000000000', 'DelSubclientProp', '00010009000000000000')
GO

