

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DelSubclientContentByFilePath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Attic/DelSubclientContentByFilePath.sp,v $ $Id: DelSubclientContentByFilePath.sp,v 1.1.2.2 2017/03/15 11:31:09 jrobert Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   DelSubclientContentByFilePath   - Delete the subclient content file path from APP_ScFilterFile table
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DelSubclientContentByFilePath <<<'

IF EXISTS (select * from sysobjects where name='DelSubclientContentByFilePath')
	drop procedure DelSubclientContentByFilePath
IF EXISTS (select * from GxQscripts where name='DelSubclientContentByFilePath')
	delete from GxQscripts where name = 'DelSubclientContentByFilePath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DelSubclientContentByFilePath')
	delete from GXDBVersions where aliasname = 'DelSubclientContentByFilePath'
GO
print '... Creating Procedure: DelSubclientContentByFilePath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DelSubclientContentByFilePath
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @filePath NVARCHAR(MAX),
  @scId integer,
  @sctype integer,
  @pit integer,
  @timeStamp integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  DECLARE @errorCode int
SET @errorCode = 0
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
If @sctype IN (21,22,23) --(CV_XML_CONTENT, CV_XML_YESDIRS_BACKUP_FILTERS, CV_XML_NODIRS_BACKUP_FILTERS)
BEGIN
	-- For sharepoint XML content need to compare the content path inside xml.
	-- This is going to be slow, but at the moment there is no other way
	if (@pit = 1)
		Update APP_ScFilterFile
		set modified = @timeStamp
		FROM APP_ScFilterFile as SC where SC.componentnameid = @scId and
		CAST(SC.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)') = CAST(@filePath AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)')
		and SC.type = @sctype and SC.modified = 0
	else
		Delete APP_ScFilterFile
		FROM APP_ScFilterFile as SC, APP_ScFilterFileTemp as SC2
		where SC.componentnameid = @scId and
		CAST(SC.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)') = CAST(@filePath AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)')
		and SC.type = @sctype and SC.modified = 0
END
ELSE
BEGIN
if (@pit = 1)
	Update APP_ScFilterFile set modified = @timeStamp FROM APP_ScFilterFile as SC where SC.componentnameid = @scId and CAST(SC.fileName AS varbinary(max)) = CAST(@filePath AS varbinary(max)) and SC.cs_fileName = checksum(@filePath) and SC.type = @sctype and SC.modified = 0
else
	Delete APP_ScFilterFile FROM APP_ScFilterFile as SC where SC.componentnameid = @scId and CAST(SC.fileName AS varbinary(max)) = CAST(@filePath AS varbinary(max)) and SC.cs_fileName = checksum(@filePath) and SC.type = @sctype and SC.modified = 0
END
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	@errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'DelSubclientContentByFilePath')
	delete from GxQscripts where name = 'DelSubclientContentByFilePath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DelSubclientContentByFilePath')
	delete from GXDBVersions where aliasname = 'DelSubclientContentByFilePath'
GO

insert into GXDBVersions values(2, 'DelSubclientContentByFilePath',  '00010001000200020000', 'DelSubclientContentByFilePath', '00010001000200020000')
GO

