

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DelSubclientContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DelSubclientContent.sp,v $ $Id: DelSubclientContent.sp,v 1.10 2014/07/30 18:07:49 gharidas Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   DelSubclientContent   - Delete the subclient content from APP_ScFilterFile table
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DelSubclientContent <<<'

IF EXISTS (select * from sysobjects where name='DelSubclientContent')
	drop procedure DelSubclientContent
IF EXISTS (select * from GxQscripts where name='DelSubclientContent')
	delete from GxQscripts where name = 'DelSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DelSubclientContent')
	delete from GXDBVersions where aliasname = 'DelSubclientContent'
GO
print '... Creating Procedure: DelSubclientContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DelSubclientContent
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @scId integer,
  @sctype integer,
  @pit integer,
  @timeStamp integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
declare @errorCode				int
declare @errorSTring			nvarchar(1024)
SET @timeStamp = dbo.GetUnixTime (GetUTCdate())
set @errorCode = 0
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
BEGIN
If @sctype IN (21,22,23) --(CV_XML_CONTENT, CV_XML_YESDIRS_BACKUP_FILTERS, CV_XML_NODIRS_BACKUP_FILTERS)
BEGIN
	-- For sharepoint XML content need to compare the content path inside xml.
	-- This is going to be slow, but at the moment there is no other way
	if (@pit = 1)
		Update APP_ScFilterFile
		set modified = @timeStamp
		FROM APP_ScFilterFile as SC, APP_ScFilterFileTemp as SC2 where SC.componentnameid = @scId and
		CAST(SC.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)') = CAST(SC2.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)')
		and SC.type = @sctype and SC.modified = 0
	else
		Delete APP_ScFilterFile
		FROM APP_ScFilterFile as SC, APP_ScFilterFileTemp as SC2
		where SC.componentnameid = @scId and
		CAST(SC.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)') = CAST(SC2.fileName AS XML).value('(/EVGui_SharePointItem/@contentPath)[1]', 'nvarchar(MAX)')
		and SC.type = @sctype and SC.modified = 0
END
ELSE
BEGIN
	if (@pit = 1)
		Update APP_ScFilterFile set modified = @timeStamp FROM APP_ScFilterFile as SC, APP_ScFilterFileTemp as SC2 where SC.componentnameid = @scId and   SC.cs_fileName = SC2.cs_fileName and SC.type = @sctype and SC.modified = 0
	else
		Delete APP_ScFilterFile FROM APP_ScFilterFile as SC, APP_ScFilterFileTemp as SC2 where SC.componentnameid = @scId and   SC.cs_fileName = SC2.cs_fileName and SC.type = @sctype and SC.modified = 0
END
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO ERROR_EXIT
--Error Check
END
ERROR_EXIT:
	EXEC SQLUtilTruncateTable 'APP_ScFilterFileTemp'
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'DelSubclientContent')
	delete from GxQscripts where name = 'DelSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DelSubclientContent')
	delete from GXDBVersions where aliasname = 'DelSubclientContent'
GO

insert into GXDBVersions values(2, 'DelSubclientContent',  '00010010000000000000', 'DelSubclientContent', '00010010000000000000')
GO

