

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DedupCopySaving.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DedupCopySaving.sp,v $ $Id: DedupCopySaving.sp,v 1.4.12.13 2020/11/17 19:57:58 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DedupCopySaving')
BEGIN
	print '>>> Drop Stored Procedure: DedupCopySaving <<<'
	drop procedure DedupCopySaving
END
IF EXISTS (select * from GxQscripts where name='DedupCopySaving')
	delete from GxQscripts where name = 'DedupCopySaving'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DedupCopySaving')
	delete from GXDBVersions where aliasname = 'DedupCopySaving'
GO
print '... Creating Procedure: DedupCopySaving'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DedupCopySaving
  @i_options INT = 0
AS
SET NOCOUNT ON
DECLARE @SyncVolumeSize INT	= (@i_options & 1)
/* This temp table is created by the caller
	CREATE TABLE #DedupeCopy (
		archGrpCopyId INT, activeStoreId INT, dedupeFlags INT,
		dataRead BIGINT, dataWritten BIGINT,
		dedupRatio FLOAT, dedupSaving DECIMAL(10,2)
	)
*/
IF OBJECT_ID('tempdb..#DedupeCopyLocal') IS NOT NULL  DROP TABLE #DedupeCopyLocal
IF OBJECT_ID('tempdb..#DedupSizeCorrection') IS NOT NULL  DROP TABLE #DedupSizeCorrection
IF OBJECT_ID('tempdb..#CopyReadSize') IS NOT NULL  DROP TABLE #CopyReadSize
IF OBJECT_ID('tempdb..#MountPathStoreSize') IS NOT NULL  DROP TABLE #MountPathStoreSize
CREATE TABLE #DedupeCopyLocal (
	archGrpCopyId INT, activeStoreId INT, dedupeFlags INT,
	dataRead BIGINT, dataWritten BIGINT,
	dedupRatio FLOAT, dedupSaving DECIMAL(10,2),
	storeCopyId INT
)
IF NOT EXISTS (SELECT * FROM #DedupeCopy)
BEGIN
	INSERT	INTO #DedupeCopyLocal
SELECT	DISTINCT AGC.id, 0, AGC.dedupeFlags, 0, 0, 0, 0, (CASE WHEN ((AGC.dedupeFlags & 134217728) > 0) THEN AG.defaultCopy ELSE AGC.id END)
	FROM	archGroupCopy AGC WITH (NOLOCK)
			LEFT OUTER JOIN archCopyToGlobalPolicy GP WITH (NOLOCK) ON GP.CopyId = AGC.id
			LEFT OUTER JOIN archGroup AG WITH (NOLOCK) ON GP.GlobalPolicyId = AG.id
WHERE	AGC.type IN (1, 2, 3) AND ((AGC.dedupeFlags & 262144) > 0)
END
ELSE
BEGIN
	INSERT INTO #DedupeCopyLocal
SELECT  DISTINCT  D.*, (CASE WHEN ((AGC.dedupeFlags & 134217728) > 0) THEN AG.defaultCopy ELSE AGC.id END)
	FROM	#DedupeCopy D
			INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON D.archGrpCopyId = AGC.id
			LEFT OUTER JOIN archCopyToGlobalPolicy GP WITH (NOLOCK) ON GP.CopyId = D.archGrpCopyId
			LEFT OUTER JOIN archGroup AG WITH (NOLOCK) ON GP.GlobalPolicyId = AG.id
	INSERT INTO #DedupeCopyLocal
	SELECT	DISTINCT AGC.id, 0, AGC.dedupeFlags, 0, 0, 0, 0, D.storeCopyId
	FROM	#DedupeCopyLocal D
			INNER JOIN archGroupCopy GPC WITH (NOLOCK) ON D.storeCopyId = GPC.id
			INNER JOIN archCopyToGlobalPolicy GP2 WITH (NOLOCK) ON GPC.archGroupId = GP2.globalPolicyId
INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON GP2.CopyId = AGC.id AND ((AGC.dedupeFlags & 134217728) > 0)
			LEFT OUTER JOIN #DedupeCopyLocal D2 ON AGC.id = D2.archGrpCopyId
WHERE	((D.dedupeFlags & 134217728) > 0)
			AND D2.archGrpCopyId IS NULL
END
-- Total Application Size of fully copied jobs on each copies
CREATE TABLE #CopyReadSize (archGrpCopyId INT, dataRead BIGINT)
IF NOT EXISTS (SELECT 1 FROM archFileCopy AFC WITH (NOLOCK) INNER JOIN #DedupeCopyLocal C
	ON AFC.archCopyId = C.archGrpCopyId AND AFC.unCompSize < 0 AND AFC.physicalSize > 0)
BEGIN
	INSERT INTO #CopyReadSize
	SELECT  AFC.archCopyId, SUM(AFC.unCompSize)
	FROM	archFileCopy AFC WITH (NOLOCK)
			INNER JOIN archFile AF WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
			INNER JOIN #DedupeCopyLocal C ON AFC.archCopyId = C.archGrpCopyId
WHERE	AFC.unCompSize > 0 AND AFC.physicalSize > 0 AND AFC.flags&256 = 0
		AND AF.fileType IN (1, 4) AND AF.isValid = 1
	GROUP BY AFC.archCopyId
END
ELSE -- In case unCompSize is not set for some valid archFileCopy entries
BEGIN
	CREATE TABLE #JobCopyToSetAppSize (jobId INT, commCellId INT, archGrpCopyId INT, totalAppSize BIGINT, totalBackupSize BIGINT)
	CREATE TABLE #VSA_AppIDs (appId INT, isIndexingV2 INT)
	-- Before IndexingV2, JMJobDataStats and archFile tables only have entries of parent jobs. Count parent jobs.
	-- Since IndexingV2, JMJobDataStats and archFile tables have entries of both parent and child jobs. Count child jobs.
	-- Parent jobs associated with appId of IndexingV2 VSA subclients will be excluded in calcultion.
	INSERT	INTO #VSA_AppIDs
	SELECT	A.id, ISNULL(CP.attrVal, 0)
	FROM	APP_Application A WITH (NOLOCK)
			INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = A.instance
				AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal <> '' AND IP.modified = 0
			LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = A.clientId
				AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1'
WHERE	A.appTypeId = 106 AND A.subclientStatus&0x00020 = 0
	INSERT	INTO #JobCopyToSetAppSize
	SELECT  AF.jobId, AF.commCellId, AFC.archCopyId, 0, 0
	FROM	archFileCopy AFC WITH (NOLOCK)
			INNER JOIN archFile AF WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
			INNER JOIN #DedupeCopyLocal C ON AFC.archCopyId = C.archGrpCopyId
			LEFT OUTER JOIN #VSA_AppIDs VA ON AF.appId = VA.appId AND VA.isIndexingV2 = 1
	WHERE	AFC.unCompSize < 0 AND AFC.physicalSize > 0
		AND AF.fileType IN (1, 4) AND AF.isValid = 1
		AND VA.appId IS NULL
	GROUP BY AF.jobId, AF.commCellId, AFC.archCopyId
	INSERT INTO #CopyReadSize
	SELECT  AFC.archCopyId, SUM(AFC.unCompSize)
	FROM	archFileCopy AFC WITH (NOLOCK)
			INNER JOIN archFile AF WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
			INNER JOIN #DedupeCopyLocal C ON AFC.archCopyId = C.archGrpCopyId
			LEFT OUTER JOIN (
				SELECT	AF.id, AF.commCellId, J.archGrpCopyId
				FROM	archFile AF WITH (NOLOCK)
						INNER JOIN #JobCopyToSetAppSize J ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId
				) T ON AFC.archFileId = T.id AND AFC.commCellId = T.commCellId AND AFC.archCopyId = T.archGrpCopyId
	WHERE	AFC.unCompSize > 0 AND T.id IS NULL
		AND AF.fileType IN (1, 4) AND AF.isValid = 1
	GROUP BY AFC.archCopyId
	UPDATE	T SET totalAppSize = B.totalUncompBytes, totalBackupSize = B.totalBackupSize
	FROM	#JobCopyToSetAppSize T
			INNER JOIN JMBkpStats B WITH (NOLOCK) ON T.jobId = B.jobId AND T.commCellId = B.commCellId
	UPDATE	T SET totalAppSize = A.totalBackupSize, totalBackupSize = A.totalBackupSize
	FROM	#JobCopyToSetAppSize T
			INNER JOIN JMAdminJobStatsTable A WITH (NOLOCK) ON T.jobId = A.jobId AND T.commCellId = A.commCellId
	-- Available and partial jobs on each dedup copies
	INSERT	INTO #CopyReadSize
	SELECT	archGrpCopyId, SUM(totalAppSize)
	FROM	#JobCopyToSetAppSize
	GROUP BY archGrpCopyId
	-- Partially copied jobs
	CREATE TABLE #PartialJobSize (jobId INT, commCellId INT, archGrpCopyId INT,
			totalAppSize BIGINT, totalBackupSize BIGINT, dataRead BIGINT)
	INSERT	INTO #PartialJobSize
	SELECT	J.jobId, J.commCellId, J.archGrpCopyId, T.totalAppSize, T.totalBackupSize, 0
	FROM	JMJobDataStats J WITH (NOLOCK)
			INNER JOIN #JobCopyToSetAppSize T ON J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = T.archGrpCopyId
	WHERE	J.status <> 1000
	GROUP BY J.jobId, J.commCellId, J.archGrpCopyId, T.totalAppSize, T.totalBackupSize
	HAVING MAX(J.status) IN (102, 103) OR MIN(J.status) = 100 AND MAX(J.status) = 101
	UPDATE	#PartialJobSize
	SET		dataRead = CASE WHEN totalBackupSize > T.dataCompressed THEN ((1.0*T.dataCompressed)/totalBackupSize)*totalAppSize ELSE T.dataCompressed END
	FROM	(SELECT J.jobId, J.commCellId, J.archGrpCopyId, SUM(AFC.physicalSize) AS dataCompressed
			FROM	#PartialJobSize J
					INNER JOIN archFile AF  WITH (NOLOCK)
						ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.fileType IN (1, 4) AND AF.isValid = 1
					INNER JOIN archFileCopy AFC  WITH (NOLOCK)
						ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId
			GROUP BY J.jobId, J.commCellId, J.archGrpCopyId
			) T
	WHERE	#PartialJobSize.jobId = T.jobId AND #PartialJobSize.commCellId = T.commCellId AND #PartialJobSize.archGrpCopyId = T.archGrpCopyId
			AND T.dataCompressed > 0
	INSERT	INTO #CopyReadSize
	SELECT	archGrpCopyId, -SUM(totalAppSize - dataRead)
	FROM	#PartialJobSize
	GROUP BY archGrpCopyId
	DROP TABLE #VSA_AppIDs
	DROP TABLE #PartialJobSize
	DROP TABLE #JobCopyToSetAppSize
END
IF @SyncVolumeSize = 1
BEGIN
	-- Correction because of backlog of updating volume sizes on disk
	CREATE TABLE #DedupSizeCorrection (MediaSideId INT, UsedSpaceMB BIGINT, factor FLOAT)
	INSERT	INTO #DedupSizeCorrection
	SELECT	MediaSideId,
			CASE WHEN TotalSpaceMB < 0 OR FreeBytesMB < 0 OR (TotalSpaceMB - FreeBytesMB) < 0 THEN 0
				 ELSE TotalSpaceMB - FreeBytesMB
			END,
			1
	FROM	MMMediaSide WITH (NOLOCK)
	WHERE	MediaSideId > 0
	;WITH DedupDiskSize (MediaSideId, DedupSizeMB, NonDedupSizeMB) AS
	(
		SELECT	MediaSideId,
				SUM(CASE WHEN SIDBStoreId > 0 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END),
				SUM(CASE WHEN SIDBStoreId = 0 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END)
		FROM	MMVolume WITH (NOLOCK)
		WHERE	MediaSideId > 0 AND (Attributes & 512) = 0 AND SiloStatus <> 3
		GROUP BY MediaSideId
	)
	UPDATE	#DedupSizeCorrection
	SET		factor = 1.0*(UsedSpaceMB - NonDedupSizeMB)/DedupSizeMB
	FROM	#DedupSizeCorrection F
			INNER JOIN DedupDiskSize S ON F.MediaSideId = S.MediaSideId
	WHERE	DedupSizeMB > 0 AND (UsedSpaceMB - NonDedupSizeMB) > 0
END
IF OBJECT_ID('tempdb.dbo.#StoreSizeInfo') IS NOT NULL DROP TABLE #StoreSizeInfo
CREATE TABLE #StoreSizeInfo(
	storeCopyId integer,
	SIDBStoreId integer,
	dataWrittenMB BIGINT DEFAULT 0,
	zeroRefCount  BIGINT DEFAULT 0,
	SIBlockSizeKB	  integer DEFAULT 0,
	appSizeFreedBytes	BIGINT DEFAULT 0,
PRIMARY KEY (SIDBStoreId))
INSERT INTO #StoreSizeInfo(storeCopyId, SIDBStoreId, SIBlockSizeKB)
SELECT	DISTINCT AGC.id storeCopyId, S.SIDBStoreId SIDBStoreId, AG.SIBlockSizeKB
FROM	#DedupeCopyLocal DC
		INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON DC.storeCopyId = AGC.id
		INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id
		INNER JOIN archCopySIDBStore S WITH (NOLOCK) ON AGC.id = S.CopyId
UPDATE	C2
SET		zeroRefCount = ISNULL(T2.zeroRefCount, 0)
FROM	#StoreSizeInfo C2,
		(SELECT	UH2.SIDBStoreId, SUM(zeroRefCount) zeroRefCount
		FROM	IdxSIDBUsageHistory UH2 WITH (READUNCOMMITTED),
				(SELECT	UH.SIDBStoreId, UH.SubStoreId, MAX(ModifiedTime) MaxModifiedTIme
				FROM	#StoreSizeInfo C, IdxSIDBUsageHistory UH WITH (READUNCOMMITTED)
				WHERE	UH.SIDBStoreId = C.SIDBStoreId
						AND UH.HistoryType = 2
				GROUP BY UH.SIDBStoreId, UH.SubStoreId) T
		WHERE	UH2.SIDBStoreId = T.SIDBStoreId
				AND UH2.SubStoreId = T.SubStoreId
				AND UH2.HistoryType = 2
				AND UH2.ModifiedTime = T.MaxModifiedTIme
		GROUP BY UH2.SIDBStoreId) T2
WHERE	C2.SIDBStoreId = T2.SIDBStoreId
UPDATE	C2
SET		appSizeFreedBytes = ISNULL(T.appSizeFreedBytes, 0)
FROM	#StoreSizeInfo C2,
		(SELECT	D.SIDBStoreId, SUM(D.appSizeFreedBytes) appSizeFreedBytes
		FROM	#StoreSizeInfo C, MMDeletedAF D WITH (READUNCOMMITTED)
		WHERE	D.SIDBStoreId = C.SIDBStoreId
		GROUP BY D.SIDBStoreId) T
WHERE	C2.SIDBStoreId = T.SIDBStoreId
-- Calculate average dedupe ratio for each torage policy copy including active and sealed dedup stores.
-- All storage policy copies using the same GDSP have same dedup ratio.
-- Include all volumes except physically deleted volumes for calculating dedup ratio.
CREATE TABLE #MountPathStoreSize (MediaSideId INT, SIDBStoreId INT, PhysicalBytesMB BIGINT)
INSERT	INTO #MountPathStoreSize
SELECT	V.MediaSideId, V.SIDBStoreId, SUM(CAST(V.PhysicalBytesMB AS BIGINT)) AS PhysicalBytesMB
FROM	MMVolume V WITH (NOLOCK) INNER JOIN #StoreSizeInfo S ON V.SIDBStoreId = S.SIDBStoreId
WHERE	V.SIDBStoreId > 0 AND V.PhysicalBytesMB > 0 AND (V.Attributes & 512) = 0 AND V.SiloStatus <> 3
GROUP BY V.MediaSideId, V.SIDBStoreId
IF @SyncVolumeSize = 1
	UPDATE	C2
	SET		dataWrittenMB = T.dataWrittenMB
	FROM	#StoreSizeInfo C2,
			(SELECT	C.SIDBStoreId, SUM(SS.PhysicalBytesMB*F.factor) dataWrittenMB
			FROM	#StoreSizeInfo C
					INNER JOIN #MountPathStoreSize SS ON C.SIDBStoreId = SS.SIDBStoreId
					INNER JOIN #DedupSizeCorrection F ON SS.MediaSideId = F.MediaSideId
			GROUP BY C.SIDBStoreId) T
	WHERE	C2.SIDBStoreId = T.SIDBStoreId
ELSE
	UPDATE	C2
	SET		dataWrittenMB = T.dataWrittenMB
	FROM	#StoreSizeInfo C2,
			(SELECT	C.SIDBStoreId, SUM(SS.PhysicalBytesMB) dataWrittenMB
			FROM	#StoreSizeInfo C
					INNER JOIN #MountPathStoreSize SS ON C.SIDBStoreId = SS.SIDBStoreId
			GROUP BY C.SIDBStoreId) T
	WHERE	C2.SIDBStoreId = T.SIDBStoreId
DROP TABLE #MountPathStoreSize
UPDATE #DedupeCopyLocal
SET		dedupRatio = (((1048576.0*W.dataWrittenMB) - w.zeroRefSize)/(R.dataRead + w.appSizeFreedBytes))
FROM	(SELECT	DC.storeCopyId, SUM(RS.dataRead) AS dataRead
		FROM	#CopyReadSize RS
				INNER JOIN #DedupeCopyLocal DC ON RS.archGrpCopyId = DC.archGrpCopyId
		GROUP BY DC.storeCopyId) R
		INNER JOIN (SELECT  storeCopyId, SUM(dataWrittenMB) dataWrittenMB, SUM(zeroRefCount * SIBlockSizeKB * 1024) zeroRefSize, SUM(appSizeFreedBytes) appSizeFreedBytes
					FROM	#StoreSizeInfo
					GROUP BY storeCopyId) W ON W.storeCopyId = R.storeCopyId
		INNER JOIN #DedupeCopyLocal C ON C.storeCopyId = R.storeCopyId
WHERE	R.dataRead > 0
DROP TABLE #StoreSizeInfo
UPDATE	#DedupeCopyLocal
SET		dataRead = S.dataRead, dataWritten = S.dataRead * dedupRatio,
		dedupSaving = CASE WHEN dedupRatio < 1 THEN 100.0*(1 - dedupRatio) ELSE 0 END
FROM	(SELECT	archGrpCopyId, SUM(dataRead) AS dataRead
		FROM	#CopyReadSize
		GROUP BY archGrpCopyId) S
WHERE	#DedupeCopyLocal.archGrpCopyId = S.archGrpCopyId
IF EXISTS (SELECT * FROM #DedupeCopy)
BEGIN
	UPDATE	D
	SET		dataRead = DL.dataRead,
			dataWritten = DL.dataWritten,
			dedupSaving = DL.dedupSaving,
			dedupRatio = DL.dedupRatio
	FROM	#DedupeCopy D, #DedupeCopyLocal DL
	WHERE	D.archGrpCopyId = DL.archGrpCopyId
END
ELSE
BEGIN
	INSERT INTO #DedupeCopy
	SELECT	archGrpCopyId, activeStoreId, dedupeFlags, dataRead, dataWritten, dedupRatio, dedupSaving
	FROM	#DedupeCopyLocal
END
IF OBJECT_ID('tempdb..#DedupeCopyLocal') IS NOT NULL  DROP TABLE #DedupeCopyLocal
IF OBJECT_ID('tempdb..#DedupSizeCorrection') IS NOT NULL  DROP TABLE #DedupSizeCorrection
IF OBJECT_ID('tempdb..#CopyReadSize') IS NOT NULL  DROP TABLE #CopyReadSize
IF OBJECT_ID('tempdb..#MountPathStoreSize') IS NOT NULL  DROP TABLE #MountPathStoreSize
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DedupCopySaving')
	delete from GxQscripts where name = 'DedupCopySaving'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DedupCopySaving')
	delete from GXDBVersions where aliasname = 'DedupCopySaving'
GO

insert into GXDBVersions values(2, 'DedupCopySaving',  '00010004001200130000', 'DedupCopySaving', '00010004001200130000')
GO

