

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbclrInstall_1_Init.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DbclrInstall_1_Init')
BEGIN
	print '>>> Drop Stored Procedure: DbclrInstall_1_Init <<<'
	drop procedure DbclrInstall_1_Init
END
IF EXISTS (select * from GxQscripts where name='DbclrInstall_1_Init')
	delete from GxQscripts where name = 'DbclrInstall_1_Init'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbclrInstall_1_Init')
	delete from GXDBVersions where aliasname = 'DbclrInstall_1_Init'
GO
print '... Creating Procedure: DbclrInstall_1_Init'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbclrInstall_1_Init
AS
  DECLARE @versionSQL NVARCHAR(MAX)
  DECLARE @o_retVal INTEGER
	SET NOCOUNT ON
	DECLARE @sqlQuery NVARCHAR(MAX)
	DECLARE @ParmDefinition NVARCHAR(MAX)
	DECLARE @windows TINYINT = 1
	DECLARE @linux TINYINT = 2
	DECLARE @osType TINYINT = 0
	DECLARE @nl VARCHAR(4) = ''
	SET @versionSQL = @@VERSION
	SET @osType = IIF((@versionSQL LIKE '%Linux%'), @linux, @windows)
	SET @nl = IIF((@osType = @windows), (CHAR(13) + CHAR(10)), CHAR(10))		-- CRLF(Windows), LF(Linux newline)
	-- Get SQL Release to determine how to query the local SQL Server
	DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
	DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	-- Changes to stop RECONFIGURE the SQL Server during each DbUpgrade over the life time of the server
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'show advanced options' AND CAST(value_in_use AS INT) = 0)
	BEGIN
		SET @sqlQuery = 'USE MASTER;
				EXEC sp_configure ''show advanced options'', 1;
				RECONFIGURE;
		'
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
	END
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr enabled' AND CAST(value_in_use AS INT) = 0)
	BEGIN
		SET @sqlQuery = 'USE MASTER;
				EXEC sp_configure ''clr enabled'' , 1;
				RECONFIGURE;
		'
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
	END
	IF (@releaseNumber >= 14)	-- SQL Server 2017+
	BEGIN
		IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr strict security' AND CAST(value_in_use AS INT) = 1)
		BEGIN
			SET @sqlQuery = 'USE MASTER;
					EXEC sp_configure ''clr strict security'' , 0;
					RECONFIGURE;
			'
			EXECUTE sp_executeSql @sqlQuery
			SET @o_retVal = @@ERROR
			IF	@o_retVal <> 0 GOTO CX_EXIT
		END
	END
	-- SP21 Note: New CLR functions are being written to replace the OLE Usage and support Linux and should be able to disable this in the near future for Windows SQL 2017+
	-- In the CV Security Hardening documentation it is stated that 'Ole Automation Procedures' can be disabled but the Commserv Database has SPs using it?
	-- Adding OLE only for Windows Unsafe methods and only if the Commserv database is being created
	-- NCVS Search: sp_OACreate
	-- Note Linux does NOT support 'Ole Automation Procedures'
	IF (@osType = @windows)
	BEGIN
		IF (DB_NAME() = 'Commserv') AND  EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'Ole Automation Procedures' AND CAST(value_in_use AS INT) = 0)
		BEGIN
			SET @sqlQuery = 'USE MASTER;
					EXEC sp_configure ''Ole Automation Procedures'', 1;
					RECONFIGURE;
			'
			EXECUTE sp_executeSql @sqlQuery
			SET @o_retVal = @@ERROR
			IF	@o_retVal <> 0 GOTO CX_EXIT
		END
	END
	SET @sqlQuery =  ''
	DECLARE @objcur CURSOR
	DECLARE @object_id INT
	DECLARE @type char(2)
	SET @objcur=CURSOR FOR
		(SELECT object_id,TYPE FROM sys.objects WHERE object_id in(
			SELECT object_id FROM sys.assembly_modules
			WHERE assembly_id in (SELECT assembly_id FROM sys.assemblies WHERE name IN ('dbCLR','timezoneclr'))))
	OPEN @objcur
	FETCH NEXT FROM @objcur INTO @object_id,@type
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @type = 'P' OR @type = 'PC'
			SET @sqlQuery += 'DROP PROCEDURE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		ELSE IF @type = 'FS'
			SET @sqlQuery += 'DROP FUNCTION ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		ELSE IF @type = 'AF'
			SET @sqlQuery += 'DROP AGGREGATE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		FETCH NEXT FROM @objcur INTO @object_id,@type
	END
	CLOSE @objcur
	DEALLOCATE @objcur
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = '
		IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''dbCLR'')
			DROP ASSEMBLY [dbCLR];
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = '
		IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''timezoneCLR'')
			DROP ASSEMBLY [timezoneclr];
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = '
		USE MASTER;
		IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVDBCLRLogin'')
			DROP LOGIN CVDBCLRLogin;
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = '
		USE MASTER;
		IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVDBCLRKey'')
			DROP ASYMMETRIC KEY CVDBCLRKey;
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = '
		USE MASTER;
		IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVTIMEZONECLRLogin'')
			DROP LOGIN CVTIMEZONECLRLogin;
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = '
		USE MASTER;
		IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVTIMEZONECLRKey'')
			DROP ASYMMETRIC KEY CVTIMEZONECLRKey;
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
CX_EXIT:
	SELECT @versionSQL,@o_retVal
	RETURN @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'DbclrInstall_1_Init')
	delete from GxQscripts where name = 'DbclrInstall_1_Init'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbclrInstall_1_Init')
	delete from GXDBVersions where aliasname = 'DbclrInstall_1_Init'
GO

insert into GXDBVersions values(2, 'DbclrInstall_1_Init',  '00000000000000000000', 'DbclrInstall_1_Init', '00000000000000000000')
GO

