

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLVSASubclientSummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DbXMLVSASubclientSummary.sp,v $ $Id: DbXMLVSASubclientSummary.sp,v 1.3.198.3 2020/10/04 00:59:05 abilbrey Exp $";
-- =============================================
-- Author:		Dinesh Kriplani
-- Create date: 04/10/2011
-- Description:	Get the VS Subclient Summary page
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DbXMLVSASubclientSummary')
BEGIN
	print '>>> Drop Stored Procedure: DbXMLVSASubclientSummary <<<'
	drop procedure DbXMLVSASubclientSummary
END
IF EXISTS (select * from GxQscripts where name='DbXMLVSASubclientSummary')
	delete from GxQscripts where name = 'DbXMLVSASubclientSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLVSASubclientSummary')
	delete from GXDBVersions where aliasname = 'DbXMLVSASubclientSummary'
GO
print '... Creating Procedure: DbXMLVSASubclientSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLVSASubclientSummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
	SET NOCOUNT ON
	DECLARE @clientId INT
	DECLARE @backupSetId INT
	DECLARE @subclientId INT
	DECLARE @errmsg NVARCHAR(2000)
	DECLARE @VSASubclientSummaryPageResp XML
	SET @VSASubclientSummaryPageResp =''
	DECLARE @VMSummaryData XML
	SET @VMSummaryData =NULL
	SELECT
			@clientId    = ISNULL(@request.value('(/EVGui_SubclientSummaryPageReq/client/@clientId)[1]', 'integer'),0),
			@backupSetId = ISNULL(@request.value('(/EVGui_SubclientSummaryPageReq/backupSet/@backupsetId)[1]', 'integer'), 0),
			@subclientId = ISNULL(@request.value('(/EVGui_SubclientSummaryPageReq/subclient/@subclientId)[1]', 'integer'), 0)
--	+===============================================+
--	| subclientId Validation Only subclient summary allowed presently:							|
--	+===============================================+
IF(@subclientId<1)
BEGIN
SET @errmsg = N'DbXMLVSASubclientSummary: subclientId[' + CAST(@subclientId AS NVARCHAR(12)) + '] is not a valid subclient'
RAISERROR(@errmsg, 16, 1)
GOTO DbXMLVSASubclientSummary_End
END
	IF object_id('tempdb.dbo.#tempJobs') IS NOT NULL DROP TABLE #tempJobs
	CREATE TABLE #tempJobs
	(
		jobId				int ,
		PRIMARY KEY(jobId)
	)
INSERT INTO #tempJobs
 --ISNULL((
 SELECT jobid From JMBkpStats WHERE fullCycleNum = (
	SELECT CAST(attrVal AS int) AS LastFullCycleNumber FROM APP_SubClientProp WHERE componentNameId = @subclientId and attrName like '%sys:full cycle num%' and modified = 0)
	and appId = @subclientId AND status in(1,3)
	--and bkpLevel =1
	--),0)
DECLARE @totalJobs INT = 0
SET @totalJobs = ISNULL((SELECT COUNT (DISTINCT jobId) FROM #tempJobs),0)
IF(@totalJobs<1)
BEGIN
--SET @errmsg = N'NO DbXMLVSASubclientSummary_End: lastfullJobId not found for subclientId[' + CAST(@subclientId AS NVARCHAR(12)) + '],please run a backup for the subclient '
--RAISERROR(@errmsg, 16, 1)
GOTO DbXMLVSASubclientSummary_End
END
IF object_id('tempdb.dbo.#VMList') IS NOT NULL
	DROP TABLE #VMList
CREATE TABLE #VMList
(
	jobId					INT,
	commcellId				INT,
	vmClientId				INT,
	vmName					NVARCHAR(510),
	vmSize					BIGINT,
	vmBkpEndTime			INTEGER,
	operatingSystem			NVARCHAR(512),
	owners					NVARCHAR(512)
)
INSERT	INTO #VMList
	SELECT	MAX(Q.jobId), Q.commcellId, Q.clientId, Q.clientName,
	0, 0,  N'', N''
	FROM	JMQinetixUpdateStatus Q
	INNER JOIN #tempJobs jobs
	ON	Q.jobId = jobs.jobId
	GROUP BY Q.commcellId, Q.clientId, Q.clientName
UPDATE	#VMList
SET		  vmSize			= (SELECT ISNULL(attrVal, 0)   FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmSize')
		, vmBkpEndTime		= (SELECT ISNULL(attrVal, 0)   FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmBackupEndTime')
		, operatingSystem	= (SELECT ISNULL(attrVal, N'')	FROM APP_ClientProp A WHERE V.vmClientId = A.componentNameId AND attrName = 'Operating System Name' AND A.modified = 0)
		, owners		= ISNULL(dbo.getclientowners(V.vmClientId), N'')
FROM	#VMList V
	SET @VMSummaryData=(
		  SELECT
			V.vmSize  AS [@backedupDataSize],
			V.vmBkpEndTime AS [@lastBackupTime],
			V.vmClientId  AS 'virtualMachine/@id',
			V.vmName AS 'virtualMachine/@name'
		  FROM #VMList AS V
		  FOR XML PATH ('vmData'))
	DbXMLVSASubclientSummary_End:
IF object_id('tempdb.dbo.#VMList') IS NOT NULL
	DROP TABLE #VMList
	SET @VSASubclientSummaryPageResp	 =
					(SELECT @VMSummaryData AS scData
						FOR XML PATH ('EVGui_SubclientSummaryPageResp')
						)
	SELECT @VSASubclientSummaryPageResp AS [response]
IF object_id('tempdb.dbo.#tempJobs') IS NOT NULL DROP TABLE #tempJobs
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLVSASubclientSummary')
	delete from GxQscripts where name = 'DbXMLVSASubclientSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLVSASubclientSummary')
	delete from GXDBVersions where aliasname = 'DbXMLVSASubclientSummary'
GO

insert into GXDBVersions values(2, 'DbXMLVSASubclientSummary',  '00010003019800030000', 'DbXMLVSASubclientSummary', '00010003019800030000')
GO

