

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLStoragePolicySummary.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DbXMLStoragePolicySummary')
BEGIN
	print '>>> Drop Stored Procedure: DbXMLStoragePolicySummary <<<'
	drop procedure DbXMLStoragePolicySummary
END
IF EXISTS (select * from GxQscripts where name='DbXMLStoragePolicySummary')
	delete from GxQscripts where name = 'DbXMLStoragePolicySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLStoragePolicySummary')
	delete from GXDBVersions where aliasname = 'DbXMLStoragePolicySummary'
GO
print '... Creating Procedure: DbXMLStoragePolicySummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLStoragePolicySummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML,
  @i_localeId INTEGER
AS
  DECLARE @response XML
BEGIN
	SET NOCOUNT ON
	DECLARE @reportType INT
	DECLARE @spId INT
	DECLARE @clientId INT
	DECLARE @appType INT
	DECLARE @spCopyId INT
	DECLARE @subclientId INT
	DECLARE @respFlag INT
	DECLARE @errmsg NVARCHAR(2000)
	DECLARE @SummaryData XML
	SET @SummaryData =''
	DECLARE @CopyData XML
	SET @CopyData =''
	DECLARE @SPCopySummaryData XML
	SET @SPCopySummaryData =''
	DECLARE @flags INT				-- storage policy copy options
	DECLARE	@multiplexingEnabled int=0
	DECLARE	@combineStreams int=-1
	DECLARE	@mediaRefreshEnabled int=0
	DECLARE	@reEncryptionEnabled int=0
	DECLARE	@retentionFortheCopy int=0
	DECLARE	@retentionCyclesFortheCopy int=0
DECLARE	@sourceCopy			nvarchar(255)
	DECLARE @dedupFlags INT			-- dedup options
	DECLARE @archTaskActive INT
	DECLARE @numDays INT
	DECLARE @periodType INT
	DECLARE	@blockLevelDeduplication	bigint=0
	DECLARE	@softwareCompressionEnabled int=0
	DECLARE	@storePrimingEnabled int=0
	DECLARE	@siloEnabled			int=0
DECLARE	@dashOptions			nvarchar(255)
DECLARE	@uponAnyPartitionCorruption nvarchar(255)
	DECLARE	@doNotDuplicateAgainstObjects int=0
	--DECLARE	@sealStoreEnabled	int
	DECLARE	@storeCreationDays   int=0
	DECLARE	@storeCreationSize	bigint=0
	DECLARE @storeCreationMonths	int=0
	DECLARE @storeCreationDate	bigint=0
	DECLARE @freeSpaceforCopyMB	bigint=0
	SELECT
			@reportType   = @request.value('(/EVGui_StoragePolicySummaryReq/@reportType)[1]', 'integer'),
			@spId         = ISNULL(@request.value('(/EVGui_StoragePolicySummaryReq/@spId)[1]', 'integer'), 0),
			@clientId     = ISNULL(@request.value('(/EVGui_StoragePolicySummaryReq/@clientId)[1]', 'integer'), 0),
			@appType      = ISNULL(@request.value('(/EVGui_StoragePolicySummaryReq/@appType)[1]', 'integer'), 0),
			@spCopyId	  = ISNULL(@request.value('(/EVGui_StoragePolicySummaryReq/@spCopyId)[1]', 'integer'), 0),
			@subclientId  = ISNULL(@request.value('(/EVGui_StoragePolicySummaryReq/@subclientId)[1]', 'integer'), 0),
			@respFlag     = ISNULL(@request.value('(/EVGui_StoragePolicySummaryReq/@respFlag)[1]', 'integer'), 0)
	IF (@spId IS NULL)
	BEGIN
		SET @errmsg = N'DbXMLStoragePolicySummary: SPID[' + CAST(@spId AS NVARCHAR(12)) + '] is not Specified in request'
		RAISERROR(@errmsg, 16, 1)
		GOTO DbXMLStoragePolicySummary_End
	END
	IF (@clientId IS NULL)
		SET @clientId =0
	IF (@appType IS NULL)
		SET @appType =0
	IF (@spCopyId IS NULL)
		SET @spCopyId =0
	IF (@subclientId IS NULL)
		SET @subclientId =0
--	+===============================================+
--	|  Sub Client Info:							|
--	+===============================================+
	IF object_id('tempdb.dbo.#tempSubclientStats') is not null DROP TABLE #tempSubclientStats
	create table #tempSubclientStats
	(
		commCellId			int,
commCellName		nvarchar(255),
		applicationSize		bigint,
		compressedAppSize	bigint,
		sizeOnMedia			bigint,
		nwTransferSize		bigint,
		clientId			int,
clientName			nvarchar(255),
		appTypeId			int,
appTypeName			varchar(255),
		backupSetId			int,
backupSetName		nvarchar(255),
		subClientId			int,
subClientName		nvarchar(255),
		instanceId			int,
instanceName		nvarchar(255),
		lastbackupTime		int,
		jobsCount			int,
		copyId				int,
		spId				int,  -- it will be used only in case of GDSP data being asked, in rest case it would be spid given as input
		PRIMARY KEY(subClientId, commCellId,copyId))
--	+===============================================+
--	|  Job Info:							|
--	+===============================================+
IF (@spCopyId>0)
BEGIN
	IF object_id('tempdb.dbo.#tempJobStats1') is not null DROP TABLE #tempJobStats1
	create table #tempJobStats1
	(
		jobId				int,
		commCellId			int,
		subClientId1		int,
		applicationSize		bigint,
		compressedAppSize	bigint,
		totalBackupSize		bigint,
		nwTransferSize		bigint,
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		jobstatus			int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		streamNum			int,
		numObjects			bigint,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
userName			nvarchar(255),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		subClientId			int,
		clientId			int,
		appTypeId			int,
		instanceId			int,
		backupSetId			int,
clientName			nvarchar(255),
appTypeName			varchar(255),
instanceName		nvarchar(255),
backupSetName		nvarchar(255),
subClientName		nvarchar(255),
commCellName		nvarchar(255),
		status				int,
		disabled			int,
		toBeCopied			int,
		jobCopyAttributes	int,
		sizeOnMedia			bigint,
		archCheckEndTime	int,
		archCheckStatus		int,
		extRetentionFlags	int,
		retentionEndTime	bigint,
		copiedTime			bigint,
		agedTime			bigint,
		errorCode			int,
		retainedBy			integer,
		copyId				int,
		dedupSaving			bigint,
		jobCopyStatus		int,
		jobDescription		nvarchar(MAX),
		jobDisplayFlags		bigint,
		indexBackupJob		int,
		clientOwnerList		nvarchar(MAX),
		RequiredByJobIds	nvarchar(MAX),
		lastRefreshTime		int,
clientDisplayName	nvarchar(255),
		PRIMARY KEY(jobId, commCellId))
	INSERT INTO #tempJobStats1
	EXEC archViewJobsByCopy @spCopyId,0,0,0,0,0,0,0,0
	INSERT INTO #tempSubclientStats
	SELECT
	J.commCellId,J.commCellName,
	SUM(J.applicationSize),
	SUM(J.compressedAppSize),
	SUM(J.sizeOnMedia),
	SUM(J.nwTransferSize),
	J.clientId,
	J.clientName,
	J.appTypeId,
	J.appTypeName,
	J.backupSetId,
	J.backupSetName,
	J.subClientId,
	J.subClientName,
	J.instanceId,
	J.instanceName,
	MAX(J.endTime),
	COUNT(J.jobId),
	J.copyId,
	@spId
	FROM  #tempJobStats1 AS J
	WHERE J.status = 100
	GROUP BY J.commCellId,J.commCellName,
			J.clientId,J.clientName,
			J.appTypeId,J.appTypeName,
			J.backupSetId,J.backupSetName,
			J.subClientId,J.subClientName,
			J.instanceId,J.instanceName,
			J.copyId
	IF (@reportType =5) --start of storage policy copy summary and dedup information for report type COMMSERV
	BEGIN
		DECLARE @SIDBStoreId INTEGER = 0
		SELECT 	@flags = flags, @dedupFlags = dedupeFlags, @SIDBStoreId = SIDBStoreId,
				@sourceCopy = (SELECT SC.name FROM archGroupCopy SC WITH (NOLOCK) WHERE SC.id = AGC.sourceCopyId),
				@multiplexingEnabled = maxMultiplex,
				@combineStreams = 	CASE
WHEN (flags & 4) = 4 THEN maxStreamNum
WHEN (flags & 4) = 0 THEN -1
									END
		FROM 	archGroupCopy AGC WITH (NOLOCK)
		WHERE 	id = @spCopyId
		IF(@dedupFlags > 0)
		BEGIN
			DECLARE @MagLibrariesforCopy  TABLE (t_LibraryId int)
			DECLARE @i_Flags integer = 0
			INSERT INTO @MagLibrariesforCopy
			  SELECT DISTINCT MP.LibraryId
			  FROM MMDrivePool DRP WITH (READUNCOMMITTED), MMDataPath DAP WITH (READUNCOMMITTED),
				  MMMasterPool MP WITH (READUNCOMMITTED)
			  WHERE DAP.CopyId = @spCopyId AND DAP.DrivePoolId = DRP.DrivePoolId AND ((@i_Flags & 1) = 0 OR (DAP.Flag & 8) = 0)
AND DRP.DrivePoolType = 10001 AND DRP.MasterPoolId = MP.MasterPoolId
			 SELECT @freeSpaceforCopyMB = SUM(FreeBytesMB)
			  FROM @MagLibrariesforCopy T, MMMedia MM WITH (READUNCOMMITTED), MMMediaSide MS WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED)
			  WHERE MM.LibraryId = T.t_LibraryId AND MM.MediaId = MS.MediaId AND MS.MediaSideId = MP.MediaSideId
		END
		SELECT @retentionFortheCopy = retentionDays, @retentionCyclesFortheCopy = fullCycles from archAgingRule WITH (NOLOCK) where copyId = @spCopyId
		SELECT	@blockLevelDeduplication = SIBlockSizeKB
		FROM	archGroup WITH (NOLOCK)
		WHERE	id = @spId
IF (@dedupFlags & 134217728) <> 0 AND @SIDBStoreId > 0
		BEGIN
			SELECT	@blockLevelDeduplication = AG.SIBlockSizeKB
			FROM	archGroup AG WITH (NOLOCK), archCopyToGlobalPolicy C2G WITH (NOLOCK)
			WHERE	AG.id = C2G.globalPolicyId
					AND C2G.copyId = @spCopyId
		END
		ELSE IF @blockLevelDeduplication = 0
		BEGIN
SET @blockLevelDeduplication = 128
		END
		DECLARE @isPrimary 	TINYINT	= 0
		DECLARE @releaseID 	TINYINT	= 0 --for 9.0 relaseID =14
		DECLARE @maLessthan90 	TINYINT	= 0
		IF EXISTS (SELECT defaultCopy FROM archGroup WHERE id=@spId AND defaultCopy=@spCopyId)
		BEGIN
			SET @isPrimary  = 1
		END
		SET @releaseID = (SELECT MIN (releaseId) FROM APP_Client app
							INNER JOIN MMDataPath md
							ON
							md.HostClientId = app.id
							AND MD.CopyId =@spCopyId)
		IF(@releaseID<14)
		BEGIN
			SET @maLessthan90 = 1
		END
		SELECT @softwareCompressionEnabled = CASE
WHEN (flags & 2) = 2 THEN 1
			ELSE 0
		END
		FROM IdxSIDBStore WITH (NOLOCK) where SIDBStoreId in (select SIDBStoreId from archCopySIDBStore WITH (NOLOCK) where copyId = @spCopyId and commCellId = 2) and status = 0
		SELECT
		@sourceCopy = dbo.NormalizeForXML(CASE @sourceCopy
		WHEN 'DUMMY' THEN ''
		ELSE @sourceCopy
		END),
		@multiplexingEnabled = CASE
			WHEN @multiplexingEnabled > 0 THEN 1
			ELSE 0
		END,
@mediaRefreshEnabled = CASE(@flags & 33554432)
WHEN 33554432 THEN 1
		ELSE 0
		END,
@reEncryptionEnabled = CASE (@flags & 8388608)
WHEN 8388608 THEN 1
		ELSE 0
		END,
		@storePrimingEnabled = CASE
		WHEN (@dedupFlags & 2) = 2 THEN 1
		ELSE 0
		END,
@siloEnabled = CASE (@flags & 524288)
WHEN 524288 THEN 1
		ELSE 0
		END,
		@dashOptions = CASE
WHEN ((@dedupFlags & 8388608) = 8388608  AND ((@isPrimary  = 1 ) OR(@maLessthan90 = 1))) THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (2729 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
WHEN ((@dedupFlags & 524288) = 524288 AND ((@isPrimary  = 1 ) OR(@maLessthan90 = 1))) THEN ''
WHEN (@dedupFlags & 8388608) = 8388608   THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3206 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
WHEN (@dedupFlags & 524288) = 524288 THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3205 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		ELSE ''
		END,
		@uponAnyPartitionCorruption = CASE
WHEN (@dedupFlags & 33554432) = 33554432 THEN
			CASE
WHEN (@dedupFlags & 67108864) = 67108864 THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (2809 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
ELSE DBO.fn_EvFormatEventMsgText(0, @i_localeId, (2810 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			END
ELSE DBO.fn_EvFormatEventMsgText(0, @i_localeId, (2808 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		END
		-- DBO.fn_EvFormatEventMsgText(0, @i_localeId, (2808 | (CAST(POWER(2, 24) AS	BIGINT) * 61)), 0,2) -- for Failover to new store
		--DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3181 | (CAST(POWER(2, 24) AS	BIGINT) * 61)), 0,2) -- for Recover current store
		--CASE
		--WHEN (@dedupFlags & 131072) = 131072 THEN 1
		--ELSE 0
		--END AS sealStoreEnabled
		SELECT @archTaskActive = active, @numDays = numPeriod, @periodType = periodType, @storeCreationSize = dataSizeGB, @storeCreationDate = dbo.GetUnixTime(nextEvent), @doNotDuplicateAgainstObjects  = oldestEligibleObjArchiveTime
		FROM archGroupCopy AGC WITH (NOLOCK)
INNER JOIN archCopySIDBStore CS WITH (NOLOCK) ON AGC.id = CS.copyId AND ((CS.Flags & 4) > 0)
		INNER JOIN IdxSIDBStore S WITH (NOLOCK)
		ON S.SIDBStoreId = CS.SIDBStoreId
		INNER JOIN archTask T WITH (NOLOCK) ON
		T.id = AGC.sealStoreTaskId
		WHERE AGC.id = @spCopyId
		IF (@archTaskActive = 1)
		BEGIN
			IF(@periodType = 3)
			BEGIN
				SET @storeCreationDays = @numDays
			END
			IF(@periodType = 4)
			BEGIN
				SET @storeCreationMonths = @numDays
			END
		END
	END -- end of storage policy copy summary and dedup information for report type COMMSERV
END
ELSE IF (@spId>0)
BEGIN
		DECLARE	@l_spFlags		INT = 0
		SELECT	@l_spFlags = flags	FROM archGroup 	WHERE id = @spId
IF	(@l_spFlags & 256) <> 0 OR (@l_spFlags & 8388608) <> 0
	BEGIN
		IF object_id('tempdb.dbo.#tempJobStatsGDSP') is not null DROP TABLE #tempJobStatsGDSP
		create table #tempJobStatsGDSP
		(
			jobId				int,
			commCellId			int,
commCellName		nvarchar(255),
			dataState			int,
			applicationSize		bigint,
			compressedAppSize	bigint,
			sizeOnMedia			bigint,
			nwTransferSize		bigint,
			clientId			int,
clientName			nvarchar(255),
			appTypeId 			int,
appTypeName			varchar(255),
			backupSetId			int,
backupSetName		nvarchar(255),
			subClientId 		int,
subClientName		nvarchar(255),
			instanceId 			int,
instanceName		nvarchar(255),
			startTime			int,
			endTime				int,
			opType				int,
			level				int,
			status				int,
			fullCycleNum		int,
			seqNumInCycle		int,
			duration			int,
			streamNum			int,
			initFrom			int,
			attributes			bigint,
failReason			nvarchar(255),
userName			nvarchar(255),
			totalWriteTime		int,
			scanFileFailures	int,
			scanFolderFailures	int,
			bkpFileFailures		int,
			bkpFolderFailures	int,
			numObjects			bigint,
			extRetentionFlags	int,
			retentionEndTime	bigint,
			agedTime			bigint,
			jobDescription		nvarchar(MAX),
			copyId				integer,
copyName			nvarchar(255),
			spId				integer,
policyName			nvarchar(255),
			retainedBy			integer,
			PRIMARY KEY(jobId, commCellId,copyId))
			EXEC archViewJobsByGlobalPolicy @spId,0,0,0,0,0,0,0,0
			INSERT INTO #tempSubclientStats
			SELECT
			J.commCellId,J.commCellName,
			SUM(J.applicationSize),
			SUM(J.compressedAppSize),
			SUM(J.sizeOnMedia),
			SUM(J.nwTransferSize),
			J.clientId,
			J.clientName,
			J.appTypeId,
			J.appTypeName,
			J.backupSetId,
			J.backupSetName,
			J.subClientId,
			J.subClientName,
			J.instanceId,
			J.instanceName,
			MAX(J.endTime),
			COUNT(J.jobId),
			J.copyId,
			J.spId
			FROM  #tempJobStatsGDSP AS J
			GROUP BY J.commCellId,J.commCellName,
					J.clientId,J.clientName,
					J.appTypeId,J.appTypeName,
					J.backupSetId,J.backupSetName,
					J.subClientId,J.subClientName,
					J.instanceId,J.instanceName,
					J.copyId,J.spId
		IF object_id('tempdb.dbo.#tempJobStatsGDSP') is not null DROP TABLE #tempJobStatsGDSP
	END
	ELSE
	BEGIN
	IF object_id('tempdb.dbo.#tempJobStats') is not null DROP TABLE #tempJobStats
	create table #tempJobStats
	(
		jobId				int,
		commCellId			int,
commCellName		nvarchar(255),
		dataState			int,
		applicationSize		bigint,
		compressedAppSize	bigint,
		sizeOnMedia			bigint,
		nwTransferSize		bigint,
		clientId			int,
clientName			nvarchar(255),
		appTypeId 			int,
appTypeName			varchar(255),
		backupSetId			int,
backupSetName		nvarchar(255),
		subClientId 		int,
subClientName		nvarchar(255),
		instanceId 			int,
instanceName		nvarchar(255),
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		status				int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		streamNum			int,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
failReason			nvarchar(255),
userName			nvarchar(255),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		numObjects			bigint,
		extRetentionFlags	int,
		retentionEndTime	bigint,
		agedTime			int,
		flagsCI				int,
		flagsFLA			int,
		minFileType			int,
		contentIndexTime	int,
		snapToTapeStatus	int,
		snapDeferredCatalogStatus	int,
		retainedBy	int,
		dedupSaving			bigint,
		copyId				int,
		stubDataSize		bigInt,
		jobDescription		nvarchar(MAX),
		searchEngine		varchar(1024),
		indexBackupJob		int,
		encrypted	int,
clientDisplayName nvarchar(255),
		PRIMARY KEY(jobId, commCellId,copyId))
	-- OUTPUT WILL BE THE JOB WHICH WE NEED TO SHOW AT SP LEVEL ONLY
     DECLARE @filterFlags int
SET @filterFlags = 256
	 IF ((@reportType = 8) OR (@reportType = 5) OR (@respFlag=0)OR (@respFlag=1))
	   BEGIN
	INSERT INTO #tempJobStats
		 EXEC archViewJobsByPolicy @spId,0,0,0,0,0,0,@filterFlags,0,0
       END
	-- OUTPUT WILL BE THE JOB WHICH WE NEEDS TO SHOW AT SP/SP COPY LEVEL, SO IF SAME JOB RESIDE 10 COPIES, IT WILL PROVIDE 10 ROW FOR THAT JOB
     IF ((@respFlag=0)OR (@respFlag=2))
	   BEGIN
SET @filterFlags = @filterFlags|128
	INSERT INTO #tempJobStats
		 EXEC archViewJobsByPolicy @spId,0,0,0,0,0,0,@filterFlags,0,0
	   END
	INSERT INTO #tempSubclientStats
	SELECT
	J.commCellId,J.commCellName,
	SUM(J.applicationSize),
	SUM(J.compressedAppSize),
	SUM(J.sizeOnMedia),
	SUM(J.nwTransferSize),
	J.clientId,
	J.clientName,
	J.appTypeId,
	J.appTypeName,
	J.backupSetId,
	J.backupSetName,
	J.subClientId,
	J.subClientName,
	J.instanceId,
	J.instanceName,
	MAX(J.endTime),
	COUNT(J.jobId),
		J.copyId,
		@spId
	FROM  #tempJobStats AS J
	GROUP BY J.commCellId,J.commCellName,
			J.clientId,J.clientName,
			J.appTypeId,J.appTypeName,
			J.backupSetId,J.backupSetName,
			J.subClientId,J.subClientName,
			J.instanceId,J.instanceName,
			J.copyId
	END
END
------
DECLARE @sptype INT
SET @sptype  = ISNULL((SELECT type FROM archGroup WHERE id = @spId),0)
--
	--NO DISTRIBUTION provides mounth path info
	IF (@reportType =0)   --EVGui::SPReportType_CLIENT
		BEGIN
		  IF ((@respFlag=0)OR (@respFlag=1))
		  BEGIN
			SET @SummaryData =(
			SELECT
				SUM(outtb.jobsCount) AS '@jobsCount'
				,COUNT(DISTINCT outtb.subClientId) AS '@clientsCount'       -- it would count the subclients
				, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
,CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'
				, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
				, outtb.clientId AS 'client/@id'
				, dbo.NormalizeForXML(outtb.clientName) AS 'client/@name'
				, outtb.appTypeId AS 'appType/@id'
				, dbo.NormalizeForXML(outtb.appTypeName) AS 'appType/@name'
			FROM #tempSubclientStats AS outtb
			WHERE outtb.appTypeId = @appType
			AND (( (outtb.copyId = -1 OR outtb.copyId = @spCopyId) AND (outtb.spId = @spId))
				 OR(outtb.spId <> @spId)) -- THIS IS IN CASE OF GDSP
			GROUP BY   outtb.clientId, outtb.clientName
					 , outtb.appTypeId , outtb.appTypeName
				FOR XML Path('data'))
			END
		  IF ((@respFlag=0)OR (@respFlag=2))
		  BEGIN
			SET @CopyData =(
			SELECT
				SUM(outtb.jobsCount) AS '@jobsCount'
,CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'       -- it would count the subclients
				, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
				, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
				, outtb.copyId AS 'spcopy/@id'
				,dbo.NormalizeForXML(agc.name) AS 'spcopy/@name'
			FROM #tempSubclientStats AS outtb
			INNER JOIN archGroupCopy AS agc ON
			agc.id =  outtb.copyId
			AND outtb.appTypeId = @appType
			AND (outtb.copyId >0 AND (outtb.spId = @spId))
			GROUP BY    outtb.copyId,agc.name
				FOR XML Path('copydata'))
		  END
		END
	ELSE IF (@reportType =1)   --EVGui::SPReportType_APPTYPE
		BEGIN
		  IF ((@respFlag=0)OR (@respFlag=1))
		  BEGIN
			SET @SummaryData =(
			SELECT
				SUM(outtb.jobsCount) AS '@jobsCount'
				,COUNT(DISTINCT outtb.clientId) AS '@clientsCount'       -- it would count the clients
				, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
, CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'
				, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
				, outtb.appTypeId AS 'appType/@id'
				, dbo.NormalizeForXML(outtb.appTypeName) AS 'appType/@name'
			FROM #tempSubclientStats AS outtb
			--WHERE  (outtb.copyId = -1 OR outtb.copyId = @spCopyId)
			 WHERE (((outtb.copyId = -1 OR outtb.copyId = @spCopyId) AND (outtb.spId = @spId))
					OR(outtb.spId <> @spId)) -- THIS IS IN CASE OF GDSP
			GROUP BY  outtb.appTypeId , outtb.appTypeName
				FOR XML Path('data'))
		  END
		  IF ((@respFlag=0)OR (@respFlag=2))
		  BEGIN
			SET @CopyData =(
			SELECT
				SUM(outtb.jobsCount) AS '@jobsCount'
,CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'       -- it would count the subclients
				, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
				, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
				, outtb.copyId AS 'spcopy/@id'
				,dbo.NormalizeForXML(agc.name) AS 'spcopy/@name'
			FROM #tempSubclientStats AS outtb
			INNER JOIN archGroupCopy AS agc ON
			agc.id =  outtb.copyId
			AND (outtb.copyId >0 AND (outtb.spId = @spId))
			GROUP BY    outtb.copyId,agc.name
				FOR XML Path('copydata'))
			END
		END
	ELSE IF (@reportType =5)   --EVGui::SPReportType_COMMSERVER
		BEGIN
			DECLARE @subclientcount INT =0
			IF EXISTS (SELECT defaultCopy FROM archGroup WHERE id=@spId AND defaultCopy=@spCopyId)
			BEGIN
			SET @subclientcount = (SELECT	COUNT ( id)
										FROM	APP_Application
									WHERE	(dataArchGrpId = @spId OR logArchGrpID = @spId) AND
											(subclientStatus & 2) = 0 AND (subclientStatus & 4) = 0 AND
 											((subclientStatus & 32) = 0 AND (subclientStatus & 16) = 0 OR (subclientStatus & 64) > 0)
									)
			END
			ELSE
			BEGIN
			-- this is for the AUX copy summary page and since subclient count  will be independent from the summary page
				if object_id('tempdb.dbo.#tmpCopyAppsOut') is not null DROP TABLE #tmpCopyAppsOut
					create table #tmpCopyAppsOut (id int,
					clientId	int,
					appTypeId	int,
					instance	int,
					backupSet	int,
					subclientName nvarchar(512),
					isSelected int)
					EXEC archCopyAppSubset @spCopyId,@spId
					SET @subclientcount= (SELECT COUNT(*) FROM  #tmpCopyAppsOut WHERE (isSelected>0))
					if object_id('tempdb.dbo.#tmpCopyAppsOut') is not null DROP TABLE #tmpCopyAppsOut
			END
			SET @SummaryData =(
			SELECT
				SUM(outtb.jobsCount) AS '@jobsCount'
				,@subclientcount AS '@clientsCount'       -- it would count the subclients
				, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
, CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'
				, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
			FROM #tempSubclientStats AS outtb
			--WHERE  (outtb.copyId = -1 OR outtb.copyId = @spCopyId)
			 WHERE (((outtb.copyId = -1 OR outtb.copyId = @spCopyId) AND (outtb.spId = @spId))
					OR(outtb.spId <> @spId)) -- THIS IS IN CASE OF GDSP
				FOR XML Path('data'))
			SET @CopyData ='' -- AS not needed for summary page
			SET @SPCopySummaryData =(
				SELECT
					  @multiplexingEnabled AS '@multiplexingEnabled'
					, @mediaRefreshEnabled AS '@mediaRefreshEnabled'
					, @reEncryptionEnabled AS '@reEncryptionEnabled'
					, @retentionFortheCopy AS '@retentionFortheCopy'
					, @retentionCyclesFortheCopy AS '@retentionCyclesFortheCopy'
					, @combineStreams AS '@combineStreams'
					, dbo.NormalizeForXML(@sourceCopy) AS '@sourceCopy'
					,CASE
					WHEN @dedupFlags > 0 THEN
					(
						SELECT @softwareCompressionEnabled AS '@softwareCompressionEnabled'
						, @blockLevelDeduplication AS '@blockLevelDeduplication'
						, @storePrimingEnabled AS '@storePrimingEnabled'
						, @siloEnabled AS '@siloEnabled'
						, @dashOptions AS '@dashOptions'
						, @uponAnyPartitionCorruption AS '@uponAnyPartitionCorruption'
						, @doNotDuplicateAgainstObjects AS '@doNotDuplicateAgainstObjects'
						, @storeCreationDays AS '@storeCreationDays'
						, @storeCreationSize AS '@storeCreationSize'
						, @storeCreationMonths AS '@storeCreationMonths'
						, @storeCreationDate AS '@storeCreationDate'
						, @freeSpaceforCopyMB AS '@freeSpaceforCopyMB'
						FOR
						XML PATH('dedupOptions'),
						TYPE
					)
					END
			    FOR XML Path('options'))
		END
	ELSE IF (@reportType =8)   --EVGui::SPReportType_STORAGE_POLICY  THIS WOULD BE ONLY FOR GDSP STORAGE POLICY
	BEGIN
		SET @SummaryData =(
		SELECT
			SUM(outtb.jobsCount) AS '@jobsCount'
			,COUNT(DISTINCT outtb.clientId) AS '@clientsCount'       -- it would count the clients
			, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
, CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'
			, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
			, outtb.appTypeId AS 'appType/@id'
			, dbo.NormalizeForXML(outtb.appTypeName) AS 'appType/@name'
			, outtb.instanceId AS 'instance/@id'
			, dbo.NormalizeForXML(outtb.instanceName) AS 'instance/@name'
			, outtb.clientId AS 'client/@id'
			, dbo.NormalizeForXML(outtb.clientName) AS 'client/@name'
			, outtb.backupSetId AS 'backupset/@id'
			, dbo.NormalizeForXML(outtb.backupSetName) AS 'backupset/@name'
			, outtb.subClientId AS 'subclient/@id'
			, dbo.NormalizeForXML(outtb.subClientName) AS 'subclient/@name'
			,outtb.spId AS 'sp/@id'
			,dbo.NormalizeForXML(ag.name) AS 'sp/@name'
		FROM #tempSubclientStats AS outtb
		INNER JOIN archGroup AS ag ON
		ag.id = outtb.spId
		AND outtb.appTypeId = @appType
		AND   outtb.clientId = @clientId
		AND   outtb.subClientId = @subclientId
--		AND   (outtb.copyId = -1 OR outtb.copyId = @spCopyId)
		AND    (((outtb.copyId = -1 OR outtb.copyId = @spCopyId) AND (outtb.spId = @spId))
				OR(outtb.spId <> @spId)) -- THIS IS IN CASE OF GDSP
		GROUP BY   outtb.clientId, outtb.clientName
					, outtb.appTypeId , outtb.appTypeName
					, outtb.instanceId, outtb.instanceName
					, outtb.backupSetId, outtb.backupSetName
					, outtb.subClientId, outtb.subClientName
					, outtb.spId, ag.name
			FOR XML Path('data'))
		SET @CopyData ='' -- AS COPY DATA NOT BE AVAILABLE FOR GDSP
	END
	ELSE    --EVGui::SPReportType_SUBCLIENT
		BEGIN
		  IF ((@respFlag=0)OR (@respFlag=1))
		  BEGIN
			SET @SummaryData =(
			SELECT
				SUM(outtb.jobsCount) AS '@jobsCount'
				,COUNT(DISTINCT outtb.clientId) AS '@clientsCount'       -- it would count the clients
				, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
, CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'
				, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
				, outtb.appTypeId AS 'appType/@id'
				, dbo.NormalizeForXML(outtb.appTypeName) AS 'appType/@name'
				, outtb.instanceId AS 'instance/@id'
				, dbo.NormalizeForXML(outtb.instanceName) AS 'instance/@name'
				, outtb.clientId AS 'client/@id'
				, dbo.NormalizeForXML(outtb.clientName) AS 'client/@name'
				, outtb.backupSetId AS 'backupset/@id'
				, dbo.NormalizeForXML(outtb.backupSetName) AS 'backupset/@name'
				, outtb.subClientId AS 'subclient/@id'
				, dbo.NormalizeForXML(outtb.subClientName) AS 'subclient/@name'
			FROM #tempSubclientStats AS outtb
			INNER JOIN archGroup AS ag ON
			ag.id = outtb.spId
			AND outtb.appTypeId = @appType
			AND   outtb.clientId = @clientId
--			AND   (outtb.copyId = -1 OR outtb.copyId = @spCopyId)
			AND    (((outtb.copyId = -1 OR outtb.copyId = @spCopyId) AND (outtb.spId = @spId))
					OR(outtb.spId <> @spId)) -- THIS IS IN CASE OF GDSP
			GROUP BY   outtb.clientId, outtb.clientName
					 , outtb.appTypeId , outtb.appTypeName
					 , outtb.instanceId, outtb.instanceName
					 , outtb.backupSetId, outtb.backupSetName
					 , outtb.subClientId, outtb.subClientName
				FOR XML Path('data'))
		END
		  IF ((@respFlag=0)OR (@respFlag=2))
		  BEGIN
		SET @CopyData =(
			SELECT
				SUM(outtb.jobsCount) AS '@jobsCount'
,CASE  WHEN @sptype = 2 THEN -1 ELSE  SUM(outtb.applicationSize) END AS '@applicationDataSize'       -- it would count the subclients
				, SUM(outtb.sizeOnMedia) AS '@backedupDataSize'
				, MAX(outtb.lastBackupTime)   AS '@lastBackupTime'
				, outtb.copyId AS 'spcopy/@id'
				,dbo.NormalizeForXML(agc.name) AS 'spcopy/@name'
			FROM #tempSubclientStats AS outtb
			INNER JOIN archGroupCopy AS agc ON
			agc.id =  outtb.copyId
			AND outtb.appTypeId = @appType
			AND outtb.clientId = @clientId
			AND (outtb.copyId >0 AND (outtb.spId = @spId))
			GROUP BY    outtb.copyId,agc.name
				FOR XML Path('copydata'))
			END
		END
SET @response	 =
					(SELECT @SummaryData,
							@CopyData,
							@SPCopySummaryData
						FOR XML PATH ('EVGui_StoragePolicySummaryResp')
						)
IF(@response IS NULL)
   SET @response   = '<EVGui_StoragePolicySummaryResp/>'
	DbXMLStoragePolicySummary_End:
	IF object_id('tempdb.dbo.#tempJobStats') is not null DROP TABLE #tempJobStats
	IF object_id('tempdb.dbo.#tempJobStats1') is not null DROP TABLE #tempJobStats1
	IF object_id('tempdb.dbo.#tempSubclientStats') is not null DROP TABLE #tempSubclientStats
	SELECT @response AS [response]
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLStoragePolicySummary')
	delete from GxQscripts where name = 'DbXMLStoragePolicySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLStoragePolicySummary')
	delete from GXDBVersions where aliasname = 'DbXMLStoragePolicySummary'
GO

insert into GXDBVersions values(2, 'DbXMLStoragePolicySummary',  '00010032000200150000', 'DbXMLStoragePolicySummary', '00010032000200150000')
GO

