

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLStoragePolicyJobsSummary.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DbXMLStoragePolicyJobsSummary')
BEGIN
	print '>>> Drop Stored Procedure: DbXMLStoragePolicyJobsSummary <<<'
	drop procedure DbXMLStoragePolicyJobsSummary
END
IF EXISTS (select * from GxQscripts where name='DbXMLStoragePolicyJobsSummary')
	delete from GxQscripts where name = 'DbXMLStoragePolicyJobsSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLStoragePolicyJobsSummary')
	delete from GXDBVersions where aliasname = 'DbXMLStoragePolicyJobsSummary'
GO
print '... Creating Procedure: DbXMLStoragePolicyJobsSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLStoragePolicyJobsSummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response XML
BEGIN
	SET NOCOUNT ON
	DECLARE @reportType INT
	DECLARE @spId INT
	DECLARE @clientId INT
	DECLARE @appType INT
	DECLARE @spCopyId INT
	DECLARE @subclientId INT
	DECLARE @errmsg NVARCHAR(2000)
	SELECT
			@reportType = @request.value('(/EVGui_StoragePolicyJobsSummaryReq/@reportType)[1]', 'integer'),
			@spId = ISNULL(@request.value('(/EVGui_StoragePolicyJobsSummaryReq/@spId)[1]', 'integer'), 0),
			@clientId = ISNULL(@request.value('(/EVGui_StoragePolicyJobsSummaryReq/@clientId)[1]', 'integer'), 0),
			@appType = ISNULL(@request.value('(/EVGui_StoragePolicyJobsSummaryReq/@appType)[1]', 'integer'), 0),
			@spCopyId = ISNULL(@request.value('(/EVGui_StoragePolicyJobsSummaryReq/@spCopyId)[1]', 'integer'), 0),
			@subclientId = ISNULL(@request.value('(/EVGui_StoragePolicyJobsSummaryReq/@subclientId)[1]', 'integer'), 0)
	IF (@spId IS NULL)
	BEGIN
		SET @errmsg = N'DbXMLStoragePolicyJobsSummary: SPID[' + CAST(@spId AS NVARCHAR(12)) + '] is not Specified in request'
		RAISERROR(@errmsg, 16, 1)
		GOTO DbXMLStoragePolicyJobsSummary_End
	END
	IF (@clientId IS NULL)
		SET @clientId =0
	IF (@appType IS NULL)
		SET @appType =0
	IF (@spCopyId IS NULL)
		SET @spCopyId =0
--	+===============================================+
--	|  Sub Client Info:							|
--	+===============================================+
	IF object_id('tempdb.dbo.#tempSubclientStats') is not null DROP TABLE #tempSubclientStats
	create table #tempSubclientStats
	(
		commCellId			int,
		commCellName		nvarchar(100),
		applicationSize		bigint,
		compressedAppSize	bigint,
		sizeOnMedia			bigint,
		nwTransferSize		bigint,
		clientId			int,
		clientName			nvarchar(100),
		appTypeId 			int,
		appTypeName			varchar(100),
		backupSetId			int,
		backupSetName		nvarchar(100),
		subClientId 		int,
		subClientName		nvarchar(100),
		instanceId 			int,
		instanceName		nvarchar(100),
		lastbackupTime			int,
		jobId				int ,
		jobStatus			varchar(MAX),
		agedTime			int,
		dedupSaving         bigint,
		disabled			int,               -- added to add support for the job which having status as bad f
		retentionEndTime    bigint,            -- added to add support for the retention period
		PRIMARY KEY(jobId, commCellId))
--	+===============================================+
--	|  Job Info:							|
--	+===============================================+
IF (@spCopyId>0)
BEGIN
	IF object_id('tempdb.dbo.#tempJobStats1') is not null DROP TABLE #tempJobStats1
	create table #tempJobStats1
	(
		jobId				int,
		commCellId			int,
		subClientId1 		int,
		applicationSize		bigint,
		compressedAppSize	bigint,
		totalBackupSize 	bigint,
		nwTransferSize		bigint,
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		jobstatus			int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		streamNum			int,
		numObjects			bigint,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
		userName			nvarchar(100),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		subClientId 		int,
		clientId			int,
		appTypeId 			int,
		instanceId 			int,
		backupSetId			int,
		clientName			nvarchar(100),
		appTypeName			varchar(100),
		instanceName		nvarchar(100),
		backupSetName		nvarchar(100),
		subClientName		nvarchar(100),
		commCellName		nvarchar(100),
		status				int,
		disabled			int,
		toBeCopied			int,
		jobCopyAttributes	int,
		sizeOnMedia			bigint,
		archCheckEndTime    int,
		archCheckStatus     int,
		extRetentionFlags   int,
		retentionEndTime    bigint,
		copiedTime          bigint,
		agedTime			bigint,
		errorCode			int,
		retainedBy          integer,
		copyId				int,
		dedupSaving			bigint,
		jobCopyStatus		int,
		jobDescription      nvarchar(MAX),
		jobDisplayFlags		bigint,
		indexBackupJob		int,
		clientOwnerList		nvarchar(MAX),
		RequiredByJobIds		nvarchar(MAX),
		lastRefreshTime      int,
clientDisplayName	nvarchar(255),
		PRIMARY KEY(jobId, commCellId))
	INSERT INTO #tempJobStats1
	EXEC archViewJobsByCopy @spCopyId,0,0,0,0,0,0,0,0
	INSERT INTO #tempSubclientStats
	SELECT
	J.commCellId,J.commCellName,
	J.applicationSize,
	J.compressedAppSize,
	J.sizeOnMedia,
	J.nwTransferSize,
	J.clientId,
	J.clientName,
	J.appTypeId,
	J.appTypeName,
	J.backupSetId,
	J.backupSetName,
	J.subClientId,
	J.subClientName,
	J.instanceId,
	J.instanceName,
	J.endTime,
	J.jobId ,
	CAST (J.jobStatus as varchar(20)) ,
	J.agedTime,
	J.dedupSaving,
	J.disabled,
	J.retentionEndTime
	FROM  #tempJobStats1 AS J
	WHERE J.status = 100
	GROUP BY J.commCellId,J.commCellName,
			J.clientId,J.clientName,
			J.appTypeId,J.appTypeName,
			J.backupSetId,J.backupSetName,
			J.subClientId,J.subClientName,
			J.instanceId,J.instanceName,
			J.endTime,J.jobId,J.jobStatus,J.agedTime,
			J.applicationSize,
			J.compressedAppSize,
			J.sizeOnMedia,
			J.nwTransferSize,
			J.dedupSaving,
			J.disabled,
			J.retentionEndTime
END
ELSE IF (@spId>0)
BEGIN
	IF object_id('tempdb.dbo.#tempJobStats') is not null DROP TABLE #tempJobStats
	create table #tempJobStats
	(
		jobId				int,
		commCellId			int,
		commCellName		nvarchar(100),
		dataState			int,
		applicationSize		bigint,
		compressedAppSize	bigint,
		sizeOnMedia			bigint,
		nwTransferSize		bigint,
		clientId			int,
		clientName			nvarchar(100),
		appTypeId 			int,
		appTypeName			varchar(100),
		backupSetId			int,
		backupSetName		nvarchar(100),
		subClientId 		int,
		subClientName		nvarchar(100),
		instanceId 			int,
		instanceName		nvarchar(100),
		startTime			int,
		endTime				int,
		opType				int,
		level				int,
		status				int,
		fullCycleNum		int,
		seqNumInCycle		int,
		duration			int,
		streamNum			int,
		initFrom			int,
		attributes			bigint,
		attributesEx		bigint,
		failReason			nvarchar(100),
		userName			nvarchar(100),
		totalWriteTime		int,
		scanFileFailures	int,
		scanFolderFailures	int,
		bkpFileFailures		int,
		bkpFolderFailures	int,
		numObjects			bigint,
		extRetentionFlags	int,
		retentionEndTime	bigint,
		agedTime			int,
		flagsCI				int,
		flagsFLA			int,
		minFileType			int,
		contentIndexTime	int,
		snapToTapeStatus	int,
		snapDeferredCatalogStatus int,
		retainedBy	int,
		dedupSaving			bigint,
		copyId				int,
		stubDataSize        bigInt,
		jobDescription		nvarchar(MAX),
		searchEngine		varchar(1024),
		indexBackupJob		int,
		encrypted	int,
clientDisplayName nvarchar(255),
		PRIMARY KEY(jobId, commCellId,copyId))
	INSERT INTO #tempJobStats
	EXEC archViewJobsByPolicy @spId,0,0,0,0,0,0,0,0,0
	INSERT INTO #tempSubclientStats
	SELECT
	J.commCellId,J.commCellName,
	J.applicationSize,
	J.compressedAppSize,
	J.sizeOnMedia,
	J.nwTransferSize,
	J.clientId,
	J.clientName,
	J.appTypeId,
	J.appTypeName,
	J.backupSetId,
	J.backupSetName,
	J.subClientId,
	J.subClientName,
	J.instanceId,
	J.instanceName,
	J.endTime,
	J.jobId ,
	CAST (J.status as varchar(20)) ,
	J.agedTime,
	J.dedupSaving,
	0,
	0
	FROM  #tempJobStats AS J
	GROUP BY J.commCellId,J.commCellName,
			J.clientId,J.clientName,
			J.appTypeId,J.appTypeName,
			J.backupSetId,J.backupSetName,
			J.subClientId,J.subClientName,
			J.instanceId,J.instanceName,
			J.endTime,J.jobId,J.status,J.agedTime,
			J.applicationSize,
			J.compressedAppSize,
			J.sizeOnMedia,
			J.nwTransferSize,
			J.dedupSaving
END
	--NO DISTRIBUTION provides mounth path info
	    --EVGui::SPReportType_SUBCLIENT
			SET @response =(
			SELECT
				 outtb.jobId		 AS '@jobId'
				 ,(CASE WHEN ((outtb.disabled & 64)=64)
				  THEN  N'1010'
				  ELSE outtb.jobStatus
				 END )   AS '@jobStatus'
				, outtb.agedTime     AS '@agedDays'
				, outtb.retentionEndTime     AS '@retentionEndTime'
				,( CASE WHEN ((outtb.applicationSize-outtb.sizeOnMedia)<0)
						 THEN  N'N/A'
								ELSE
						CAST(CAST(
						(((outtb.applicationSize-outtb.sizeOnMedia)*100.00)/outtb.applicationSize) AS  DECIMAL(32,2)
						)
						AS NVARCHAR(128))+ '%'
				  END) AS '@dedupRatio'
				,
				(CASE WHEN ((outtb.applicationSize-outtb.sizeOnMedia)<0)
						 THEN  N'N/A'
					ELSE
						CAST( (outtb.applicationSize-outtb.sizeOnMedia) AS NVARCHAR(128))
				END) AS '@dedupSavings'
				,1 AS '@jobsCount'
				,0 AS '@clientsCount'       -- it would count the clients
				, outtb.sizeOnMedia AS '@backedupDataSize'
				, outtb.lastBackupTime   AS '@lastBackupTime'
				, outtb.appTypeId AS 'appType/@id'
				, dbo.NormalizeForXML(outtb.appTypeName) AS 'appType/@name'
				, outtb.instanceId AS 'instance/@id'
				, dbo.NormalizeForXML(outtb.instanceName) AS 'instance/@name'
				, outtb.clientId AS 'client/@id'
				, dbo.NormalizeForXML(outtb.clientName) AS 'client/@name'
				, outtb.backupSetId AS 'backupset/@id'
				, dbo.NormalizeForXML(outtb.backupSetName) AS 'backupset/@name'
				, outtb.subClientId AS 'subclient/@id'
				, dbo.NormalizeForXML(outtb.subClientName) AS 'subclient/@name'
			FROM #tempSubclientStats AS outtb
			WHERE outtb.appTypeId = @appType
			AND   outtb.clientId = @clientId
			AND   outtb.subClientId = @subclientId
			GROUP BY  outtb.jobId, outtb.jobStatus
					 , outtb.agedTime
					 , outtb.sizeOnMedia
					 , outtb.applicationSize
					 , outtb.lastBackupTime
					 ,outtb.clientId, outtb.clientName
					 , outtb.appTypeId , outtb.appTypeName
					 , outtb.instanceId, outtb.instanceName
					 , outtb.backupSetId, outtb.backupSetName
					 , outtb.subClientId, outtb.subClientName
					 , outtb.dedupSaving
					 , outtb.disabled
					 , outtb.retentionEndTime
				FOR XML Path('data'), ROOT('EVGui_StoragePolicyJobsSummaryResp'))
IF(@response IS NULL)
   SET @response   = '<EVGui_StoragePolicyJobsSummaryResp/>'
	DbXMLStoragePolicyJobsSummary_End:
	IF object_id('tempdb.dbo.#tempJobStats') is not null DROP TABLE #tempJobStats
	IF object_id('tempdb.dbo.#tempJobStats1') is not null DROP TABLE #tempJobStats1
	IF object_id('tempdb.dbo.#tempSubclientStats') is not null DROP TABLE #tempSubclientStats
	SELECT @response AS [response]
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLStoragePolicyJobsSummary')
	delete from GxQscripts where name = 'DbXMLStoragePolicyJobsSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLStoragePolicyJobsSummary')
	delete from GXDBVersions where aliasname = 'DbXMLStoragePolicyJobsSummary'
GO

insert into GXDBVersions values(2, 'DbXMLStoragePolicyJobsSummary',  '00010025003400090000', 'DbXMLStoragePolicyJobsSummary', '00010025003400090000')
GO

