

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLRepTapeLibSummary.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DbXMLRepTapeLibSummary <<<'

IF EXISTS (select * from sysobjects where name='DbXMLRepTapeLibSummary')
	drop procedure DbXMLRepTapeLibSummary
IF EXISTS (select * from GxQscripts where name='DbXMLRepTapeLibSummary')
	delete from GxQscripts where name = 'DbXMLRepTapeLibSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepTapeLibSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepTapeLibSummary'
GO
print '... Creating Procedure: DbXMLRepTapeLibSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLRepTapeLibSummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
	SET NOCOUNT ON
	DECLARE @reportXML XML
	SET @reportXML = ''
	DECLARE @LibrarySummaryXML XML
	DECLARE @reportType INT
	DECLARE @libId INT
	DECLARE @type INT
	DECLARE @appTypeId INT
	DECLARE @clientId INT
	DECLARE @errmsg NVARCHAR(2000)
	DECLARE @nLastdays INT = 7
	DECLARE @respFlag INT
	SELECT
			@reportType = @request.value('(/EVGui_TapeLibrarySummaryReq/@reportType)[1]', 'integer'),
			@libId = ISNULL(@request.value('(/EVGui_TapeLibrarySummaryReq/@libId)[1]', 'integer'), 0),
			@type = ISNULL(@request.value('(/EVGui_TapeLibrarySummaryReq/@type)[1]', 'integer'), 0),
		    @nLastdays =ISNULL(@request.value('(/EVGui_TapeLibrarySummaryReq/@nLastdays)[1]', 'integer'), 7),
		    @respFlag     = ISNULL(@request.value('(/EVGui_TapeLibrarySummaryReq/@respFlag)[1]', 'integer'), 0)
--	+===============================================+
--	| Library Validation Only Magnetic Lib allowed:							|
--	+===============================================+
DECLARE @filterdate DATE = GETDATE()-@nLastdays
DECLARE @Libtype INT
SET @Libtype=( SELECT LibraryTypeId FROM MMLibrary WHERE LibraryId = @libId)
	DECLARE @TapeLibraryMediaData XML
	SET @TapeLibraryMediaData =''
	DECLARE @tapeMediaInfo XML
	SET @tapeMediaInfo =''
	DECLARE @tapeMediaSummaryList XML
	SET @tapeMediaSummaryList =''
	DECLARE @mediaUsage XML
	SET @mediaUsage =''
	DECLARE @spareMediaCount INT
	SET @spareMediaCount =0
	DECLARE @TapeLibrarySummaryResp XML
	SET @TapeLibrarySummaryResp =''
IF @Libtype NOT IN(  1,4)
BEGIN
SET @errmsg = N'DbXMLRepTapeLibSummary: LibraryID[' + CAST(@libId AS NVARCHAR(12)) + '] is not a Tape library'
RAISERROR(@errmsg, 16, 1)
GOTO DbXMLRepTapeLibSummary_End
END
--	+===============================================+
--	| Tape Volume Info:							|
--	+===============================================+
	IF object_id('tempdb.dbo.#tmpTapeMediaInfo') is not null DROP TABLE #tmpTapeMediaInfo
	CREATE TABLE #tmpTapeMediaInfo
	(
		VolumeFlags			integer,
		MediaId				integer,
		BarCode				varchar(255),
		TotalSpaceMB		bigint,
		FreeBytesMB			bigint,
	 )
	CREATE TABLE #tmpTapeMediaUsage
	(
		spareMediaCount       integer,
		usedMediaCount        integer,
		releasedMediaCount    integer,
		Modified            DATETIME not null
	 )
 INSERT INTO #tmpTapeMediaInfo
		SELECT
			mmv.VolumeFlags,
			mmv.MediaId,
			mmm.BarCode,
			SUM(mms.TotalSpaceMB),
			SUM(mms.FreeBytesMB)
		FROM
			MMVolume  mmv
		INNER JOIN
			MMMedia mmm
		ON
			mmm.MediaId =mmv.MediaId
		INNER JOIN
			MMMediaSide mms
		ON
			mms.MediaId =mmm.MediaId
		AND
		    mmm.LibraryId =@libId
		GROUP BY
		    mmv.VolumeFlags,mmv.MediaId,mmm.BarCode
	UPDATE #tmpTapeMediaInfo
	SET #tmpTapeMediaInfo.MediaId = B.MediaId
		,#tmpTapeMediaInfo.VolumeFlags = B.VolumeFlags
		,#tmpTapeMediaInfo.TotalSpaceMB = B.TotalSpaceMB
		,#tmpTapeMediaInfo.FreeBytesMB = B.FreeBytesMB
	FROM #tmpTapeMediaInfo As A
	INNER JOIN
		  ( SELECT
			4 AS  VolumeFlags,
			mmm.MediaId,
			mmm.BarCode,
			SUM(mms.TotalSpaceMB) AS TotalSpaceMB,
			SUM(mms.FreeBytesMB) AS FreeBytesMB
		FROM
				MMMedia mmm
		INNER JOIN
			MMMediaSide mms
		ON
			mms.MediaId =mmm.MediaId
		AND
			mmm.MediaTypeId IN
			(SELECT MediaTypeId FROM
			 MMMediaType WHERE IsCleaningMedia=1)
		AND
		    mmm.LibraryId =@libId
		GROUP BY
		    mmm.MediaId,mmm.BarCode) AS B ON
		    A.MediaId = B.MediaId
	UPDATE #tmpTapeMediaInfo
	SET #tmpTapeMediaInfo.MediaId = B.MediaId
		,#tmpTapeMediaInfo.VolumeFlags = B.VolumeFlags
		,#tmpTapeMediaInfo.TotalSpaceMB = B.TotalSpaceMB
		,#tmpTapeMediaInfo.FreeBytesMB = B.FreeBytesMB
	FROM #tmpTapeMediaInfo As A
	INNER JOIN
		  ( SELECT
			9 AS  VolumeFlags,
			mmm.MediaId,
			mmm.BarCode,
			SUM(mms.TotalSpaceMB) AS TotalSpaceMB,
			SUM(mms.FreeBytesMB) AS FreeBytesMB
		FROM
				MMMedia mmm
		INNER JOIN
			MMMediaSide mms
		ON
			mms.MediaId =mmm.MediaId
		INNER JOIN
			MMVolume  mmv
		ON
			mmm.MediaId =mmv.MediaId
		AND mmv.VolumeFlags =5
		AND mmm.IsAged = 1
		AND    mmm.LibraryId =@libId
		GROUP BY
		    mmm.MediaId,mmm.BarCode) AS B ON
		    A.MediaId = B.MediaId
DELETE #tmpTapeMediaInfo WHERE VolumeFlags NOT IN (1,7,5,4,9,2)
DELETE #tmpTapeMediaInfo WHERE  BarCode = ('StdAln_' + CAST(MediaId as varchar(64)))
								--Dummy Media for stand alone library not to be shown MR 9121
								--#define MMS2_STANDALONE_DUMMY_BARCODE     "StdAln"
	SET @tapeMediaInfo =	(
				SELECT
				(Case mediaInfo.VolumeFlags
					WHEN 1 THEN  0
					WHEN 7 THEN  1
					WHEN 5 THEN  2
					WHEN 4 THEN  4
					WHEN 9 THEN  3
					WHEN 2 THEN  5
				END) AS [@type],
				mediaInfo.TotalSpaceMB AS [@capacity],
				mediaInfo.FreeBytesMB AS [@usedSpace],
				mediaInfo.MediaId  AS 'media/@id',
				mediaInfo.BarCode AS 'media/@name'
				FROM #tmpTapeMediaInfo	mediaInfo
			FOR XML PATH ('tapeMediaInfo'))
	SET @tapeMediaSummaryList =(
				SELECT
				(Case mediaInfo.VolumeFlags
					WHEN 1 THEN  0
					WHEN 7 THEN  1
					WHEN 5 THEN  2
					WHEN 4 THEN  4
					WHEN 9 THEN  3
					WHEN 2 THEN  5
				END) AS [@type],
				COUNT(*)AS [@count]
				FROM #tmpTapeMediaInfo	mediaInfo
				GROUP BY
				mediaInfo.VolumeFlags
			FOR XML PATH ('summarylist'))
	CREATE TABLE #tmpLibraryHistory
	(
		NumberOfMediaUsed INTEGER,
		NumberOfMediaFreed INTEGER,
		Modified            DATE not null
	 )
	CREATE TABLE #tmpLibHistoryday
	(
		sumNumberOfMediaUsed INTEGER,
		sumNumberOfMediaFreed INTEGER,
		Modified            DATETIME not null
	 )
	CREATE TABLE #tmpLibHistoryperday
	(
		sumNumberOfMediaUsed INTEGER,
		sumNumberOfMediaFreed INTEGER,
		Modified            DATETIME not null
	 )
	INSERT INTO #tmpLibraryHistory
	SELECT
		medialibInfo.NumberOfMediaUsed AS NumberOfMediaUsed,
		medialibInfo.NumberOfMediaFreed AS NumberOfMediaFreed,
		CAST(medialibInfo.Modified AS DATE) AS Modified
	FROM MMLibraryHistory	AS medialibInfo
	WHERE
	medialibInfo.LibraryId =@libId
	INSERT INTO #tmpLibHistoryperday
	SELECT
		0 AS sumNumberOfMediaUsed,
		0 AS sumNumberOfMediaFreed,
		CAST(libstatinfo.Modified AS DATE) AS Modified
	FROM MMLibraryStatsHistory	AS libstatinfo
	WHERE
	libstatinfo.LibraryId =@libId
	INSERT INTO #tmpLibHistoryday
	SELECT
		SUM(libhistory.NumberOfMediaUsed)  sumNumberOfMediaUsed,
		SUM(libhistory.NumberOfMediaFreed) AS sumNumberOfMediaFreed,
		CAST(libhistory.Modified AS DATE) AS Modified
	FROM #tmpLibraryHistory	AS libhistory
	GROUP BY libhistory.Modified
	UPDATE   #tmpLibHistoryperday
	SET sumNumberOfMediaUsed = 	libhistoryperday.sumNumberOfMediaUsed,
		sumNumberOfMediaFreed = libhistoryperday.sumNumberOfMediaFreed
	FROM #tmpLibHistoryday	AS libhistoryperday
	WHERE (DATEDIFF(DAY,CAST (libhistoryperday.Modified as DATE),
  						CAST (#tmpLibHistoryperday.Modified as DATE))=0)
	INSERT INTO #tmpTapeMediaUsage
	SELECT
		medialibstatInfo.NumOfSpareMedia  ,
		libinfoperday.sumNumberOfMediaUsed ,
		libinfoperday.sumNumberOfMediaFreed ,
		CAST(libinfoperday.Modified as DATE)
		FROM MMLibraryStatsHistory	AS medialibstatInfo
		INNER JOIN  #tmpLibHistoryperday AS libinfoperday ON
		  medialibstatInfo.LibraryId = @libId
		and (DATEDIFF(DAY,CAST (medialibstatInfo.Modified as DATE),
  						CAST (libinfoperday.Modified as DATE))=0)
	--	SELECT
	--	0 ,
	--	mediaInfo.NumOfActiveMedia ,
	--	mediaInfo.Modified
	--	FROM MMLibraryStatsHistory	mediaInfo
	--UNION
	--	SELECT
	--	1 ,
	--	mediaInfo.NumOfAppendableMedia ,
	--	mediaInfo.Modified
	--	FROM MMLibraryStatsHistory	mediaInfo
	--UNION
	--	SELECT
	--	2 ,
	--	mediaInfo.NumOfSpareMedia ,
	--	mediaInfo.Modified
	--	FROM MMLibraryStatsHistory	mediaInfo
	--UNION
	--	SELECT
	--	4 ,
	--	mediaInfo.NumOfCleaningMedia ,
	--	mediaInfo.Modified
	--	FROM MMLibraryStatsHistory	mediaInfo
	IF ((@respFlag=0)OR (@respFlag=2))
	BEGIN
	SET @mediaUsage =(
			SELECT
			mediaInfoUsage.spareMediaCount AS [@spareMediaCount],
			mediaInfoUsage.usedMediaCount AS [@usedMediaCount],
			mediaInfoUsage.releasedMediaCount AS [@releasedMediaCount],
			dbo.GetUnixTime(mediaInfoUsage.Modified) AS [@asof]
			FROM #tmpTapeMediaUsage	mediaInfoUsage
			WHERE mediaInfoUsage.Modified>=@filterdate
		FOR XML PATH ('mediaUsage'))
	 END
	IF ((@respFlag=0)OR (@respFlag=1))
	BEGIN
	SET @spareMediaCount =(
					SELECT COUNT(*)
						FROM #tmpTapeMediaInfo	mediaInfo
						WHERE mediaInfo.VolumeFlags= 5)
	 END
	SET @TapeLibrarySummaryResp	 =
					(SELECT
						@spareMediaCount AS[@spareMediaCount],
						@tapeMediaSummaryList AS 'summary',
					--	@tapeMediaInfo , no needed now
						@mediaUsage
						FOR XML PATH ('data')
						)
	DROP TABLE #tmpTapeMediaInfo
	DROP TABLE #tmpTapeMediaUsage
	DROP TABLE #tmpLibHistoryperday
	DROP TABLE #tmpLibHistoryday
	DROP TABLE #tmpLibraryHistory
	DbXMLRepTapeLibSummary_End:
	SET @response=( SELECT @TapeLibrarySummaryResp FOR XML PATH ('EVGui_TapeLibrarySummaryResp'))
	SELECT @response
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLRepTapeLibSummary')
	delete from GxQscripts where name = 'DbXMLRepTapeLibSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepTapeLibSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepTapeLibSummary'
GO

insert into GXDBVersions values(2, 'DbXMLRepTapeLibSummary',  '00010013019800030000', 'DbXMLRepTapeLibSummary', '00010013019800030000')
GO

