

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLRepSILOSummary.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DbXMLRepSILOSummary')
BEGIN
	print '>>> Drop Stored Procedure: DbXMLRepSILOSummary <<<'
	drop procedure DbXMLRepSILOSummary
END
IF EXISTS (select * from GxQscripts where name='DbXMLRepSILOSummary')
	delete from GxQscripts where name = 'DbXMLRepSILOSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepSILOSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepSILOSummary'
GO
print '... Creating Procedure: DbXMLRepSILOSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLRepSILOSummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
	SET NOCOUNT ON
	DECLARE @reportXML XML
	SET @reportXML = ''
	DECLARE @SILOSummaryXML XML
	DECLARE @libId INT
	DECLARE @mountpathId INT
	DECLARE @spId INT
	DECLARE @spCopyId INT
	DECLARE @neededStearmDataAlso INT
	DECLARE @respFlag INT
	DECLARE @errmsg NVARCHAR(2000)
	SELECT
			@libId = ISNULL(@request.value('(/EVGui_SILOSummaryReq/@libId)[1]', 'integer'), 0),
			@mountpathId = ISNULL(@request.value('(/EVGui_SILOSummaryReq/@mountpathId)[1]', 'integer'), 0),
			@spId = ISNULL(@request.value('(/EVGui_SILOSummaryReq/@spId)[1]', 'integer'), 0),
			@spCopyId = ISNULL(@request.value('(/EVGui_SILOSummaryReq/@spCopyId)[1]', 'integer'), 0),
			@neededStearmDataAlso = ISNULL(@request.value('(/EVGui_SILOSummaryReq/@neededStearmDataAlso)[1]', 'integer'), 0),
			@respFlag = ISNULL(@request.value('(/EVGui_SILOSummaryReq/@respFlag)[1]', 'integer'), 0)
--	+===============================================+
--	| Library Validation Only Magnetic Lib allowed:							|
--	+===============================================+
DECLARE @SummaryData XML
SET @SummaryData =''
IF(@libId>0)
BEGIN
	DECLARE @Libtype INT
	--SET @libId= 1
	--SET @mountpathId = 1
	SET @Libtype=( SELECT LibraryTypeId FROM MMLibrary WHERE LibraryId = @libId)
IF @Libtype <>  3
	BEGIN
	SET @errmsg = N'DbXMLRepSILOSummary: LibraryID[' + CAST(@libId AS NVARCHAR(12)) + '] is not a Magnetic library'
	RAISERROR(@errmsg, 16, 1)
	GOTO DbXMLRepSILOSummary_End
	END
--	+===============================================+
--	| Media Constant Info:							|
--	+===============================================+
	IF object_id('tempdb.dbo.#tmpMediaSize') is not null DROP TABLE #tmpMediaSize
	CREATE TABLE #tmpMediaSize
	(
		mediaId		int,
		mountPathId	  int,
		MountPathName varchar(255),
		capacity  bigint,
		freeSpace bigint,
		usedSpace bigint
	 )
	INSERT INTO #tmpMediaSize
		SELECT mmm.MediaId ,
		 mmp.MountPathId,GUIView.MountPathName,
		 CASE WHEN GUIView.MountPathTypeId = 7 THEN -1 ELSE SUM(TotalSpaceMB) END,
		 CASE WHEN GUIView.MountPathTypeId = 7 THEN -1 ELSE SUM(FreeBytesMB) END,
		 SUM(TotalSpaceMB)-SUM(FreeBytesMB)
	FROM
		MMMediaSide AS mms
	INNER JOIN
		MMMedia AS mmm
	ON
		mmm.MediaId = mms.MediaId
	INNER JOIN
		MMMountPath AS mmp
	ON
		mmp.MediaSideId = mms.MediaSideId
		and mmm.MediaTypeId = 10001
	INNER JOIN
	MMS2getMountPathNameGUIView as GUIView
	ON
	GUIView.MountPathId = mmp.MountPathId
	WHERE mms.MediaId>0 AND mmm.LibraryId =@libId
	GROUP BY mmm.MediaId, mmp.MountPathId,mmp.MountPathName,mmm.MediaId,GUIView.MountPathName, GUIView.MountPathTypeId
	----------------------------------------------------------------------------------------
	-- Get siloed and to-be-siloed data size for media and put them INTO @tblSilo_All table
	DECLARE @tblSilo_All Table (mediaId int, silo_tobe bigint, silo_done bigint, silo_all bigint)
	insert into @tblSilo_All
	select a.mediaId,
			SUM(CASE WHEN SiloStatus = 1 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END),
			SUM(CASE WHEN SiloStatus in (2, 3) THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END),
			SUM(CASE WHEN SiloStatus in (1, 2, 3) THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END)
	from #tmpMediaSize a, MMVolume b
	where a.MediaId = b.MediaId
	group by a.MediaId
	-- Done getting silo data size
	----------------------------------------------------------------------------------------
	SET @SummaryData =''
	IF ((@respFlag=0)OR (@respFlag=1))
	  BEGIN
	SET @SummaryData =(
			SELECT
			info.silo_tobe AS [@silo_Tobe],
			info.silo_done AS [@silo_Done],
			info.silo_all AS [@silo_All],
			mediainfo.mountPathId  AS 'outentity/@id',
			dbo.NormalizeForXML(mediainfo.mountPathName) AS 'outentity/@name'
		FROM @tblSilo_All AS info
		INNER JOIN #tmpMediaSize mediainfo
		ON
		mediainfo.mediaId = info.mediaId
		FOR XML PATH ('data'))
	 END
		SET @SILOSummaryXML	 =
					(SELECT @SummaryData
						FOR XML PATH ('EVGui_SILOSummaryResp')
						)
	DROP TABLE	#tmpMediaSize
END
ELSE IF(@spId>0)
BEGIN
	----------------------------------------------------------------------------------------
	-- Get siloed and to-be-siloed data size for media and put them INTO @tblSilo_All table
	DECLARE @tblSilo_Allsp Table (copyId int, silo_tobe bigint, silo_done bigint, silo_all bigint)
	DECLARE	@l_DedupeFlags			INT = 0
	DECLARE	@l_Flags				INT = 0
	DECLARE	@l_SourceCopyId			INT = 0
	DECLARE	@l_SiloSource			INT = 0
	SELECT	@l_Flags = flags, @l_SourceCopyId = sourceCopyId
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	id = @spCopyId
	if @l_Flags & 524288 =524288
		set @l_SiloSource = @l_SourceCopyId
	select @l_DedupeFlags = dedupeFlags
	from archGroupCopy with (nolock)
	where id = @l_SourceCopyId
	declare @siloCopyDataInfo table
	(
		NumberOfStores int,
		SizeOfStoreMB bigint,
		SizeOffDiskMB bigint,
		SizeInSiloMB bigint,
		SizeToBeInSiloMB bigint,
		SizeOfApplication bigint,
		SizeOfBackup bigint,
		TotalSizeToBeFreedBytes bigint,
		SizeForBaseline			bigint,
		SizeForApplicationBaseline	bigint,
		DeDupSavingsPercent			varchar(20),
		DiskFreeSpaceMB  			bigint
	)
	insert into @siloCopyDataInfo
	exec MMGetSIDBStoreByCopySUM @l_SiloSource
	insert into @tblSilo_Allsp
	select @spCopyId, SizeToBeInSiloMB, SizeInSiloMB, SizeToBeInSiloMB+SizeInSiloMB
	from @siloCopyDataInfo
	-- Done getting silo data size
	-----------------------------------
	SET @SummaryData =''
	IF ((@respFlag=0)OR (@respFlag=1))
	BEGIN
	SET @SummaryData =(
			SELECT
			info.silo_tobe AS [@silo_Tobe],
			info.silo_done AS [@silo_Done],
			info.silo_all AS [@silo_All],
			info.copyId AS 'outentity/@id',
			dbo.NormalizeForXML(c.name) AS 'outentity/@name'
		FROM @tblSilo_Allsp AS info
		INNER JOIN archGroupCopy c ON
		c.id = info.copyId
		FOR XML PATH ('data'))
	END
	DECLARE @StreamData XML
	SET @StreamData =''
	IF(@neededStearmDataAlso>0)
	BEGIN
		IF object_id('tempdb.dbo.#tempAFPhySize') is not null DROP TABLE #tempAFPhySize
		IF object_id('tempdb.dbo.#tempJobPhySize') is not null DROP TABLE #tempJobPhySize
		IF object_id('tempdb.dbo.#tempJobAppSize') is not null DROP TABLE #tempJobAppSize
		IF object_id('tempdb.dbo.#tempStreamSize') is not null DROP TABLE #tempStreamSize
		CREATE TABLE #tempAFPhySize  ( jobId int, ArchFileId int, commCellId int, archCopyId int, streamNum int, dataWritten bigint, PhysicalSize bigint)
		CREATE TABLE #tempJobPhySize  (jobId int, commCellId int, archCopyId int, streamNum int, dataWritten bigint, PhysicalSize bigint)
		CREATE TABLE #tempJobAppSize  (jobId int, commCellId int, archCopyId int, streamNum int, dataWritten bigint, ApplicationSize bigint)
		CREATE TABLE #tempStreamSize  (archCopyId int, streamNum int, dataWritten bigint, ApplicationSize bigint)
		INSERT INTO #tempAFPhySize
		SELECT	A.jobID, A.id, A.commCellId, b.archCopyId, b.streamNum, b.physicalSize, b.physicalSize
		FROM	archFile a, archFileCopy b
		WHERE	a.id = b.archFileId and a.commCellId = b.commCellId and a.isValid = 1
		AND		( (b.archCopyId = @spCopyId and a.archGroupId = @spId) or (@spCopyId = 0 and a.archGroupId = @spId) or (@spCopyId = 0 and @spId = 0) )
		UPDATE	#tempAFPhySize
		SET		datawritten = a.physicalSize - ISNULL(b.secondaryObjSize, 0) + ISNULL(b.secondaryMetaDataSize, 0) + ISNULL(b.primaryMetaDataSize, 0)
		FROM	#tempAFPhySize a, archFileCopyDedup b
		WHERE	a.ArchFileId = b.archFileId and a.commCellId = b.commCellId
		AND		a.archCopyId = b.archCopyId
		INSERT INTO #tempJobPhySize
		SELECT	A.JobID, A.commCellId, A.archCopyId, A.streamNum, SUM(A.dataWritten), SUM(A.physicalSize)
		FROM	#tempAFPhySize A
		GROUP BY A.JobID, A.commCellId, A.archCopyId, A.streamNum
		INSERT INTO #tempJobAppSize
		SELECT  TJB.jobId, TJB.commCellId, TJB.archCopyId, TJB.streamNum, TJB.dataWritten,
						CASE WHEN JB.totalBackupSize > 0 THEN ((TJB.PhysicalSize * 1.0) / JB.totalBackupSize) * JB.totalUncompBytes ELSE (TJB.PhysicalSize * 1.0) END AS ApplicationSize
		FROM  JMBkpStats JB
		INNER JOIN #tempJobPhySize TJB
		ON JB.jobId = TJB.jobId AND JB.commCellId = TJB.commCellId
		INSERT INTO #tempJobAppSize
		SELECT  TJB.jobId, TJB.commCellId, TJB.archCopyId, TJB.streamNum, TJB.dataWritten,
						CASE WHEN JB.totalBackupSize > 0 THEN ((TJB.PhysicalSize * 1.0) / JB.totalBackupSize) * JB.uncompBytes ELSE (TJB.PhysicalSize * 1.0) END AS ApplicationSize
		FROM  JMAdminJobStatsTable JB
		INNER JOIN #tempJobPhySize TJB
		ON JB.jobId = TJB.jobId AND JB.commCellId = TJB.commCellId
		INSERT INTO #tempStreamSize
		SELECT archcopyid, streamNum, SUM(dataWritten) AS dataWritten, SUM(ApplicationSize) AS ApplicationSize
		FROM #tempJobAppSize
		GROUP BY archcopyid, streamNum
	  IF ((@respFlag=0)OR (@respFlag=2))
	  BEGIN
		SET @StreamData =(
				SELECT
					info.streamNum AS [@streamNo],
					info.ApplicationSize AS [@applicationSize],
					info.dataWritten AS [@dataWritten],
					info.archCopyId AS 'spCopy/@id',
					dbo.NormalizeForXML(c.name) AS 'spCopy/@name'
				FROM #tempStreamSize info
				INNER JOIN archGroupCopy c ON
				c.id = info.archCopyId
				AND info.streamNum>0
				FOR XML PATH ('streamsData'))
		END
		DROP TABLE #tempJobPhySize
		DROP TABLE #tempJobAppSize
		DROP TABLE #tempStreamSize
	END
		SET @SILOSummaryXML	 =
					(SELECT @SummaryData,
							 @StreamData
						FOR XML PATH ('EVGui_SILOSummaryResp')
						)
END
ELSE
BEGIN
	SET @errmsg = N'DbXMLRepSILOSummary: LibraryID[' + CAST(@libId AS NVARCHAR(12)) + '] and StoragePolicyId[' + CAST(@spId AS NVARCHAR(12)) + ']  both are failed during validation'
	RAISERROR(@errmsg, 16, 1)
	GOTO DbXMLRepSILOSummary_End
END
	DbXMLRepSILOSummary_End:
	SELECT @SILOSummaryXML AS [response]
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLRepSILOSummary')
	delete from GxQscripts where name = 'DbXMLRepSILOSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepSILOSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepSILOSummary'
GO

insert into GXDBVersions values(2, 'DbXMLRepSILOSummary',  '00010019007200030000', 'DbXMLRepSILOSummary', '00010019007200030000')
GO

