

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLRepMagneticLibSummary.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DbXMLRepMagneticLibSummary')
BEGIN
	print '>>> Drop Stored Procedure: DbXMLRepMagneticLibSummary <<<'
	drop procedure DbXMLRepMagneticLibSummary
END
IF EXISTS (select * from GxQscripts where name='DbXMLRepMagneticLibSummary')
	delete from GxQscripts where name = 'DbXMLRepMagneticLibSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepMagneticLibSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepMagneticLibSummary'
GO
print '... Creating Procedure: DbXMLRepMagneticLibSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLRepMagneticLibSummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response XML
SET NOCOUNT ON
DECLARE @reportType INT
DECLARE @libId INT
DECLARE @mountpathId INT
DECLARE @appTypeId INT
DECLARE @clientId INT
DECLARE @respFlag INT
DECLARE @topN INT
DECLARE @spCopyId INT
DECLARE @errmsg NVARCHAR(256)
SELECT
	@reportType 	= @request.value('(/EVGui_LibrarySummaryReq/@reportType)[1]', 'integer'),
	@libId 		= ISNULL(@request.value('(/EVGui_LibrarySummaryReq/@libId)[1]', 'integer'), 0),
	@mountpathId 	= ISNULL(@request.value('(/EVGui_LibrarySummaryReq/@mountpathId)[1]', 'integer'), 0),
	@appTypeId 	= ISNULL(@request.value('(/EVGui_LibrarySummaryReq/@appId)[1]', 'integer'), 0),
	@clientId 	= ISNULL(@request.value('(/EVGui_LibrarySummaryReq/@clientId)[1]', 'integer'), 0),
	@respFlag 	= ISNULL(@request.value('(/EVGui_LibrarySummaryReq/@respFlag)[1]', 'integer'), 0),
	@topN 		= ISNULL(@request.value('(/EVGui_LibrarySummaryReq/@nTopN)[1]', 'integer'), 10),
	@spCopyId 	= ISNULL(@request.value('(/EVGui_LibrarySummaryReq/@spCopyId)[1]', 'integer'), 0)
DECLARE @LibrarySummaryData XML = ''
DECLARE @LibrarySummarySP XML = ''
DECLARE @LibrarySummaryResp XML = ''
-----------------------------------------------------------------------------------------------
-- ALLOW FOR FACT THAT FOR SOME REPORT TYPES WE ARE GOING TO ALLOW "ALL LIBRARIES" SELECTION --
-----------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#MagLibraries') IS NOT NULL DROP TABLE #MagLibraries
CREATE TABLE #MagLibraries (libraryId  INT)
IF @libId <> 0
BEGIN
IF NOT EXISTS (SELECT LibraryId FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = @libId AND LibraryTypeId = 3)
		BEGIN
			SET @errmsg = N'DbXMLRepMagneticLibSummary: LibraryID[' + CAST(@libId AS NVARCHAR(12)) + '] is not a Magnetic library'
			RAISERROR(@errmsg, 16, 1)
			GOTO DbXMLRepMagneticLibSummary_End
		END
   INSERT #MagLibraries VALUES (@libId)
END
ELSE
   INSERT #MagLibraries
		SELECT LibraryId from MMLibrary WITH (NOLOCK) where LibraryTypeId = 3 -- DO WE ALSO WANT TO CHECK OTHER STATUS FOR LIBS BEFORE ADDING?
---------------------------------------------------------------------------------------------------
DECLARE @getDistByDataWritten BIT = (CASE WHEN (@respFlag = 0) OR (@respFlag = 1) THEN 1 ELSE 0 END)
DECLARE @getDistByCopies BIT = (CASE WHEN (@respFlag = 0) OR (@respFlag = 2) THEN 1 ELSE 0 END)
IF object_id('tempdb.dbo.#tmpMedia') IS NOT NULL DROP TABLE #tmpMedia
CREATE TABLE #tmpMedia
(
	libraryId	INT,		-- MR 233188 - SKatz
	mountPathId	INT,
	mountPathName 	VARCHAR(255),
	PRIMARY KEY (mountPathId)
)
INSERT INTO #tmpMedia (libraryId, mountpathId) 	-- MR 233188 - SKatz
	SELECT 	MP.libraryId,
		    MountPathId
	FROM 	MMMountPath MP
	INNER JOIN #MagLibraries ML ON ML.libraryId = MP.libraryId
WHERE	MountPathName NOT LIKE 'CVDiskFolder' --"CVDiskFolder"
		AND (@mountpathId = 0 OR MountPathId = @mountpathId)
IF(@getDistByDataWritten = 1)
BEGIN
	UPDATE 	#tmpMedia
	SET	mountPathName = GUIView.MountPathName
	FROM	MMS2getMountPathNameGUIView GUIView WITH (NOLOCK)
	WHERE	GUIView.MountPathId = #tmpMedia.mountPathId
END
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
CREATE	TABLE #tempChunk
(
	mountPathId	INT,
	id		BIGINT,
	commCellId	INT,
	PRIMARY KEY(id, commCellId)
)
INSERT INTO #tempChunk
	SELECT	T.mountPathId, AC.id, AC.commCellId--, AC.physicalSize
	FROM	archChunk AC WITH (NOLOCK)
		INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.volumeId
		INNER JOIN #tmpMedia T ON V.CurrMountPathId = T.mountPathId
IF object_id('tempdb.dbo.#tempDataSizes') IS NOT NULL DROP TABLE #tempDataSizes
CREATE TABLE #tempDataSizes
(
	--physicalSize	BIGINT,
	dedupedSize	BIGINT,
	unCompSize	BIGINT,
	numJobs		INT,
	libraryId	INT,
	mountPathId	INT,
	archCopyId	INT,
	clientId	INT,
	appId		INT,
	appTypeId	INT,
	numClients	INT,
	numApps		INT
)
IF (@getDistByDataWritten = 1 AND @getDistByCopies = 1) --is this a used case
BEGIN
	CREATE CLUSTERED INDEX tempDataSize_mp_idx ON #tempDataSizes(mountPathId)
	CREATE NONCLUSTERED INDEX tempDataSize_copy_idx ON #tempDataSizes(archCopyId)
END
ELSE IF(@getDistByDataWritten = 1)
BEGIN
	CREATE CLUSTERED INDEX tempDataSize_mp_idx ON #tempDataSizes(mountPathId)
END
ELSE
BEGIN
	CREATE CLUSTERED INDEX tempDataSize_copy_idx ON #tempDataSizes(archCopyId)
END
IF (@reportType = 0)-- LibrarySummaryReport_MOUNTPATH will list all mount paths
BEGIN
	IF (@getDistByDataWritten = 1)
	BEGIN
		IF object_id('tempdb.dbo.#tmpMediaInfo') IS NOT NULL DROP TABLE #tmpMediaInfo
		CREATE TABLE #tmpMediaInfo
		(
			mountPathId	INT,
			mediaId		INT,
			capacity  	BIGINT,
			freeSpace 	BIGINT,
			sizeOnMedia 	BIGINT,
			PRIMARY KEY (mountPathId)
		)
		INSERT INTO #tmpMediaInfo
			SELECT  MP.MountPathId, M.MediaId ,
SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576) THEN -1 ELSE CAST(MS.TotalSpaceMB AS BIGINT)  END), --MOUNT_PATH_EXTERNAL_REMOTE_HOST=7
SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.FreeBytesMB = 1048576) THEN -1 ELSE CAST(MS.FreeBytesMB AS BIGINT) END),
				0
			FROM	MMMountPath MP WITH (NOLOCK)
				INNER JOIN MMMediaSide MS WITH (NOLOCK) ON MP.MediaSideId = MS.MediaSideId
				INNER JOIN MMMedia M WITH (NOLOCK) ON MS.MediaId = M.MediaId
				INNER JOIN #tmpMedia TMED ON MP.MountPathId = TMED.mountpathId
			GROUP BY MP.MountPathId, M.MediaId
		UPDATE 	#tmpMediaInfo
		SET 	sizeOnMedia = UsedSpaceInBytes / (1024 * 1024)
		FROM	MMMetallicStorage MS WITH(READUNCOMMITTED)
		WHERE	#tmpMediaInfo.mountPathId = MS.MountPathId
		UPDATE 	#tmpMediaInfo
		SET 	sizeOnMedia = (SELECT	SUM(CAST(PhysicalBytesMB AS BIGINT))
					FROM	MMVolume V WITH (NOLOCK)
					WHERE	SiloStatus <> 3
						AND V.MediaId = #tmpMediaInfo.mediaId)
		WHERE	sizeOnMedia = 0
		INSERT	INTO #tempDataSizes(mountPathId, dedupedSize, unCompSize, numJobs)
			SELECT	TC.mountPathId, SUM(ACM.dedupedSize), SUM(ACM.unCompSize), COUNT(DISTINCT JDS.jobId)
			FROM	#tempChunk TC
				INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archChunkId = TC.id AND ACM.chunkCommCellId = TC.commCellId
				INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON ACM.jobId = JDS.jobId AND ACM.archCopyId = JDS.archGrpCopyId AND AF.fileType = JDS.dataType AND ACM.commcellId = JDS.commcellId
			WHERE JDS.status = 100 -- READY = 100,  --For BACKUP/AUXCOPY data: Data are successfully backuped/copied. And still retained
			GROUP BY TC.mountPathId
		SET @LibrarySummaryData =
		(
			SELECT 	0			AS [@clientsCount],-- do we need this info here?
				TDATA.numJobs 		AS [@jobsCount],
				TDATA.dedupedSize  	AS [@backedupDataSize],
				TDATA.unCompSize  	AS [@applicationDataSize],
				TMINFO.capacity 	AS [@capacity],
				TMINFO.freeSpace 	AS [@freeSpace],
				TDATA.dedupedSize 	AS [@usedSpace],
				TMINFO.sizeOnMedia 	AS [@sizeOnMedia],
				TMED.mountPathId  	AS 'mountpath/@id',
				dbo.NormalizeForXML(TMED.mountPathName) AS 'mountpath/@name'
			FROM 	#tempDataSizes TDATA
				INNER JOIN #tmpMedia TMED ON TMED.mountPathId = TDATA.mountPathId
				INNER JOIN #tmpMediaInfo TMINFO ON TMINFO.mountPathId = TDATA.mountPathId
			FOR XML PATH ('data')
		)
	END
END
IF (@reportType = 6)-- LibrarySummaryReport_SP_COPY will list all copies
BEGIN
	IF (@getDistByCopies = 1)
	BEGIN
		INSERT INTO #tempDataSizes(archcopyId, dedupedSize, unCompSize, numJobs)
			SELECT TOP (@topN)
				ACM.archCopyId, SUM(ACM.dedupedSize), SUM(ACM.unCompSize), COUNT(DISTINCT JDS.jobId)
			FROM	#tempChunk TC
				INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archChunkId = TC.id AND ACM.chunkCommCellId = TC.commCellId
				INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON ACM.jobId = JDS.jobId AND ACM.archCopyId = JDS.archGrpCopyId AND AF.fileType = JDS.dataType AND ACM.commcellId = JDS.commcellId
			WHERE JDS.status = 100 --READY = 100
			GROUP BY ACM.archCopyId
			ORDER BY SUM(ACM.dedupedSize) DESC
		SET @LibrarySummarySP =
		(
			SELECT	0 			AS [@clientsCount],
				TDATA.numJobs 		AS [@jobsCount],
				TDATA.dedupedSize  	AS [@backedupDataSize],
				TDATA.unCompSize  	AS [@applicationDataSize],
				AG.id  			AS 'archGroup/@id',
				dbo.NormalizeForXML(AG.name)  AS 'archGroup/@name',
				AGC.id  		AS 'archGroupCopy/@id',
				dbo.NormalizeForXML(AGC.name) AS 'archGroupCopy/@name'
			FROM 	#tempDataSizes TDATA
				INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON TDATA.archCopyId = AGC.id
				INNER JOIN archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
			FOR XML PATH ('spData')
		)
	END
END
-- LibrarySummaryReport_SP_COPY will list all copies and Aggregate at the Library Level (SK)
--   essentially same as reportType=6 but includes library info
IF (@reportType = 7)
BEGIN
	IF (@getDistByCopies = 1)
	BEGIN
		INSERT INTO #tempDataSizes(archcopyId, dedupedSize, unCompSize, numJobs, libraryId)
			SELECT TOP (@topN)
				ACM.archCopyId, SUM(ACM.dedupedSize), SUM(ACM.unCompSize), COUNT(DISTINCT JDS.jobId), TM.libraryId
			FROM	#tempChunk TC
				INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archChunkId = TC.id AND ACM.chunkCommCellId = TC.commCellId
				INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON ACM.jobId = JDS.jobId AND ACM.archCopyId = JDS.archGrpCopyId AND AF.fileType = JDS.dataType AND ACM.commcellId = JDS.commcellId
				INNER JOIN #tmpMedia TM   ON TM.mountPathId = TC.mountPathId
			WHERE JDS.status = 100 --READY = 100
			GROUP BY ACM.archCopyId, TM.libraryId
			ORDER BY SUM(ACM.dedupedSize) DESC
		SET @LibrarySummarySP =
		(
			SELECT	0 								AS [@clientsCount],
				TDATA.numJobs 						AS [@jobsCount],
				TDATA.dedupedSize  					AS [@backedupDataSize],
				TDATA.unCompSize  					AS [@applicationDataSize],
				AG.id  								AS 'archGroup/@id',
				dbo.NormalizeForXML(AG.name)		AS 'archGroup/@name',
				AGC.id  							AS 'archGroupCopy/@id',
				dbo.NormalizeForXML(AGC.name)		AS 'archGroupCopy/@name',
				TDATA.libraryId 					AS 'library/@id',
				dbo.NormalizeForXML(ML.LibraryName)	AS 'library/@name'
			FROM 	#tempDataSizes TDATA
				INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON TDATA.archCopyId = AGC.id
				INNER JOIN archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
				INNER JOIN MMLibrary ML WITH (NOLOCK) ON TDATA.libraryId = ML.LibraryId
			FOR XML PATH ('spData')
		)
	END
END
IF (@reportType = 1)-- LibrarySummaryReport_APPTYPE will list all apptypes for a selected mountpath/copy
BEGIN
	INSERT INTO #tempDataSizes(dedupedSize, unCompSize, numJobs, appTypeId, numClients)
		SELECT 	SUM(ACM.dedupedSize), SUM(ACM.unCompSize), COUNT(DISTINCT JDS.jobId), APP.appTypeId, COUNT(DISTINCT APP.clientId)
		FROM	#tempChunk TC
			INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archChunkId = TC.id AND ACM.chunkCommCellId = TC.commCellId
			INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId
			INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON ACM.jobId = JDS.jobId AND ACM.archCopyId = JDS.archGrpCopyId AND AF.fileType = JDS.dataType AND ACM.commcellId = JDS.commcellId
			INNER JOIN APP_Application APP WITH (NOLOCK) ON JDS.appId = APP.id
		WHERE 	JDS.status = 100 --READY = 100
			AND (@spCopyId = 0 OR ACM.archCopyId = @spCopyId)
		GROUP BY APP.appTypeId
	IF (@getDistByDataWritten = 1)
	BEGIN
		SET @LibrarySummaryData =
		(
			SELECT	TDATA.numClients	AS [@clientsCount],
				TDATA.numJobs 		AS [@jobsCount],
				TDATA.dedupedSize	AS [@backedupDataSize],
				TDATA.unCompSize	AS [@applicationDataSize],
				TMED.mountPathId	AS 'mountpath/@id',
				dbo.NormalizeForXML(TMED.mountPathName) AS 'mountpath/@name',
				IDA.type 		AS 'appType/@id',
				dbo.NormalizeForXML(IDA.name) AS 'appType/@name'
			FROM 	#tempDataSizes TDATA
				INNER JOIN #tmpMedia TMED ON TMED.mountPathId = @mountPathId
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = TDATA.appTypeId
		  	FOR XML PATH ('data')
		)
	END
	IF (@getDistByCopies = 1)
	BEGIN
		SET @LibrarySummarySP =
		(
			SELECT	TDATA.numClients	AS [@clientsCount],
				TDATA.numJobs 		AS [@jobsCount],
				TDATA.dedupedSize 	AS [@backedupDataSize],
				TDATA.unCompSize	AS [@applicationDataSize],
				AG.id			AS 'archGroup/@id',
				dbo.NormalizeForXML(AG.name)  AS 'archGroup/@name',
				AGC.id 			AS 'archGroupCopy/@id',
				dbo.NormalizeForXML(AGC.name) AS 'archGroupCopy/@name',
				IDA.type 		AS 'appType/@id',
				dbo.NormalizeForXML(IDA.name) AS 'appType/@name'
			FROM	#tempDataSizes TDATA
				INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = @spCopyId
				INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = AGC.archGroupId
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = TDATA.appTypeId
			FOR XML PATH ('spData')
		)
	END
END
IF (@reportType = 2)-- LibrarySummaryReport_APPTYPE will list all clients for a selected apptype on a selected mountpath/copy
BEGIN
	INSERT INTO #tempDataSizes(dedupedSize, unCompSize, numJobs, clientId, numApps)
		SELECT 	SUM(ACM.dedupedSize), SUM(ACM.unCompSize), COUNT(DISTINCT JDS.jobId), APP.clientId, COUNT(DISTINCT APP.id)
		FROM	#tempChunk TC
			INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archChunkId = TC.id AND ACM.chunkCommCellId = TC.commCellId
			INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId
			INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON ACM.jobId = JDS.jobId AND ACM.archCopyId = JDS.archGrpCopyId AND AF.fileType = JDS.dataType AND ACM.commcellId = JDS.commcellId
			INNER JOIN APP_Application APP WITH (NOLOCK) ON JDS.appId = APP.id
		WHERE 	JDS.status = 100 --READY = 100
			AND (@spCopyId = 0 OR ACM.archCopyId = @spCopyId)
			AND APP.appTypeId = @appTypeId
		GROUP BY APP.clientId
	IF (@getDistByDataWritten = 1)
	BEGIN
		SET @LibrarySummaryData =
		(
			SELECT	TDATA.numApps		AS [@clientsCount],--it is subclient count
				TDATA.numJobs 		AS [@jobsCount],
				TDATA.dedupedSize	AS [@backedupDataSize],
				TDATA.unCompSize	AS [@applicationDataSize],
				TMED.mountPathId	AS 'mountpath/@id',
				dbo.NormalizeForXML(TMED.mountPathName) AS 'mountpath/@name',
				IDA.type 		AS 'appType/@id',
				dbo.NormalizeForXML(IDA.name) AS 'appType/@name',
				CL.id 			AS 'client/@id',
				dbo.NormalizeForXML(CL.name) AS 'client/@name'
			FROM 	#tempDataSizes TDATA
				INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = TDATA.clientId
				INNER JOIN #tmpMedia TMED ON TMED.mountPathId = @mountPathId
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = @appTypeId
		  	FOR XML PATH ('data')
		)
	END
	IF (@getDistByCopies = 1)
	BEGIN
		SET @LibrarySummarySP =
		(
			SELECT	TDATA.numApps		AS [@clientsCount],--it is subclient count
				TDATA.numJobs 		AS [@jobsCount],
				TDATA.dedupedSize 	AS [@backedupDataSize],
				TDATA.unCompSize	AS [@applicationDataSize],
				AG.id			AS 'archGroup/@id',
				dbo.NormalizeForXML(AG.name)  AS 'archGroup/@name',
				AGC.id 			AS 'archGroupCopy/@id',
				dbo.NormalizeForXML(AGC.name) AS 'archGroupCopy/@name',
				IDA.type 		AS 'appType/@id',
				dbo.NormalizeForXML(IDA.name) AS 'appType/@name',
				CL.id 			AS 'client/@id',
				dbo.NormalizeForXML(CL.name) AS 'client/@name'
			FROM 	#tempDataSizes TDATA
				INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = TDATA.clientId
				INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = @spCopyId
				INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = AGC.archGroupId
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = @appTypeId
			FOR XML PATH ('spData')
		)
	END
END
IF (@reportType = 3)-- LibrarySummaryReport_SUBCLIENT list all sublclients for a selected client, apptype, mountpath/copy
BEGIN
	INSERT INTO #tempDataSizes(dedupedSize, unCompSize, numJobs, appId)
			SELECT 	SUM(ACM.dedupedSize), SUM(ACM.unCompSize), COUNT(DISTINCT JDS.jobId), APP.id
			FROM	#tempChunk TC
				INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archChunkId = TC.id AND ACM.chunkCommCellId = TC.commCellId
				INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON ACM.jobId = JDS.jobId AND ACM.archCopyId = JDS.archGrpCopyId AND AF.fileType = JDS.dataType AND ACM.commcellId = JDS.commcellId
				INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = JDS.appId
			WHERE	JDS.status = 100 --READY = 100
				AND (@spCopyId = 0 OR ACM.archCopyId = @spCopyId)
				AND APP.appTypeId = @appTypeId AND APP.clientId = @clientId
			GROUP BY APP.id
	IF (@getDistByDataWritten = 1)
	BEGIN
		SET @LibrarySummaryData =
		(
			SELECT	TDATA.numJobs 		AS [@jobsCount],
				TDATA.dedupedSize 	AS [@backedupDataSize],
				TDATA.unCompSize 	AS [@applicationDataSize],
				TMED.mountPathId  	AS 'mountpath/@id',
				dbo.NormalizeForXML(TMED.mountPathName) AS 'mountpath/@name',
				IDA.type 	AS 'appType/@id',
				dbo.NormalizeForXML(IDA.name) AS 'appType/@name',
				INS.id 		AS 'instance/@id',
				dbo.NormalizeForXML(INS.name) AS 'instance/@name',
				CL.id 		AS 'client/@id',
				dbo.NormalizeForXML(CL.name)  AS 'client/@name',
				BSN.id 		AS 'backupSet/@id',
				dbo.NormalizeForXML(BSN.name) AS 'backupSet/@name',
				APP.id 		AS 'subclient/@id',
				dbo.NormalizeForXML(APP.subclientName) AS 'subclient/@name'
			FROM	#tempDataSizes TDATA
				INNER JOIN APP_Application APP WITH (NOLOCK) ON TDATA.appId = APP.id
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON APP.appTypeId = IDA.type
				INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON APP.instance = INS.id
				INNER JOIN APP_BackupSetName BSN WITH (NOLOCK) ON APP.backupSet = BSN.id
				INNER JOIN APP_Client CL WITH (NOLOCK) ON APP.clientId = CL.id
				INNER JOIN #tmpMedia TMED ON TMED.mountPathId = @mountPathId
			FOR XML PATH ('data')
		)
	END
	IF (@getDistByCopies = 1)
	BEGIN
		SET @LibrarySummarySP =
		(
			SELECT TOP (@topN)
				TDATA.numJobs 	  AS [@jobsCount],
				TDATA.dedupedSize AS [@backedupDataSize],
				TDATA.unCompSize  AS [@applicationDataSize],
				AG.id  	AS 'archGroup/@id',
				dbo.NormalizeForXML(AG.name)  AS 'archGroup/@name',
				AGC.id  AS 'archGroupCopy/@id',
				dbo.NormalizeForXML(AGC.name) AS 'archGroupCopy/@name',
				IDA.type AS 'appType/@id',
				dbo.NormalizeForXML(IDA.name) AS 'appType/@name',
				INS.id 	AS  'instance/@id',
				dbo.NormalizeForXML(INS.name) AS 'instance/@name',
				CL.id 	AS 'client/@id',
				dbo.NormalizeForXML(CL.name)  AS 'client/@name',
				BSN.id 	AS 'backupSet/@id',
				dbo.NormalizeForXML(BSN.name) AS 'backupSet/@name',
				APP.id 	AS 'subclient/@id',
				dbo.NormalizeForXML(APP.subclientName) AS 'subclient/@name'
			FROM	#tempDataSizes TDATA
				INNER JOIN APP_Application APP WITH (NOLOCK) ON TDATA.appId = APP.id
				INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON APP.appTypeId = IDA.type
				INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON APP.instance = INS.id
				INNER JOIN APP_BackupSetName BSN WITH (NOLOCK) ON APP.backupSet = BSN.id
				INNER JOIN APP_Client CL WITH (NOLOCK) ON APP.clientId = CL.id
				INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = @spCopyId
				INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = AGC.archGroupId
			ORDER BY TDATA.dedupedSize
			FOR XML PATH ('spData')
		)
	END
END
SET @LibrarySummaryResp	 = ( SELECT @LibrarySummaryData, @LibrarySummarySP
				FOR XML PATH ('EVGui_LibrarySummaryResp'))
DROP TABLE	#tempChunk
DROP TABLE	#tempDataSizes
DROP TABLE	#tmpMedia
IF object_id('tempdb.dbo.#MagLibraries') IS NOT NULL DROP TABLE #MagLibraries
DbXMLRepMagneticLibSummary_End:
SELECT @LibrarySummaryResp AS [response]
SET NOCOUNT OFF
/*  FOR STANDALONE TESTING:
DECLARE @inXML XML='<EVGui_LibrarySummaryReq appId="0" clientId="0" libId="8" mediaId="0" mountpathId="0" nTopN="10" reportType="7" respFlag="2" spCopyId="0" spId="0"/>'
DECLARE @outTblXml TABLE (oXML xml)
INSERT @outTblXml
	EXEC DbXMLRepMagneticLibSummary @inXML
DECLARE @oXML XML = (SELECT top 1 oXML from @outTblXml)
SELECT @oXML
SELECT
		 LData.value ('library[1]/@id',			'INT')				as libId
		,LData.value ('library[1]/@name',		'NVARCHAR(256)')	as libName
		,LData.value ('archGroup[1]/@id',		'INT')				as archGroupId
		,LData.value ('archGroup[1]/@name',		'NVARCHAR(256)')	as archGroupName
		,LData.value ('archGroupCopy[1]/@name',	'NVARCHAR(256)')	as archGroupName
		,LData.value ('@jobsCount',				'INT')				as jobsCount
		,LData.value ('@backedupDataSize',		'BIGINT')			as backedupDataSize
		,LData.value ('@applicationDataSize',	'BIGINT')			as applicationDataSize
 --     ,LData.query('.')
FROM
	  @oXML.nodes('/EVGui_LibrarySummaryResp/spData') AS Ref(LData)
*/
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLRepMagneticLibSummary')
	delete from GxQscripts where name = 'DbXMLRepMagneticLibSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepMagneticLibSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepMagneticLibSummary'
GO

insert into GXDBVersions values(2, 'DbXMLRepMagneticLibSummary',  '00010036004800090000', 'DbXMLRepMagneticLibSummary', '00010036004800090000')
GO

