

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLRepMagneticLibJobsSummary.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DbXMLRepMagneticLibJobsSummary <<<'

IF EXISTS (select * from sysobjects where name='DbXMLRepMagneticLibJobsSummary')
	drop procedure DbXMLRepMagneticLibJobsSummary
IF EXISTS (select * from GxQscripts where name='DbXMLRepMagneticLibJobsSummary')
	delete from GxQscripts where name = 'DbXMLRepMagneticLibJobsSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepMagneticLibJobsSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepMagneticLibJobsSummary'
GO
print '... Creating Procedure: DbXMLRepMagneticLibJobsSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLRepMagneticLibJobsSummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
	SET NOCOUNT ON
	DECLARE @reportXML XML
	SET @reportXML = ''
	DECLARE @LibrarySummaryXML XML
	DECLARE @reportType INT
	DECLARE @libId INT
	DECLARE @mountpathId INT
	DECLARE @appTypeId INT
	DECLARE @clientId INT
	DECLARE @nLastdays INT = 7
	DECLARE @errmsg NVARCHAR(2000)
	SELECT
			@reportType = @request.value('(/EVGui_LibrarySummaryJobsReq/@reportType)[1]', 'integer'),
			@libId = ISNULL(@request.value('(/EVGui_LibrarySummaryJobsReq/@libId)[1]', 'integer'), 0),
			@mountpathId = ISNULL(@request.value('(/EVGui_LibrarySummaryJobsReq/@mountpathId)[1]', 'integer'), 0),
			@appTypeId = ISNULL(@request.value('(/EVGui_LibrarySummaryJobsReq/@appId)[1]', 'integer'), 0),
			@clientId = ISNULL(@request.value('(/EVGui_LibrarySummaryJobsReq/@clientId)[1]', 'integer'), 0),
			@nLastdays =ISNULL(@request.value('(/EVGui_LibrarySummaryJobsReq/@nLastdays)[1]', 'integer'), 7)
--	+===============================================+
--	| Library Validation Only Magnetic Lib allowed:							|
--	+===============================================+
DECLARE @filterdate DATE = GETDATE()-@nLastdays
DECLARE @Libtype INT
SET @Libtype=( SELECT LibraryTypeId FROM MMLibrary WHERE LibraryId = @libId)
	DECLARE @LibrarySummaryData XML
	SET @LibrarySummaryData =''
	DECLARE @LibrarySummaryJobData XML
	SET @LibrarySummaryJobData =''
	DECLARE @LibrarySummaryJobsResp XML
	SET @LibrarySummaryJobsResp =''
IF @Libtype <>  3
BEGIN
SET @errmsg = N'DbXMLRepMagneticLibSummary: LibraryID[' + CAST(@libId AS NVARCHAR(12)) + '] is not a Magnetic library'
RAISERROR(@errmsg, 16, 1)
GOTO DbXMLRepMagneticLibSummary_End
END
--	+===============================================+
--	| Media Job Info:							|
--	+===============================================+
		IF object_id('tempdb.dbo.#tmpMediadata') is not null DROP TABLE #tmpMediadata
	CREATE TABLE #tmpMediadata
	(
		mediaId			int,
		jobId			int,
		jobStatus		int,
		backedupDataSize bigint,
		applicationDataSize bigint,
		clientId integer,
		clientName varchar(255),
		appTypeId integer,
		appTypeName varchar(255),
		instanceId integer,
		instanceName varchar(255),
		backupSetId integer,
		backupSetName varchar(255),
		appId integer,
		subclientName Nvarchar(255),
		archGroupId integer,
		archGroupName NVARCHAR(255)
		--,
		--dedupRatio varchar(255),
		--dedupSavings varchar(255)
	 )
--	+===============================================+
--	| Media Constant Info:							|
--	+===============================================+
		IF object_id('tempdb.dbo.#tmpMediaSize') is not null DROP TABLE #tmpMediaSize
	CREATE TABLE #tmpMediaSize
	(
		mediaId		int,
		mountPathId	  int,
		MountPathName varchar(255),
		capacity  bigint,
		freeSpace bigint,
		usedSpace bigint
	 )
--	+===============================================+
--	| NOW LOOP FOR ALL THE ENTRIES IN THE TABLE:	|
--	+===============================================+
	DECLARE @MediaId int;
	DECLARE	loopCursor CURSOR  FOR
	SELECT DISTINCT MediaId from MMMedia where LibraryId = @libId
	OPEN loopCursor
	FETCH NEXT from loopCursor INTO @MediaId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF object_id('tempdb.dbo.#tmpAggrMedia') is not null DROP TABLE #tmpAggrMedia
create table #tmpAggrMedia
(
	jobId			int,
	backupLevel		int,
	fullCycleNum	int,
	cycleSeqNum		int,
	jobStartTime	int,
	jobStatus		int,
	jobDataStatus	int,
	jobDataFlags	int,
	retentionDays integer,
	pinJobEndTime bigint,
	archFileId integer,
archFileName nvarchar(2048),
	archFileType integer,
	archFileCreateTime integer,
	isValidData integer,
	sizeOnMedia bigint,
	sizeOfBackup bigint,
	mediaSideId integer,
	clientId integer,
	clientName varchar(255),
	appTypeId integer,
	appTypeName varchar(255),
	instanceId integer,
	instanceName varchar(255),
	backupSetId integer,
	backupSetName varchar(255),
	appId integer,
	subclientName Nvarchar(255),
	archGroupId integer,
	archGroupName NVARCHAR(255),
	copyId integer,
	copyName NVARCHAR(255),
	mediaSideName varchar(255),
	applicationSize	bigint
	 )
INSERT INTO #tmpAggrMedia exec GetMediaContents @MediaId
-- DISTRIBUTION BY NO TYPE
 INSERT INTO #tmpMediadata
		SELECT @mediaId,
			jobId,jobStatus,
			SUM(sizeOnMedia),-1,
			clientId , clientName,
			appTypeId ,appTypeName,
			instanceId,instanceName,
			backupSetId, backupSetName,
			appId, subclientName,
			archGroupId,archGroupName
		FROM #tmpAggrMedia
			WHERE jobid>0
			AND jobStartTime>=dbo.GetUnixTime(@filterdate)
		GROUP BY
			jobId,jobStatus,
			clientId , clientName,
			appTypeId ,appTypeName,
			instanceId,instanceName,
			backupSetId, backupSetName,
			appId, subclientName,
			archGroupId,archGroupName
UPDATE #tmpMediadata
 SET applicationDataSize = JMBkpStats.totalUncompBytes
FROM #tmpMediadata
INNER JOIN JMBkpStats ON #tmpMediadata.jobId = JMBkpStats.jobId
DROP TABLE  #tmpAggrMedia
NEXT_ROW:
			FETCH NEXT from loopCursor INTO @MediaId
END
IF ( CURSOR_STATUS('global', 'loopCursor') >= 0 	OR CURSOR_STATUS('local', 'loopCursor') >= 0 )
BEGIN
	CLOSE		loopCursor
	DEALLOCATE	loopCursor
END
INSERT INTO #tmpMediaSize
	SELECT mmm.MediaId ,
		 mmp.MountPathId,GUIView.MountPathName,
		 SUM(TotalSpaceMB),SUM(FreeBytesMB),
		 SUM(TotalSpaceMB)-SUM(FreeBytesMB)
	FROM
		MMMediaSide AS mms
	INNER JOIN
		MMMedia AS mmm
	ON
		mmm.MediaId = mms.MediaId
	INNER JOIN
		MMMountPath AS mmp
	ON
		mmp.MediaSideId = mms.MediaSideId
		and mmm.MediaTypeId = 10001
	INNER JOIN
	MMS2getMountPathNameGUIView as GUIView
	ON
	GUIView.MountPathId = mmp.MountPathId
	WHERE mms.MediaId>0 AND mmm.LibraryId =@libId
	GROUP BY mmp.MountPathId,mmp.MountPathName,mmm.MediaId,GUIView.MountPathName
	IF object_id('tempdb.dbo.#tmpMediaInfo') is not null DROP TABLE #tmpMediaInfo
	CREATE TABLE #tmpMediaInfo
	(
		mediaId		int,
		mountPathId	  int,
		mountPathName varchar(255),
		capacity  bigint ,
		freeSpace bigint,
		usedSpace bigint,
		backedupDataSize bigint,
		applicationDataSize bigint,
		clientId integer,
		clientName varchar(255),
		appTypeId integer,
		appTypeName varchar(255),
		instanceId integer,
		instanceName varchar(255),
		backupSetId integer,
		backupSetName varchar(255),
		appId integer,
		subclientName Nvarchar(255),
		archGroupId integer,
		archGroupName NVARCHAR(255),
		jobsCount			int
		--,
		--dedupRatio varchar(255),
		--dedupSavings varchar(255)
	 )
	 INSERT INTO #tmpMediaInfo
		SELECT
			mddata.mediaId,
			mediasize.mountPathId,
			mediasize.MountPathName,
			mediasize.capacity*1024*1024,
			mediasize.freeSpace*1024*1024,
			mediasize.usedSpace*1024*1024,
			SUM(mddata.backedupDataSize),SUM(mddata.applicationDataSize),
			mddata.clientId , mddata.clientName,
			mddata.appTypeId ,mddata.appTypeName,
			mddata.instanceId,mddata.instanceName,
			mddata.backupSetId, mddata.backupSetName,
			mddata.appId, mddata.subclientName,
			mddata.archGroupId, mddata.archGroupName,
			COUNT(DISTINCT mddata.jobId)
		FROM #tmpMediadata AS mddata
		RIGHT OUTER JOIN #tmpMediaSize  AS mediasize
		ON
			mediasize.MediaId = mddata.mediaId
		GROUP BY
			mddata.mediaId,
			mediasize.mountPathId,
			mediasize.MountPathName,
			mediasize.capacity,
			mediasize.freeSpace,
			mediasize.usedSpace,
			mddata.clientId , mddata.clientName,
			mddata.appTypeId ,mddata.appTypeName,
			mddata.instanceId,mddata.instanceName,
			mddata.backupSetId, mddata.backupSetName,
			mddata.appId, mddata.subclientName,
			mddata.archGroupId, mddata.archGroupName
	--NO DISTRIBUTION provides mounth path info
	IF (@reportType =0)
		BEGIN
		SET @LibrarySummaryJobData=(
			SELECT
				jobinfo.jobId  AS [@jobId],
				CAST (jobinfo.jobStatus  AS NVARCHAR(128)) AS [@status],
				SUM(jobinfo.backedupDataSize)  AS [@backedupDataSize],
				SUM(jobinfo.applicationDataSize)  AS [@applicationDataSize],
				(CASE SIGN( (SUM(jobinfo.applicationDataSize))- (SUM(jobinfo.backedupDataSize)) )
				WHEN -1 THEN  N'N/A'
				ELSE
					(CASE (SUM(jobinfo.applicationDataSize))
						WHEN 0 THEN  N'N/A'
						ELSE CAST (
						CAST (
							( ((SUM(jobinfo.applicationDataSize))  -(SUM(jobinfo.backedupDataSize)))*100.00
								/(SUM(jobinfo.applicationDataSize))) AS DECIMAL(32,2))AS NVARCHAR(128))+ '%'
					END)
				END)AS [@dedupRatio],
				(SUM(jobinfo.applicationDataSize)  -
				SUM(jobinfo.backedupDataSize)) AS [@dedupSavings],
				jobinfo.appTypeId AS   'appType/@id',
				dbo.NormalizeForXML(jobinfo.appTypeName) AS 'appType/@name',
				jobinfo.instanceId AS  'instance/@id',
				dbo.NormalizeForXML(jobinfo.instanceName) AS 'instance/@name',
				jobinfo.clientId AS 'client/@id',
				dbo.NormalizeForXML(jobinfo.clientName) AS 'client/@name',
				jobinfo.backupSetId AS 'backupSet/@id',
				dbo.NormalizeForXML(jobinfo.backupSetName) AS 'backupSet/@name',
				jobinfo.appId AS 'subclient/@id',
				dbo.NormalizeForXML(jobinfo.subclientName) AS 'subclient/@name',
				jobinfo.archGroupId AS 'sp/@id',
				dbo.NormalizeForXML(jobinfo.archGroupName) AS 'sp/@name'
			FROM #tmpMediadata AS jobinfo
			GROUP BY jobinfo.jobId,jobinfo.jobStatus,
			jobinfo.appTypeId,jobinfo.instanceId,jobinfo.clientId,jobinfo.backupSetId,jobinfo.appId,
			jobinfo.appTypeName,jobinfo.instanceName,jobinfo.clientName,jobinfo.backupSetName,jobinfo.subclientName
			,jobinfo.archGroupId,jobinfo.archGroupName
			FOR XML PATH ('jobsData'))
		END
		--DISTRIBUTION BY MOUNT PATH
	IF (@reportType =1)
		BEGIN
		  SET @LibrarySummaryJobData=(
			SELECT
				jobinfo.jobId  AS [@jobId],
				CAST (jobinfo.jobStatus  AS NVARCHAR(128)) AS [@status],
				SUM(jobinfo.backedupDataSize)  AS [@backedupDataSize],
				SUM(jobinfo.applicationDataSize)  AS [@applicationDataSize],
				(CASE SIGN( (SUM(jobinfo.applicationDataSize))- (SUM(jobinfo.backedupDataSize)) )
				WHEN -1 THEN  N'N/A'
				ELSE
					(CASE (SUM(jobinfo.applicationDataSize))
						WHEN 0 THEN  N'N/A'
						ELSE CAST (
						CAST (
							( ((SUM(jobinfo.applicationDataSize))  -(SUM(jobinfo.backedupDataSize)))*100.00
								/(SUM(jobinfo.applicationDataSize))) AS DECIMAL(32,2))AS NVARCHAR(128))+ '%'
					END)
				END)AS [@dedupRatio],
				(SUM(jobinfo.applicationDataSize)  -
				SUM(jobinfo.backedupDataSize))AS [@dedupSavings],
				jobinfo.appTypeId AS   'appType/@id',
				dbo.NormalizeForXML(jobinfo.appTypeName) AS 'appType/@name',
				jobinfo.instanceId AS  'instance/@id',
				dbo.NormalizeForXML(jobinfo.instanceName) AS 'instance/@name',
				jobinfo.clientId AS 'client/@id',
				dbo.NormalizeForXML(jobinfo.clientName) AS 'client/@name',
				jobinfo.backupSetId AS 'backupSet/@id',
				dbo.NormalizeForXML(jobinfo.backupSetName) AS 'backupSet/@name',
				jobinfo.appId AS 'subclient/@id',
				dbo.NormalizeForXML(jobinfo.subclientName) AS 'subclient/@name',
				jobinfo.archGroupId AS 'sp/@id',
				dbo.NormalizeForXML(jobinfo.archGroupName) AS 'sp/@name'
			FROM #tmpMediadata AS jobinfo
			INNER JOIN #tmpMediaInfo AS info
			ON
			info.mediaId = jobinfo.mediaId
			AND info.mountPathId = @mountpathId
			GROUP BY jobinfo.jobId,jobinfo.jobStatus,
			jobinfo.appTypeId,jobinfo.instanceId,jobinfo.clientId,jobinfo.backupSetId,jobinfo.appId,
			jobinfo.appTypeName,jobinfo.instanceName,jobinfo.clientName,jobinfo.backupSetName,jobinfo.subclientName
			,jobinfo.archGroupId,jobinfo.archGroupName
			FOR XML PATH ('jobsData'))
		END
		--DISTRIBUTION BY APP TYPE
	IF (@reportType =2)
	BEGIN
		SET @LibrarySummaryJobData=(
		  SELECT
			jobinfo.jobId  AS [@jobId],
			CAST (jobinfo.jobStatus  AS NVARCHAR(128)) AS [@status],
			SUM(jobinfo.backedupDataSize)  AS [@backedupDataSize],
			SUM(jobinfo.applicationDataSize)  AS [@applicationDataSize],
			(CASE SIGN( (SUM(jobinfo.applicationDataSize))- (SUM(jobinfo.backedupDataSize)) )
			WHEN -1 THEN  N'N/A'
			ELSE
				(CASE (SUM(jobinfo.applicationDataSize))
					WHEN 0 THEN  N'N/A'
					ELSE CAST (
						CAST (
							( ((SUM(jobinfo.applicationDataSize))  -(SUM(jobinfo.backedupDataSize)))*100.00
								/(SUM(jobinfo.applicationDataSize))) AS DECIMAL(32,2))AS NVARCHAR(128))+ '%'
				END)
			END)AS [@dedupRatio],
			(SUM(jobinfo.applicationDataSize)  -
			SUM(jobinfo.backedupDataSize)) AS [@dedupSavings],
			jobinfo.appTypeId AS   'appType/@id',
			dbo.NormalizeForXML(jobinfo.appTypeName) AS 'appType/@name',
			jobinfo.instanceId AS  'instance/@id',
			dbo.NormalizeForXML(jobinfo.instanceName) AS 'instance/@name',
			jobinfo.clientId AS 'client/@id',
			dbo.NormalizeForXML(jobinfo.clientName) AS 'client/@name',
			jobinfo.backupSetId AS 'backupSet/@id',
			dbo.NormalizeForXML(jobinfo.backupSetName) AS 'backupSet/@name',
			jobinfo.appId AS 'subclient/@id',
			dbo.NormalizeForXML(jobinfo.subclientName) AS 'subclient/@name',
			jobinfo.archGroupId AS 'sp/@id',
			dbo.NormalizeForXML(jobinfo.archGroupName) AS 'sp/@name'
		FROM #tmpMediadata AS jobinfo
		INNER JOIN #tmpMediaInfo AS info
		ON
		  info.mediaId = jobinfo.mediaId
		AND jobinfo.appTypeId = @appTypeId
		AND info.mountPathId = @mountpathId
		AND info.appTypeId = @appTypeId
		GROUP BY jobinfo.jobId,jobinfo.jobStatus,
		jobinfo.appTypeId,jobinfo.instanceId,jobinfo.clientId,jobinfo.backupSetId,jobinfo.appId,
		jobinfo.appTypeName,jobinfo.instanceName,jobinfo.clientName,jobinfo.backupSetName,jobinfo.subclientName
		,jobinfo.archGroupId,jobinfo.archGroupName
		FOR XML PATH ('jobsData'))
	END
		--DISTRIBUTION BY CLIENT TYPE
	IF (@reportType =3)
	BEGIN
		SET @LibrarySummaryJobData=(
		  SELECT
			jobinfo.jobId  AS [@jobId],
			CAST (jobinfo.jobStatus  AS NVARCHAR(128)) AS [@status],
			SUM(jobinfo.backedupDataSize)  AS [@backedupDataSize],
			SUM(jobinfo.applicationDataSize)  AS [@applicationDataSize],
			(CASE SIGN( (SUM(jobinfo.applicationDataSize))- (SUM(jobinfo.backedupDataSize)) )
			WHEN -1 THEN  N'N/A'
			ELSE
				(CASE (SUM(jobinfo.applicationDataSize))
					WHEN 0 THEN  N'N/A'
					ELSE CAST (
						CAST (
							( ((SUM(jobinfo.applicationDataSize))  -(SUM(jobinfo.backedupDataSize)))*100.00
								/(SUM(jobinfo.applicationDataSize))) AS DECIMAL(32,2))AS NVARCHAR(128)) + '%'
				END)
			END)AS [@dedupRatio],
			(SUM(jobinfo.applicationDataSize)  -
			SUM(jobinfo.backedupDataSize)) AS [@dedupSavings],
			jobinfo.appTypeId AS   'appType/@id',
			dbo.NormalizeForXML(jobinfo.appTypeName) AS 'appType/@name',
			jobinfo.instanceId AS  'instance/@id',
			dbo.NormalizeForXML(jobinfo.instanceName) AS 'instance/@name',
			jobinfo.clientId AS 'client/@id',
			dbo.NormalizeForXML(jobinfo.clientName) AS 'client/@name',
			jobinfo.backupSetId AS 'backupSet/@id',
			dbo.NormalizeForXML(jobinfo.backupSetName) AS 'backupSet/@name',
			jobinfo.appId AS 'subclient/@id',
			dbo.NormalizeForXML(jobinfo.subclientName) AS 'subclient/@name',
			jobinfo.archGroupId AS 'sp/@id',
			dbo.NormalizeForXML(jobinfo.archGroupName) AS 'sp/@name'
		  FROM #tmpMediadata AS jobinfo
		  INNER JOIN  #tmpMediaInfo AS info
		  ON
			info.mediaId = jobinfo.mediaId
		  AND jobinfo.appTypeId = @appTypeId
		  AND jobinfo.clientId = @clientId
		  AND info.mountPathId = @mountpathId
		  AND info.appTypeId = @appTypeId
		  AND info.clientId = @clientId
          GROUP BY jobinfo.jobId,jobinfo.jobStatus,
		jobinfo.appTypeId,jobinfo.instanceId,jobinfo.clientId,jobinfo.backupSetId,jobinfo.appId,
		jobinfo.appTypeName,jobinfo.instanceName,jobinfo.clientName,jobinfo.backupSetName,jobinfo.subclientName
		,jobinfo.archGroupId,jobinfo.archGroupName
		  FOR XML PATH ('jobsData'))
	END
	SET @LibrarySummaryJobsResp	 =
					(SELECT @LibrarySummaryJobData
						FOR XML PATH ('EVGui_LibrarySummaryJobsResp')
						)
	DROP TABLE #tmpMediadata
	DROP TABLE	#tmpMediaSize
	DROP TABLE	#tmpMediaInfo
	DbXMLRepMagneticLibSummary_End:
	SELECT @LibrarySummaryJobsResp AS [response]
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLRepMagneticLibJobsSummary')
	delete from GxQscripts where name = 'DbXMLRepMagneticLibJobsSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepMagneticLibJobsSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepMagneticLibJobsSummary'
GO

insert into GXDBVersions values(2, 'DbXMLRepMagneticLibJobsSummary',  '00010012004800030000', 'DbXMLRepMagneticLibJobsSummary', '00010012004800030000')
GO

