

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLRepMagneticLibDataWrittenHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DbXMLRepMagneticLibDataWrittenHistory.sp,v $ $Id: DbXMLRepMagneticLibDataWrittenHistory.sp,v 1.9.196.1 2018/03/19 23:57:50 jiechen Exp $";
-- =============================================
-- Author:		Dinesh Kriplani
-- Create date: 04/10/2011
-- Description:	Get the VS Subclient Summary page
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DbXMLRepMagneticLibDataWrittenHistory <<<'

IF EXISTS (select * from sysobjects where name='DbXMLRepMagneticLibDataWrittenHistory')
	drop procedure DbXMLRepMagneticLibDataWrittenHistory
IF EXISTS (select * from GxQscripts where name='DbXMLRepMagneticLibDataWrittenHistory')
	delete from GxQscripts where name = 'DbXMLRepMagneticLibDataWrittenHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepMagneticLibDataWrittenHistory')
	delete from GXDBVersions where aliasname = 'DbXMLRepMagneticLibDataWrittenHistory'
GO
print '... Creating Procedure: DbXMLRepMagneticLibDataWrittenHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLRepMagneticLibDataWrittenHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
DECLARE @libId INT = 1
DECLARE @Libtype INT
DECLARE @nLastdays INT = 7
--DECLARE @reportType INT
DECLARE @mountpathId INT
DECLARE @errmsg NVARCHAR(2000)
DECLARE @debug INT = 0
DECLARE @LibrarySummaryDataWrittenHistoryResp XML
SET @LibrarySummaryDataWrittenHistoryResp =''
DECLARE @DataWrittenUsage XML
	SET @DataWrittenUsage =''
DECLARE @DataWrittenUsageforMountPath XML
	SET @DataWrittenUsageforMountPath =''
--SELECT	@reportType = @request.value('(/EVGui_LibrarySummaryDataWrittenHistoryReq/@reportType)[1]', 'integer')
SELECT @libId =ISNULL(@request.value('(/EVGui_LibrarySummaryDataWrittenHistoryReq/@libId)[1]', 'integer'), 0)
SELECT @mountpathId =ISNULL(@request.value('(/EVGui_LibrarySummaryDataWrittenHistoryReq/@mountpathId)[1]', 'integer'), 0)
SELECT @nLastdays =ISNULL(@request.value('(/EVGui_LibrarySummaryDataWrittenHistoryReq/@nLastdays)[1]', 'integer'), 7)
DECLARE @filterdate DATE = GETDATE()-@nLastdays
IF(@debug=0)
SET NOCOUNT ON
SET @Libtype=( SELECT LibraryTypeId FROM MMLibrary WHERE LibraryId = @libId)
IF(@debug>0)
	PRINT @Libtype
--IF @Libtype <>  CV_LIB_MAGNETIC
IF @Libtype <>  3
BEGIN
SET @errmsg = N'DbXMLRepMagneticLibDataWrittenHistory: LibraryID[' + CAST(@libId AS NVARCHAR(12)) + '] is not a Magnetic library'
RAISERROR(@errmsg, 16, 1)
GOTO DbXMLRepMagneticLibDataWrittenHistory_End
END
--	+===============================================+
--	| Media Constant Info:							|
--	+===============================================+
 IF object_id('tempdb.dbo.#tmpMediaSize') is not null DROP TABLE #tmpMediaSize
	CREATE TABLE #tmpMediaSize
(
		mediaId		int,
		mountPathId	  int,
		MountPathName varchar(255),
		capacity  bigint,
		freeSpace bigint,
		usedSpace bigint
	 )
INSERT INTO #tmpMediaSize
	SELECT mmm.MediaId ,
		 mmp.MountPathId,GUIView.MountPathName,
		 CASE WHEN GUIView.MountPathTypeId = 7 THEN -1 ELSE SUM(TotalSpaceMB) END,
		 CASE WHEN GUIView.MountPathTypeId = 7 THEN -1 ELSE SUM(FreeBytesMB) END,
		 SUM(TotalSpaceMB)-SUM(FreeBytesMB)
	FROM
		MMMediaSide AS mms
	INNER JOIN
		MMMedia AS mmm
	ON
		mmm.MediaId = mms.MediaId
	INNER JOIN
		MMMountPath AS mmp
	ON
		mmp.MediaSideId = mms.MediaSideId
		and mmm.MediaTypeId = 10001
	INNER JOIN
	MMS2getMountPathNameGUIView as GUIView
	ON
	GUIView.MountPathId = mmp.MountPathId
	WHERE mms.MediaId>0 AND mmm.LibraryId =@libId AND mmp.MountPathName not like 'CVDiskFolder' --MOUNT_PATH_TEMPLATE_FOLDER
	GROUP BY mmp.MountPathId,mmp.MountPathName,mmm.MediaId,GUIView.MountPathName, GUIView.MountPathTypeId
IF OBJECT_ID('tempdb.dbo.#DrivemediaTBL')                IS NOT null DROP TABLE #DrivemediaTBL
CREATE TABLE #DrivemediaTBL
(
tdrive_id int,
tmedia_id int
)
IF OBJECT_ID('tempdb.dbo.#DatawrittenHistory')                IS NOT null DROP TABLE #DatawrittenHistory
CREATE TABLE #DatawrittenHistory
(
	mountPathId	  int,
	MountPathName varchar(255),
	datawritten BIGINT,
	Modified            DATE not null
)
INSERT INTO #DrivemediaTBL
SELECT	driveId,MediaId
FROM	MMDrive D WITH (NOLOCK) JOIN MMMasterPool P WITH (NOLOCK) ON D.masterPoolId = P.masterPoolId
WHERE	LibraryId = @libId
IF(@debug>0)
SELECT * FROM #DrivemediaTBL
--introduce mmtemp table as we saw duplicate row for same drive,client,history at same time
IF OBJECT_ID('tempdb.dbo.#MMDatawrittenHistory') IS NOT null DROP TABLE #MMDatawrittenHistory
CREATE TABLE #MMDatawrittenHistory
(
	DriveId            integer,
	MediaId			   integer,
	ClientId           integer,
	HistoryType        integer,
	TimeStart          DATETIME not null,
	DataWritten        bigint,
)
INSERT INTO #MMDatawrittenHistory
SELECT DISTINCT t.DriveId,dd.tmedia_id ,t.ClientId,t.HistoryType,t.TimeStart,t.DataWritten
FROM MMDrivehistory as t WITH (NOLOCK) INNER JOIN #DrivemediaTBL as dd ON t.DriveId = dd.tdrive_id
AND t.DataWritten > 0
	AND t.HistoryType = 1
INSERT INTO #DatawrittenHistory
	SELECT	tmpmpInfo.mountPathId,tmpmpInfo.MountPathName,(mmt.dataWritten),  CAST (mmt.TimeStart as date ) as modified
	FROM	#MMDatawrittenHistory AS mmt WITH (NOLOCK)
	INNER JOIN #tmpMediaSize as tmpmpInfo ON
		mmt.MediaId = tmpmpInfo.mediaId
IF(@debug>0)
 select * from #DatawrittenHistory ORDER BY Modified
IF(@debug>0)
SELECT t1.mountPathId,t1.MountPathName,SUM(t1.datawritten),t1.Modified FROM #DatawrittenHistory as t1
group by t1.Modified,
t1.mountPathId,t1.MountPathName
order by t1.Modified
SET @DataWrittenUsageforMountPath =(
		SELECT
			SUM (dataWrittenUsage.datawritten) AS [@dataWrittenSizeinMB],
			dbo.GetUnixTime( dataWrittenUsage.Modified) AS [@asof],
			dataWrittenUsage.mountPathId  AS 'mountpath/@id',
			dbo.NormalizeForXML(dataWrittenUsage.mountPathName) AS 'mountpath/@name'
			FROM #DatawrittenHistory	as dataWrittenUsage
			WHERE ((@mountpathId=0 )OR(@mountpathId =dataWrittenUsage.mountPathId ) )
			AND dataWrittenUsage.Modified>=@filterdate
			group by dataWrittenUsage.Modified,
			dataWrittenUsage.mountPathId,dataWrittenUsage.MountPathName
			order by dataWrittenUsage.Modified
			FOR XML PATH ('mountpathUsage'))
-- As per Demo feedback library data usage not required
--SET @DataWrittenUsage =(
--		SELECT
--			SUM (dataWrittenUsage.datawritten) AS [@dataWrittenSizeinMB],
--			dbo.GetUnixTime( dataWrittenUsage.Modified) AS [@asof]
--			FROM #DatawrittenHistory	dataWrittenUsage
--			group by dataWrittenUsage.Modified
--			order by dataWrittenUsage.Modified
--			FOR XML PATH ('libUsage'))
DbXMLRepMagneticLibDataWrittenHistory_End:
		SET @LibrarySummaryDataWrittenHistoryResp	 =
					(SELECT
						@DataWrittenUsage ,
						@DataWrittenUsageforMountPath
						FOR XML PATH ('EVGui_LibrarySummaryDataWrittenHistoryResp')
						)
	SELECT @LibrarySummaryDataWrittenHistoryResp
IF OBJECT_ID('tempdb.dbo.#DrivemediaTBL')                IS NOT null DROP TABLE #DrivemediaTBL
IF OBJECT_ID('tempdb.dbo.#DatawrittenHistory')                IS NOT null DROP TABLE #DatawrittenHistory
IF OBJECT_ID('tempdb.dbo.#MMDatawrittenHistory') IS NOT null DROP TABLE #MMDatawrittenHistory
IF(@debug=0)
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLRepMagneticLibDataWrittenHistory')
	delete from GxQscripts where name = 'DbXMLRepMagneticLibDataWrittenHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepMagneticLibDataWrittenHistory')
	delete from GXDBVersions where aliasname = 'DbXMLRepMagneticLibDataWrittenHistory'
GO

insert into GXDBVersions values(2, 'DbXMLRepMagneticLibDataWrittenHistory',  '00010009019600010000', 'DbXMLRepMagneticLibDataWrittenHistory', '00010009019600010000')
GO

