

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLRepDedupStoreHistory.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DbXMLRepDedupStoreHistory')
BEGIN
	print '>>> Drop Stored Procedure: DbXMLRepDedupStoreHistory <<<'
	drop procedure DbXMLRepDedupStoreHistory
END
IF EXISTS (select * from GxQscripts where name='DbXMLRepDedupStoreHistory')
	delete from GxQscripts where name = 'DbXMLRepDedupStoreHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepDedupStoreHistory')
	delete from GXDBVersions where aliasname = 'DbXMLRepDedupStoreHistory'
GO
print '... Creating Procedure: DbXMLRepDedupStoreHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLRepDedupStoreHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
	SET NOCOUNT ON
	DECLARE @reportXML XML
	SET @reportXML = ''
	DECLARE @dedupStoreHistoryXML XML
	DECLARE @commcellId INT
	DECLARE @storeId INT
	DECLARE @subStoreId INT
	DECLARE @nLastdays INT
	DECLARE @errmsg NVARCHAR(2000)
	DECLARE @rowHistoryType INT
	SELECT
			@commcellId = ISNULL(@request.value('(/EVGui_DedupStoreHistoryReq/@commcellId)[1]', 'integer'), 0),
			@storeId = ISNULL(@request.value('(/EVGui_DedupStoreHistoryReq/@storeId)[1]', 'integer'), 0),
			@subStoreId = ISNULL(@request.value('(/EVGui_DedupStoreHistoryReq/@subStoreId)[1]', 'integer'), 0),
			@nLastdays = ISNULL(@request.value('(/EVGui_DedupStoreHistoryReq/@nLastdays)[1]', 'integer'), 0)
    DECLARE @Now DATETIME = GETUTCDATE ()
	DECLARE @filterdate BIGINT = dbo.GetUnixTime(@Now-@nLastdays)
	--	+===============================================+
	--	| Aggr row  Info:							|
	--	+===============================================+
	IF object_id('tempdb.dbo.#tmpDedupStoreHistory') is not null DROP TABLE #tmpDedupStoreHistory
		CREATE TABLE #tmpDedupStoreHistory
	(
		endTime				integer,
		ModifiedTime		integer,
		PrimaryEntries		bigint,
		SecondaryEntries	bigint,
		ZeroRefCount		bigint,
		NumOfConnections	bigint,
		AvgQITime			bigint,  -- Average Query and Insert Time
		rowsCount			integer,
		DataSizeToBeFreed   bigint
		)
	IF (@nLastdays>3) -- we are doing one row per day basis  HistoryType =2 need to do aggr. in case subStoreId =0
	BEGIN
        DECLARE @StartTime DATETIME = DATEADD (DAY, 0, DATEDIFF (DAY, 0, @Now))
		--Get time before 6 hours as user want to see current, status for last 6 hours
 	    DECLARE @timeBefore6Hours DATETIME = DATEADD (HOUR, -6, @Now)
	    --If current time minus 6 hours gives earlier days value then consider "startdate" as yesterday's start time of the day (midnight)
    	IF DATEPART (day, @timeBefore6Hours) <> DATEPART (day, @Now)
     	BEGIN
      		SET @StartTime = DATEADD (DAY, 0, DATEDIFF (DAY, 0, @timeBefore6Hours))
      		SET @filterdate = dbo.GetUnixTime(@Now-(@nLastdays-1))
     	END
		DECLARE @TodayDayStart int
		SET @TodayDayStart = dbo.GetUnixTime(@StartTime)
		DECLARE @lt_SubStoresAvgQITime TABLE (SubStoreId int, AvgQITime bigint, RowNumber int)
		DECLARE @lt_SubStoresMedianQITime  TABLE (SubStoreId int, MedianQITime bigint)
		DECLARE @lt_SubStoresLastModified TABLE (SubStoreId int, ModifiedTime int)
		/*Store the latest modifiedTime for each substore since these may differ for multiple substores*/
		INSERT INTO @lt_SubStoresLastModified
		SELECT SubStoreId, MAX(ModifiedTime)
		FROM IdxSIDBUsageHistory
		WHERE SIDBStoreId = @storeId AND ((SubStoreId = @subStoreId) OR(@subStoreId = 0 ))
			AND HistoryType = 0 AND ModifiedTime >= @TodayDayStart
		GROUP BY SubStoreId
		INSERT 	INTO @lt_SubStoresAvgQITime
		SELECT	SubStoreId, AvgQITime,
				ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY AvgQITime ASC) AS RowNumber
		FROM	IdxSIDBUsageHistory WITH (READUNCOMMITTED)
		WHERE	SIDBStoreId = @storeId AND ((SubStoreId = @subStoreId) OR(@subStoreId = 0 ))
				AND HistoryType = 0 AND ModifiedTime >= @TodayDayStart AND AvgQITime > 0
				AND AvgQITimeSampleCount >= 100 -- Discard QI Times if sample count less than 100
		IF EXISTS (SELECT 1 FROM @lt_SubStoresAvgQITime)
		BEGIN
			INSERT INTO @lt_SubStoresMedianQITime
			SELECT SubStoreId,  AVG(AvgQITime)
			FROM (
					SELECT	SubStoreId, AvgQITime,
							RowNumber AS RowNumAsc,
							ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY RowNumber DESC) AS RowNumDesc
					FROM	@lt_SubStoresAvgQITime
				) Usage
			WHERE RowNumAsc IN (RowNumDesc, RowNumDesc - 1, RowNumDesc + 1)
			GROUP BY SubStoreId
		END
		INSERT INTO #tmpDedupStoreHistory
			SELECT 0, ModifiedTime AS dateorder,
					SUM(PrimaryEntries) ,
					SUM(SecondaryEntries) ,
					SUM(ZeroRefCount) ,
					SUM(NumOfConnections) ,
					MAX(AvgQITime) ,
					COUNT (*),
					SUM(CASE WHEN ZeroRefCount>0 THEN DataSizeToPrune ELSE 0 END) "Data Size to Be Freed"
			FROM IdxSIDBUsageHistory
			WHERE ModifiedTime>=@filterdate
				AND CommCellId =  @commcellId
				AND SIDBStoreId = @storeId
				AND ((SubStoreId = @subStoreId) OR(@subStoreId = 0 ))
					AND HistoryType =2
			GROUP BY  ModifiedTime
			ORDER BY dateorder
		/*We dont have historyType 2 row for current day. So we plot median value for today as the last plotting point.
		Even if we dont have enough rows that qualify to calculate median value, we should still show latest values for other info.*/
		IF EXISTS (SELECT 1 FROM @lt_SubStoresLastModified)
		BEGIN
			INSERT INTO #tmpDedupStoreHistory
				SELECT 0, @TodayDayStart,
						SUM(PrimaryEntries) ,
						SUM(SecondaryEntries) ,
						SUM(ZeroRefCount) ,
						SUM(NumOfConnections) ,
						MAX(ISNULL(MedianQITime, 0)),
						COUNT (*),
						SUM(CASE WHEN ZeroRefCount>0 THEN DataSizeToPrune ELSE 0 END) "Data Size to Be Freed"
				FROM IdxSIDBUsageHistory SU1
				INNER JOIN @lt_SubStoresLastModified SU2 ON SU1.SubStoreId = SU2.SubStoreId AND SU1.ModifiedTime = SU2.ModifiedTime
				LEFT OUTER JOIN @lt_SubStoresMedianQITime SU3 ON SU1.SubStoreId = SU3.SubStoreId
		END
        -- Insert hourly rows for last 6 hours
		DECLARE @tblTimeHourly TABLE
        ( SubStoreId int,
          endTime int,
          ModifiedTime int
        )
		INSERT INTO @tblTimeHourly
			SELECT SubStoreId, dbo.GetUnixTime( DATEADD(HOUR, datediff(HOUR, 0, dbo.GetDateTime( ModifiedTime )) , 0)) AS hourorder, max(ModifiedTime)
			FROM IdxSIDBUsageHistory
			WHERE ModifiedTime>=dbo.GetUnixTime(@timeBefore6Hours)
				AND CommCellId =  @commcellId
				AND SIDBStoreId = @storeId
				AND ((SubStoreId = @subStoreId) OR(@subStoreId = 0 ))
				AND HistoryType = 0
			GROUP BY SubStoreId, DATEADD(HOUR, datediff(HOUR, 0, dbo.GetDateTime( ModifiedTime )), 0)
		INSERT INTO #tmpDedupStoreHistory
			SELECT  b.endTime,
					MAX(a.modifiedTime),
					SUM(a.PrimaryEntries),
					SUM(a.SecondaryEntries),
					SUM(a.ZeroRefCount),
					SUM(a.NumOfConnections),
					MAX(a.AvgQITime),
					COUNT(*),
					SUM(CASE WHEN ZeroRefCount>0 THEN DataSizeToPrune ELSE 0 END) "Data Size to Be Freed"
			FROM IdxSIDBUsageHistory a, @tblTimeHourly b
			WHERE a.ModifiedTime = b.ModifiedTime
				AND CommCellId =  @commcellId
				AND a.SubStoreId = b.SubStoreId
				AND ((a.SubStoreId = @subStoreId) OR(@subStoreId = 0 ))
			GROUP BY b.endTime
		SET @rowHistoryType = 1 --This decides the format of the date to be shown in the entries for the graph
	END
	ELSE IF(@nLastdays>0) -- presently we are doing only Hour basis HistoryType = 0	only one row should be per hours need to do aggr. in case subStoreId =0
	BEGIN
		/*The less than or equal 3 days case is same as previous less than or equal 30 days.
		We show hourly entries and in this case we may even show the spikes where sample count is low.
		We dont have a system like historyType = 2 rows to get an hourly basis median. And if we ignore low sample count rows,
		we may end up missing out data for other columns. And showing 0 would also be incorrect*/
		declare @tblTime table (SubStoreId int, endTime int, ModifiedTime int)
		INSERT INTO @tblTime
			SELECT SubStoreId, dbo.GetUnixTime( DATEADD(HOUR, datediff(HOUR, 0, dbo.GetDateTime( ModifiedTime )) , 0)) AS hourorder, max(ModifiedTime)
			FROM IdxSIDBUsageHistory
			WHERE ModifiedTime>=@filterdate
				AND CommCellId =  @commcellId
				AND SIDBStoreId = @storeId
				AND ((SubStoreId = @subStoreId) OR(@subStoreId = 0 ))
				AND HistoryType = 0
			group by SubStoreId, DATEADD(HOUR, datediff(HOUR, 0, dbo.GetDateTime( ModifiedTime )), 0)
		INSERT INTO #tmpDedupStoreHistory
			SELECT  b.endTime,
					MAX(a.modifiedTime),
					SUM(a.PrimaryEntries),
					SUM(a.SecondaryEntries),
					SUM(a.ZeroRefCount),
					SUM(a.NumOfConnections),
					MAX(a.AvgQITime),
					COUNT(*),
					SUM(CASE WHEN ZeroRefCount>0 THEN DataSizeToPrune ELSE 0 END) "Data Size to Be Freed"
			FROM IdxSIDBUsageHistory a, @tblTime b
			WHERE a.ModifiedTime = b.ModifiedTime
				AND CommCellId =  @commcellId
				AND a.SubStoreId = b.SubStoreId
				AND ((a.SubStoreId = @subStoreId) OR(@subStoreId = 0 ))
			GROUP BY b.endTime
			SET @rowHistoryType = 0
	END
	DECLARE @HistoryData XML
	SET @HistoryData =''
		SET @HistoryData =(
							SELECT ModifiedTime   AS [@asof],
								   PrimaryEntries AS [@noOfUniqueBlocks],
								   SecondaryEntries AS [@noOfSecondaryBlocks],
								   ZeroRefCount AS [@noOfPendingDelRecords],
								   NumOfConnections AS [@noOfConnections],
								   AvgQITime AS [@avgQITime],
								   CEILING((DataSizeToBeFreed/(1024.0*1024.0))) AS [@dataSizeToBeFreed]
							FROM #tmpDedupStoreHistory ORDER BY ModifiedTime DESC
						FOR XML PATH ('data'))
SET @dedupStoreHistoryXML =( SELECT @rowHistoryType AS [@rowHistoryType],
									@HistoryData
FOR XML PATH ('EVGui_DedupStoreHistoryResp'))
	DedupStoreHistory_End:
	DROP TABLE #tmpDedupStoreHistory
	SELECT @dedupStoreHistoryXML AS [response]
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLRepDedupStoreHistory')
	delete from GxQscripts where name = 'DbXMLRepDedupStoreHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepDedupStoreHistory')
	delete from GXDBVersions where aliasname = 'DbXMLRepDedupStoreHistory'
GO

insert into GXDBVersions values(2, 'DbXMLRepDedupStoreHistory',  '00010007004000020000', 'DbXMLRepDedupStoreHistory', '00010007004000020000')
GO

