

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DbXMLRepAuxCopyJobSummary.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DbXMLRepAuxCopyJobSummary <<<'

IF EXISTS (select * from sysobjects where name='DbXMLRepAuxCopyJobSummary')
	drop procedure DbXMLRepAuxCopyJobSummary
IF EXISTS (select * from GxQscripts where name='DbXMLRepAuxCopyJobSummary')
	delete from GxQscripts where name = 'DbXMLRepAuxCopyJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepAuxCopyJobSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepAuxCopyJobSummary'
GO
print '... Creating Procedure: DbXMLRepAuxCopyJobSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DbXMLRepAuxCopyJobSummary
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
	SET NOCOUNT ON
	DECLARE @reportXML XML
	SET @reportXML = ''
	DECLARE @AuxCopyJobSummaryXML XML
	DECLARE @spId INT
	DECLARE @spCopyId INT
	DECLARE @debug INT = 0
	DECLARE @errmsg NVARCHAR(2000)
	SELECT
			@spId = ISNULL(@request.value('(/EVGui_ActiveAuxiliaryCopyJobReq/@spId)[1]', 'integer'), 0),
			@spCopyId = ISNULL(@request.value('(/EVGui_ActiveAuxiliaryCopyJobReq/@spCopyId)[1]', 'integer'), 0)
	--	+===============================================+
	--	| SP /  SP COPY Validation
	--	+===============================================+
	DECLARE @SummaryData XML
	SET @SummaryData =''
	IF((@spId<1) AND (@spCopyId<1))
	BEGIN
		SET @errmsg = N'DbXMLRepAuxCopyJobSummary: StoragePolicyId[' + CAST(@spId AS NVARCHAR(12)) + '] and StoragePolicyCopyId[' + CAST(@spCopyId AS NVARCHAR(12)) + ']  both are failed during validation'
		RAISERROR(@errmsg, 16, 1)
		GOTO DbXMLRepAuxCopyJobSummary_End
	END
	-- SP Input Params
	--DECLARE @i_StoragePolicy NVARCHAR(2048) = ''
	--DECLARE @i_StoragePolicyCopy NVARCHAR(2048) = ''
	--SET @i_StoragePolicy = N'ALL'
	--SET @i_StoragePolicyCopy = N'ALL'
	DECLARE @errorCode INTEGER
	SET		@errorCode = 0
	DECLARE	@tblSP TABLE (archGroupId INTEGER, archGroupCopyId INTEGER, sourceCopyId INTEGER,
				AuxCopyJobId INTEGER, opType INTEGER, ActiveStreamsCount INTEGER, AuxCopyJobThroughput FLOAT,
				ToBeCopiedDataSizeByCurrentJob BIGINT, EstCompletionDateWithCurrent DATETIME,
				NewDataSincetheCurrentAuxCopyJobStarted BIGINT, TotalToBeCopiedDataSize BIGINT, EstCompletionDateWithCurrentAndNewData DATETIME)
	DECLARE @CommCellId INTEGER = -1
	DECLARE @JobId		INTEGER = -1
	DECLARE @ActiveStreamCount		INTEGER = -1
	DECLARE @ToBeCopiedDataSizeByCurrentJob				BIGINT = -1
	DECLARE @NewDataSincetheCurrentAuxCopyJobStarted	BIGINT = -1
	DECLARE @ToBeCopiedDataSizeIncludingNewData			BIGINT = -1
	DECLARE	@AuxCopyJobThroughput						Float = 0.0
	INSERT INTO @tblSP
	SELECT	AG.id, AGC.id, (CASE WHEN AGC.SourceCopyId > 0 THEN AGC.SourceCopyId ELSE AG.defaultCopy END), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	FROM	archGroup AG WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
	WHERE	AG.id = AGC.archGroupId
			AND AGC.id <> AG.defaultCopy
			AND AGC.id <> AG.defaultSnapCopy
			AND AGC.isSnapCopy = 0  -- PICK ONLY NON SNAP COPIES
AND AGC.type NOT IN (5)
AND (AGC.flags & 524288) = 0
			AND (@spId = 0 OR AG.id = @spId)
			AND (@spCopyId = 0 OR AGC.id = @spCopyId)
		--	AND (@i_StoragePolicy = 'ALL' OR AG.name = @i_StoragePolicy)
			--AND (@i_StoragePolicyCopy = 'ALL' OR AGC.name = @i_StoragePolicyCopy)
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO DbXMLRepAuxCopyJobSummary_End
	IF NOT EXISTS (SELECT * FROM @tblSP)
	BEGIN
		SET	@errorCode = -1
		SET @errmsg = 'Error: Invalid Storage Policy StoragePolicyId[' + CAST(@spId AS NVARCHAR(12)) + ']' + ' OR  Storage Policy Copy StoragePolicyCopyId[' + CAST(@spCopyId AS NVARCHAR(12)) + ']'
		GOTO DbXMLRepAuxCopyJobSummary_End
	END
	UPDATE	@tblSP
	SET		AuxCopyJobId = J.jobId, opType = J.opType
	FROM	@tblSP T, JMAdminJobInfoTable J  WITH (READUNCOMMITTED)
	WHERE	J.archGrpID = T.archGroupId
			AND (J.archGrpCopyID = 0 OR J.archGrpCopyID = T.archGroupCopyId)
			AND J.OpType IN (13, 104)
	UPDATE	@tblSP
	SET		ActiveStreamsCount = ISNULL(J.ActiveStreamsCount, 0),
			AuxCopyJobThroughput = ISNULL(J.AuxCopyJobThroughput, 0)
	FROM	@tblSP T,
			(SELECT jobId, destCopyId, COUNT(*) AS ActiveStreamsCount, ISNULL(SUM(throughput), 0) AS AuxCopyJobThroughput
			FROM JMJobStreams  WITH (READUNCOMMITTED), @tblSP T1
			WHERE	status = 1 --AND throughput > 0
					AND JMJobStreams.JobId = T1.AuxCopyJobId
					AND JMJobStreams.destCopyId = T1.archGroupCopyId
			GROUP BY jobId, destCopyId) J
	WHERE	J.JobId = T.AuxCopyJobId
			AND J.destCopyId = T.archGroupCopyId
	UPDATE	@tblSP
	SET		ActiveStreamsCount = ISNULL(ActiveStreamsCount, 0),
			AuxCopyJobThroughput = ISNULL(AuxCopyJobThroughput, 0)
	IF OBJECT_ID('tempdb..#jobsToBeCopiedNewData') IS NOT NULL DROP TABLE #jobsToBeCopiedNewData
	CREATE	TABLE #jobsToBeCopiedNewData (archGroupId INTEGER, archGroupCopyId INTEGER, sourceCopyId INTEGER, CommCellId INTEGER, JobID INTEGER, AuxCopyJobId INTEGER, CurrentOrNew INTEGER, sizeOnSrc BIGINT, sizeOnDest BIGINT PRIMARY KEY (archGroupCopyId, JobId, CommCellId))
	INSERT INTO #jobsToBeCopiedNewData
	SELECT	T.archGroupId, T.archGroupCopyId, T.sourceCopyId, JDS.commCellId, JDS.jobId, T.AuxCopyJobId, 0, 0, 0
	FROM	@tblSP T
				INNER JOIN JMJobDataStats JDS  WITH (NOLOCK) ON archGrpId = T.archGroupId AND archGrpCopyId = T.archGroupCopyId
	WHERE	(JDS.disabled & 257) = 0
			AND JDS.status IN (101, 102, 103)
	GROUP BY T.archGroupId, T.archGroupCopyId, T.sourceCopyId, JDS.commCellId, JDS.jobId, T.AuxCopyJobId
	CREATE INDEX jobsToBeCopiedNewData_SourceCopyId_JobId_CommCellId_IDX ON #jobsToBeCopiedNewData(sourceCopyId, JobId, CommCellId)
	UPDATE	ND
	SET		ND.CurrentOrNew = (CASE WHEN T.BackupJobId IS NULL THEN 2 ELSE 1 END)
	FROM	#jobsToBeCopiedNewData ND LEFT OUTER JOIN
			(SELECT	R.DestCopyId, R.backupJobId, R.CommCellID
			FROM	#jobsToBeCopiedNewData D, archChunkToReplicate R WITH (READUNCOMMITTED)
			WHERE	D.AuxCopyJobId = R.adminJobId
			GROUP BY R.adminJobId, R.DestCopyId, R.backupJobId, R.CommCellId
			UNION
			SELECT	R.DestCopyId, R.backupJobId, R.CommCellID
			FROM	#jobsToBeCopiedNewData D, archChunkToCopy R WITH (READUNCOMMITTED)
			WHERE	D.AuxCopyJobId = R.adminJobId
			GROUP BY R.adminJobId, R.DestCopyId, R.backupJobId, R.CommCellId
			UNION
			SELECT	R.DestCopyId, R.backupJobId, R.CommCellID
			FROM	#jobsToBeCopiedNewData D, archChunkToCopyHistory R WITH (READUNCOMMITTED)
			WHERE	D.AuxCopyJobId = R.adminJobId
			GROUP BY R.adminJobId, R.DestCopyId, R.backupJobId, R.CommCellId) T
					ON ND.archGroupCopyId = T.DestCopyId
					AND ND.JobId = T.backupJobId
					AND ND.commCellId = T.commCellId
	UPDATE	ND
	SET		ND.sizeOnDest = T.unCompSize
	FROM	#jobsToBeCopiedNewData ND,
			(SELECT	ACM.archCopyId, ACM.JobId, ACM.commCellId, SUM(ACM.unCompSize) unCompSize
			FROM	#jobsToBeCopiedNewData J, archChunkMapping ACM
			WHERE	J.archGroupCopyId = ACM.archCopyId
					AND J.JobId = ACM.JobId
					AND J.CommCellId = ACM.commCellId
			GROUP BY ACM.archCopyId, ACM.JobId, ACM.commCellId) T
	WHERE	ND.archGroupCopyId = T.archCopyId
			AND ND.JobID = T.jobId
			AND ND.CommCellId = T.commCellId
	UPDATE	ND
	SET		ND.sizeOnSrc = T.unCompSize
	FROM	#jobsToBeCopiedNewData ND,
			(SELECT	J.archGroupCopyId,ACM.archCopyId, ACM.JobId, ACM.commCellId, SUM(ACM.unCompSize) unCompSize
			FROM	#jobsToBeCopiedNewData J, archChunkMapping ACM
			WHERE	J.sourceCopyId = ACM.archCopyId
					AND J.JobId = ACM.JobId
					AND J.CommCellId = ACM.commCellId
			GROUP BY J.archGroupCopyId, ACM.archCopyId, ACM.JobId, ACM.commCellId) T
	WHERE	ND.sourceCopyId = T.archCopyId
			AND ND.archGroupCopyId = T.archGroupCopyId
			AND ND.JobID = T.jobId
			AND ND.CommCellId = T.commCellId
	UPDATE	@tblSP
	SET		NewDataSincetheCurrentAuxCopyJobStarted = J.NewDataSincetheCurrentAuxCopyJobStarted,
			ToBeCopiedDataSizeByCurrentJob = J.ToBeCopiedDataSizeByCurrentJob
	FROM	@tblSP T,
			(
				SELECT	archGroupId, archGroupCopyId,
									ISNULL(SUM(CASE WHEN CurrentOrNew = 1 THEN sizeOnSrc-sizeOnDest ELSE 0 END)/(1024*1024*1024), 0) AS ToBeCopiedDataSizeByCurrentJob,
									ISNULL(SUM(CASE WHEN CurrentOrNew = 2 THEN sizeOnSrc-sizeOnDest ELSE 0 END)/(1024*1024*1024), 0) AS NewDataSincetheCurrentAuxCopyJobStarted
				FROM	#jobsToBeCopiedNewData
				--WHERE	CurrentOrNew = 2
				GROUP BY archGroupId, archGroupCopyId
			) J
	WHERE	T.archGroupId = J.archGroupId
			AND T.archGroupCopyID = J.archGroupCopyId
	UPDATE	@tblSP
	SET		ToBeCopiedDataSizeByCurrentJob = ISNULL(ToBeCopiedDataSizeByCurrentJob, 0),
			NewDataSincetheCurrentAuxCopyJobStarted = ISNULL(NewDataSincetheCurrentAuxCopyJobStarted, 0)
	UPDATE	@tblSP
	SET		EstCompletionDateWithCurrent = DATEADD(s, ((ToBeCopiedDataSizeByCurrentJob * 3600)/AuxCopyJobThroughput), GetDate()),
			EstCompletionDateWithCurrentAndNewData = DATEADD(s, (((ToBeCopiedDataSizeByCurrentJob + NewDataSincetheCurrentAuxCopyJobStarted) * 3600)/AuxCopyJobThroughput), GetDate())
	FROM	@tblSP T
	WHERE	AuxCopyJobThroughput > 0
	SET @SummaryData =(
	SELECT
	T.AuxCopyJobId						AS  [@auxCopyJobId],
	T.ActiveStreamsCount				AS  [@activeStreamsCount],
	CAST(T.AuxCopyJobThroughput AS	 DECIMAL(32,2)) AS  [@auxCopyJobThroughput],
	T.ToBeCopiedDataSizeByCurrentJob	AS  [@toBeCopiedDataSizeByCurrentJob],
	(CASE WHEN T.AuxCopyJobThroughput = 0 THEN 'NA' ELSE CONVERT(NVARCHAR(max), T.EstCompletionDateWithCurrent, 21) END) AS  [@estCompletionDateWithCurrent],
	T.NewDataSincetheCurrentAuxCopyJobStarted AS [@newDataSincetheCurrentAuxCopyJobStarted],
	(T.ToBeCopiedDataSizeByCurrentJob + T.NewDataSincetheCurrentAuxCopyJobStarted) AS [@estTotalDataWithCurrentAndNewData],
	(CASE WHEN T.AuxCopyJobThroughput = 0 THEN 'NA' ELSE CONVERT(NVARCHAR(max), T.EstCompletionDateWithCurrentAndNewData, 21) END)  AS [@estCompletionDateWithCurrentAndNewData],
	AGC.id AS 'spCopy/@id',
	dbo.NormalizeForXML(AGC.name) AS 'spCopy/@name'
	FROM	@tblSP T, archGroup AG, archGroupCopy AGC
	WHERE	T.archGroupId = AG.id
		AND T.archGroupCopyId = AGC.id
AND AGC.type NOT IN (5)
AND (AGC.flags & 524288) = 0
		AND T.AuxCopyJobId>0
	FOR XML PATH ('data'))
DbXMLRepAuxCopyJobSummary_End:
	IF (@errorCode <> 0 AND @debug>0)
	BEGIN
		IF (@errorCode = -3)
			SELECT	@errmsg
		ELSE IF (@errorCode NOT IN (0, -3))
			Raiserror(@errmsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	SET @AuxCopyJobSummaryXML	 =
					(SELECT @SummaryData
						FOR XML PATH ('EVGui_ActiveAuxiliaryCopyJobResp')
						)
	SELECT @AuxCopyJobSummaryXML AS [response]
	SET NOCOUNT OFF
	IF OBJECT_ID('tempdb..#jobsToBeCopiedNewData') IS NOT NULL DROP TABLE #jobsToBeCopiedNewData
END
GO

IF EXISTS (select * from GxQscripts where name = 'DbXMLRepAuxCopyJobSummary')
	delete from GxQscripts where name = 'DbXMLRepAuxCopyJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DbXMLRepAuxCopyJobSummary')
	delete from GXDBVersions where aliasname = 'DbXMLRepAuxCopyJobSummary'
GO

insert into GXDBVersions values(2, 'DbXMLRepAuxCopyJobSummary',  '00010007008000040000', 'DbXMLRepAuxCopyJobSummary', '00010007008000040000')
GO

